/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.size;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.path.DirectoryFragment;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.IDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import java.util.ArrayList;
import java.util.List;

public abstract class InternalDirectoryProcessor
extends NamedElementVisitor
implements DirectoryPath.IVisitor,
DirectoryFragment.IVisitor {
    private final boolean m_count;

    public static List<IType> collectTypesFromInternalDirectory(IDirectoryPath directory) {
        assert (directory != null) : "Parameter 'directory' of method 'collectTypesFromInternaDirectory' must not be null";
        assert (!directory.getNamedElement().isExternal()) : "External directory: " + String.valueOf(directory.getNamedElement());
        boolean containsAtLeastOneIncludedComponent = false;
        ArrayList<IType> types = new ArrayList<IType>();
        for (IComponent nextComponent : directory.getNamedElement().getChildren(IComponent.class)) {
            if (nextComponent.isExcluded()) continue;
            assert (!nextComponent.isExternal()) : "Component is external: " + String.valueOf(nextComponent);
            containsAtLeastOneIncludedComponent = true;
            types.addAll(nextComponent.getNamedElement().getChildrenRecursively(IType.class, new Class[0]));
        }
        assert (containsAtLeastOneIncludedComponent) : "Directory is empty: " + String.valueOf(directory.getNamedElement());
        return types;
    }

    protected InternalDirectoryProcessor(boolean count) {
        this.m_count = count;
    }

    @Override
    public final void visitNamedElement(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
        if (!element.isExternal() && !(element instanceof IComponent)) {
            super.visitNamedElement(element);
        }
    }

    protected void processInternalDirectory(IDirectoryPath directory, int components, int types, int issueIgnoringComponents) {
        assert (directory != null) : "Parameter 'directory' of method 'processInternalNonPartDirectory' must not be null";
    }

    private void process(IDirectoryPath directory) {
        block8: {
            block7: {
                assert (directory != null) : "Parameter 'directory' of method 'process' must not be null";
                assert (!directory.getNamedElement().isExternal()) : "External directory: " + String.valueOf(directory.getNamedElement());
                if (!this.m_count) break block7;
                int components = 0;
                int issueIgnoringComponents = 0;
                int types = 0;
                for (IComponent nextComponent : directory.getNamedElement().getChildren(IComponent.class)) {
                    if (nextComponent.isExcluded()) continue;
                    assert (!nextComponent.isExternal()) : "Component is external: " + String.valueOf(nextComponent);
                    ++components;
                    if (nextComponent.ignoreIssues()) {
                        ++issueIgnoringComponents;
                    }
                    types += nextComponent.getNamedElement().getChildrenRecursively(IType.class, new Class[0]).size();
                }
                if (components <= 0) break block8;
                this.processInternalDirectory(directory, components, types, issueIgnoringComponents);
                break block8;
            }
            for (IComponent nextComponent : directory.getNamedElement().getChildren(IComponent.class)) {
                if (nextComponent.isExcluded()) continue;
                assert (!nextComponent.isExternal()) : "Component is external: " + String.valueOf(nextComponent);
                this.processInternalDirectory(directory, -1, -1, -1);
                break;
            }
        }
    }

    @Override
    public final void visitDirectoryPath(DirectoryPath element) {
        assert (element != null) : "Parameter 'element' of method 'visitDirectoryPath' must not be null";
        if (!element.isExternal()) {
            this.process(element);
            this.visitChildrenOf(element);
        }
    }

    @Override
    public final void visitDirectoryFragment(DirectoryFragment element) {
        assert (element != null) : "Parameter 'element' of method 'visitDirectoryFragment' must not be null";
        if (!element.isExternal()) {
            this.process(element);
            this.visitChildrenOf(element);
        }
    }
}

