/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.cycles;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerJob;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.system.IMetricAccessor;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.ArrayList;
import java.util.List;

public abstract class CycleMetricsAnalyzerAdapter
extends AnalyzerAdapter {
    private final List<IAnalyzerId> m_basedOn;

    public CycleMetricsAnalyzerAdapter(IAnalyzerController controller, IConfigurableAnalyzerId analyzerId, List<IAnalyzerId> basedOn) {
        super(controller, analyzerId);
        assert (basedOn != null && !basedOn.isEmpty() && basedOn.size() <= 2) : "Parameter 'basedOn' of method 'CycleMetricsAnalyzerAdapter' must not be empty and must contain at most 2: " + String.valueOf(basedOn);
        this.m_basedOn = new ArrayList<IAnalyzerId>(basedOn.size());
        for (IAnalyzerId next : basedOn) {
            assert (next != CoreAnalyzerId.SIZE_METRICS) : "Unexpected analyzer id '" + String.valueOf(CoreAnalyzerId.SIZE_METRICS) + "'";
            assert (!this.m_basedOn.contains(next)) : "Already added: " + String.valueOf(next);
            this.m_basedOn.add(next);
        }
    }

    protected abstract IMetricDescriptor getNumberOfIgnoredCyclicElementsMetric();

    protected abstract IMetricDescriptor getNumberOfCycleGroupsMetric();

    protected abstract IMetricDescriptor getNumberOfCriticalCycleGroupsMetric();

    protected abstract IMetricDescriptor getNumberOfCyclicElementsMetric();

    protected abstract IMetricDescriptor getBiggestCycleGroupMetric();

    protected abstract IMetricDescriptor getReferencesToCutMetric();

    protected abstract IMetricDescriptor getComponentDependenciesToCutMetric();

    protected abstract IMetricDescriptor getStructuralDebtIndexMetric();

    protected abstract IMetricDescriptor getCyclicityMetric();

    protected abstract IMetricDescriptor getRelativeCyclicityMetric();

    protected IMetricDescriptor getAverageRelativeCyclicityMetric() {
        return null;
    }

    protected abstract IMetricId getNumberOfElementsMetricId();

    protected abstract boolean runOnSystemLevel();

    protected Language getLanguage() {
        return null;
    }

    protected NamedElement getSystemScope() {
        return this.getSoftwareSystem();
    }

    protected List<? extends NamedElement> getModuleScopes() {
        ArrayList<Module> moduleScopes = new ArrayList<Module>();
        Language language = this.getLanguage();
        for (Module nextModule : this.getSoftwareSystem().getUniqueExistingChild(Workspace.class).getChildren(Module.class)) {
            if (language != null && nextModule.getLanguage() != language) continue;
            moduleScopes.add(nextModule);
        }
        return moduleScopes;
    }

    protected NamedElement getScope(NamedElement cycleScope) {
        assert (cycleScope != null) : "Parameter 'cycleScope' of method 'getScope' must not be null";
        return cycleScope;
    }

    @Override
    protected IssueFilter getIssueFilter(AnalyzerResult result) {
        return null;
    }

    @Override
    public boolean canStoreResult() {
        return true;
    }

    @Override
    protected void runJobs(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'runJobs' must not be null";
        ArrayList<AnalyzerResult> requiredResults = new ArrayList<AnalyzerResult>(this.m_basedOn.size() + 1);
        IAnalyzerController controller = this.getController();
        requiredResults.add(controller.getResultFor(CoreAnalyzerId.SIZE_METRICS));
        this.m_basedOn.forEach(r -> {
            boolean bl = requiredResults.add(controller.getResultFor((IAnalyzerId)r));
        });
        CycleMetricAnalyzerJob job = new CycleMetricAnalyzerJob(this.getGroup(), result, controller, requiredResults);
        job.start();
    }

    private class CycleMetricAnalyzerJob
    extends AnalyzerJob {
        private double m_averageRelativeCyclicityAggregator;
        private int m_totalElements;

        private CycleMetricAnalyzerJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller, List<AnalyzerResult> requiredResults) {
            super(group, result, controller, requiredResults);
            this.m_averageRelativeCyclicityAggregator = 0.0;
            this.m_totalElements = 0;
        }

        @Override
        protected void internalRun() {
            IMetricAccessor accessor = CycleMetricsAnalyzerAdapter.this.getController().getInstallation().getExtension(IMetricAccessor.class);
            if (CycleMetricsAnalyzerAdapter.this.runOnSystemLevel()) {
                CycleMetricComputer computer = new CycleMetricComputer(CycleMetricsAnalyzerAdapter.this.getSystemScope(), accessor);
                computer.compute();
            } else {
                IWorkerContext workerContext = this.getWorkerContext();
                for (NamedElement namedElement : CycleMetricsAnalyzerAdapter.this.getModuleScopes()) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    CycleMetricComputer computer = new CycleMetricComputer(namedElement, accessor);
                    computer.compute();
                }
                IMetricDescriptor iMetricDescriptor = CycleMetricsAnalyzerAdapter.this.getAverageRelativeCyclicityMetric();
                if (iMetricDescriptor != null) {
                    double val = this.m_averageRelativeCyclicityAggregator / (double)this.m_totalElements;
                    CycleMetricsAnalyzerAdapter.this.storeMetricValue(this.getResult(), CycleMetricsAnalyzerAdapter.this.getSystemScope(), val, iMetricDescriptor);
                }
            }
        }

        private class CycleMetricComputer {
            private final NamedElement m_scope;
            private final IMetricAccessor m_metricAccessor;

            private CycleMetricComputer(NamedElement scope, IMetricAccessor accessor) {
                assert (scope != null) : "Parameter 'scope' of method 'CycleMetricComputer' must not be null";
                assert (accessor != null) : "Parameter 'accessor' of method 'CycleMetricComputer' must not be null";
                this.m_scope = scope;
                this.m_metricAccessor = accessor;
            }

            private void setNumberOfCycleGroups(int n) {
                if (CycleMetricsAnalyzerAdapter.this.getNumberOfCycleGroupsMetric() != null) {
                    CycleMetricsAnalyzerAdapter.this.storeMetricValue(CycleMetricAnalyzerJob.this.getResult(), CycleMetricsAnalyzerAdapter.this.getScope(this.m_scope), n, CycleMetricsAnalyzerAdapter.this.getNumberOfCycleGroupsMetric());
                }
            }

            private void setNumberOfCriticalCycleGroups(int n) {
                if (CycleMetricsAnalyzerAdapter.this.getNumberOfCriticalCycleGroupsMetric() != null) {
                    CycleMetricsAnalyzerAdapter.this.storeMetricValue(CycleMetricAnalyzerJob.this.getResult(), CycleMetricsAnalyzerAdapter.this.getScope(this.m_scope), n, CycleMetricsAnalyzerAdapter.this.getNumberOfCriticalCycleGroupsMetric());
                }
            }

            private void setSizeOfBiggestCycleGroup(int n) {
                if (CycleMetricsAnalyzerAdapter.this.getBiggestCycleGroupMetric() != null) {
                    CycleMetricsAnalyzerAdapter.this.storeMetricValue(CycleMetricAnalyzerJob.this.getResult(), CycleMetricsAnalyzerAdapter.this.getScope(this.m_scope), n, CycleMetricsAnalyzerAdapter.this.getBiggestCycleGroupMetric());
                }
            }

            private void setNumberOfIgnoredCyclicElements(int n) {
                if (CycleMetricsAnalyzerAdapter.this.getNumberOfIgnoredCyclicElementsMetric() != null) {
                    CycleMetricsAnalyzerAdapter.this.storeMetricValue(CycleMetricAnalyzerJob.this.getResult(), CycleMetricsAnalyzerAdapter.this.getScope(this.m_scope), n, CycleMetricsAnalyzerAdapter.this.getNumberOfIgnoredCyclicElementsMetric());
                }
            }

            private void setNumberOfCyclicElements(int n) {
                if (CycleMetricsAnalyzerAdapter.this.getNumberOfCyclicElementsMetric() != null) {
                    CycleMetricsAnalyzerAdapter.this.storeMetricValue(CycleMetricAnalyzerJob.this.getResult(), CycleMetricsAnalyzerAdapter.this.getScope(this.m_scope), n, CycleMetricsAnalyzerAdapter.this.getNumberOfCyclicElementsMetric());
                }
            }

            private void setReferencesToCutMetric(int val) {
                IMetricDescriptor md = CycleMetricsAnalyzerAdapter.this.getReferencesToCutMetric();
                if (md != null) {
                    CycleMetricsAnalyzerAdapter.this.storeMetricValue(CycleMetricAnalyzerJob.this.getResult(), CycleMetricsAnalyzerAdapter.this.getScope(this.m_scope), val, md);
                }
            }

            private void setComponentDependenciesToCutMetric(int val) {
                IMetricDescriptor md = CycleMetricsAnalyzerAdapter.this.getComponentDependenciesToCutMetric();
                if (md != null) {
                    CycleMetricsAnalyzerAdapter.this.storeMetricValue(CycleMetricAnalyzerJob.this.getResult(), CycleMetricsAnalyzerAdapter.this.getScope(this.m_scope), val, md);
                }
            }

            private void setStructuralDebtIndexMetric(int val) {
                IMetricDescriptor md = CycleMetricsAnalyzerAdapter.this.getStructuralDebtIndexMetric();
                if (md != null) {
                    CycleMetricsAnalyzerAdapter.this.storeMetricValue(CycleMetricAnalyzerJob.this.getResult(), CycleMetricsAnalyzerAdapter.this.getScope(this.m_scope), val, md);
                }
            }

            private void setCyclicityMetric(int val) {
                IMetricDescriptor md = CycleMetricsAnalyzerAdapter.this.getCyclicityMetric();
                if (md != null) {
                    CycleMetricsAnalyzerAdapter.this.storeMetricValue(CycleMetricAnalyzerJob.this.getResult(), CycleMetricsAnalyzerAdapter.this.getScope(this.m_scope), val, md);
                }
                this.setRelativeCyclicityMetric(val);
            }

            private void setRelativeCyclicityMetric(int cyclicity) {
                IMetricDescriptor md = CycleMetricsAnalyzerAdapter.this.getRelativeCyclicityMetric();
                if (md != null) {
                    IMetricId noe = CycleMetricsAnalyzerAdapter.this.getNumberOfElementsMetricId();
                    if (noe == null) {
                        return;
                    }
                    Number noElements = this.m_metricAccessor.getMetricValue(CycleMetricAnalyzerJob.this.getSoftwareSystem(), CycleMetricsAnalyzerAdapter.this.getScope(this.m_scope), noe);
                    if (noElements == null || noElements.intValue() == 0) {
                        CycleMetricsAnalyzerAdapter.this.storeMetricValue(CycleMetricAnalyzerJob.this.getResult(), CycleMetricsAnalyzerAdapter.this.getScope(this.m_scope), Float.valueOf(0.0f), md);
                        return;
                    }
                    double val = 100.0 * Math.sqrt(cyclicity) / noElements.doubleValue();
                    CycleMetricsAnalyzerAdapter.this.storeMetricValue(CycleMetricAnalyzerJob.this.getResult(), CycleMetricsAnalyzerAdapter.this.getScope(this.m_scope), Float.valueOf((float)val), md);
                    CycleMetricAnalyzerJob.this.m_averageRelativeCyclicityAggregator += noElements.doubleValue() * val;
                    CycleMetricAnalyzerJob.this.m_totalElements += noElements.intValue();
                }
            }

            protected void compute() {
                IWorkerContext workerContext = CycleMetricAnalyzerJob.this.getWorkerContext();
                VirtualModel vm = CycleMetricsAnalyzerAdapter.this.getCurrentModel();
                List requiredResults = CycleMetricAnalyzerJob.this.getRequiredResults();
                assert (requiredResults.size() >= 2) : "At least 2 required results expected: " + String.valueOf(requiredResults);
                assert (((AnalyzerResult)requiredResults.get(0)).getId().equals(CoreAnalyzerId.SIZE_METRICS)) : "Size metrics analyzer result must be at first position: " + String.valueOf(requiredResults);
                int cyclicElements = 0;
                int ignoredCyclicElements = 0;
                int cycleGroupCount = 0;
                int criticalCycleGroupCount = 0;
                int biggestCycleGroupSize = 0;
                int cyclicity = 0;
                int refsToCut = 0;
                int cdToCut = 0;
                int sdi = 0;
                int i = 1;
                while (i < requiredResults.size()) {
                    AnalyzerResult nextRequiredBaseAnalyzerResult = (AnalyzerResult)requiredResults.get(i);
                    for (AnalyzerCycleGroup nextCycleGroup : nextRequiredBaseAnalyzerResult.getChildren(AnalyzerCycleGroup.class)) {
                        if (workerContext.hasBeenCanceled()) {
                            return;
                        }
                        if (!CycleMetricsAnalyzerAdapter.this.runOnSystemLevel() && nextCycleGroup.getScope() != this.m_scope) continue;
                        ResolutionState resolutionState = ResolutionState.NONE;
                        Issue issue = vm.getElementIssue(nextCycleGroup, nextCycleGroup.getCycleGroupIssueId());
                        if (issue != null && issue.getResolution() != null) {
                            ResolutionState resolutionState2 = resolutionState = issue.getResolution().ignores() ? ResolutionState.IGNORED : ResolutionState.TASK;
                        }
                        if (resolutionState == ResolutionState.IGNORED) {
                            ignoredCyclicElements += nextCycleGroup.getNumberOfCyclicElements();
                        }
                        int size = nextCycleGroup.getNumberOfCyclicElements();
                        cyclicElements += size;
                        ++cycleGroupCount;
                        if (nextCycleGroup.isCritical()) {
                            ++criticalCycleGroupCount;
                        }
                        cyclicity += size * size;
                        if (size > biggestCycleGroupSize) {
                            biggestCycleGroupSize = size;
                        }
                        refsToCut += nextCycleGroup.getParserDependenciesToRemove();
                        cdToCut += nextCycleGroup.getComponentDependenciesToRemove();
                        sdi += nextCycleGroup.getStructuralDebtIndex();
                    }
                    ++i;
                }
                this.setNumberOfIgnoredCyclicElements(ignoredCyclicElements);
                this.setNumberOfCycleGroups(cycleGroupCount);
                this.setNumberOfCriticalCycleGroups(criticalCycleGroupCount);
                this.setNumberOfCyclicElements(cyclicElements);
                this.setSizeOfBiggestCycleGroup(biggestCycleGroupSize);
                this.setCyclicityMetric(cyclicity);
                this.setReferencesToCutMetric(refsToCut);
                this.setComponentDependenciesToCutMetric(cdToCut);
                this.setStructuralDebtIndexMetric(sdi);
            }
        }
    }

    private static enum ResolutionState {
        NONE,
        IGNORED,
        TASK;

    }
}

