/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.coupling;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.coupling.AbstractDependencyMetricsModuleAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.IIncomingDependencyCumulatorAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.foundation.common.graph.IncomingDependencyCumulator;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.metrics.ValueList;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.workspace.Module;

public final class IncomingDependencyMetricsModule
extends AbstractDependencyMetricsModuleAdapter {
    public static final IConfigurableAnalyzerId ID = CoreAnalyzerId.INCOMING_DEPENDENCY_METRICS_MODULE;
    private final IMetricDescriptor m_usedFromModule;
    private final IMetricDescriptor m_fanInDescriptor;

    public IncomingDependencyMetricsModule(IAnalyzerController controller) {
        super(controller, ID);
        MetricProvider mp = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        this.m_usedFromModule = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_USED_FROM_MODULE, CoreMetricLevel.COMPONENT, null);
        this.m_fanInDescriptor = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_FAN_IN_MODULE, CoreMetricLevel.COMPONENT, null);
    }

    @Override
    public void runJobs(AnalyzerResult result) {
        IncomingDependencyMetricsModuleJob job = new IncomingDependencyMetricsModuleJob(this.getGroup(), result, this.getController());
        job.start();
    }

    private class IncomingDependencyMetricsModuleJob
    extends AbstractDependencyMetricsModuleAdapter.DependencyMetricsModuleJob
    implements IIncomingDependencyCumulatorAdapter {
        private ValueList m_currentUsedFromList;
        private ValueList m_currentFanInList;

        private IncomingDependencyMetricsModuleJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller) {
            super(group, result, controller);
        }

        @Override
        protected void processModule(Module module, NodeAdapterSet<ParserDependencyNodeAdapter> nodeAdapterSet) {
            assert (module != null) : "Parameter 'module' of method 'calculateDependencyMetrics' must not be null";
            this.m_currentUsedFromList = IncomingDependencyMetricsModule.this.createValueList(this.getResult(), IncomingDependencyMetricsModule.this.m_usedFromModule, module);
            this.m_currentFanInList = IncomingDependencyMetricsModule.this.createValueList(this.getResult(), IncomingDependencyMetricsModule.this.m_fanInDescriptor, module);
            if (nodeAdapterSet != null && !nodeAdapterSet.getNodes().isEmpty()) {
                new IncomingDependencyCumulator(nodeAdapterSet.getNodes(), this.getWorkerContext(), this);
            }
        }

        @Override
        public void setUsedFrom(INode<?> node, int usedFrom) {
            this.m_currentUsedFromList.addValue(((ParserDependencyNodeAdapter)node).getUnderlyingObject(), usedFrom);
        }

        @Override
        public void setFanIn(INode<?> node, float fanIn) {
            this.m_currentFanInList.addValue(((ParserDependencyNodeAdapter)node).getUnderlyingObject(), Float.valueOf(fanIn));
        }

        @Override
        public boolean isNodeIncluded(INode<?> node) {
            assert (node != null) : "Parameter 'node' of method 'isNodeIncluded' must not be null";
            NamedElement namedElement = ((ParserDependencyNodeAdapter)node).getUnderlyingObject();
            return !namedElement.ignoreIssues();
        }
    }
}

