/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.coupling;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerJob;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.base.IMetricAwareLanguageProvider;
import com.hello2morrow.sonargraph.core.foundation.common.graph.CycleAnalyzer;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.CycleAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.analysis.NaturalPackage;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementProxy;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.DependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyEdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public final class CalculateMaintainabilityLevelAnalyzerAdapter
extends AnalyzerAdapter {
    public static final IConfigurableAnalyzerId ID = CoreAnalyzerId.MAINTAINABILITY_LEVEL;
    private static final int SMALL_SYSTEM_COMPONENTS_THRESHOLD = 100;
    private static final Predicate<ProgrammingElement> PE = pe -> !pe.isExcluded() && !pe.ignoreIssues() && !pe.getRefactoringState().hasBeenDeleted();
    private static final Predicate<ParserDependency> PD = pd -> !pd.isExcluded() && !pd.getTo().isExcluded() && !pd.ignoreIssues() && pd.isCompileTimeDependency() && !pd.getRefactoringState().hasBeenDeleted();
    private Map<NamedElement, NaturalPackage> m_naturalPackageMap;
    private final IMetricDescriptor m_maintainabilityLevelModule;
    private final IMetricDescriptor m_maintainabilityLevelSystem;
    private final IMetricDescriptor m_mlFanInModule;

    public CalculateMaintainabilityLevelAnalyzerAdapter(IAnalyzerController controller) {
        super(controller, ID);
        MetricProvider mp = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        this.m_maintainabilityLevelModule = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_MAINTAINABILITY_LEVEL, CoreMetricLevel.MODULE, null);
        this.m_maintainabilityLevelSystem = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_MAINTAINABILITY_LEVEL, CoreMetricLevel.SYSTEM, null);
        this.m_mlFanInModule = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_ML_FAN_IN_MODULE, CoreMetricLevel.COMPONENT, null);
    }

    @Override
    protected void runJobs(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'runJobs' must not be null";
        List<AnalyzerResult> requiredResults = this.getController().getResultsFor(AnalyzerGroup.CYCLE_METRICS);
        MaintainabilityLevelCalculatorJob job = requiredResults.isEmpty() ? new MaintainabilityLevelCalculatorJob(this.getGroup(), result, this.getController()) : new MaintainabilityLevelCalculatorJob(this.getGroup(), result, this.getController(), requiredResults);
        job.start();
    }

    @Override
    protected IssueFilter getIssueFilter(AnalyzerResult result) {
        return null;
    }

    @Override
    public boolean canStoreResult() {
        return true;
    }

    private class MaintainabilityLevelCalculatorJob
    extends AnalyzerJob {
        private final Map<Module, Integer> m_moduleSizeMap;
        private final Map<Module, Double> m_moduleMlMap;
        private int m_totalNumberOfComponents;

        private MaintainabilityLevelCalculatorJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller) {
            super(group, result, controller);
            this.m_moduleSizeMap = new THashMap();
            this.m_moduleMlMap = new THashMap();
        }

        private MaintainabilityLevelCalculatorJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller, List<AnalyzerResult> requiredResults) {
            super(group, result, controller, requiredResults);
            this.m_moduleSizeMap = new THashMap();
            this.m_moduleMlMap = new THashMap();
        }

        @Override
        protected void internalRun() {
            List<Module> modules = this.getSoftwareSystem().getUniqueExistingChild(Workspace.class).getChildren(Module.class);
            this.getWorkerContext().setNumberOfSteps(modules.size() * 5);
            for (Module module : modules) {
                if (this.getWorkerContext().hasBeenCanceled()) {
                    return;
                }
                this.calculateMaintainabilityLevel(module, CalculateMaintainabilityLevelAnalyzerAdapter.this.m_maintainabilityLevelModule, CalculateMaintainabilityLevelAnalyzerAdapter.this.m_mlFanInModule);
                this.getWorkerContext().endStep();
            }
            int limit = this.m_totalNumberOfComponents * 3 / 4;
            int total = 0;
            double totalMl = 0.0;
            modules.sort((m1, m2) -> this.m_moduleSizeMap.get(m2) - this.m_moduleSizeMap.get(m1));
            for (Module mod : modules) {
                if (this.getWorkerContext().hasBeenCanceled()) {
                    return;
                }
                int size = this.m_moduleSizeMap.get(mod);
                Double ml = this.m_moduleMlMap.get(mod);
                if (total >= limit && size < 100) break;
                if (ml == null) {
                    return;
                }
                totalMl += (double)size * ml;
                total += size;
            }
            totalMl = total == 0 ? 100.0 : (totalMl /= (double)total);
            CalculateMaintainabilityLevelAnalyzerAdapter.this.storeMetricValue(this.getResult(), this.getSoftwareSystem(), totalMl, CalculateMaintainabilityLevelAnalyzerAdapter.this.m_maintainabilityLevelSystem);
        }

        private void calculateMaintainabilityLevel(Module module, IMetricDescriptor metricDescr, IMetricDescriptor compMetric) {
            assert (module != null) : "Parameter 'module' of method 'calculateMaintainabilityLevel' must not be null";
            assert (metricDescr != null) : "Parameter 'metricDescr' of method 'calculateMaintainabilityLevel' must not be null";
            assert (compMetric != null) : "Parameter 'compMetric' of method 'calculateMaintainabilityLevel' must not be null";
            ArrayList<NamedElement> components = new ArrayList<NamedElement>();
            for (IComponent next : module.getChildrenRecursively(IComponent.class, IComponent.class)) {
                if (this.getWorkerContext().hasBeenCanceled()) {
                    return;
                }
                if (next.isExcluded() || next.isExternal() || next.ignoreIssues()) continue;
                components.add(next.getNamedElement());
            }
            if (components.size() <= 1) {
                CalculateMaintainabilityLevelAnalyzerAdapter.this.storeMetricValue(this.getResult(), module, 100.0, metricDescr);
                this.m_moduleSizeMap.put(module, 0);
                this.m_moduleMlMap.put(module, 100.0);
                return;
            }
            this.m_totalNumberOfComponents += components.size();
            this.m_moduleSizeMap.put(module, components.size());
            CalculateMaintainabilityLevelAnalyzerAdapter.this.m_naturalPackageMap = new THashMap();
            this.getWorkerContext().beginSubTask("Creating first node adapter set for: " + module.getName());
            ParserDependencyNodeAdapterSet nodeAdapterSet = new ParserDependencyNodeAdapterSet(this.getWorkerContext(), components, new SpecialCollector(), PE, PD);
            if (this.getWorkerContext().hasBeenCanceled()) {
                CalculateMaintainabilityLevelAnalyzerAdapter.this.m_naturalPackageMap = null;
                return;
            }
            this.getWorkerContext().endSubTask();
            this.getWorkerContext().beginSubTask("Calculating cycles for: " + module.getName());
            CycleAnalyzerAdapter cycleAnalyzerAdapter = new CycleAnalyzerAdapter(nodeAdapterSet);
            CycleAnalyzer.compute(cycleAnalyzerAdapter, this.getWorkerContext());
            this.getWorkerContext().endSubTask();
            if (this.getWorkerContext().hasBeenCanceled()) {
                CalculateMaintainabilityLevelAnalyzerAdapter.this.m_naturalPackageMap = null;
                return;
            }
            Collection<? extends NodeAdapter> cyclicNodes = cycleAnalyzerAdapter.getCyclicNodes();
            THashMap naturalPackageMap = new THashMap();
            THashSet naturalPackages = new THashSet();
            for (NodeAdapter nodeAdapter : cyclicNodes) {
                if (this.getWorkerContext().hasBeenCanceled()) {
                    return;
                }
                Integer group = cycleAnalyzerAdapter.getGroup(nodeAdapter);
                NaturalPackage naturalPackage = (NaturalPackage)naturalPackageMap.get(group);
                if (naturalPackage == null) {
                    naturalPackage = new NaturalPackage(this.getResult());
                    naturalPackages.add(naturalPackage);
                    naturalPackageMap.put(group, naturalPackage);
                }
                naturalPackage.addChild(new NamedElementProxy(naturalPackage, nodeAdapter.getUnderlyingObject()));
                CalculateMaintainabilityLevelAnalyzerAdapter.this.m_naturalPackageMap.put(nodeAdapter.getUnderlyingObject(), naturalPackage);
            }
            if (this.getWorkerContext().hasBeenCanceled()) {
                CalculateMaintainabilityLevelAnalyzerAdapter.this.m_naturalPackageMap = null;
                return;
            }
            for (ParserDependencyNodeAdapter parserDependencyNodeAdapter : nodeAdapterSet.getNodes()) {
                if (this.getWorkerContext().hasBeenCanceled()) {
                    CalculateMaintainabilityLevelAnalyzerAdapter.this.m_naturalPackageMap = null;
                    return;
                }
                if (cyclicNodes.contains(parserDependencyNodeAdapter)) continue;
                NaturalPackage naturalPackage = new NaturalPackage(this.getResult());
                naturalPackages.add(naturalPackage);
                naturalPackage.addChild(new NamedElementProxy(naturalPackage, parserDependencyNodeAdapter.getUnderlyingObject()));
                CalculateMaintainabilityLevelAnalyzerAdapter.this.m_naturalPackageMap.put(parserDependencyNodeAdapter.getUnderlyingObject(), naturalPackage);
            }
            if (this.getWorkerContext().hasBeenCanceled()) {
                CalculateMaintainabilityLevelAnalyzerAdapter.this.m_naturalPackageMap = null;
                return;
            }
            this.getWorkerContext().beginSubTask("Creating second node adapter set for: " + module.getName());
            nodeAdapterSet = new ParserDependencyNodeAdapterSet(this.getWorkerContext(), (Collection<? extends NamedElement>)naturalPackages, new NaturalPackageCollector(), PE, PD);
            this.getWorkerContext().endSubTask();
            this.getWorkerContext().beginSubTask("Calculating levels for: " + module.getName());
            cycleAnalyzerAdapter = new CycleAnalyzerAdapter(nodeAdapterSet);
            CycleAnalyzer.compute(cycleAnalyzerAdapter, this.getWorkerContext());
            this.getWorkerContext().endSubTask();
            assert (cycleAnalyzerAdapter.getCyclicNodes().isEmpty());
            if (this.getWorkerContext().hasBeenCanceled()) {
                CalculateMaintainabilityLevelAnalyzerAdapter.this.m_naturalPackageMap = null;
                return;
            }
            double d = this.computeMaintainabilityLevel(module, nodeAdapterSet, compMetric, 100);
            if (this.getWorkerContext().hasBeenCanceled()) {
                CalculateMaintainabilityLevelAnalyzerAdapter.this.m_naturalPackageMap = null;
                return;
            }
            IMetricAwareLanguageProvider languageProvider = CalculateMaintainabilityLevelAnalyzerAdapter.this.getController().getLanguageProvider(module.getLanguage());
            Double alternateMaintainabilityLevel = languageProvider.computeLanguageSpecificMaintainabilityLevel(this.getSoftwareSystem(), module);
            if (alternateMaintainabilityLevel == null) {
                CalculateMaintainabilityLevelAnalyzerAdapter.this.m_naturalPackageMap = null;
                return;
            }
            d = Math.min(d, alternateMaintainabilityLevel);
            this.m_moduleMlMap.put(module, d);
            CalculateMaintainabilityLevelAnalyzerAdapter.this.storeMetricValue(this.getResult(), module, d, metricDescr);
            CalculateMaintainabilityLevelAnalyzerAdapter.this.m_naturalPackageMap = null;
        }

        private double computeMaintainabilityLevel(Module module, NodeAdapterSet<ParserDependencyNodeAdapter> nodeAdapterSet, IMetricDescriptor compMetric, int smallSystemThreshold) {
            assert (module != null) : "Parameter 'module' of method 'computeMaintainabilityLevel' must not be null";
            assert (nodeAdapterSet != null) : "Parameter 'nodeAdapterSet' of method 'computeMaintainabilityLevel' must not be null";
            assert (compMetric != null) : "Parameter 'compMetric' of method 'computeMaintainabilityLevel' must not be null";
            THashMap levelMap = new THashMap();
            THashMap penaltyMap = new THashMap();
            int maxLevel = 0;
            IWorkerContext workerContext = this.getWorkerContext();
            for (ParserDependencyNodeAdapter nextNode : nodeAdapterSet.getNodes()) {
                ArrayList<ParserDependencyNodeAdapter> levelMembers;
                if (workerContext.hasBeenCanceled()) {
                    return 0.0;
                }
                int level = nextNode.getLevel();
                assert (level >= 1);
                if (level > maxLevel) {
                    maxLevel = level;
                }
                if ((levelMembers = (ArrayList<ParserDependencyNodeAdapter>)levelMap.get(level)) == null) {
                    levelMembers = new ArrayList<ParserDependencyNodeAdapter>();
                    levelMap.put(level, levelMembers);
                }
                levelMembers.add(nextNode);
            }
            if (workerContext.hasBeenCanceled()) {
                return 0.0;
            }
            int[] cumulatedLevelSize = new int[maxLevel];
            int cumulatedSize = 0;
            int i = maxLevel;
            while (i >= 1) {
                if (workerContext.hasBeenCanceled()) {
                    return 0.0;
                }
                int size = 0;
                for (ParserDependencyNodeAdapter node : (List)levelMap.get(i)) {
                    if (this.getWorkerContext().hasBeenCanceled()) {
                        return 0.0;
                    }
                    int nodeSize = node.getUnderlyingObject().getNumberOfChildren();
                    size += nodeSize;
                    double penalty = nodeSize <= 5 ? 100.0 : 100.0 / ((double)nodeSize / 5.0);
                    penaltyMap.put(node, penalty);
                }
                cumulatedLevelSize[i - 1] = cumulatedSize += size;
                --i;
            }
            double maintainabilityLevel = 0.0;
            int i2 = maxLevel;
            while (i2 >= 1) {
                if (workerContext.hasBeenCanceled()) {
                    return 0.0;
                }
                for (ParserDependencyNodeAdapter node : (List)levelMap.get(i2)) {
                    double fanIn;
                    if (workerContext.hasBeenCanceled()) {
                        return 0.0;
                    }
                    double factor = (Double)penaltyMap.get(node) * (double)node.getUnderlyingObject().getNumberOfChildren() / (double)cumulatedSize;
                    if (i2 == maxLevel) {
                        maintainabilityLevel += factor;
                        fanIn = 0.0;
                    } else {
                        int usedFrom = this.calculateUsedFrom(node, (Set<ParserDependencyNodeAdapter>)new THashSet());
                        assert (usedFrom <= cumulatedLevelSize[i2]);
                        fanIn = (double)usedFrom / (double)cumulatedLevelSize[i2];
                        maintainabilityLevel += factor * (1.0 - fanIn);
                    }
                    NaturalPackage np = (NaturalPackage)node.getUnderlyingObject();
                    np.getChildren(NamedElementProxy.class).forEach(c -> CalculateMaintainabilityLevelAnalyzerAdapter.this.storeMetricValue(this.getResult(), c.getElement(), 100.0 * fanIn, compMetric));
                }
                --i2;
            }
            if (cumulatedSize < smallSystemThreshold) {
                maintainabilityLevel = 100.0 * (double)(smallSystemThreshold - cumulatedSize) / (double)smallSystemThreshold + (double)cumulatedSize / (double)smallSystemThreshold * maintainabilityLevel;
            }
            return maintainabilityLevel;
        }

        private int calculateUsedFrom(ParserDependencyNodeAdapter node, Set<ParserDependencyNodeAdapter> visited) {
            int usedFrom = 0;
            IWorkerContext workerContext = this.getWorkerContext();
            for (ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter> edge : node.getIncomingEdges()) {
                if (workerContext.hasBeenCanceled()) {
                    return 0;
                }
                ParserDependencyNodeAdapter from = (ParserDependencyNodeAdapter)edge.getFrom();
                if (!visited.add(from)) continue;
                usedFrom += from.getUnderlyingObject().getNumberOfChildren();
                usedFrom += this.calculateUsedFrom(from, visited);
            }
            return usedFrom;
        }
    }

    private class NaturalPackageCollector
    extends SpecialCollector {
        private NaturalPackageCollector() {
        }

        @Override
        public Collection<ProgrammingElement> getProgrammingElements(NamedElement forNamedElement) {
            assert (forNamedElement instanceof NaturalPackage) : "Not a natural package: " + String.valueOf(forNamedElement);
            ArrayList<ProgrammingElement> result = new ArrayList<ProgrammingElement>();
            for (NamedElementProxy proxy : forNamedElement.getChildren(NamedElementProxy.class)) {
                NamedElement orig = proxy.getElement();
                result.addAll(orig.getChildrenRecursively(ProgrammingElement.class, new Class[0]));
            }
            return result;
        }

        @Override
        public NamedElement getFirstCandidateForNodeAdapterLookUp(NamedElement element) {
            assert (element instanceof ProgrammingElement) : "Not a programming element : " + String.valueOf(element);
            if (element.isExternal()) {
                return null;
            }
            if (element.isExcluded() || element.ignoreIssues()) {
                return null;
            }
            IComponent comp = element.getParent(IComponent.class, new Class[0]);
            if (comp == null) {
                return null;
            }
            return CalculateMaintainabilityLevelAnalyzerAdapter.this.m_naturalPackageMap.get(comp.getNamedElement());
        }
    }

    private static class SpecialCollector
    extends DependencyEndpointCollector {
        private SpecialCollector() {
        }

        @Override
        public boolean addDependency(NamedElement from, NamedElement to, Dependency dependency) {
            if (from == to || to.isExternal() || to.ignoreIssues()) {
                return false;
            }
            ParserDependency dep = (ParserDependency)dependency;
            return dep.getGenericDependencyType() != CoreParserDependencyType.USES;
        }
    }
}

