/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.diff.DiffProcess;
import com.hello2morrow.sonargraph.core.controller.system.graphview.ISystemDiffAdditionalInfoProvider;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.StandardFilePathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerState;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.analysis.SystemDiffAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemBaseDirectory;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemDirectory;
import com.hello2morrow.sonargraph.core.model.system.BaselinesDirectory;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.Baseline;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineInfo;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.ISystemDiffProvider;
import com.hello2morrow.sonargraph.core.model.system.diff.MetricValueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.MetricsDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.SoftwareSystemDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.SystemDiffConfiguration;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.CycleGroupIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.CyclicElementDiff;
import com.hello2morrow.sonargraph.core.model.system.ranking.IssueRank;
import com.hello2morrow.sonargraph.core.persistence.diff.BaselineReader;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.set.hash.THashSet;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

abstract class SystemDiffProvider
extends Extension
implements ISystemDiffProvider,
ISystemDiffAdditionalInfoProvider {
    private final SoftwareSystem m_softwareSystem;
    private final IAnalyzerController m_analyzerController;
    private final boolean m_isLicensed;

    protected SystemDiffProvider(SoftwareSystem softwareSystem, IAnalyzerController analyzerController) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'SystemDiffProvider' must not be null";
        assert (analyzerController != null) : "Parameter 'analyzerController' of method 'SystemDiffProvider' must not be null";
        this.m_softwareSystem = softwareSystem;
        this.m_analyzerController = analyzerController;
        this.m_isLicensed = this.m_analyzerController.isAnalyzerLicensed(CoreAnalyzerId.SYSTEM_DIFF);
    }

    @Override
    public IPathValidator getBaselineValidator() {
        return new BaselineFilePathValidator();
    }

    protected final SoftwareSystem getSoftwareSystem() {
        return this.m_softwareSystem;
    }

    @Override
    public String getBaselineFileNameProposal() {
        return this.m_softwareSystem.getName() + "_" + Iso8601DateFormat.formatDateAndTimeForFileName((Date)new Date());
    }

    @Override
    public OperationResultWithOutcome<BaselineInfo> getBaselineInfo(TFile baselineReport) {
        assert (baselineReport != null) : "Parameter 'baselineReport' of method 'getBaselineInfo' must not be null";
        try {
            return new BaselineReader().read(baselineReport);
        }
        catch (Exception e) {
            OperationResultWithOutcome result = new OperationResultWithOutcome("Reading info for baseline " + baselineReport.getPath());
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)e);
            return result;
        }
    }

    @Override
    public BaselinesDirectory getBaselinesDirectory() {
        return this.m_softwareSystem.getUniqueExistingChild(Files.class).getUniqueExistingChild(SoftwareSystemBaseDirectory.class).getUniqueExistingChild(SoftwareSystemDirectory.class).getUniqueExistingChild(BaselinesDirectory.class);
    }

    public final IDiffElement getFirstDiffElement(SoftwareSystemDiff softwareSystemDiff, Element element) {
        assert (softwareSystemDiff != null) : "Parameter 'softwareSystemDiff' of method 'getFirstDiffElement' must not be null";
        assert (element != null) : "Parameter 'element' of method 'getFirstDiffElement' must not be null";
        Element toMatch = element instanceof IssueRank ? ((IssueRank)element).getRankedElement() : element;
        return DiffProcess.findDiffFor(softwareSystemDiff, toMatch);
    }

    @Override
    public final IDiffElement getFirstDiffElement(List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'getDiffElements' must not be null";
        SoftwareSystemDiff softwareSystemDiff = this.getSoftwareSystemDiff();
        if (softwareSystemDiff != null) {
            for (Element next : elements) {
                IDiffElement diff = this.getFirstDiffElement(softwareSystemDiff, next);
                if (diff == null) continue;
                return diff;
            }
        }
        return null;
    }

    @Override
    public Set<NamedElement> getAddedCyclicElements(List<CycleGroup> cycleGroups) {
        assert (cycleGroups != null && !cycleGroups.isEmpty()) : "Parameter 'cycleGroups' of method 'getAddedCyclicElements' must not be empty";
        SoftwareSystemDiff softwareSystemDiff = this.getSoftwareSystemDiff();
        if (softwareSystemDiff != null) {
            THashSet namedElements = new THashSet();
            for (CycleGroup nextCycleGroup : cycleGroups) {
                IDiffElement diffElement = this.getFirstDiffElement(softwareSystemDiff, nextCycleGroup);
                if (diffElement == null) continue;
                assert (diffElement instanceof CycleGroupIssueDiff) : "Wrong diff element type: " + diffElement.getClass().getCanonicalName();
                CycleGroupIssueDiff cycleDiff = (CycleGroupIssueDiff)diffElement;
                if (diffElement.getChange() == IDiffElement.Change.ADDED) {
                    namedElements.addAll(cycleDiff.getChildren(CyclicElementDiff.class).stream().map(e -> (NamedElement)e.getCurrent()).collect(Collectors.toSet()));
                    continue;
                }
                namedElements.addAll(cycleDiff.getChildren(CyclicElementDiff.class).stream().filter(e -> e.getChange() == IDiffElement.Change.ADDED).map(e -> (NamedElement)e.getCurrent()).collect(Collectors.toSet()));
            }
            return Collections.unmodifiableSet(namedElements);
        }
        return Collections.emptySet();
    }

    protected final String createDefaultDiffFileName(Date timestamp) {
        assert (timestamp != null) : "Parameter 'timestamp' of method 'createDefaultDiffFileName' must not be null";
        return this.getSoftwareSystem().getName() + "_diff_" + Iso8601DateFormat.formatDateAndTimeForFileName((Date)timestamp);
    }

    @Override
    public final String createDiffFileName(String mainReportFileName, Date timestamp) {
        assert (timestamp != null) : "Parameter 'timestamp' of method 'createDiffFileName' must not be null";
        return mainReportFileName != null && mainReportFileName.trim().length() > 0 ? mainReportFileName + "_diff" : this.createDefaultDiffFileName(timestamp);
    }

    @Override
    public final AnalyzerConfigurationFile getSystemDiffAnalyzerConfigurationFile() {
        assert (this.isLicensed()) : "Not licensed";
        AnalyzerConfigurationFile configurationFile = this.getSoftwareSystem().getExtension(IAnalyzerController.class).getAnalyzerConfigurationFile(CoreAnalyzerId.SYSTEM_DIFF);
        assert (configurationFile != null) : "Parameter 'configurationFile' of method 'getSistemDiffAnalyzerConfigurationFile' must not be null";
        return configurationFile;
    }

    protected final SystemDiffAnalyzerConfiguration getSystemDiffAnalyzerConfiguration() {
        assert (this.isLicensed()) : "Not licensed";
        IAnalyzerController analyzerExtension = this.getSoftwareSystem().getExtension(IAnalyzerController.class);
        AnalyzerConfiguration config = analyzerExtension.getConfiguration(CoreAnalyzerId.SYSTEM_DIFF);
        assert (config != null && config instanceof SystemDiffAnalyzerConfiguration) : "Unexpected class in method 'getAnalyzerConfiguration': " + String.valueOf(config);
        return (SystemDiffAnalyzerConfiguration)config;
    }

    @Override
    public final boolean isLicensed() {
        return this.m_isLicensed;
    }

    @Override
    public final TFile getActiveBaselineFile() {
        return this.isLicensed() ? this.getSystemDiffConfiguration().getActiveBaselineFile() : null;
    }

    @Override
    public final boolean isSoftwareSystemDiffAvailable() {
        if (this.isLicensed()) {
            AnalyzerResult result = this.m_analyzerController.getResultFor(CoreAnalyzerId.SYSTEM_DIFF);
            return result != null && result.getState() == AnalyzerState.FINISHED;
        }
        return false;
    }

    @Override
    public final SoftwareSystemDiff getSoftwareSystemDiff() {
        AnalyzerResult result;
        if (this.isLicensed() && (result = this.m_analyzerController.getResultFor(CoreAnalyzerId.SYSTEM_DIFF)) != null && result.getState() == AnalyzerState.FINISHED) {
            return result.getUniqueChild(SoftwareSystemDiff.class);
        }
        return null;
    }

    @Override
    public final boolean executesOnCurrentAnalyzerExecutionLevel() {
        return this.isLicensed() && this.m_analyzerController.getAnalyzerExecutionLevel() == AnalyzerExecutionLevel.FULL;
    }

    @Override
    public final boolean isComputeAndSetBaslinePossible() {
        return this.isLicensed() && this.getSoftwareSystem().isClearable() && this.m_analyzerController.getAnalyzerExecutionLevel() == AnalyzerExecutionLevel.FULL;
    }

    @Override
    public final boolean mayBeActivated(Baseline baseline) {
        assert (baseline != null) : "Parameter 'baseline' of method 'mayBeActivated' must not be null";
        if (this.isLicensed()) {
            TFile activeBaselineFile = this.getActiveBaselineFile();
            return activeBaselineFile == null ? true : !FileUtility.refersToSameFile((TFile)activeBaselineFile, (TFile)baseline.getFile());
        }
        return false;
    }

    @Override
    public final boolean mayBeDeactivated(Baseline baseline) {
        if (this.isLicensed()) {
            assert (baseline != null) : "Parameter 'baseline' of method 'mayBeDeactivated' must not be null";
            TFile activeBaselineFile = this.getActiveBaselineFile();
            return activeBaselineFile == null ? false : FileUtility.areEqual((TFile)activeBaselineFile, (TFile)baseline.getFile());
        }
        return false;
    }

    @Override
    public final Pair<String, String> getBaselineInfo() {
        SystemDiffConfiguration diffConfiguration;
        TFile baseline;
        if (this.isLicensed() && (baseline = (diffConfiguration = this.getSystemDiffConfiguration()).getActiveBaselineFile()) != null) {
            StringBuilder info = new StringBuilder();
            info.append(baseline.getName());
            info.append(" (type '");
            info.append(diffConfiguration.getBaselineType().getPresentationName());
            info.append("')");
            return new Pair((Object)info.toString(), (Object)FileUtility.getCanonicalFilePath((TFile)baseline));
        }
        return new Pair((Object)"Inactive", null);
    }

    @Override
    public final MetricValueDiff getMetricDiff(SoftwareSystemDiff systemDiff, IMetricDescriptor metricDescriptor) {
        assert (systemDiff != null) : "Parameter 'systemDiff' of method 'getMetricDiff' must not be null";
        assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'getMetricDiff' must not be null";
        MetricsDiff metricsDiff = systemDiff.getUniqueChild(MetricsDiff.class);
        if (metricsDiff == null) {
            return null;
        }
        if (metricDescriptor.getLevel() != CoreMetricLevel.SYSTEM) {
            return null;
        }
        for (MetricValueDiff next : metricsDiff.getChildren(MetricValueDiff.class)) {
            if (next.getCurrent() == null || ((IMetricValue)next.getCurrent()).getMetricDescriptor() != metricDescriptor) continue;
            return next;
        }
        return null;
    }

    @Override
    public final String aboutToSaveFullSnapshot() {
        SystemDiffConfiguration configuration = this.getSystemDiffConfiguration();
        TFile activeBaseline = configuration.getActiveBaselineFile();
        if (activeBaseline != null) {
            BaselinesDirectory baselinesDirectory = this.m_softwareSystem.getUniqueExistingChild(Files.class).getSoftwareSystemFilesDirectory(BaselinesDirectory.class);
            assert (baselinesDirectory != null) : "'baselinesDirectory' of method 'saveSnapshot' must not be null";
            TFile baselinesDir = baselinesDirectory.getFile();
            if (!FileUtility.isDirSameOrParentOf((TFile)baselinesDir, (TFile)activeBaseline)) {
                return "The active '" + configuration.getBaselineType().getPresentationName() + "' baseline is not located in the 'Baselines' directory!\nIf you want to distribute the created snapshot, that baseline might not be accessible on other machines.";
            }
        }
        return null;
    }

    private final class BaselineFilePathValidator
    extends StandardFilePathValidator {
        BaselineFilePathValidator() {
            super(CoreFileType.REPORT_XML, true, false);
        }

        @Override
        public ValidationResult isValid(TFile currentInput, TFile newInput) {
            ValidationResult result = super.isValid(currentInput, newInput);
            if (result.isSuccess()) {
                SystemDiffConfiguration configuration = SystemDiffProvider.this.getSystemDiffConfiguration();
                if (FileUtility.refersToSameFile((TFile)newInput, (TFile)configuration.getActiveBaselineFile())) {
                    result.addError("Already set as '" + configuration.getBaselineType().getPresentationName() + "' baseline.");
                }
                if (result.isSuccess()) {
                    try {
                        BaselineReader reader = new BaselineReader();
                        OperationResultWithOutcome<BaselineInfo> readResult = reader.read(newInput);
                        if (readResult.isFailure()) {
                            result.addError("Invalid baseline");
                        }
                    }
                    catch (Exception e) {
                        result.addError("Failed to process baseline");
                    }
                }
            }
            return result;
        }
    }
}

