/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.IQualityModelProvider;
import com.hello2morrow.sonargraph.core.controller.system.QualityGateProvider;
import com.hello2morrow.sonargraph.core.controller.system.analysis.IQualityGateFileProvider;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.base.AnalyzerConfigurationChangeMode;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.IModifiableFileProvider;
import com.hello2morrow.sonargraph.core.controller.system.base.ISoftwareSystemLifecycleListener;
import com.hello2morrow.sonargraph.core.controller.system.migration.QualityGateConditionIssueIdMigration;
import com.hello2morrow.sonargraph.core.controller.system.migration.QualityGateConditionSeverityResolutionMigration;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IQualityGateExtension;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.QualityGateCheckConfiguration;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileDeltaKey;
import com.hello2morrow.sonargraph.core.model.path.ImportQualityModel;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileCandidate;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDelta;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDeltaDetector;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFilesDirectory;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractCurrentIssueQualityGateConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractIssueDiffAgainstBaselineConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateElementInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.CurrentIssueQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.CurrentIssueQualityGateConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.CurrentSystemConditions;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.DiffAgainstBaselineConditions;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IssueDiffAgainstBaselineCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IssueDiffAgainstBaselineConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.MetricValueDiffQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.MetricValueDiffQualityGateConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateExcludeFilter;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateExcludeFilterInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGates;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueDiffAgainstBaselineCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueDiffAgainstBaselineConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueQualityGateConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.issue.QualityGateCheckConfigurationInconsistent;
import com.hello2morrow.sonargraph.core.persistence.qualitygate.QualityGatePersistence;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class QualityGateExtension
extends QualityGateProvider
implements IQualityGateExtension,
IQualityGateFileProvider,
IModifiableFileProvider,
IModifiableFileDeltaKey,
IQualityModelProvider,
ISoftwareSystemLifecycleListener {
    private final IFinishModelProcessor m_finishModelProcessor;

    public QualityGateExtension(Installation installation, SoftwareSystem softwareSystem, IFinishModelProcessor finishModelProcessor) {
        super(installation, softwareSystem);
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'QualityGateExtension' must not be null";
        this.m_finishModelProcessor = finishModelProcessor;
        this.m_finishModelProcessor.addListener(this);
    }

    @Override
    public void finishSoftwareSystemInitialization(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'finishSoftwareSystemInitialization' must not be null";
        Files files = this.getSoftwareSystem().getUniqueExistingChild(Files.class);
        QualityGates qualityGates = files.getQualityGatesDirectory();
        TFile directory = qualityGates.getDirectoryFile();
        String currentVersion = this.getInstallation().getVersion().toString();
        boolean writeToDisk = this.getSoftwareSystem().getMode() != SoftwareSystemMode.SYSTEM_LOADED_FROM_SNAPSHOT;
        new QualityGateConditionIssueIdMigration(writeToDisk, false).migrate(currentVersion, directory, result);
        new QualityGateConditionSeverityResolutionMigration(writeToDisk, true).migrate(currentVersion, directory, result);
    }

    @Override
    public void initialized(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result) {
        this.checkQualityGateCheckConfiguration(softwareSystem);
    }

    private void checkQualityGateCheckConfiguration(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'checkQualityGateCheckConfiguration' must not be null";
        IAnalyzerController analyzerExtension = softwareSystem.getExtension(IAnalyzerController.class);
        AnalyzerConfigurationFile analyzerConfigurationFile = analyzerExtension.getAnalyzerConfigurationFile(CoreAnalyzerId.QUALITY_GATES);
        if (analyzerConfigurationFile != null) {
            analyzerConfigurationFile.removeIssues();
            AnalyzerConfiguration configuration = analyzerExtension.getConfiguration(CoreAnalyzerId.QUALITY_GATES);
            if (configuration != null) {
                Map<String, QualityGate> identifyingPathToQualityGate = this.getQualityGatesDirectory().getChildren(QualityGate.class).stream().collect(Collectors.toMap(ModifiableFile::getIdentifyingPath, qg -> qg));
                assert (configuration instanceof QualityGateCheckConfiguration) : "Unexpected class in method 'initialized': " + String.valueOf(configuration);
                QualityGateCheckConfiguration qualityGateCheckConfiguration = (QualityGateCheckConfiguration)configuration;
                qualityGateCheckConfiguration.resetWarnings();
                for (String nextIdentifyingPath : qualityGateCheckConfiguration.getIdentifyingPaths()) {
                    QualityGate qualityGate = identifyingPathToQualityGate.remove(nextIdentifyingPath);
                    if (qualityGate == null) {
                        analyzerConfigurationFile.addIssue(new QualityGateCheckConfigurationInconsistent(analyzerConfigurationFile, "Quality Gate file '" + nextIdentifyingPath + "' not found."));
                        qualityGateCheckConfiguration.setWarning(nextIdentifyingPath, "Quality Gate file not found.");
                        continue;
                    }
                    qualityGate.setChecked(true);
                }
                for (QualityGate nextToSetUnchecked : identifyingPathToQualityGate.values()) {
                    nextToSetUnchecked.setChecked(false);
                }
            }
        }
    }

    @Override
    public void analyzerConfigurationChanged(IWorkerContext workerContext, AnalyzerConfigurationChangeMode mode, AnalyzerConfiguration configuration, EnumSet<Modification> modifications, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'configurationChanged' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'configurationChanged' must not be null";
        assert (configuration != null) : "Parameter 'configuration' of method 'configurationChanged' must not be null";
        assert (result != null) : "Parameter 'result' of method 'configurationChanged' must not be null";
        if (mode != AnalyzerConfigurationChangeMode.OPEN && configuration.affects(CoreAnalyzerId.QUALITY_GATES)) {
            if (modifications != null) {
                modifications.add(Modification.QUALITY_GATES_MODIFIED);
            }
            this.checkQualityGateCheckConfiguration(this.getSoftwareSystem());
        }
    }

    @Override
    public void checkOutOfSync(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'checkOutOfSync' must not be null";
        this.getQualityGatesDirectory().enforceExistence(result);
        if (result.isSuccess() && (SoftwareSystemFilesDirectory.isOutOfSync(this.getQualityGateCheckConfigurationFile()) || this.getQualityGatesDirectory().isOutOfSync(new String[][]{CoreFileType.QUALITY_GATE.getExtensions()}))) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, "Consider to refresh the system", new Object[0]);
        }
        if (this.getQualityGatesDirectory().isOutOfSync(new String[][]{CoreFileType.QUALITY_GATE.getExtensions()})) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, "Consider to refresh the system", new Object[0]);
        }
    }

    @Override
    public void prepareRefresh(ModifiableFileDeltaDetector deltaDetector, boolean onSystemOpen, PrepareRefreshResult result) {
        assert (deltaDetector != null) : "Parameter 'deltaDetector' of method 'prepareRefresh' must not be null";
        this.getQualityGatesDirectory().checkExistence();
        deltaDetector.detect(new ModifiableFileDeltaDetector.IProvider(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return QualityGateExtension.this;
            }

            @Override
            public boolean exists(IModifiableFile modifiableFile) {
                if (!$assertionsDisabled && modifiableFile == null) {
                    throw new AssertionError((Object)"Parameter 'modifiableFile' of method 'exists' must not be null");
                }
                return modifiableFile instanceof QualityGate;
            }

            @Override
            public DirectoryPath getDirectoryPath() {
                return QualityGateExtension.this.getQualityGatesDirectory();
            }

            @Override
            public List<IFileType> getFileTypes() {
                return Collections.singletonList(CoreFileType.QUALITY_GATE);
            }

            @Override
            public String getImageResource(IFileType fileType) {
                return QualityGate.class.getSimpleName();
            }
        });
    }

    @Override
    public void refreshFiles(IWorkerContext workerContext, ModifiableFileDelta delta, EnumSet<Modification> modifications, final OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refreshFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'refreshFiles' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'refreshFiles' must not be null";
        delta.visit(new ModifiableFileDelta.IVisitor(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return QualityGateExtension.this;
            }

            @Override
            public void visitModified(IModifiableFile modified) {
                if (!($assertionsDisabled || modified != null && modified instanceof QualityGate)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitModified': " + String.valueOf(modified)));
                }
                QualityGateExtension.this.addQualityGate(modified.getFile(), modified.getFile(), (QualityGate)modified, false);
            }

            @Override
            public void visitDeleted(IModifiableFile deleted) {
                if (!($assertionsDisabled || deleted != null && deleted instanceof QualityGate)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitDeleted': " + String.valueOf(deleted)));
                }
                QualityGate toBeRemoved = (QualityGate)deleted;
                toBeRemoved.remove();
            }

            @Override
            public void visitAdded(ModifiableFileCandidate added) {
                if (!$assertionsDisabled && added == null) {
                    throw new AssertionError((Object)"Parameter 'added' of method 'visitAdded' must not be null");
                }
                TFile file = added.getFile();
                result.addMessagesFrom(QualityGateExtension.this.addQualityGate(file, file, null, false));
            }
        }, true);
    }

    QualityGatePersistence getPersistence() {
        Files files = this.getSoftwareSystem().getUniqueExistingChild(Files.class);
        return new QualityGatePersistence(this, this.getInstallation().getVersion(), files.getQualityGatesDirectory(), this.getSoftwareSystem().getUniqueExistingChild(Files.class));
    }

    private OperationResult addQualityGate(TFile contentFile, TFile modelFile, QualityGate qualityGate, boolean saveToDisk) {
        OperationResultWithOutcome<QualityGate> loadResult;
        assert (contentFile != null) : "Parameter 'contentFile' of method 'addQualityGate' must not be null";
        assert (modelFile != null) : "Parameter 'modelFile' of method 'addQualityGate' must not be null";
        QualityGates qualityGates = this.getQualityGatesDirectory();
        QualityGatePersistence persistence = this.getPersistence();
        if (qualityGate == null) {
            qualityGate = new QualityGate(qualityGates, new TFile((File)qualityGates.getFile(), contentFile.getName()), contentFile.lastModified(), "", this.getSoftwareSystem().getUniqueExistingChild(Files.class));
            loadResult = persistence.load(contentFile, qualityGate);
            if (loadResult.isSuccess()) {
                qualityGates.addChild(qualityGate);
            }
        } else {
            qualityGate.removeChildren(CurrentSystemConditions.class);
            qualityGate.removeChildren(DiffAgainstBaselineConditions.class);
            loadResult = persistence.load(qualityGate.getFile(), qualityGate);
            qualityGate.reloaded(contentFile.lastModified(), false);
        }
        if (saveToDisk && loadResult.isSuccess()) {
            OperationResult saveResult = persistence.save(qualityGate, modelFile);
            loadResult.addMessagesFrom(saveResult);
            if (saveResult.isSuccess()) {
                qualityGate.setExistsOnDisk(true);
                qualityGate.resetTimestamp();
            }
            TrueZipFacade.clear((TFile)modelFile);
        }
        return loadResult;
    }

    @Override
    public OperationResult delete(IWorkerContext workerContext, List<QualityGate> qualityGates) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'delete' must not be null";
        assert (qualityGates != null && !qualityGates.isEmpty()) : "Parameter 'qualityGates' of method 'delete' must not be empty";
        OperationResult result = new OperationResult("Delete " + qualityGates.size() + " quality gate(s)");
        this.checkOutOfSync(result);
        if (result.isFailure()) {
            return result;
        }
        QualityGateCheckConfiguration configuration = this.getQualityGateCheckConfiguration(false);
        ArrayList<String> identifyingPathsToRemove = new ArrayList<String>();
        for (QualityGate next : qualityGates) {
            String identifyingPath = next.getIdentifyingPath();
            if (configuration.isChecked(identifyingPath)) {
                identifyingPathsToRemove.add(identifyingPath);
            }
            SoftwareSystemFilesDirectory.removeFile(next.getFile(), false, result);
            next.remove();
        }
        EnumSet<Modification> modifications = EnumSet.noneOf(Modification.class);
        for (String next : identifyingPathsToRemove) {
            configuration.removeValue(next);
        }
        this.finishWithQualityGateCheckConfigurationUpdate(workerContext, modifications, result);
        result.setIsSuccess(true);
        return result;
    }

    @Override
    public AnalyzerConfigurationFile getQualityGateCheckConfigurationFile() {
        return this.getSoftwareSystem().getExtension(IAnalyzerController.class).getAnalyzerConfigurationFile(CoreAnalyzerId.QUALITY_GATES);
    }

    private void finishWithQualityGateCheckConfigurationUpdate(IWorkerContext workerContext, EnumSet<Modification> modifications, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'finishWithQualityGateCheckConfigurationUpdate' must not be null";
        assert (modifications != null) : "Parameter 'modifications' of method 'finishWithQualityGateCheckConfigurationUpdate' must not be null";
        assert (result != null) : "Parameter 'result' of method 'finishWithQualityGateCheckConfigurationUpdate' must not be null";
        IAnalyzerController analyzerExtension = this.getSoftwareSystem().getExtension(IAnalyzerController.class);
        Set<AnalyzerGroup> restartGroups = analyzerExtension.cancelAndResetAnalyzerGroups(EnumSet.of(AnalyzerGroup.SYSTEM_DIFF, AnalyzerGroup.QUALITY_GATE), ResetMode.ALL);
        AnalyzerConfigurationFile configuration = this.getQualityGateCheckConfigurationFile();
        if (configuration != null) {
            configuration.setNeedsSave(true);
            result.addMessagesFrom(analyzerExtension.save(configuration));
        }
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), modifications, result);
        analyzerExtension.runAnalyzerGroups(restartGroups);
    }

    public OperationResult save(QualityGate qualityGate) {
        assert (qualityGate != null) : "Parameter 'qualityGate' of method 'save' must not be null";
        assert (qualityGate.needsSave()) : "Does not need save: " + qualityGate.getName();
        OperationResult saveResult = this.getPersistence().save(qualityGate, qualityGate.getFile());
        if (saveResult.isSuccess()) {
            qualityGate.setNeedsSave(false);
            qualityGate.resetTimestamp();
        }
        return saveResult;
    }

    @Override
    public OperationResultWithOutcome<QualityGate> create(IWorkerContext workerContext, String name, String description) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createQualityGate' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'createQualityGate' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'createQualityGate' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Creating quality gate");
        this.checkOutOfSync((OperationResult)result);
        if (result.isFailure()) {
            return result;
        }
        TFile file = new TFile((File)this.getQualityGatesDirectory().getFile(), name + CoreFileType.QUALITY_GATE.getDefaultExtension());
        QualityGate qualityGate = new QualityGate(this.getQualityGatesDirectory(), file, file.lastModified(), description, this.getSoftwareSystem().getUniqueExistingChild(Files.class));
        CurrentSystemConditions currentSystemConditions = new CurrentSystemConditions(qualityGate);
        qualityGate.addChild(currentSystemConditions);
        DiffAgainstBaselineConditions baselineConditions = new DiffAgainstBaselineConditions(qualityGate);
        qualityGate.addChild(baselineConditions);
        OperationResult saveResult = this.getPersistence().save(qualityGate, file);
        if (saveResult.isSuccess()) {
            this.getQualityGatesDirectory().addChild(qualityGate);
            qualityGate.setExistsOnDisk(true);
            qualityGate.resetTimestamp();
            result.setOutcome((Object)qualityGate);
            QualityGateCheckConfiguration configuration = this.getQualityGateCheckConfiguration(false);
            if (configuration != null && configuration.isChecked(qualityGate.getIdentifyingPath())) {
                IAnalyzerController analyzerExtension = this.getSoftwareSystem().getExtension(IAnalyzerController.class);
                Set<AnalyzerGroup> restartGroups = analyzerExtension.cancelAndResetAnalyzerGroups(EnumSet.of(AnalyzerGroup.SYSTEM_DIFF, AnalyzerGroup.QUALITY_GATE), ResetMode.ALL);
                qualityGate.setChecked(true);
                this.checkQualityGateCheckConfiguration(this.getSoftwareSystem());
                this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.of(Modification.QUALITY_GATES_MODIFIED), (OperationResult)result);
                analyzerExtension.runAnalyzerGroups(restartGroups);
            } else {
                this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), (OperationResult)result);
            }
        } else {
            result.addMessagesFrom(saveResult);
        }
        return result;
    }

    @Override
    public OperationResult editCoreInfo(IWorkerContext workerContext, QualityGate qualityGate, String name, String description) {
        assert (qualityGate != null) : "Parameter 'qualityGate' of method 'editCoreInfo' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'editCoreInfo' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'editCoreInfo' must not be null";
        String newName = name + CoreFileType.QUALITY_GATE.getDefaultExtension();
        boolean nameChanged = !newName.equals(qualityGate.getFile().getName());
        OperationResult result = new OperationResult("Editing core info of quality gate");
        this.checkOutOfSync(result);
        if (result.isFailure()) {
            return result;
        }
        String previousIdentifyingPath = qualityGate.getIdentifyingPath();
        qualityGate.setNeedsSave(true);
        if (nameChanged) {
            TFile targetFile = new TFile((File)this.getQualityGatesDirectory().getFile(), newName);
            try {
                qualityGate.getFile().mv((File)targetFile);
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_MOVE, (Throwable)ex);
                return result;
            }
            qualityGate.setPath(targetFile);
        }
        qualityGate.setDescription(description);
        if (nameChanged) {
            OperationResult saveResult = this.save(qualityGate);
            result.addMessagesFrom(saveResult);
            QualityGateCheckConfiguration configuration = this.getQualityGateCheckConfiguration(true);
            if (configuration != null) {
                configuration.replaceIfPresent(previousIdentifyingPath, qualityGate.getIdentifyingPath());
                result.addMessagesFrom(this.getSoftwareSystem().getExtension(IAnalyzerController.class).applyEditedConfiguration(workerContext, configuration));
                return result;
            }
        }
        this.finishWithQualityGateCheckConfigurationUpdate(workerContext, EnumSet.noneOf(Modification.class), result);
        return result;
    }

    boolean isChecked(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'isChecked' must not be empty";
        QualityGateCheckConfiguration configuration = this.getQualityGateCheckConfiguration(false);
        return configuration != null && configuration.isChecked(identifyingPath);
    }

    @Override
    public OperationResultWithOutcome<IQualityGateCondition> createCondition(IWorkerContext workerContext, QualityGate qualityGate, NamedElement parent, IQualityGateConditionInfo conditionInfo) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createCondition' must not be null";
        assert (qualityGate != null) : "Parameter 'qualityGate' of method 'createCondition' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'createCondition' must not be null";
        assert (conditionInfo != null) : "Parameter 'conditionInfo' of method 'createCondition' must not be null";
        OperationResultWithOutcome createResult = new OperationResultWithOutcome("Creating new quality gate condition");
        IAnalyzerController analyzerExtension = this.getSoftwareSystem().getExtension(IAnalyzerController.class);
        Set<AnalyzerGroup> restartGroups = analyzerExtension.cancelAndResetAnalyzerGroups(EnumSet.of(AnalyzerGroup.SYSTEM_DIFF, AnalyzerGroup.QUALITY_GATE), ResetMode.ALL);
        AbstractQualityGateElement condition = null;
        if (conditionInfo instanceof AbstractCurrentIssueQualityGateConditionInfo) {
            assert (parent instanceof CurrentSystemConditions) : "Unexpected parent class " + parent.getClass().getCanonicalName();
            if (conditionInfo instanceof ThresholdIssueQualityGateConditionInfo) {
                info = (ThresholdIssueQualityGateConditionInfo)conditionInfo;
                condition = new ThresholdIssueQualityGateCondition(parent, ((AbstractQualityGateElementInfo)((Object)info)).getIssueType(), ((AbstractQualityGateElementInfo)((Object)info)).getSeverities(), ((AbstractQualityGateElementInfo)((Object)info)).getResolutions(), ((ThresholdIssueQualityGateConditionInfo)info).getMetricId(), ((AbstractCurrentIssueQualityGateConditionInfo)info).getOperator(), ((AbstractCurrentIssueQualityGateConditionInfo)info).getLimit());
            } else if (conditionInfo instanceof CurrentIssueQualityGateConditionInfo) {
                info = (CurrentIssueQualityGateConditionInfo)conditionInfo;
                condition = new CurrentIssueQualityGateCondition(parent, ((AbstractQualityGateElementInfo)((Object)info)).getIssueType(), ((AbstractQualityGateElementInfo)((Object)info)).getSeverities(), ((AbstractQualityGateElementInfo)((Object)info)).getResolutions(), ((AbstractCurrentIssueQualityGateConditionInfo)info).getOperator(), ((AbstractCurrentIssueQualityGateConditionInfo)info).getLimit());
            } else assert (false) : "Unsupported condition info " + conditionInfo.getClass().getCanonicalName();
        } else if (conditionInfo instanceof AbstractIssueDiffAgainstBaselineConditionInfo) {
            assert (parent instanceof DiffAgainstBaselineConditions) : "Unexpected parent class " + parent.getClass().getCanonicalName();
            if (conditionInfo instanceof IssueDiffAgainstBaselineConditionInfo) {
                info = (IssueDiffAgainstBaselineConditionInfo)conditionInfo;
                condition = ((AbstractIssueDiffAgainstBaselineConditionInfo)info).getCheck() != null ? new IssueDiffAgainstBaselineCondition(parent, ((AbstractQualityGateElementInfo)((Object)info)).getIssueType(), ((AbstractQualityGateElementInfo)((Object)info)).getSeverities(), ((AbstractQualityGateElementInfo)((Object)info)).getResolutions(), ((AbstractIssueDiffAgainstBaselineConditionInfo)info).getCheck()) : new IssueDiffAgainstBaselineCondition(parent, ((AbstractQualityGateElementInfo)((Object)info)).getIssueType(), ((AbstractQualityGateElementInfo)((Object)info)).getSeverities(), ((AbstractQualityGateElementInfo)((Object)info)).getResolutions());
            } else if (conditionInfo instanceof ThresholdIssueDiffAgainstBaselineConditionInfo) {
                info = (ThresholdIssueDiffAgainstBaselineConditionInfo)conditionInfo;
                condition = new ThresholdIssueDiffAgainstBaselineCondition(parent, ((AbstractQualityGateElementInfo)((Object)info)).getIssueType(), ((AbstractQualityGateElementInfo)((Object)info)).getSeverities(), ((AbstractQualityGateElementInfo)((Object)info)).getResolutions(), ((ThresholdIssueDiffAgainstBaselineConditionInfo)info).getMetricId(), ((ThresholdIssueDiffAgainstBaselineConditionInfo)info).getOperator(), ((ThresholdIssueDiffAgainstBaselineConditionInfo)info).getDiffThreshold(), ((ThresholdIssueDiffAgainstBaselineConditionInfo)info).getDiffThresholdRelative(), ((AbstractIssueDiffAgainstBaselineConditionInfo)info).getCheck());
            }
        } else if (conditionInfo instanceof MetricValueDiffQualityGateConditionInfo) {
            assert (parent instanceof DiffAgainstBaselineConditions) : "Unexpected parent class " + parent.getClass().getCanonicalName();
            info = (MetricValueDiffQualityGateConditionInfo)conditionInfo;
            condition = new MetricValueDiffQualityGateCondition(parent, ((MetricValueDiffQualityGateConditionInfo)info).getMetricId(), ((MetricValueDiffQualityGateConditionInfo)info).getOperator(), ((MetricValueDiffQualityGateConditionInfo)info).getDiffThreshold(), ((MetricValueDiffQualityGateConditionInfo)info).getDiffThresholdRelative());
        } else assert (false) : "Unspported condition info type: " + conditionInfo.getClass().getCanonicalName();
        if (condition != null) {
            parent.addChild(condition);
            QualityGateExcludeFilter excludeFilter = parent.getFirstChild(QualityGateExcludeFilter.class);
            if (excludeFilter != null) {
                parent.moveChild(AbstractQualityGateElement.class, condition, parent.getIndexOf(AbstractQualityGateElement.class, excludeFilter));
            }
            createResult.setOutcome((Object)condition);
        }
        qualityGate.setNeedsSave(true);
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), (OperationResult)createResult);
        analyzerExtension.runAnalyzerGroups(restartGroups);
        return createResult;
    }

    @Override
    public OperationResultWithOutcome<QualityGateExcludeFilter> createExcludeFilter(IWorkerContext workerContext, QualityGate qualityGate, NamedElement parent, QualityGateExcludeFilterInfo filterInfo) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createExcludeFilter' must not be null";
        assert (qualityGate != null) : "Parameter 'qualityGate' of method 'createExcludeFilter' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'createExcludeFilter' must not be null";
        assert (filterInfo != null) : "Parameter 'filterInfo' of method 'createExcludeFilter' must not be null";
        IAnalyzerController analyzerExtension = this.getSoftwareSystem().getExtension(IAnalyzerController.class);
        Set<AnalyzerGroup> restartGroups = analyzerExtension.cancelAndResetAnalyzerGroups(EnumSet.of(AnalyzerGroup.SYSTEM_DIFF, AnalyzerGroup.QUALITY_GATE), ResetMode.ALL);
        OperationResultWithOutcome createResult = new OperationResultWithOutcome("Create new quality gate exclude filter");
        QualityGateExcludeFilter excludeFilter = filterInfo.getMetricId() != null && filterInfo.getMetricId().trim().length() > 0 ? new QualityGateExcludeFilter(parent, filterInfo.getIssueType(), filterInfo.getMetricId(), filterInfo.getSeverities(), filterInfo.getResolutions()) : new QualityGateExcludeFilter(parent, filterInfo.getIssueType(), filterInfo.getSeverities(), filterInfo.getResolutions());
        parent.addChild(excludeFilter);
        qualityGate.setNeedsSave(true);
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), (OperationResult)createResult);
        analyzerExtension.runAnalyzerGroups(restartGroups);
        createResult.setOutcome((Object)excludeFilter);
        return createResult;
    }

    @Override
    public OperationResultWithOutcome<QualityGate> deleteQualityGateElements(IWorkerContext workerContext, QualityGate qualityGate, List<IQualityGateElement> elementsToDelete) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'deleteQualityGateElements' must not be null";
        assert (qualityGate != null) : "Parameter 'qualityGate' of method 'deleteQualityGateElements' must not be null";
        assert (elementsToDelete != null) : "Parameter 'elementsToDelete' of method 'deleteQualityGateElements' must not be null";
        OperationResultWithOutcome deleteResult = new OperationResultWithOutcome("Deleting quality gate elements");
        IAnalyzerController analyzerExtension = this.getSoftwareSystem().getExtension(IAnalyzerController.class);
        Set<AnalyzerGroup> restartGroups = analyzerExtension.cancelAndResetAnalyzerGroups(EnumSet.of(AnalyzerGroup.SYSTEM_DIFF, AnalyzerGroup.QUALITY_GATE), ResetMode.ALL);
        for (IQualityGateElement next : elementsToDelete) {
            assert (next != null) : "Parameter 'next' of method 'deleteQualityGateElements' must not be null";
            assert (next instanceof NamedElement) : "Unexpected class in method 'deleteQualityGateElements': " + next.getClass().getCanonicalName() + ", element: " + String.valueOf(next);
            NamedElement nextElement = (NamedElement)((Object)next);
            nextElement.remove();
        }
        qualityGate.setNeedsSave(true);
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), (OperationResult)deleteResult);
        analyzerExtension.runAnalyzerGroups(restartGroups);
        deleteResult.setOutcome((Object)qualityGate);
        return deleteResult;
    }

    @Override
    public OperationResultWithOutcome<IQualityGateCondition> editCondition(IWorkerContext workerContext, QualityGate qualityGate, IQualityGateCondition conditionToEdit, IQualityGateConditionInfo conditionInfo) {
        AbstractQualityGateElement newCondition;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'editCondition' must not be null";
        assert (qualityGate != null) : "Parameter 'qualityGate' of method 'editCondition' must not be null";
        assert (conditionToEdit != null) : "Parameter 'conditionToEdit' of method 'editCondition' must not be null";
        assert (conditionInfo != null) : "Parameter 'conditionInfo' of method 'editCondition' must not be null";
        OperationResultWithOutcome editResult = new OperationResultWithOutcome("Edit condition");
        IAnalyzerController analyzerExtension = this.getSoftwareSystem().getExtension(IAnalyzerController.class);
        Set<AnalyzerGroup> restartGroups = analyzerExtension.cancelAndResetAnalyzerGroups(EnumSet.of(AnalyzerGroup.SYSTEM_DIFF, AnalyzerGroup.QUALITY_GATE), ResetMode.ALL);
        NamedElement condition = (NamedElement)((Object)conditionToEdit);
        NamedElement parent = condition.getParent();
        if (conditionInfo instanceof CurrentIssueQualityGateConditionInfo) {
            info = (CurrentIssueQualityGateConditionInfo)conditionInfo;
            newCondition = new CurrentIssueQualityGateCondition(parent, ((AbstractQualityGateElementInfo)((Object)info)).getIssueType(), ((AbstractQualityGateElementInfo)((Object)info)).getSeverities(), ((AbstractQualityGateElementInfo)((Object)info)).getResolutions(), ((AbstractCurrentIssueQualityGateConditionInfo)info).getOperator(), ((AbstractCurrentIssueQualityGateConditionInfo)info).getLimit());
        } else if (conditionInfo instanceof ThresholdIssueQualityGateConditionInfo) {
            info = (ThresholdIssueQualityGateConditionInfo)conditionInfo;
            newCondition = new ThresholdIssueQualityGateCondition(parent, ((AbstractQualityGateElementInfo)((Object)info)).getIssueType(), ((AbstractQualityGateElementInfo)((Object)info)).getSeverities(), ((AbstractQualityGateElementInfo)((Object)info)).getResolutions(), ((ThresholdIssueQualityGateConditionInfo)info).getMetricId(), ((AbstractCurrentIssueQualityGateConditionInfo)info).getOperator(), ((AbstractCurrentIssueQualityGateConditionInfo)info).getLimit());
        } else if (conditionInfo instanceof IssueDiffAgainstBaselineConditionInfo) {
            info = (IssueDiffAgainstBaselineConditionInfo)conditionInfo;
            newCondition = ((AbstractIssueDiffAgainstBaselineConditionInfo)info).getCheck() != null ? new IssueDiffAgainstBaselineCondition(parent, ((AbstractQualityGateElementInfo)((Object)info)).getIssueType(), ((AbstractQualityGateElementInfo)((Object)info)).getSeverities(), ((AbstractQualityGateElementInfo)((Object)info)).getResolutions(), ((AbstractIssueDiffAgainstBaselineConditionInfo)info).getCheck()) : new IssueDiffAgainstBaselineCondition(parent, ((AbstractQualityGateElementInfo)((Object)info)).getIssueType(), ((AbstractQualityGateElementInfo)((Object)info)).getSeverities(), ((AbstractQualityGateElementInfo)((Object)info)).getResolutions());
        } else if (conditionInfo instanceof ThresholdIssueDiffAgainstBaselineConditionInfo) {
            info = (ThresholdIssueDiffAgainstBaselineConditionInfo)conditionInfo;
            newCondition = new ThresholdIssueDiffAgainstBaselineCondition(parent, ((AbstractQualityGateElementInfo)((Object)info)).getIssueType(), ((AbstractQualityGateElementInfo)((Object)info)).getSeverities(), ((AbstractQualityGateElementInfo)((Object)info)).getResolutions(), ((ThresholdIssueDiffAgainstBaselineConditionInfo)info).getMetricId(), ((ThresholdIssueDiffAgainstBaselineConditionInfo)info).getOperator(), ((ThresholdIssueDiffAgainstBaselineConditionInfo)info).getDiffThreshold(), ((ThresholdIssueDiffAgainstBaselineConditionInfo)info).getDiffThresholdRelative(), ((AbstractIssueDiffAgainstBaselineConditionInfo)info).getCheck());
        } else if (conditionInfo instanceof MetricValueDiffQualityGateConditionInfo) {
            info = (MetricValueDiffQualityGateConditionInfo)conditionInfo;
            newCondition = new MetricValueDiffQualityGateCondition(parent, ((MetricValueDiffQualityGateConditionInfo)info).getMetricId(), ((MetricValueDiffQualityGateConditionInfo)info).getOperator(), ((MetricValueDiffQualityGateConditionInfo)info).getDiffThreshold(), ((MetricValueDiffQualityGateConditionInfo)info).getDiffThresholdRelative());
        } else {
            assert (false) : "Unsupported condition info: " + conditionInfo.getClass().getCanonicalName();
            newCondition = null;
        }
        int index = parent.getIndexOf(IQualityGateCondition.class, condition);
        NamedElement addedCondition = newCondition;
        parent.addChild(addedCondition);
        parent.moveChild(IQualityGateCondition.class, addedCondition, index);
        condition.remove();
        qualityGate.setNeedsSave(true);
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), (OperationResult)editResult);
        analyzerExtension.runAnalyzerGroups(restartGroups);
        editResult.setOutcome((Object)newCondition);
        return editResult;
    }

    @Override
    public OperationResultWithOutcome<QualityGateExcludeFilter> editExcludeFilter(IWorkerContext workerContext, QualityGate qualityGate, QualityGateExcludeFilter excludeFilterToEdit, QualityGateExcludeFilterInfo filterInfo) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'editExcludeFilter' must not be null";
        assert (qualityGate != null) : "Parameter 'qualityGate' of method 'editExcludeFilter' must not be null";
        assert (excludeFilterToEdit != null) : "Parameter 'excludeFilterToEdit' of method 'editExcludeFilter' must not be null";
        assert (filterInfo != null) : "Parameter 'filterInfo' of method 'editExcludeFilter' must not be null";
        IAnalyzerController analyzerExtension = this.getSoftwareSystem().getExtension(IAnalyzerController.class);
        Set<AnalyzerGroup> restartGroups = analyzerExtension.cancelAndResetAnalyzerGroups(EnumSet.of(AnalyzerGroup.SYSTEM_DIFF, AnalyzerGroup.QUALITY_GATE), ResetMode.ALL);
        OperationResultWithOutcome editResult = new OperationResultWithOutcome("Edit exclude filter");
        NamedElement parent = excludeFilterToEdit.getParent();
        int index = parent.getIndexOf(QualityGateExcludeFilter.class, excludeFilterToEdit);
        QualityGateExcludeFilter newFilter = filterInfo.getMetricId() != null ? new QualityGateExcludeFilter(parent, filterInfo.getIssueType(), filterInfo.getMetricId(), filterInfo.getSeverities(), filterInfo.getResolutions()) : new QualityGateExcludeFilter(parent, filterInfo.getIssueType(), filterInfo.getSeverities(), filterInfo.getResolutions());
        parent.addChild(newFilter);
        parent.moveChild(QualityGateExcludeFilter.class, newFilter, index);
        excludeFilterToEdit.remove();
        qualityGate.setNeedsSave(true);
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), (OperationResult)editResult);
        analyzerExtension.runAnalyzerGroups(restartGroups);
        editResult.setOutcome((Object)newFilter);
        return editResult;
    }

    @Override
    public QualityGate getQualityGate(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'getQualityGate' must not be empty";
        QualityGate qualityGate = !identifyingPath.startsWith("./") ? this.getQualityGatesDirectory().getUniqueChild(new NameFilter("./" + identifyingPath), QualityGate.class) : this.getQualityGatesDirectory().getUniqueChild(new NameFilter(identifyingPath), QualityGate.class);
        return qualityGate;
    }

    @Override
    public OperationResult addToCheck(IWorkerContext workerContext, List<Element> elements) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'addToCheck' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'addToCheck' must not be null";
        OperationResult result = new OperationResult("Add to quality gate check");
        QualityGateCheckConfiguration configuration = this.getQualityGateCheckConfiguration(true);
        for (Element next : elements) {
            assert (next != null && next instanceof QualityGate) : "Unexpected class in method 'addToCheck': " + String.valueOf(next);
            QualityGate qualityGate = (QualityGate)next;
            configuration.addIdentifyingPath(qualityGate.getIdentifyingPath(), true);
            qualityGate.setChecked(true);
        }
        result.addMessagesFrom(this.getSoftwareSystem().getExtension(IAnalyzerController.class).applyEditedConfiguration(workerContext, configuration));
        this.m_finishModelProcessor.finishModification(this.getSoftwareSystem(), EnumSet.of(Modification.QUALITY_GATES_MODIFIED));
        return result;
    }

    @Override
    public OperationResult removeFromCheck(IWorkerContext workerContext, List<Element> elements) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'removeFromCheck' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'removeFromCheck' must not be null";
        OperationResult result = new OperationResult("Remove from quality gate check");
        QualityGateCheckConfiguration configuration = this.getQualityGateCheckConfiguration(true);
        for (Element next : elements) {
            assert (next != null && next instanceof QualityGate) : "Unexpected class in method 'removeFromCheck': " + String.valueOf(next);
            QualityGate qualityGate = (QualityGate)next;
            configuration.removeIdentifyingPath(qualityGate.getIdentifyingPath(), true);
            qualityGate.setChecked(false);
        }
        result.addMessagesFrom(this.getSoftwareSystem().getExtension(IAnalyzerController.class).applyEditedConfiguration(workerContext, configuration));
        this.m_finishModelProcessor.finishModification(this.getSoftwareSystem(), EnumSet.of(Modification.QUALITY_GATES_MODIFIED));
        return result;
    }

    protected QualityGateCheckConfiguration getQualityGateCheckConfiguration(boolean forEdit) {
        AnalyzerConfiguration configuration;
        IAnalyzerController analyzerExtension = this.getSoftwareSystem().getExtension(IAnalyzerController.class);
        AnalyzerConfiguration analyzerConfiguration = configuration = forEdit ? analyzerExtension.getConfigurationForEdit(CoreAnalyzerId.QUALITY_GATES) : analyzerExtension.getConfiguration(CoreAnalyzerId.QUALITY_GATES);
        assert (configuration != null && configuration instanceof QualityGateCheckConfiguration) : "Unexpected class in method 'getQualityGateCheckConfiguration': " + String.valueOf(configuration);
        return (QualityGateCheckConfiguration)configuration;
    }

    public List<IModifiableFile> getAvailableFiles() {
        ArrayList<IModifiableFile> result = new ArrayList<IModifiableFile>();
        result.addAll(this.getAvailableQualityGates());
        return result;
    }

    @Override
    public boolean exports(IModifiableFile modifiableFile) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'exports' must not be null";
        return CoreFileType.QUALITY_GATE.equals(modifiableFile.getFileType());
    }

    @Override
    public String getExportBaseDirectory() {
        return "QualityGates";
    }

    @Override
    public void exportFile(IModifiableFile file, TFile targetFile, OperationResult result) {
        assert (file != null && file instanceof QualityGate) : "Unexpected class in method 'exportFile': " + String.valueOf(file);
        assert (targetFile != null) : "Parameter 'targetFile' of method 'exportFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'exportFile' must not be null";
        QualityGate qualityGate = (QualityGate)file;
        result.addMessagesFrom(this.getPersistence().save(qualityGate, targetFile));
    }

    @Override
    public void importFiles(IWorkerContext workerContext, ImportQualityModel importQualityModel, EnumSet<Modification> modfications, OperationResult result) {
        assert (importQualityModel != null) : "Parameter 'importQualityModel' of method 'importFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'importFiles' must not be null";
        List<ImportQualityModel.ImportQualityModelCandidate> candidates = importQualityModel.getCandidatesByFileType(CoreFileType.QUALITY_GATE);
        QualityGates qualityGatesDirectory = this.getQualityGatesDirectory();
        block0: for (ImportQualityModel.ImportQualityModelCandidate nextImportQualityModelCandidate : candidates) {
            if (!nextImportQualityModelCandidate.isIncluded()) continue;
            TFile contentFile = nextImportQualityModelCandidate.getModifiableFile().getFile();
            String contentFileIdentifyingPath = nextImportQualityModelCandidate.getModifiableFile().getIdentifyingPath();
            if (importQualityModel.discardCurrentContent() || !nextImportQualityModelCandidate.isAlreadyInModel()) {
                TFile targetFile = new TFile((File)qualityGatesDirectory.getFile(), contentFileIdentifyingPath).getNormalizedFile();
                result.addMessagesFrom(this.addQualityGate(contentFile, targetFile.getNormalizedFile(), null, true));
                continue;
            }
            if (importQualityModel.discardCurrentContent()) continue;
            for (IModifiableFile nextAvailable : this.getAvailableFiles()) {
                assert (nextAvailable != null && nextAvailable instanceof QualityGate) : "Unexpected class in method 'importFiles': " + String.valueOf(nextAvailable);
                if (!nextAvailable.getIdentifyingPath().equals(contentFileIdentifyingPath)) continue;
                result.addMessagesFrom(this.addQualityGate(contentFile, nextAvailable.getFile(), (QualityGate)nextAvailable, true));
                continue block0;
            }
        }
    }

    @Override
    public void discardFiles(IWorkerContext workerContext, EnumSet<Modification> modfications, OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'discardFiles' must not be null";
        this.getQualityGatesDirectory().removeAll(result);
    }

    @Override
    public void setQualityModelRoot(TFile qualityModel) {
        assert (qualityModel != null) : "Parameter 'qualityModel' of method 'setQualityModelRoot' must not be null";
        this.getQualityGatesDirectory().setPath(new TFile((File)qualityModel, "./QualityGates"));
    }

    @Override
    public void importFinished(IWorkerContext workerContext, EnumSet<Modification> modifications, OperationResult result) {
        this.checkQualityGateCheckConfiguration(this.getSoftwareSystem());
    }
}

