/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.TemplateUtility;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public abstract class MSBuildExecutor {
    private final TFile m_projectFile;
    private final TFile m_solutionDir;
    private final TFile m_solutionFile;

    public MSBuildExecutor(TFile projectFile, TFile solutionFile, TFile solutionDir) {
        assert (projectFile != null) : "Parameter 'projectFile' must not be null";
        assert (projectFile.canRead()) : "No permission to read '" + projectFile.getAbsolutePath() + "' of method 'CPlusPlusMSBuildExecutor'";
        this.m_projectFile = projectFile;
        this.m_solutionFile = solutionFile;
        this.m_solutionDir = solutionDir;
    }

    protected TFile getProjectFile() {
        return this.m_projectFile;
    }

    protected TFile getSolutionDir() {
        return this.m_solutionDir;
    }

    protected TFile getSolutionFile() {
        return this.m_solutionFile;
    }

    protected abstract String getTemplateName();

    protected abstract String getWrapperFileName();

    protected TFile writeProjectWrapper() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.getTemplateName());){
            String template = FileUtility.getFileContent((InputStream)inputStream);
            Map<String, String> props = this.getProperties();
            TFile projectWrapperFile = new TFile((File)this.m_projectFile.getParentFile(), this.getWrapperFileName());
            if (projectWrapperFile.exists()) {
                projectWrapperFile.rm();
            }
            String content = TemplateUtility.expandTemplateText(template, props);
            FileUtility.writeFileContent((String)content, (TFile)projectWrapperFile);
            return projectWrapperFile;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected Map<String, String> getProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("proj", this.m_projectFile.getName());
        return props;
    }
}

