/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewVisitor;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.export.ColumnDatatype;
import com.hello2morrow.sonargraph.foundation.export.ExportData;
import java.util.Iterator;
import java.util.List;

final class ExplorationViewRepresentationExcelExportVisitor
extends ArchitecturalViewVisitor
implements ArchitecturalViewNode.IVisitor {
    private final IWorkerContext m_workerContext;
    private final ExportData m_downgoing;
    private final ExportData m_upgoing;

    ExplorationViewRepresentationExcelExportVisitor(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'ExplorationViewRepresentationExcelExportVisitor' must not be null";
        this.m_workerContext = workerContext;
        this.m_downgoing = new ExportData("Downward Depndencies");
        this.initColumns(this.m_downgoing);
        this.m_upgoing = new ExportData("Upward Dependencies");
        this.initColumns(this.m_upgoing);
    }

    private void initColumns(ExportData exportData) {
        exportData.addColumn("From Source");
        exportData.addColumn("Line", ColumnDatatype.NUMBER);
        exportData.addColumn("Dependency Type");
        exportData.addColumn("Is Violation?");
        exportData.addColumn("To Source");
        exportData.addColumn("To Element");
    }

    @Override
    protected boolean done() {
        return this.m_workerContext.hasBeenCanceled();
    }

    @Override
    public void visitArchitecturalViewNode(ArchitecturalViewNode element) {
        assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewNode' must not be null";
        if (!element.isVisible()) {
            this.visitChildrenOf(element);
            return;
        }
        int fromRelIndex = element.getRelativeIndex();
        for (ArchitecturalViewNode.ArchitecturalViewDependency next : element.getOutgoingDependencies()) {
            Iterator<ParserDependency> iterator = next.getParserDependenciesIterator();
            int nextToRelIndex = next.getTo().getRelativeIndex();
            ExportData data = fromRelIndex < nextToRelIndex ? this.m_downgoing : this.m_upgoing;
            while (iterator.hasNext()) {
                ParserDependency pd = iterator.next();
                SourceFile fromSource = pd.getFrom().getParent(SourceFile.class, new Class[0]);
                boolean isViolation = pd.isViolation();
                SourceFile toSource = pd.getTo().getParent(SourceFile.class, new Class[0]);
                String toSourceName = toSource == null ? "External" : toSource.getIdentifyingPath();
                data.addRow(new Object[]{fromSource.getIdentifyingPath(), pd.getLineNumber(), pd.getDependencyType().getStandardName(), Boolean.toString(isViolation), toSourceName, pd.getTo().getName()});
            }
        }
        if (element.isExpanded()) {
            this.visitChildrenOf(element);
        }
    }

    List<ExportData> getResult() {
        if (this.m_upgoing.getRowCount() == 0) {
            return List.of(this.m_downgoing);
        }
        return List.of(this.m_downgoing, this.m_upgoing);
    }
}

