/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.system.INamedElementResolver;
import com.hello2morrow.sonargraph.core.model.system.Root;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ElementResolver
implements INamedElementResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElementResolver.class);
    private static final String TYPE_ISSUE = "I";
    private static final String TYPE_NAMED_ELEMENT = "N";
    private static final String TYPE_WORKSPACE_DEPENDENCY = "W";
    private static final String TYPE_PARSER_DEPENDENCY = "P";
    private final Map<String, Root> m_nameToRoot = new HashMap<String, Root>(2);
    private final Map<Root, String> m_rootToName = new HashMap<Root, String>(2);

    ElementResolver(Root root) {
        assert (root != null) : "Parameter 'root' of method 'CoreNamedElementResolver' must not be null";
        String name = root.getClass().getSimpleName();
        this.m_nameToRoot.put(name, root);
        this.m_rootToName.put(root, name);
    }

    void add(Root root) {
        assert (root != null) : "Parameter 'root' of method 'add' must not be null";
        String name = root.getClass().getSimpleName();
        Root previous = this.m_nameToRoot.put(name, root);
        assert (previous == null) : "Root for resolver already present: " + root.getClass().getSimpleName();
        this.m_rootToName.put(root, name);
    }

    void remove(Root root) {
        assert (root != null) : "Parameter 'root' of method 'remove' must not be null";
        String name = root.getClass().getSimpleName();
        Root removed = this.m_nameToRoot.remove(name);
        if (removed != null) {
            this.m_rootToName.remove(root);
        }
    }

    private String getNamedElementDescriptor(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getNamedElementDescriptor' must not be null";
        if (namedElement instanceof Root) {
            return "";
        }
        String originalFullyQualifiedName = namedElement.getOriginalFullyQualifiedName();
        return originalFullyQualifiedName != null ? originalFullyQualifiedName : namedElement.getFullyQualifiedName();
    }

    private NamedElement resolveNamedElement(Root root, List<String> splitDescriptor, boolean originalOnly) {
        assert (root != null) : "Parameter 'root' of method 'resolveNamedElement' must not be null";
        assert (splitDescriptor != null) : "Parameter 'splitDescriptor' of method 'resolveNamedElement' must not be null";
        NamedElement resolved = root;
        if (!splitDescriptor.isEmpty()) {
            for (String nextNamePart : splitDescriptor) {
                NamedElement currentResolved;
                NamedElement namedElement = currentResolved = originalOnly ? resolved.resolveOriginalByFullyQualifiedNamePart(nextNamePart) : resolved.resolveByFullyQualifiedNamePart(nextNamePart);
                if (currentResolved == null) {
                    return null;
                }
                resolved = currentResolved;
            }
        }
        return resolved;
    }

    private Root getRoot(NamedElement ... involvedNamedElements) {
        assert (involvedNamedElements != null && involvedNamedElements.length > 0) : "Parameter 'involvedNamedElements' of method 'initDescriptor' must not be empty";
        Root root = null;
        NamedElement[] namedElementArray = involvedNamedElements;
        int n = involvedNamedElements.length;
        int n2 = 0;
        while (n2 < n) {
            NamedElement nextInvolved = namedElementArray[n2];
            Root nextRoot = nextInvolved.getParent(Root.class, ParentMode.SELF_OR_FIRST_PARENT);
            if (nextRoot == null) {
                LOGGER.warn("Named element not contained in root class: [" + nextInvolved.getClass().getName() + "] " + nextInvolved.getName());
                return null;
            }
            if (root != null && nextRoot != root) {
                LOGGER.warn("Named element provides different root: [" + nextInvolved.getClass().getName() + "] " + nextInvolved.getName() + " in root: " + String.valueOf(nextRoot));
                return null;
            }
            if (root == null) {
                root = nextRoot;
            }
            ++n2;
        }
        if (root != null && !this.m_rootToName.containsKey(root)) {
            LOGGER.error("'root' of method 'getRoot' is not a recognized root: " + String.valueOf(root) + ". Involved elements are: " + Arrays.toString(involvedNamedElements));
            root = null;
        }
        return root;
    }

    private DescriptorRequest requestDescriptor(ElementWithIssues element) {
        assert (element != null) : "Parameter 'element' of method 'getDescriptor' must not be null";
        if (element instanceof NamedElement) {
            NamedElement namedElement = (NamedElement)element;
            Root root = this.getRoot(namedElement);
            if (root != null) {
                DescriptorRequest descriptorRequest = new DescriptorRequest(this.m_rootToName.get(root));
                descriptorRequest.append(TYPE_NAMED_ELEMENT);
                String descriptor = this.getNamedElementDescriptor(namedElement);
                if (descriptor != null) {
                    if (!descriptor.isEmpty()) {
                        descriptorRequest.append(Element.DESCRIPTOR_SEPARATOR);
                        descriptorRequest.append(descriptor);
                    }
                    return descriptorRequest;
                }
            }
        } else if (element instanceof ParserDependency) {
            ProgrammingElement to;
            ParserDependency dependency = (ParserDependency)element;
            ProgrammingElement from = dependency.getFrom();
            Root root = this.getRoot(from, to = dependency.getTo());
            if (root != null) {
                String fromDescriptor = this.getNamedElementDescriptor(from);
                String toDescriptor = this.getNamedElementDescriptor(to);
                if (fromDescriptor != null && !fromDescriptor.isEmpty() && toDescriptor != null && !toDescriptor.isEmpty()) {
                    IParserDependencyType dependencyType = dependency.getDependencyType();
                    String dependencyContribution = dependency.getDescriptorContribution();
                    int lineNumber = dependency.getLineNumber();
                    DescriptorRequest descriptorRequest = new DescriptorRequest(this.m_rootToName.get(root));
                    descriptorRequest.append(TYPE_PARSER_DEPENDENCY);
                    descriptorRequest.append(Element.DESCRIPTOR_SEPARATOR);
                    descriptorRequest.append(dependencyType.getStandardName());
                    descriptorRequest.append(Element.DESCRIPTOR_SEPARATOR);
                    descriptorRequest.append(dependencyContribution);
                    descriptorRequest.append(Element.DESCRIPTOR_SEPARATOR);
                    descriptorRequest.append(Integer.toString(lineNumber));
                    descriptorRequest.append(Element.DESCRIPTOR_SEPARATOR);
                    descriptorRequest.append(fromDescriptor);
                    descriptorRequest.append(Element.DESCRIPTOR_SEPARATOR);
                    descriptorRequest.append(toDescriptor);
                    return descriptorRequest;
                }
            }
        } else if (element instanceof WorkspaceDependency) {
            NamedElement to;
            NamedElement from;
            Root root;
            WorkspaceDependency workspaceDependency = (WorkspaceDependency)element;
            assert (workspaceDependency.getFrom() != null) : "'from' of workspaceDependency must not be null";
            if (workspaceDependency.getTo() != null && (root = this.getRoot(from = (NamedElement)workspaceDependency.getFrom().getUnderlyingObject(), to = (NamedElement)workspaceDependency.getTo().getUnderlyingObject())) != null) {
                String fromDescriptor = this.getNamedElementDescriptor(from);
                String toDescriptor = this.getNamedElementDescriptor(to);
                if (fromDescriptor != null && !fromDescriptor.isEmpty() && toDescriptor != null && !toDescriptor.isEmpty()) {
                    DescriptorRequest descriptorRequest = new DescriptorRequest(this.m_rootToName.get(root));
                    descriptorRequest.append(TYPE_WORKSPACE_DEPENDENCY);
                    descriptorRequest.append(Element.DESCRIPTOR_SEPARATOR);
                    descriptorRequest.append(fromDescriptor);
                    descriptorRequest.append(Element.DESCRIPTOR_SEPARATOR);
                    descriptorRequest.append(toDescriptor);
                    return descriptorRequest;
                }
            }
        }
        return null;
    }

    private int getPosOf(List<String> list, String of, int numberOfOccurrence) {
        assert (list != null && !list.isEmpty()) : "Parameter 'list' of method 'getPos' must not be empty";
        assert (of != null) : "Parameter 'of' of method 'getPos' must not be null";
        int currentNumberOfOccurrence = 0;
        int i = 0;
        while (i < list.size()) {
            String next = list.get(i);
            if (next.equals(of) && ++currentNumberOfOccurrence == numberOfOccurrence) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private Pair<NamedElement, NamedElement> resolveNamedElementDependencyEndpoints(Root root, List<String> remainingDescriptor, String descriptor, String descriptorType, boolean originalOnly) {
        assert (root != null) : "Parameter 'root' of method 'resolveNamedElementDependencyEndpoints' must not be null";
        assert (remainingDescriptor != null) : "Parameter 'remainingDescriptor' of method 'resolveNamedElementDependencyEndpoints' must not be null";
        assert (descriptor != null && descriptor.length() > 0) : "Parameter 'descriptor' of method 'resolveNamedElementDependencyEndpoints' must not be empty";
        assert (descriptorType != null) : "Parameter 'descriptorType' of method 'resolveNamedElementDependencyEndpoints' must not be null";
        assert (descriptorType.equals(TYPE_PARSER_DEPENDENCY) || descriptorType.equals(TYPE_WORKSPACE_DEPENDENCY)) : "Unexpected descriptor type " + descriptorType;
        int numberOfOccurrence = descriptorType.equals(TYPE_WORKSPACE_DEPENDENCY) ? 1 : 4;
        int initialPositionforFromDescriptor = descriptorType.equals(TYPE_WORKSPACE_DEPENDENCY) ? 0 : 6;
        int pos = this.getPosOf(remainingDescriptor, Element.DESCRIPTOR_SEPARATOR, numberOfOccurrence);
        if (pos == -1) {
            LOGGER.warn("Descriptor not valid: " + descriptor);
            return null;
        }
        List<String> fromDescriptor = remainingDescriptor.subList(initialPositionforFromDescriptor, pos);
        List<String> toDescriptor = remainingDescriptor.subList(pos + 1, remainingDescriptor.size());
        NamedElement from = this.resolveNamedElement(root, fromDescriptor, originalOnly);
        NamedElement to = this.resolveNamedElement(root, toDescriptor, originalOnly);
        if (from != null && to != null) {
            return new Pair((Object)from.getRepresentative(), (Object)to.getRepresentative());
        }
        return null;
    }

    private ElementWithIssues resolveElementWithIssues(Root root, String type, List<String> splitDescriptor, String descriptor, boolean originalOnly) {
        assert (root != null) : "Parameter 'root' of method 'resolve' must not be null";
        assert (type != null && type.length() > 0) : "Parameter 'type' of method 'resolve' must not be empty";
        assert (splitDescriptor != null) : "Parameter 'splitDescriptor' of method 'resolve' must not be null";
        assert (descriptor != null && descriptor.length() > 0) : "Parameter 'descriptor' of method 'resolve' must not be empty";
        switch (type) {
            case "N": {
                NamedElement resolveNamedElement = this.resolveNamedElement(root, splitDescriptor, originalOnly);
                if (resolveNamedElement != null) {
                    resolveNamedElement.getRepresentative();
                }
                return resolveNamedElement;
            }
            case "P": {
                Pair<NamedElement, NamedElement> dependencyEndpoints = this.resolveNamedElementDependencyEndpoints(root, splitDescriptor, descriptor, type, originalOnly);
                if (dependencyEndpoints == null) break;
                NamedElement from = (NamedElement)dependencyEndpoints.getFirst();
                NamedElement to = (NamedElement)dependencyEndpoints.getSecond();
                if (!(from instanceof ProgrammingElement) || !(to instanceof ProgrammingElement)) break;
                String dependencyType = splitDescriptor.get(0);
                String dependencyContribution = splitDescriptor.get(2);
                String lineAsString = splitDescriptor.get(4);
                int lineNumber = -1;
                try {
                    lineNumber = Integer.parseInt(lineAsString);
                }
                catch (Throwable t) {
                    LOGGER.warn("Descriptor not valid (not a valid dependency line number): " + descriptor);
                    return null;
                }
                List<ParserDependency> outgoingDependencies = ((ProgrammingElement)from).getOutgoingDependencies(new IParserDependencyType[0]);
                ArrayList<ParserDependency> matchingDependencies = new ArrayList<ParserDependency>();
                for (ParserDependency next : outgoingDependencies) {
                    if (next.getTo() != to || !next.getDependencyType().getStandardName().equals(dependencyType) || !next.getDescriptorContribution().equals(dependencyContribution) || lineNumber != next.getLineNumber()) continue;
                    matchingDependencies.add(next);
                }
                if (matchingDependencies.size() == 1) {
                    return (ElementWithIssues)matchingDependencies.get(0);
                }
                if (matchingDependencies.isEmpty()) break;
                LOGGER.warn("Descriptor name not unique: '" + descriptor + "' for endpoints from: " + String.valueOf(from) + " and to: " + String.valueOf(to));
                break;
            }
            case "W": {
                Pair<NamedElement, NamedElement> workspaceDependencyEndpoints = this.resolveNamedElementDependencyEndpoints(root, splitDescriptor, descriptor, type, originalOnly);
                if (workspaceDependencyEndpoints == null) break;
                NamedElement from = (NamedElement)workspaceDependencyEndpoints.getFirst();
                NamedElement to = (NamedElement)workspaceDependencyEndpoints.getSecond();
                if (!(from instanceof IWorkspaceDependencyElement) || !(to instanceof IWorkspaceDependencyElement)) break;
                return ((IWorkspaceDependencyElement)((Object)from)).getOutgoingWorkspaceDependency((IWorkspaceDependencyElement)((Object)to));
            }
            default: {
                assert (false) : "Unhandled element with issues type: " + type;
                break;
            }
        }
        return null;
    }

    @Override
    public String getDescriptor(Element element) {
        DescriptorRequest descriptorRequest;
        assert (element != null) : "Parameter 'element' of method 'getDescriptor' must not be null";
        if (element instanceof Issue) {
            Issue issue = (Issue)element;
            Element affectedElement = issue.getAffectedElement();
            assert (affectedElement instanceof ElementWithIssues) : "Unexpected class: " + String.valueOf(affectedElement);
            DescriptorRequest descriptorRequest2 = this.requestDescriptor((ElementWithIssues)affectedElement);
            if (descriptorRequest2 != null) {
                descriptorRequest2.prepend(Element.DESCRIPTOR_SEPARATOR);
                descriptorRequest2.prepend(issue.getDescriptorContribution());
                descriptorRequest2.prepend(Element.DESCRIPTOR_SEPARATOR);
                descriptorRequest2.prepend(Integer.toString(issue.getColumn()));
                descriptorRequest2.prepend(Element.DESCRIPTOR_SEPARATOR);
                descriptorRequest2.prepend(Integer.toString(issue.getLineNumber()));
                descriptorRequest2.prepend(Element.DESCRIPTOR_SEPARATOR);
                descriptorRequest2.prepend(Element.escapeSpecialCharacters(issue.getProvider().getStandardName()));
                descriptorRequest2.prepend(Element.DESCRIPTOR_SEPARATOR);
                descriptorRequest2.prepend(Element.escapeSpecialCharacters(issue.getId().getStandardName()));
                descriptorRequest2.prepend(Element.DESCRIPTOR_SEPARATOR);
                descriptorRequest2.prepend(TYPE_ISSUE);
                return descriptorRequest2.getRoot() + Element.DESCRIPTOR_SEPARATOR + descriptorRequest2.getDescriptor();
            }
        } else if (element instanceof ElementWithIssues && (descriptorRequest = this.requestDescriptor((ElementWithIssues)element)) != null) {
            return descriptorRequest.getRoot() + Element.DESCRIPTOR_SEPARATOR + descriptorRequest.getDescriptor();
        }
        return null;
    }

    @Override
    public Element resolve(String descriptor) {
        assert (descriptor != null) : "Parameter 'descriptor' of method 'splitDescriptor' must not be null";
        List<String> splitDescriptor = Element.splitDescriptor(descriptor);
        if (splitDescriptor.size() < 3) {
            LOGGER.warn("Descriptor not valid: " + descriptor);
            return null;
        }
        String rootIdentifier = splitDescriptor.get(0);
        Root root = this.m_nameToRoot.get(rootIdentifier);
        if (root == null) {
            LOGGER.warn("Root not available in resolver: " + rootIdentifier);
            return null;
        }
        if (splitDescriptor.size() == 3) {
            splitDescriptor.add("");
        }
        String type = splitDescriptor.get(2);
        List<String> remainingDescriptor = splitDescriptor.subList(4, splitDescriptor.size());
        if (TYPE_ISSUE.equals(type)) {
            String affectedElementType = remainingDescriptor.get(10);
            ElementWithIssues resolvedAffectedElement = root;
            if (remainingDescriptor.size() > 12) {
                List<String> splitAffectedElementDescriptor = remainingDescriptor.subList(12, remainingDescriptor.size());
                resolvedAffectedElement = this.resolveElementWithIssues(root, affectedElementType, splitAffectedElementDescriptor, descriptor, true);
            }
            if (resolvedAffectedElement != null) {
                String issueIdStandardName = remainingDescriptor.get(0);
                String issueProviderStandardName = remainingDescriptor.get(2);
                String lineAsString = remainingDescriptor.get(4);
                String columnAsString = remainingDescriptor.get(6);
                String descriptorContribution = remainingDescriptor.get(8);
                int lineNumber = -1;
                int columnNumber = -1;
                try {
                    lineNumber = Integer.parseInt(lineAsString);
                    columnNumber = Integer.parseInt(columnAsString);
                }
                catch (Throwable t) {
                    LOGGER.warn("Descriptor not valid (not a valid issue line number): " + descriptor);
                    return null;
                }
                for (Issue nextIssue : resolvedAffectedElement.getIssues()) {
                    if (!nextIssue.getId().getStandardName().equals(issueIdStandardName) || !nextIssue.getProvider().getStandardName().equals(issueProviderStandardName) || nextIssue.getLineNumber() != lineNumber || nextIssue.getColumn() != columnNumber || !descriptorContribution.equals(nextIssue.getDescriptorContribution())) continue;
                    return nextIssue;
                }
            }
            return null;
        }
        return this.resolveElementWithIssues(root, type, remainingDescriptor, descriptor, true);
    }

    @Override
    public NamedElement resolve(Root root, String fqName) {
        assert (root != null) : "Parameter 'root' of method 'resolve' must not be null";
        assert (fqName != null) : "Parameter 'fqName' of method 'resolve' must not be null";
        List<String> split = Element.splitDescriptor(fqName);
        if (split.isEmpty()) {
            return null;
        }
        return this.resolveNamedElement(root, split, false);
    }

    @Override
    public NamedElement resolveOriginal(Root root, String fqName) {
        List<String> split = Element.splitDescriptor(fqName);
        if (split.isEmpty()) {
            return null;
        }
        return this.resolveNamedElement(root, split, true);
    }

    @Override
    public <T> T resolve(Root root, String fqName, Class<T> namedElementClass) {
        assert (root != null) : "Parameter 'root' of method 'resolve' must not be null";
        assert (fqName != null) : "Parameter 'fqName' of method 'resolve' must not be null";
        assert (namedElementClass != null) : "Parameter 'namedElementClass' of method 'resolve' must not be null";
        NamedElement resolved = this.resolve(root, fqName);
        if (resolved != null && namedElementClass.isAssignableFrom(resolved.getClass())) {
            return (T)resolved;
        }
        return null;
    }

    private static final class DescriptorRequest {
        private final String m_root;
        private final StringBuilder m_descriptor = new StringBuilder();

        DescriptorRequest(String root) {
            assert (root != null && root.length() > 0) : "Parameter 'root' of method 'DescriptorRequest' must not be empty";
            this.m_root = root;
        }

        void append(String append) {
            assert (append != null && append.length() > 0) : "Parameter 'append' of method 'appendToDescriptor' must not be empty";
            this.m_descriptor.append(append);
        }

        String getRoot() {
            return this.m_root;
        }

        public void prepend(String prepend) {
            assert (prepend != null && prepend.length() > 0) : "Parameter 'prepend' of method 'prepend' must not be empty";
            this.m_descriptor.insert(0, prepend);
        }

        String getDescriptor() {
            assert (this.m_descriptor.length() > 0) : "'m_descriptor' of method 'getDescriptor' must not be empty";
            return this.m_descriptor.toString();
        }

        public String toString() {
            return "[" + this.m_root + "] " + this.m_descriptor.toString();
        }
    }
}

