/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.ArchitecturalViewBaseProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.controller.system.UpdateInfo;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.ModelModificationInfo;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitectureFileBasedCreator;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitectureFileGenerator;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArtifactHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ExpandCollapseHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ExplorationViewOnDemandCreator;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FilterHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FindingHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FocusHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ITransferHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.LoadedRepresentationInfo;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.MetricsHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.NodeHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.OperationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.RefactoringHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.RepresentationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.SearchHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.StateHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.TargetArchitectureFileValidator;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementUtility;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewUnloadedEvent;
import com.hello2morrow.sonargraph.core.model.event.ContextsModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemEvent;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewArtifactNameValidator;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewArtifactOperationAvailability;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFinding;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFindingList;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFindingProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperationList;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewState;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNodeConnection;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNodeFilter;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableTargetInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableToArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.DeleteArchitecturalViewFileInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.DeleteElementsOperationType;
import com.hello2morrow.sonargraph.core.model.explorationview.ExpandCollapseRequest;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocus;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocusProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocusRequest;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewOnDemand;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewOperationMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewSortMode;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.explorationview.IAssignableTarget;
import com.hello2morrow.sonargraph.core.model.explorationview.IExplorationViewRepresentationOwner;
import com.hello2morrow.sonargraph.core.model.explorationview.MovableTargetInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.MoveElementsInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.PartialAlternativeInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.RecursiveElementCreationInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.RenameElementInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.RevealRequest;
import com.hello2morrow.sonargraph.core.model.explorationview.TransferArchitectureExecutionInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.TransferAvailability;
import com.hello2morrow.sonargraph.core.model.explorationview.TransferExecutionInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.TransferRefactoringsExecutionInfo;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.SearchCriteria;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import com.hello2morrow.sonargraph.core.model.system.Representations;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.SessionToArchitecturalViewMigration;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.export.ExportData;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public abstract class ArchitecturalViewProvider
extends ArchitecturalViewBaseProvider
implements IArchitecturalViewProvider {
    public ArchitecturalViewProvider(LanguageProviderAccessor accessor, Installation installation, SoftwareSystem softwareSystem, IElementResolver resolver, IFinishModelProcessor finishModelProcessor, boolean enabled) {
        super(accessor, installation, softwareSystem, resolver, finishModelProcessor, enabled);
    }

    @Override
    public final void finishSoftwareSystemInitialization(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'finishSoftwareSystemInitialization' must not be null";
        Files files = this.getSoftwareSystem().getUniqueExistingChild(Files.class);
        SessionToArchitecturalViewMigration.migrate(files.getSystemDirectory(), files.getArchitecturalViews(), result);
        super.finishSoftwareSystemInitialization(result);
    }

    @Override
    public final ArchitecturalViewArtifactNameValidator getArtifactNameValidator(AssignableTargetInfo assignableTargetInfo, ArtifactNode artifactNodeToBeEdited) {
        assert (assignableTargetInfo != null) : "Parameter 'assignableTargetInfo' of method 'getArtifactNameValidator' must not be null";
        return ArtifactHandler.getArtifactNameValidator(assignableTargetInfo, artifactNodeToBeEdited);
    }

    @Override
    public final ArchitecturalViewArtifactNameValidator getArtifactFromElementsNameValidator(AssignableTargetInfo assignableTargetInfo, List<? extends ArchitecturalViewElement> elements) {
        assert (assignableTargetInfo != null) : "Parameter 'assignableTargetInfo' of method 'getArtifactFromElementsNameValidator' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'getArtifactFromElementsNameValidator' must not be null";
        return ArtifactHandler.getArtifactFromElementsNameValidator(assignableTargetInfo, elements);
    }

    @Override
    public final ArchitecturalViewArtifactOperationAvailability isCreateArtifactPossible(List<? extends ArchitecturalViewElement> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'isCreateArtifactPossible' must not be empty";
        return this.getLoadedRepresentationInfo(elements.get(0)).isExplorationViewOrInLevelizationModeAll() ? null : OperationHandler.isOpCreateArtifactPossible(elements.get(0).getPresentationMode(), elements);
    }

    @Override
    public final ArchitecturalViewArtifactOperationAvailability isCreateArtifactFromElementsPossible(List<? extends ArchitecturalViewElement> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'isCreateArtifactFromElementsPossible' must not be empty";
        return this.getLoadedRepresentationInfo(elements.get(0)).isExplorationViewOrInLevelizationModeAll() ? null : OperationHandler.isOpCreateArtifactFromElementsPossible(elements.get(0).getPresentationMode(), elements);
    }

    @Override
    public final String getNameProposalForCreateArtifactFromElements(IAssignableTarget parent, List<? extends ArchitecturalViewElement> elements) {
        assert (parent != null) : "Parameter 'parent' of method 'getNameProposalForCreateArtifactFromElements' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'getNameProposalForCreateArtifactFromElements' must not be empty";
        assert (this.isCreateArtifactFromElementsPossible(elements).isAvailable()) : "Create artifact from elements not possible";
        return OperationHandler.getSingleNameProposal(parent, elements, parent.getArchitecturalViewElement().getPresentationMode());
    }

    @Override
    public final ArchitecturalViewArtifactOperationAvailability isCreateArtifactsForElementsPossible(List<? extends ArchitecturalViewElement> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'isCreateArtifactsForElementsPossible' must not be empty";
        return this.getLoadedRepresentationInfo(elements.get(0)).isExplorationViewOrInLevelizationModeAll() ? null : OperationHandler.isOpCreateArtifactsForElementsPossible(elements.get(0).getPresentationMode(), elements);
    }

    @Override
    public final ArchitecturalViewArtifactOperationAvailability isEditArtifactsPossible(List<ArtifactNode> artifacts) {
        assert (artifacts != null && !artifacts.isEmpty()) : "Parameter 'artifacts' of method 'isEditArtifactsPossible' must not be empty";
        return this.getLoadedRepresentationInfo(artifacts.get(0)).isExplorationViewOrInLevelizationModeAll() ? null : OperationHandler.isEditArtifactsPossible(artifacts.get(0).getPresentationMode(), artifacts);
    }

    @Override
    public boolean editArtifactsHasChanges(List<ArtifactNode> artifacts, AssignableTargetInfo targetInfo, ArtifactProperties properties) {
        assert (artifacts != null && !artifacts.isEmpty()) : "Parameter 'artifacts' of method 'editArtifactsHasChanges' must not be empty";
        assert (targetInfo != null) : "Parameter 'targetInfo' of method 'editArtifactsHasChanges' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'editArtifactsHasChanges' must not be null";
        return OperationHandler.editArtifactsHasChanges(artifacts, targetInfo, properties);
    }

    @Override
    public final boolean isMoveElementsPossible(List<? extends ArchitecturalViewElement> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'isMoveElementsPossible' must not be empty";
        LoadedRepresentationInfo loadedRepresentationInfo = this.getLoadedRepresentationInfo(elements.get(0));
        return loadedRepresentationInfo.isExplorationView() ? false : OperationHandler.isOpMoveElementsPossible(elements.get(0).getPresentationMode(), elements, loadedRepresentationInfo.inLevelizationModeAll());
    }

    @Override
    public final MoveElementsInfo isPossibleTargetInMoveElements(List<? extends ArchitecturalViewElement> elements, MovableTargetInfo targetInfo) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'isPossibleTargetInMoveElements' must not be empty";
        assert (targetInfo != null) : "Parameter 'targetInfo' of method 'isMoveElementsPossible' must not be null";
        return OperationHandler.isOpMoveElementsTargetPossible(elements.get(0).getPresentationMode(), elements, targetInfo);
    }

    @Override
    public final RenameElementInfo isRenameElementPossible(ArchitecturalViewElement element) {
        assert (element != null) : "Parameter 'element' of method 'isRenameElementPossible' must not be null";
        return this.getLoadedRepresentationInfo(element).isExplorationView() ? null : OperationHandler.isOpRenameElementPossible(element.getPresentationMode(), element, this.getArchitecturalViewRepresentation(Collections.singletonList(element)));
    }

    @Override
    public final PartialAlternativeInfo calculatePartialMoveElementsAlternative(List<? extends ArchitecturalViewElement> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'calculatePartialMoveElementsAlternative' must not be empty";
        return OperationHandler.calculatePartialMoveElementsAlternative(elements, this.getLoadedRepresentationInfo(elements.get(0)).inLevelizationModeAll());
    }

    @Override
    public final PartialAlternativeInfo calculatePartialCreateArtifactFromElementsAlternative(List<? extends ArchitecturalViewElement> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'calculatePartialCreateArtifactFromElementsAlternative' must not be empty";
        return OperationHandler.calculatePartialCreateArtifactFromElementsAlternative(elements);
    }

    @Override
    public PartialAlternativeInfo calculatePartialCreateArtifactsForElementsAlternative(List<? extends ArchitecturalViewElement> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'calculatePartialCreateArtifactsForElementsAlternative' must not be empty";
        return OperationHandler.calculatePartialCreateArtifactsForElementsAlternative(elements);
    }

    @Override
    public final DeleteElementsOperationType isDeleteElementsPossible(List<? extends ArchitecturalViewElement> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'isDeleteElementsPossible' must not be empty";
        LoadedRepresentationInfo loadedRepresentationInfo = this.getLoadedRepresentationInfo(elements.get(0));
        return loadedRepresentationInfo.isExplorationView() ? DeleteElementsOperationType.NONE : OperationHandler.isOpDeleteElementsPossible(elements.get(0).getPresentationMode(), elements, loadedRepresentationInfo.inLevelizationModeAll());
    }

    @Override
    public final boolean isHideElementsPossible(List<? extends ArchitecturalViewElement> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'isHideElementsPossible' must not be empty";
        return OperationHandler.isOpHideElementsPossible(elements.get(0).getPresentationMode(), elements);
    }

    @Override
    public final ArtifactNodeConnection isCreateAllowedArtifactConnectionPossible(ArchitecturalViewElement from, ArchitecturalViewElement to) {
        assert (from != null) : "Parameter 'from' of method 'isCreateAllowedArtifactConnectionPossible' must not be null";
        assert (to != null) : "Parameter 'to' of method 'isCreateAllowedArtifactConnectionPossible' must not be null";
        return OperationHandler.isOpCreateAllowedArtifactConnectionPossible(from.getPresentationMode(), from, to);
    }

    @Override
    public final boolean isDeleteDependenciesPossible(List<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies) {
        assert (dependencies != null && !dependencies.isEmpty()) : "Parameter 'dependencies' of method 'isDeleteDependenciesPossible' must not be empty";
        return !this.getLoadedRepresentationInfo(dependencies.get(0).getFrom()).isExplorationView() && OperationHandler.isOpDeleteDependenciesPossible(dependencies.get(0).getFrom().getPresentationMode(), dependencies) != null;
    }

    @Override
    public final DeleteArchitecturalViewFileInfo isDeleteArchitecturalViewsPossible(List<ArchitecturalViewFile> files) {
        assert (files != null && !files.isEmpty()) : "Parameter 'files' of method 'isDeleteArchitecturalViewsPossible' must not be empty";
        ArrayList<ArchitecturalViewFile> topLevel = new ArrayList<ArchitecturalViewFile>(NamedElementUtility.normalize(files, true, new Class[0]));
        DeleteArchitecturalViewFileInfo info = new DeleteArchitecturalViewFileInfo(topLevel);
        for (ArchitecturalViewFile next : topLevel) {
            info.addDependingFiles(next.getChildrenRecursively(ArchitecturalViewFile.class, ArchitecturalViewOperationList.class, ExplorationViewRepresentation.class));
        }
        return info;
    }

    @Override
    public final TransferAvailability isTransferPossible(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'isArchitectureFileGenerationPossible' must not be null";
        ExplorationViewRepresentation representation = element instanceof ArchitecturalViewFile ? element.getUniqueChild(ExplorationViewRepresentation.class) : (element instanceof ExplorationViewRepresentation ? (ExplorationViewRepresentation)element : null);
        if (representation != null && representation.isValid()) {
            boolean architectureTransferPossible = ArchitectureFileGenerator.isGenerationPossible(representation);
            boolean refactoringTransferPossible = RefactoringHandler.isRefactoringsTransferPossible(representation);
            if (architectureTransferPossible || refactoringTransferPossible) {
                ArchitecturalViewFile file = representation.getParent(ArchitecturalViewFile.class, ParentMode.ONLY_DIRECT_PARENT);
                assert (file != null) : "'file' of method 'isArchitectureFileGenerationPossible' must not be null";
                boolean modifiableModelIsUsed = this.getSoftwareSystem().getCurrentModel(ModifiableModel.class) != null;
                StringBuilder warningInfo = new StringBuilder();
                boolean createIgnoreViolationResolutionsIsPossible = false;
                if (architectureTransferPossible && FindingHandler.hasIgnoredViolationsInfo(file.getUniqueExistingChild(ArchitecturalViewFindingList.class), representation)) {
                    if (modifiableModelIsUsed) {
                        createIgnoreViolationResolutionsIsPossible = true;
                    } else {
                        warningInfo.append("Ignore violation resolution(s)");
                        createIgnoreViolationResolutionsIsPossible = false;
                    }
                }
                if (refactoringTransferPossible && !modifiableModelIsUsed) {
                    refactoringTransferPossible = false;
                    if (warningInfo.length() == 0) {
                        warningInfo.append("Refactoring(s)");
                    } else {
                        warningInfo.append(" and refactoring(s)");
                    }
                }
                if (warningInfo.length() > 0) {
                    warningInfo.append(" cannot be transferred, the 'Parser' model is currently active!");
                }
                return new TransferAvailability(file, representation, architectureTransferPossible, createIgnoreViolationResolutionsIsPossible, refactoringTransferPossible, warningInfo.toString());
            }
        }
        return null;
    }

    @Override
    public final TransferExecutionInfo getTransferExecutionInfo(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'getTransferExecutionInfo' must not be null";
        TransferAvailability availability = this.isTransferPossible(element);
        assert (availability != null) : "'availability' of method 'getTransferExecutionInfo' must not be null";
        TransferArchitectureExecutionInfo architectureExecutionInfo = null;
        if (availability.isArchitectureTransferPossible()) {
            Map<ArchitecturalViewFinding, List<ParserDependency>> ignoredViolationsInfo = FindingHandler.getIgnoredViolationsInfo(availability.getFile().getUniqueExistingChild(ArchitecturalViewFindingList.class), availability.getRepresentation());
            architectureExecutionInfo = new TransferArchitectureExecutionInfo(new TargetArchitectureFileValidator(this.getSoftwareSystem().getUniqueExistingChild(Files.class).getArchitecture().getDirectoryFile()), FileUtility.removeExtension((String)availability.getFile().getShortName()), ignoredViolationsInfo, availability.isCreateIgnoreViolationResolutionsPossible());
        }
        TransferRefactoringsExecutionInfo refactoringsExecutionInfo = null;
        if (availability.isRefactoringTransferPossible()) {
            refactoringsExecutionInfo = RefactoringHandler.createRefactoringTransfer(this.getSoftwareSystem().getExtension(ITransferHandler.class), availability.getRepresentation());
        }
        return new TransferExecutionInfo(availability.getFile(), architectureExecutionInfo, refactoringsExecutionInfo, availability.getWarningInfo());
    }

    @Override
    public final String isFilterValid(ArtifactNodeFilter filter) {
        assert (filter != null) : "Parameter 'filter' of method 'isFilterValid' must not be null";
        return FilterHandler.isFilterValid(filter);
    }

    @Override
    public final RecursiveElementCreationInfo isCreateElementPossible(ArchitecturalViewElement element) {
        assert (element != null) : "Parameter 'element' of method 'isCreateElementPossible' must not be null";
        return this.getLoadedRepresentationInfo(element).isExplorationView() ? null : OperationHandler.isOpCreateElementPossible(element.getPresentationMode(), element);
    }

    @Override
    public final void reveal(RevealRequest request) {
        assert (request != null) : "Parameter 'request' of method 'reveal' must not be null";
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(request.getRepresentation());
        ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger trigger = FocusHandler.reveal(request);
        if (trigger != null) {
            this.notifyModification(loadedInfo.getOwner(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(trigger, request.getNodes().get(0)));
        }
    }

    @Override
    public final void selectAll(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'selectAll' must not be null";
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(representation);
        ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger trigger = RepresentationHandler.selectAll(representation);
        if (trigger != null) {
            this.notifyModification(loadedInfo.getOwner(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(trigger));
        }
    }

    @Override
    public final ExplorationViewRepresentation isCollapseAllPossible(ExplorationViewRepresentation representation, List<ArchitecturalViewNode> nodes, List<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies) {
        assert (nodes != null) : "Parameter 'nodes' of method 'isCollapseAllPossible' must not be null";
        assert (dependencies != null) : "Parameter 'dependencies' of method 'isCollapseAllPossible' must not be null";
        return RepresentationHandler.isCollapseAllPossible(representation, nodes, dependencies);
    }

    @Override
    public final void collapseAll(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'collapseAll' must not be null";
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(representation);
        ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger trigger = RepresentationHandler.collapseAll(representation);
        if (trigger != null) {
            this.notifyModification(loadedInfo.getOwner(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(trigger));
        }
    }

    @Override
    public final ExpandCollapseRequest isCollapseToArtifactsPossible(ExplorationViewRepresentation representation, List<ArchitecturalViewNode> nodes, List<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies, boolean firstElementOnly) {
        assert (nodes != null) : "Parameter 'nodes' of method 'isCollapseToArtifactsPossible' must not be null";
        assert (dependencies != null) : "Parameter 'dependencies' of method 'isCollapseToArtifactsPossible' must not be null";
        return RepresentationHandler.isCollapseToArtifactsPossible(representation, nodes, dependencies, firstElementOnly);
    }

    @Override
    public final void collapseToArtifacts(IWorkerContext workerContext, ExpandCollapseRequest request) {
        assert (request != null) : "Parameter 'request' of method 'collapseToArtifacts' must not be null";
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(request.getRepresentation());
        ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger trigger = RepresentationHandler.processExpandCollapseRequest(request);
        if (trigger != null) {
            this.notifyModification(loadedInfo.getOwner(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(trigger));
        }
    }

    @Override
    public final ExpandCollapseRequest isExpandToArtifactsPossible(ExplorationViewRepresentation representation, List<ArchitecturalViewNode> nodes, List<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies, boolean firstElementOnly) {
        assert (nodes != null) : "Parameter 'nodes' of method 'isExpandToArtifactsPossible' must not be null";
        assert (dependencies != null) : "Parameter 'dependencies' of method 'isExpandToArtifactsPossible' must not be null";
        return RepresentationHandler.isExpandToArtifactsPossible(representation, nodes, dependencies, firstElementOnly);
    }

    @Override
    public final void expandToArtifacts(IWorkerContext workerContext, ExpandCollapseRequest request) {
        assert (request != null) : "Parameter 'request' of method 'expandToArtifacts' must not be null";
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(request.getRepresentation());
        ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger trigger = RepresentationHandler.processExpandCollapseRequest(request);
        if (trigger != null) {
            this.notifyModification(loadedInfo.getOwner(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(trigger));
        }
    }

    @Override
    public final ExpandCollapseRequest isExpandToAssignableToArtifactsPossible(List<ArchitecturalViewNode> nodes, List<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies, boolean firstElementOnly) {
        assert (nodes != null) : "Parameter 'nodes' of method 'isExpandToAssignableToArtifactsPossible' must not be null";
        assert (dependencies != null) : "Parameter 'dependencies' of method 'isExpandToAssignableToArtifactsPossible' must not be null";
        return RepresentationHandler.isExpandToAssignableToArtifactsPossible(nodes, dependencies, firstElementOnly);
    }

    @Override
    public final void expandToAssignableToArtifacts(IWorkerContext workerContext, ExpandCollapseRequest request) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'expandToAssignableToArtifacts' must not be null";
        assert (request != null) : "Parameter 'request' of method 'expandToAssignableToArtifacts' must not be null";
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(request.getRepresentation());
        ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger trigger = RepresentationHandler.processExpandCollapseRequest(request);
        if (trigger != null) {
            this.notifyModification(loadedInfo.getOwner(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(trigger));
        }
    }

    @Override
    public final List<ArchitecturalViewNode> expand(ArchitecturalViewNode node, boolean autoExpand, ExplorationViewRepresentation representation) {
        assert (node != null) : "Parameter 'node' of method 'expand' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'expand' must not be null";
        return ExpandCollapseHandler.expand(node, autoExpand, this.getLoadedRepresentationInfo(representation).getRepresentation());
    }

    @Override
    public final int collapse(ArchitecturalViewNode node, ExplorationViewRepresentation representation) {
        assert (node != null) : "Parameter 'node' of method 'collapse' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'collapse' must not be null";
        return ExpandCollapseHandler.collapse(node, this.getLoadedRepresentationInfo(representation).getRepresentation());
    }

    @Override
    public final ArchitecturalViewState createState(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'createState' must not be null";
        return StateHandler.createState(representation);
    }

    @Override
    public final void restoreState(ArchitecturalViewState state, PresentationMode presentationMode, ExplorationViewSortMode levelizationMode, ExplorationViewFocus focus, String revealNodeWithRelativePath, ExplorationViewRepresentation representation) {
        assert (state != null) : "Parameter 'state' of method 'restoreState' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'restoreState' must not be null";
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(representation);
        ArchitecturalViewNode reveal = StateHandler.applyState(state, presentationMode, levelizationMode, focus, revealNodeWithRelativePath, representation);
        this.notifyModification(loadedInfo.getOwner(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.RESTORE_STATE, reveal));
    }

    @Override
    public final List<ArchitecturalViewState> updateStates(List<ArchitecturalViewState> states, ExplorationViewRepresentation representation) {
        assert (states != null && !states.isEmpty()) : "Parameter 'states' of method 'updateStates' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'updateStates' must not be null";
        return StateHandler.updateStates(states, representation);
    }

    @Override
    public final ExplorationViewFocus updateFocus(ExplorationViewFocus focus, ExplorationViewRepresentation representation) {
        assert (focus != null) : "Parameter 'focus' of method 'updateFocus' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'updateFocus' must not be null";
        return FocusHandler.updateFocus(focus, representation);
    }

    @Override
    public final OperationResult setPresentationMode(IWorkerContext workerContext, ExplorationViewRepresentation representation, PresentationMode mode) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'setPresentationMode' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'setPresentationMode' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'setPresentationMode' must not be null";
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(representation);
        OperationResult result = new OperationResult("Set presentation mode of " + representation.getType().toLowerCase() + " '" + loadedInfo.getOwner().getId() + "' to '" + String.valueOf((Object)mode) + "'");
        OperationHandler.changePresentationMode(mode, loadedInfo.getRepresentation());
        this.notifyModification(loadedInfo.getOwner(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.PRESENTATION_MODE));
        return result;
    }

    @Override
    public final OperationResult setSortMode(IWorkerContext workerContext, ExplorationViewRepresentation representation, ExplorationViewSortMode mode) {
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(representation);
        OperationResult result = new OperationResult("Set sort mode of " + representation.getType().toLowerCase() + " '" + loadedInfo.getOwner().getId() + "' to '" + String.valueOf((Object)mode) + "'");
        OperationHandler.changeSortMode(mode, loadedInfo.getRepresentation());
        this.notifyModification(loadedInfo.getOwner(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.SORT_MODE));
        return result;
    }

    @Override
    public final OperationResult clearFocus(IWorkerContext workerContext, ExplorationViewRepresentation representation) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'clearFocus' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'clearFocus' must not be null";
        OperationResult result = new OperationResult("Clear focus");
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(representation);
        FocusHandler.clearFocus(representation);
        this.notifyModification(loadedInfo.getOwner(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.FOCUS));
        return result;
    }

    @Override
    public final ExplorationViewFocusRequest isApplyFocusPossible(ExplorationViewFocusProperties.FocusType focusType, List<ArchitecturalViewNode> nodes, List<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies, List<ArchitecturalViewFinding> findings) {
        assert (focusType != null) : "Parameter 'focusType' of method 'isApplyFocusPossible' must not be null";
        assert (nodes != null) : "Parameter 'nodes' of method 'isApplyFocusPossible' must not be null";
        assert (dependencies != null) : "Parameter 'dependencies' of method 'isApplyFocusPossible' must not be null";
        assert (findings != null) : "Parameter 'findings' of method 'isApplyFocusPossible' must not be null";
        return FocusHandler.isApplyFocusPossible(focusType, nodes, dependencies, findings);
    }

    @Override
    public boolean isCreateFindingPossible(List<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies) {
        assert (dependencies != null && !dependencies.isEmpty()) : "Parameter 'dependencies' of method 'isCreateFindingPossible' must not be empty";
        return this.getLoadedRepresentationInfo(dependencies.get(0).getFrom()).isExplorationView() ? false : OperationHandler.isOpCreateFindingPossible(dependencies.get(0).getFrom().getPresentationMode(), dependencies) != null;
    }

    @Override
    public ArchitecturalViewFindingProperties createFindingProperties(List<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies) {
        assert (dependencies != null && !dependencies.isEmpty()) : "Parameter 'dependencies' of method 'createFindingProperties' must not be empty";
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(dependencies.get(0).getFrom());
        return OperationHandler.createFindingProperties(loadedInfo.getPresentationMode(), dependencies, loadedInfo.getOperationList(), loadedInfo.getFindingList());
    }

    @Override
    public final ArchitecturalViewOperation getCorrespondingOperation(ArchitecturalViewFinding finding) {
        assert (finding != null) : "Parameter 'finding' of method 'getCorrespondingOperation' must not be null";
        return OperationHandler.getCorrespondingOperation(finding);
    }

    @Override
    public final ExplorationViewFocusProperties createOnDemandFocusProperties() {
        return FocusHandler.createOnDemandFocusProperties();
    }

    @Override
    public final ExplorationViewFocusProperties getFocusProperties(ExplorationViewFocusProperties.FocusType focusType, ExplorationViewFocusRequest request) {
        assert (focusType != null) : "Parameter 'focusType' of method 'getFocusProperties' must not be null";
        assert (request != null) : "Parameter 'request' of method 'getFocusProperties' must not be null";
        return FocusHandler.createFocusProperties(focusType, request);
    }

    @Override
    public final OperationResult applyFocus(IWorkerContext workerContext, ExplorationViewFocusProperties focusProperties, ExplorationViewFocusRequest focusRequest) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'applyFocus' must not be null";
        assert (focusProperties != null) : "Parameter 'focusProperties' of method 'applyFocus' must not be null";
        assert (focusRequest != null) : "Parameter 'focusRequest' of method 'applyFocus' must not be null";
        OperationResult result = new OperationResult("Apply focus operation '" + String.valueOf((Object)focusProperties.getFocusType()) + "'");
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(focusRequest.getRepresentation());
        FocusHandler.applyFocus(focusProperties, focusRequest);
        this.notifyModification(loadedInfo.getOwner(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.FOCUS));
        return result;
    }

    @Override
    public final List<ExportData> convertToExportData(IWorkerContext workerContext, ArchitecturalViewFile file, String topic, Collection<? extends ArchitecturalViewInfo<? extends Element>> info) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'convertToExportData' must not be null";
        assert (file != null) : "Parameter 'file' of method 'convertToExportData' must not be null";
        assert (topic != null && topic.length() > 0) : "Parameter 'topic' of method 'convertToExportData' must not be empty";
        assert (info != null) : "Parameter 'info' of method 'convertToExportData' must not be null";
        ExportData exportData = new ExportData(topic, topic + " [" + info.size() + "] of Architectural View '" + file.getIdentifyingPath() + "'");
        exportData.addColumn("Type");
        exportData.addColumn("File");
        exportData.addColumn("Line");
        exportData.addColumn("Element");
        exportData.addColumn("To Element");
        exportData.addColumn("Info");
        info.forEach(i -> exportData.addRow(new Object[]{i.getTopic().getPresentationName(), i.getIdentifyingFilePath(), i.getLineNumber() == -1 ? "n/a" : Integer.toString(i.getLineNumber()), i.getElementName(), i.getToElementName(), i.getInformation()}));
        return Collections.singletonList(exportData);
    }

    @Override
    public final RevealRequest getRevealRequest(List<ArchitecturalViewNode> nodesToReveal, boolean forceFocus) {
        assert (nodesToReveal != null && !nodesToReveal.isEmpty()) : "Parameter 'nodesToReveal' of method 'getRevealRequest' must not be empty";
        return FocusHandler.getRevealRequest(nodesToReveal, forceFocus);
    }

    @Override
    public final boolean isSearchPatternValid(String pattern, EnumSet<SearchCriteria> criteria) {
        assert (pattern != null) : "Parameter 'pattern' of method 'isSearchPatternValid' must not be null";
        assert (criteria != null) : "Parameter 'criteria' of method 'isSearchPatternValid' must not be null";
        return SearchHandler.isSearchPatternValid(pattern, criteria);
    }

    @Override
    public boolean isSelectDependenciesPossible(List<ArchitecturalViewNode> nodes) {
        assert (nodes != null) : "Parameter 'nodes' of method 'isSelectDependenciesPossible' must not be null";
        return RepresentationHandler.isSelectDependenciesPossible(nodes);
    }

    @Override
    public final void selectDependencies(List<ArchitecturalViewNode> nodes) {
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'selectDependencies' must not be empty";
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(nodes.get(0));
        ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger trigger = RepresentationHandler.selectDependencies(nodes);
        if (trigger != null) {
            this.notifyModification(loadedInfo.getOwner(), new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(trigger));
        }
    }

    protected final Set<UpdateInfo> getUpdateInfo(EnumSet<ModelModificationInfo.ModelModification> modelModifications) {
        assert (modelModifications != null) : "Parameter 'modelModifications' of method 'getUpdateInfo' must not be null";
        THashSet info = new THashSet();
        if (modelModifications.contains((Object)ModelModificationInfo.ModelModification.PHYSICAL_MODEL_MODIFIED)) {
            info.add(new UpdateInfo(ExplorationViewOperationMode.ARCHITECTURAL_MODELLING_PHYSICAL, UpdateInfo.UpdateMode.RECREATE_ALL_EXPLORATION_VIEWS));
            info.add(new UpdateInfo(ExplorationViewOperationMode.ARCHITECTURE_EXPLORATION_PHYSICAL, UpdateInfo.UpdateMode.RECREATE_ALL_EXPLORATION_VIEWS));
            info.add(new UpdateInfo(ExplorationViewOperationMode.SYSTEM_EXPLORATION_PHYSICAL, UpdateInfo.UpdateMode.RECREATE_ALL_EXPLORATION_VIEWS));
        }
        if (modelModifications.contains((Object)ModelModificationInfo.ModelModification.LOGIGAL_MODEL_MODIFIED)) {
            info.add(new UpdateInfo(ExplorationViewOperationMode.ARCHITECTURAL_MODELLING_LOGICAL, UpdateInfo.UpdateMode.RECREATE_ALL_EXPLORATION_VIEWS));
            info.add(new UpdateInfo(ExplorationViewOperationMode.ARCHITECTURE_EXPLORATION_LOGICAL, UpdateInfo.UpdateMode.RECREATE_ALL_EXPLORATION_VIEWS));
            info.add(new UpdateInfo(ExplorationViewOperationMode.SYSTEM_EXPLORATION_LOGICAL, UpdateInfo.UpdateMode.RECREATE_ALL_EXPLORATION_VIEWS));
        }
        if (modelModifications.contains((Object)ModelModificationInfo.ModelModification.ARCHITECTURE_MODEL_MODIFIED)) {
            if (!modelModifications.contains((Object)ModelModificationInfo.ModelModification.PHYSICAL_MODEL_MODIFIED)) {
                info.add(new UpdateInfo(ExplorationViewOperationMode.ARCHITECTURE_EXPLORATION_PHYSICAL, UpdateInfo.UpdateMode.RECREATE_ARTIFACTS_FROM_ARCHITECTURE_FILE_BASED_EXPLORATION_VIEW));
                info.add(new UpdateInfo(ExplorationViewOperationMode.SYSTEM_EXPLORATION_PHYSICAL, UpdateInfo.UpdateMode.UPDATE_DEPENDENCIES));
            }
            if (!modelModifications.contains((Object)ModelModificationInfo.ModelModification.LOGIGAL_MODEL_MODIFIED)) {
                info.add(new UpdateInfo(ExplorationViewOperationMode.ARCHITECTURE_EXPLORATION_LOGICAL, UpdateInfo.UpdateMode.RECREATE_ARTIFACTS_FROM_ARCHITECTURE_FILE_BASED_EXPLORATION_VIEW));
                info.add(new UpdateInfo(ExplorationViewOperationMode.SYSTEM_EXPLORATION_LOGICAL, UpdateInfo.UpdateMode.UPDATE_DEPENDENCIES));
            }
        }
        if (modelModifications.contains((Object)ModelModificationInfo.ModelModification.ISSUES_MODIFIED)) {
            if (!modelModifications.contains((Object)ModelModificationInfo.ModelModification.PHYSICAL_MODEL_MODIFIED)) {
                info.add(new UpdateInfo(ExplorationViewOperationMode.ARCHITECTURE_EXPLORATION_PHYSICAL, UpdateInfo.UpdateMode.UPDATE_DEPENDENCIES));
                info.add(new UpdateInfo(ExplorationViewOperationMode.SYSTEM_EXPLORATION_PHYSICAL, UpdateInfo.UpdateMode.UPDATE_DEPENDENCIES));
            }
            if (!modelModifications.contains((Object)ModelModificationInfo.ModelModification.LOGIGAL_MODEL_MODIFIED)) {
                info.add(new UpdateInfo(ExplorationViewOperationMode.ARCHITECTURE_EXPLORATION_LOGICAL, UpdateInfo.UpdateMode.UPDATE_DEPENDENCIES));
                info.add(new UpdateInfo(ExplorationViewOperationMode.SYSTEM_EXPLORATION_LOGICAL, UpdateInfo.UpdateMode.UPDATE_DEPENDENCIES));
            }
        }
        return info;
    }

    protected final ArchitecturalViewFile getRestoredFile(List<IModifiableFile> restoredFiles) {
        assert (restoredFiles != null && !restoredFiles.isEmpty()) : "Parameter 'restoredFiles' of method 'getRestoredFile' must not be empty";
        ArchitecturalViewFile restored = null;
        for (IModifiableFile next : restoredFiles) {
            if (!(next instanceof ArchitecturalViewFile)) continue;
            assert (restored == null) : "'restored' of method 'getRestoredFile' must be null";
            restored = (ArchitecturalViewFile)next;
        }
        return restored;
    }

    protected final Map<ExplorationViewOnDemand, UpdateInfo.UpdateMode> getAvailableOnDemand(Set<UpdateInfo> updateInfo) {
        assert (updateInfo != null) : "Parameter 'updateInfo' of method 'getAvailableArchitecturalViewFiles' must not be null";
        if (updateInfo.isEmpty()) {
            return Collections.emptyMap();
        }
        List<ExplorationViewOnDemand> available = this.getSoftwareSystem().getUniqueExistingChild(Representations.class).getChildren(ExplorationViewOnDemand.class);
        if (available.isEmpty()) {
            return Collections.emptyMap();
        }
        THashMap availableToUpdateMode = new THashMap(available.size());
        block0: for (ExplorationViewOnDemand nextAvailable : available) {
            for (UpdateInfo nextUpdateInfo : updateInfo) {
                if (nextAvailable.getOperationMode() != nextUpdateInfo.getOperationMode()) continue;
                availableToUpdateMode.put(nextAvailable, nextUpdateInfo.getUpdateMode());
                continue block0;
            }
        }
        return availableToUpdateMode;
    }

    protected final List<ArchitecturalViewFile> getAvailableArchitecturalViewFiles(Set<UpdateInfo> updateInfo, ArchitecturalViewFile exclude) {
        assert (updateInfo != null) : "Parameter 'updateInfo' of method 'getAvailableArchitecturalViewFiles' must not be null";
        if (updateInfo.isEmpty()) {
            return Collections.emptyList();
        }
        List<ArchitecturalViewFile> available = this.getArchitecturalViewsDirectory().getChildrenRecursively(ArchitecturalViewFile.class, ExplorationViewRepresentation.class);
        if (available.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ArchitecturalViewFile> matched = new ArrayList<ArchitecturalViewFile>(available.size());
        block0: for (ArchitecturalViewFile nextAvailable : available) {
            if (nextAvailable == exclude) continue;
            for (UpdateInfo nextUpdateInfo : updateInfo) {
                if (nextAvailable.getOperationMode() != nextUpdateInfo.getOperationMode()) continue;
                assert (nextUpdateInfo.getUpdateMode() == UpdateInfo.UpdateMode.RECREATE_ALL_EXPLORATION_VIEWS) : "Unexpected update mode: " + String.valueOf((Object)nextUpdateInfo.getUpdateMode());
                matched.add(nextAvailable);
                continue block0;
            }
        }
        return matched;
    }

    @Override
    public final List<AssignableToArtifactNode> calculateMatchingPreview(IWorkerContext workerContext, AssignableTargetInfo targetInfo, ArtifactNodeFilter filter, Set<String> multipleAttributeInfoCollector, ArtifactNode toBeEdited) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'calculateMatchingPreview' must not be null";
        assert (targetInfo != null) : "Parameter 'targetInfo' of method 'calculateMatchingPreview' must not be null";
        assert (filter != null) : "Parameter 'filter' of method 'calculateMatchingPreview' must not be null";
        assert (multipleAttributeInfoCollector != null) : "Parameter 'multipleAttributeInfoCollector' of method 'calculateMatchingPreview' must not be null";
        ExplorationViewRepresentation representation = this.getArchitecturalViewRepresentation(Collections.singletonList(targetInfo.getTarget().getArchitecturalViewElement()));
        assert (representation != null) : "'representation' of method 'calculateMatchingPreview' must not be null";
        return FilterHandler.calculateMatchingPreview(workerContext, targetInfo, filter, multipleAttributeInfoCollector, toBeEdited, representation);
    }

    @Override
    public final String getExportNameProposal(IExplorationViewRepresentationOwner owner) {
        assert (owner != null) : "Parameter 'owner' of method 'getExportNameProposal' must not be null";
        if (owner instanceof ArchitecturalViewFile) {
            return FileUtility.removeExtension((String)((ArchitecturalViewFile)owner).getFile().getName());
        }
        assert (owner instanceof ExplorationViewOnDemand) : "Unexpected class in method 'getExportNameProposal': " + String.valueOf(owner);
        ArchitectureFile architectureFile = ((ExplorationViewOnDemand)owner).getArchitectureFile();
        return "Exploration" + (String)(architectureFile == null ? "" : "_" + architectureFile.getShortName());
    }

    @Override
    public final List<ArchitecturalViewNode> getSearchInNodes(List<Element> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'getSearchInNodes' must not be empty";
        ArrayList<ArchitecturalViewNode> nodes = new ArrayList<ArchitecturalViewNode>();
        ExplorationViewRepresentation representation = null;
        for (Element next : elements) {
            if (!(next instanceof ArchitecturalViewNode)) continue;
            ArchitecturalViewNode nextNode = (ArchitecturalViewNode)next;
            ExplorationViewRepresentation nextRepresentation = nextNode.getParent(ExplorationViewRepresentation.class, ParentMode.SELF_OR_FIRST_PARENT);
            if (nextRepresentation == null) {
                return Collections.emptyList();
            }
            if (representation == null) {
                representation = nextRepresentation;
                IExplorationViewRepresentationOwner nextOwner = nextRepresentation.getParent(IExplorationViewRepresentationOwner.class, ParentMode.SELF_OR_FIRST_PARENT);
                if (nextOwner == null) {
                    return Collections.emptyList();
                }
            } else if (representation != nextRepresentation) {
                return Collections.emptyList();
            }
            nodes.add((ArchitecturalViewNode)next);
        }
        return NodeHandler.getToplevelNodes(nodes);
    }

    @Override
    public final List<ArchitecturalViewNode> search(IWorkerContext workerContext, String pattern, EnumSet<SearchCriteria> criteria, Predicate<ArchitecturalViewNode> include, List<ArchitecturalViewNode> nodes, ExplorationViewRepresentation representation) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'searchMoveTargets' must not be null";
        assert (pattern != null && pattern.length() > 0) : "Parameter 'pattern' of method 'searchMoveTargets' must not be empty";
        assert (this.isSearchPatternValid(pattern, criteria)) : "Pattern not valid: " + pattern;
        assert (criteria != null) : "Parameter 'criteria' of method 'searchMoveTargets' must not be null";
        assert (nodes != null) : "Parameter 'nodes' of method 'search' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'searchMoveTargets' must not be null";
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(representation);
        if (include == null) {
            return SearchHandler.search(workerContext, pattern, criteria, nodes, loadedInfo.getRepresentation());
        }
        return SearchHandler.search(workerContext, pattern, criteria, include, nodes, loadedInfo.getRepresentation());
    }

    @Override
    public ExplorationViewOperationMode isCalculateMetricsPossible(List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'isCalculateMetricsPossible' must not be null";
        return MetricsHandler.isCalculateMetricsPossible(elements);
    }

    protected final void processModifiedOnDemand(IWorkerContext workerContext, SoftwareSystem softwareSystem, Map<ExplorationViewOnDemand, UpdateInfo.UpdateMode> onDemand, List<SoftwareSystemEvent> eventsToDispatch) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'processModifiedOnDemand' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'processModifiedOnDemand' must not be null";
        assert (onDemand != null) : "Parameter 'onDemand' of method 'processModifiedOnDemand' must not be null";
        assert (eventsToDispatch != null) : "Parameter 'eventsToDispatch' of method 'processModifiedOnDemand' must not be null";
        ISoftwareSystemProvider softwareSystemProvider = softwareSystem.getExtension(ISoftwareSystemProvider.class);
        boolean contextsModified = false;
        for (Map.Entry<ExplorationViewOnDemand, UpdateInfo.UpdateMode> nextEntry : onDemand.entrySet()) {
            ExplorationViewOnDemand nextOnDemand = nextEntry.getKey();
            assert (this.hasBeenLoaded(nextOnDemand)) : "Has not been loaded: " + String.valueOf(nextOnDemand);
            ExplorationViewRepresentation nextRepresentation = nextOnDemand.getUniqueExistingChild(ExplorationViewRepresentation.class);
            assert (!nextRepresentation.isInTransfer()) : "Cannot be 'inTransfer': " + String.valueOf(nextRepresentation);
            if (ExplorationViewOnDemandCreator.unload(nextOnDemand, nextRepresentation)) {
                this.performUnload(nextOnDemand);
                eventsToDispatch.add(new ArchitecturalViewUnloadedEvent(softwareSystemProvider, nextOnDemand));
                contextsModified = true;
                continue;
            }
            workerContext.working("Updating exploration view on demand '" + nextOnDemand.getId() + "'", true);
            UpdateInfo.UpdateMode nextUpdateMode = nextEntry.getValue();
            switch (nextUpdateMode) {
                case RECREATE_ALL_EXPLORATION_VIEWS: {
                    ExplorationViewFocus focus = !nextRepresentation.getFocus().isEmpty() ? nextRepresentation.getFocus().copy() : null;
                    ArchitecturalViewState state = StateHandler.createState(nextRepresentation);
                    this.performUnload(nextOnDemand);
                    if (this.load((IWorkerContext)DefaultWorkerContext.INSTANCE, nextOnDemand, nextRepresentation.getPresentationMode(), (Pair<ExplorationViewFocus, ArchitecturalViewState>)new Pair((Object)focus, (Object)state), null, null)) {
                        eventsToDispatch.add(new ArchitecturalViewModifiedEvent(softwareSystemProvider, nextOnDemand, new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.MODEL)));
                        break;
                    }
                    eventsToDispatch.add(new ArchitecturalViewUnloadedEvent(softwareSystemProvider, nextOnDemand));
                    break;
                }
                case RECREATE_ARTIFACTS_FROM_ARCHITECTURE_FILE_BASED_EXPLORATION_VIEW: {
                    ArchitectureFile basedOnArchitectureFile = nextOnDemand.getArchitectureFile();
                    assert (basedOnArchitectureFile != null) : "Architecture file expected: " + String.valueOf(nextOnDemand);
                    if (!basedOnArchitectureFile.isValid()) {
                        this.performUnload(nextOnDemand);
                        eventsToDispatch.add(new ArchitecturalViewUnloadedEvent(softwareSystemProvider, nextOnDemand));
                        break;
                    }
                    ArchitectureFileBasedCreator.processModifiedArchitectureFile(workerContext, nextOnDemand.getArchitectureFile(), nextRepresentation);
                    eventsToDispatch.add(new ArchitecturalViewModifiedEvent(softwareSystemProvider, nextOnDemand, new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.MODEL)));
                    break;
                }
                case UPDATE_DEPENDENCIES: {
                    RepresentationHandler.updateAggregatedDependencies(nextRepresentation);
                    eventsToDispatch.add(new ArchitecturalViewModifiedEvent(softwareSystemProvider, nextOnDemand, new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.DEPENDENCIES)));
                    break;
                }
                default: {
                    assert (false) : "Unhandled update mode: " + String.valueOf((Object)nextUpdateMode);
                    break;
                }
            }
            contextsModified = true;
        }
        if (contextsModified) {
            eventsToDispatch.add(new ContextsModifiedEvent(softwareSystemProvider));
        }
    }
}

