/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.AnalyzerAdapterUtitity;
import com.hello2morrow.sonargraph.core.controller.system.AnalyzerIdComparator;
import com.hello2morrow.sonargraph.core.controller.system.AnalyzerProvider;
import com.hello2morrow.sonargraph.core.controller.system.IAnalyzerConfigurationInfoProvider;
import com.hello2morrow.sonargraph.core.controller.system.IQualityModelProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.controller.system.QualityModelMessageCause;
import com.hello2morrow.sonargraph.core.controller.system.analysis.IssueDensityAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.IssueRankingAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.QualityGateAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.ScmAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.ScriptRunner;
import com.hello2morrow.sonargraph.core.controller.system.analysis.SystemDiffAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.ThresholdAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.architecture.ArchitectureCheckAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.architecture.ArchitectureMetricAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerResultConsumer;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.PluginAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.analysis.complexity.AverageComplexityAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.complexity.ComplexityMetricsAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.coupling.CalculateMaintainabilityLevelAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.coupling.CohesionAndCouplingMetricsModule;
import com.hello2morrow.sonargraph.core.controller.system.analysis.coupling.CohesionAndCouplingMetricsSystem;
import com.hello2morrow.sonargraph.core.controller.system.analysis.coupling.IncomingDependencyMetricsModule;
import com.hello2morrow.sonargraph.core.controller.system.analysis.coupling.IncomingDependencyMetricsSystem;
import com.hello2morrow.sonargraph.core.controller.system.analysis.coupling.OutgoingDependencyMetricsModule;
import com.hello2morrow.sonargraph.core.controller.system.analysis.coupling.OutgoingDependencyMetricsSystem;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.ComponentCyclesInModulesAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.ComponentCyclesInModulesMetricsAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.ComponentCyclesInSystemAnalyzer;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.ComponentCyclesInSystemMetricsAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.CyclesAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.EntanglementAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.LogicalToplevelElementCyclesAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.ModuleCyclesInSystemAnalyzer;
import com.hello2morrow.sonargraph.core.controller.system.analysis.duplicate.DuplicateCodeAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.duplicate.DuplicateCodeMetricsAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.size.CodeOrganizationAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.size.SizeMetricsAdapter;
import com.hello2morrow.sonargraph.core.controller.system.base.AnalyzerConfigurationChangeMode;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.IModifiableFileProvider;
import com.hello2morrow.sonargraph.core.controller.system.base.ISoftwareSystemLifecycleListener;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IAnalyzerExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.Analyzer;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerState;
import com.hello2morrow.sonargraph.core.model.analysis.Analyzers;
import com.hello2morrow.sonargraph.core.model.analysis.ConfigurableAnalyzerIdComparator;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockIssue;
import com.hello2morrow.sonargraph.core.model.analysis.IAnalyzerJob;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.SourceFileIssueParticipationInfo;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.SonargraphProduct;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultAvailableEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultClearedEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzersFinishedEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzersStartedEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemEvent;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileAccess;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileDeltaKey;
import com.hello2morrow.sonargraph.core.model.path.ImportQualityModel;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileCandidate;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDelta;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDeltaDetector;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.path.scm.TemporalCouplingModel;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.INamedElementResolver;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.core.persistence.system.settings.AnalyzerConfigurationPersistence;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.collections.MultipleValueMap;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.scm.ScmManager;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnalyzerExtension
extends AnalyzerProvider
implements IAnalyzerExtension,
ISoftwareSystemLifecycleListener,
IModifiableFileProvider,
IQualityModelProvider,
IModifiableFileDeltaKey,
ThreadFactory {
    static final String ANALYZER_RESULTS = "AnalyzerResults";
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyzerExtension.class);
    private final List<IAnalyzerJob> m_currentlyRunning = new ArrayList<IAnalyzerJob>();
    private final Set<IConfigurableAnalyzerId> m_licensedAnalyzerIds = new TreeSet<IAnalyzerId>(new AnalyzerIdComparator());
    private final Set<IConfigurableAnalyzerId> m_notLicensedAnalyzerIds = new TreeSet<IAnalyzerId>(new AnalyzerIdComparator());
    private final Map<IConfigurableAnalyzerId, AnalyzerAdapter> m_currentlyUsedAnalyzerIdToAdapter = new TreeMap<IConfigurableAnalyzerId, AnalyzerAdapter>(new ConfigurableAnalyzerIdComparator());
    private final MultipleValueMap<AnalyzerGroup, AnalyzerAdapter> m_groups = new MultipleValueMap();
    private final IFinishModelProcessor m_finishModelProcessor;
    private final IAnalyzerConfigurationInfoProvider m_configurationInfoProvider;
    private final INamedElementResolver m_namedElementResolver;
    private ExecutorService m_executorService;
    private volatile boolean m_cancelled = false;
    private volatile boolean m_closed = false;
    private volatile int m_runningControllers;
    private volatile int m_finishedAnalyzerCount = 0;
    private volatile boolean m_analyzersAreRunning = false;
    private volatile int m_finishModelProcessorCalls = 0;
    private volatile boolean m_finishingAnalyzerRun = false;
    private AnalyzerExecutionLevel m_lastAppliedAnalyzerExecutionLevel;

    public AnalyzerExtension(LanguageProviderAccessor accessor, Installation installation, SoftwareSystem softwareSystem, IFinishModelProcessor finishModelProcessor, IAnalyzerConfigurationInfoProvider configurationInfoProvider, INamedElementResolver resolver, SonargraphProduct product) {
        super(accessor, installation, softwareSystem);
        assert (installation != null) : "Parameter 'installation' of method 'AnalyzerExtension' must not be null";
        assert (configurationInfoProvider != null) : "Parameter 'configurationInfoProvider' of method 'AnalyzerExtension' must not be null";
        assert (resolver != null) : "Parameter 'resolver' of method 'AnalyzerExtension' must not be null";
        assert (product != null) : "Parameter 'product' of method 'AnalyzerExtension' must not be null";
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        this.m_executorService = product == SonargraphProduct.SONARGRAPH_BUILD ? Executors.newFixedThreadPool(availableProcessors, this) : Executors.newFixedThreadPool(Math.max(availableProcessors - 3, 1), this);
        this.m_finishModelProcessor = finishModelProcessor;
        this.m_configurationInfoProvider = configurationInfoProvider;
        this.m_namedElementResolver = resolver;
        finishModelProcessor.addListener(this);
    }

    @Override
    public INamedElementResolver getResolver() {
        return this.m_namedElementResolver;
    }

    @Override
    public AnalyzerExecutionLevel getAnalyzerExecutionLevel() {
        return this.m_configurationInfoProvider.getAnalyzerExecutionLevel();
    }

    synchronized AnalyzerExecutionLevel getLastAppliedAnalyzerExecutionLevel() {
        return this.m_lastAppliedAnalyzerExecutionLevel;
    }

    @Override
    public void released(SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToDispatch, OperationResult result) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'released' must not be null";
        for (Language nextLanguage : softwareSystem.getUsedLanguages()) {
            LanguageProvider nextLanguageProvider = this.getLanguageProviderAccessor().getLanguageProvider(nextLanguage);
            if (nextLanguageProvider == null) continue;
            this.m_currentlyUsedAnalyzerIdToAdapter.values().forEach(a -> a.languageRemoved(nextLanguageProvider));
            AnalyzerAdapterUtitity.finishLanguageRemoved(this.getInstallation(), nextLanguageProvider);
        }
    }

    @Override
    public void savedAs(SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToDispatch, EnumSet<Modification> modifications, TFile oldSystemDirectory, OperationResult result, boolean baseDirectoryChanged) {
        this.m_currentlyUsedAnalyzerIdToAdapter.values().forEach(a -> a.systemSavedAs(baseDirectoryChanged));
    }

    @Override
    public TFile getAnalyzerResultStorageDirectory() {
        TFile dir = new TFile((File)this.getSoftwareSystem().getHiddenDataDirectory(), ANALYZER_RESULTS);
        dir.mkdirs();
        return dir;
    }

    @Override
    public TFile getAnalyzerResultReadDirectory() {
        if (this.getSoftwareSystem().getMode() != SoftwareSystemMode.SYSTEM) {
            TFile snapshot = this.getSoftwareSystem().getSnapshot();
            assert (snapshot != null) : "'snapshot' of method 'getAnalyzerResultReadDirectory' must not be null";
            return new TFile((File)snapshot, ANALYZER_RESULTS);
        }
        return new TFile((File)this.getSoftwareSystem().getHiddenDataDirectory(), ANALYZER_RESULTS);
    }

    @Override
    public String getAnalyzerExecutionLevelDescription(AnalyzerExecutionLevel level) {
        assert (level != null) : "Parameter 'level' of method 'getAnalyzerExecutionLevelDescription' must not be null";
        ArrayList<String> analyzersToBeRun = new ArrayList<String>();
        for (AnalyzerAdapter next : this.m_currentlyUsedAnalyzerIdToAdapter.values()) {
            if (!next.getAnalyzerId().getExecutionLevel().equals((Object)level)) continue;
            analyzersToBeRun.add(next.getAnalyzerId().getPresentationName());
        }
        Collections.sort(analyzersToBeRun);
        StringBuilder builder = new StringBuilder();
        if (level.equals((Object)AnalyzerExecutionLevel.MINIMAL)) {
            builder.append("Analyzers: ");
        } else {
            AnalyzerExecutionLevel previous = AnalyzerExecutionLevel.values()[level.ordinal() + 1];
            builder.append("Analyzers from '").append(previous.getPresentationName()).append("' and additionally:");
        }
        analyzersToBeRun.forEach(a -> {
            StringBuilder stringBuilder2 = builder.append("\n - ").append((String)a);
        });
        return builder.toString();
    }

    @Override
    public void checkOutOfSync(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'checkOutOfSync' must not be null";
        Analyzers analyzers = this.getSoftwareSystem().getUniqueExistingChild(Files.class).getAnalyzers();
        analyzers.enforceExistence(result);
        IModifiableFileAccess fileAccess = new IModifiableFileAccess(){

            @Override
            public boolean accept(String fileName) {
                if (!($assertionsDisabled || fileName != null && fileName.length() > 0)) {
                    throw new AssertionError((Object)"Parameter 'fileName' of method 'accept' must not be empty");
                }
                return AnalyzerExtension.this.getAnalyzerConfiguration(fileName) != null;
            }
        };
        if (result.isSuccess() && analyzers.isOutOfSync(fileAccess, (String[][])new String[][]{CoreFileType.ANALYZER_CONFIGURATION.getExtensions()})) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, "Consider to refresh the system", new Object[0]);
        }
    }

    private AnalyzerConfigurationFile getAnalyzerConfigurationFile(Analyzers analyzers, String fileName) {
        assert (analyzers != null) : "Parameter 'analyzers' of method 'getAnalyzerConfigurationFile' must not be null";
        List<AnalyzerConfigurationFile> files = analyzers.getChildren(c -> c.getName().endsWith(fileName), AnalyzerConfigurationFile.class);
        assert (files.size() <= 1) : "Not more than one match expected";
        return files.size() == 1 ? files.get(0) : null;
    }

    @Override
    public AnalyzerConfigurationFile getAnalyzerConfigurationFile(IAnalyzerId id) {
        assert (id != null) : "Parameter 'id' of method 'getAnalyzerConfigurationFile' must not be null";
        Analyzers analyzers = this.getSoftwareSystem().getUniqueExistingChild(Files.class).getAnalyzers();
        return this.getAnalyzerConfigurationFile(analyzers, AnalyzerConfigurationFile.getName(analyzers, id));
    }

    private boolean processAvailableAnalyzerId(IConfigurableAnalyzerId analyzerId) {
        assert (analyzerId != null) : "Parameter 'analyzerId' of method 'processAvailableAnalyzerId' must not be null";
        if (this.isAnalyzerLicensed(analyzerId)) {
            this.m_licensedAnalyzerIds.add(analyzerId);
            return true;
        }
        this.m_notLicensedAnalyzerIds.add(analyzerId);
        return false;
    }

    @Override
    public void finishSoftwareSystemInitialization(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'finishSoftwareSystemInitialization' must not be null";
        THashSet availableCoreAnalyzerIds = new THashSet(Arrays.asList(CoreAnalyzerId.values()));
        availableCoreAnalyzerIds.forEach(id -> {
            boolean bl = this.processAvailableAnalyzerId((IConfigurableAnalyzerId)id);
        });
        for (LanguageProvider nextLanguageProvider : this.getLanguageProviderAccessor().getAvailableLanguageProviders()) {
            nextLanguageProvider.getAnalyzerIds().forEach(id -> {
                boolean bl = this.processAvailableAnalyzerId((IConfigurableAnalyzerId)id);
            });
        }
        Set<IConfigurableAnalyzerId> created = this.createAnalyzers(this.getSoftwareSystem().getUniqueExistingChild(Files.class).getAnalyzers(), (Set<? extends IConfigurableAnalyzerId>)availableCoreAnalyzerIds);
        this.addAdapterIfCreated(created, SizeMetricsAdapter.ID, () -> new SizeMetricsAdapter(this));
        this.addAdapterIfCreated(created, ThresholdAnalyzerAdapter.ID, () -> new ThresholdAnalyzerAdapter(this));
        this.addAdapterIfCreated(created, CodeOrganizationAnalyzerAdapter.ID, () -> new CodeOrganizationAnalyzerAdapter(this));
        this.addAdapterIfCreated(created, ArchitectureCheckAnalyzerAdapter.ID, () -> new ArchitectureCheckAnalyzerAdapter(this));
        this.addAdapterIfCreated(created, ArchitectureMetricAnalyzerAdapter.ID, () -> new ArchitectureMetricAnalyzerAdapter(this));
        this.addAdapterIfCreated(created, DuplicateCodeAnalyzerAdapter.ID, () -> new DuplicateCodeAnalyzerAdapter(this));
        this.addAdapterIfCreated(created, DuplicateCodeMetricsAdapter.ID, () -> new DuplicateCodeMetricsAdapter(this));
        this.addAdapterIfCreated(created, CohesionAndCouplingMetricsSystem.ID, () -> new CohesionAndCouplingMetricsSystem(this));
        this.addAdapterIfCreated(created, CohesionAndCouplingMetricsModule.ID, () -> new CohesionAndCouplingMetricsModule(this));
        this.addAdapterIfCreated(created, AverageComplexityAnalyzerAdapter.ID, () -> new AverageComplexityAnalyzerAdapter(this));
        this.addAdapterIfCreated(created, ComplexityMetricsAdapter.ID, () -> new ComplexityMetricsAdapter(this));
        this.addAdapterIfCreated(created, IncomingDependencyMetricsSystem.ID, () -> new IncomingDependencyMetricsSystem(this));
        this.addAdapterIfCreated(created, OutgoingDependencyMetricsSystem.ID, () -> new OutgoingDependencyMetricsSystem(this));
        this.addAdapterIfCreated(created, IncomingDependencyMetricsModule.ID, () -> new IncomingDependencyMetricsModule(this));
        this.addAdapterIfCreated(created, OutgoingDependencyMetricsModule.ID, () -> new OutgoingDependencyMetricsModule(this));
        this.addAdapterIfCreated(created, ModuleCyclesInSystemAnalyzer.ID, () -> new ModuleCyclesInSystemAnalyzer(this));
        this.addAdapterIfCreated(created, ComponentCyclesInSystemAnalyzer.ID, () -> new ComponentCyclesInSystemAnalyzer(this));
        this.addAdapterIfCreated(created, ComponentCyclesInSystemMetricsAnalyzerAdapter.ID, () -> new ComponentCyclesInSystemMetricsAnalyzerAdapter(this));
        this.addAdapterIfCreated(created, ComponentCyclesInModulesAnalyzerAdapter.ID, () -> new ComponentCyclesInModulesAnalyzerAdapter(this));
        this.addAdapterIfCreated(created, ComponentCyclesInModulesMetricsAnalyzerAdapter.ID, () -> new ComponentCyclesInModulesMetricsAnalyzerAdapter(this));
        this.addAdapterIfCreated(created, LogicalToplevelElementCyclesAnalyzerAdapter.ID, () -> new LogicalToplevelElementCyclesAnalyzerAdapter(this));
        this.addAdapterIfCreated(created, EntanglementAnalyzerAdapter.ID, () -> new EntanglementAnalyzerAdapter(this));
        this.addAdapterIfCreated(created, CalculateMaintainabilityLevelAnalyzerAdapter.ID, () -> new CalculateMaintainabilityLevelAnalyzerAdapter(this));
        this.addAdapterIfCreated(created, ScriptRunner.ID, () -> new ScriptRunner(this));
        this.addAdapterIfCreated(created, ScmAnalyzerAdapter.ID, () -> new ScmAnalyzerAdapter((IAnalyzerController)this, ScmManager.getInstance()));
        this.getLanguageProviderAccessor().getLanguageProviders(this.getSoftwareSystem().getUsedLanguages()).forEach(lp -> {
            boolean bl = this.addLanguage((LanguageProvider)lp, null);
        });
        this.addAdapterIfCreated(created, IssueDensityAnalyzerAdapter.ID, () -> new IssueDensityAnalyzerAdapter(this));
        this.addAdapterIfCreated(created, SystemDiffAnalyzerAdapter.ID, () -> new SystemDiffAnalyzerAdapter(this));
        this.addAdapterIfCreated(created, IssueRankingAnalyzerAdapter.ID, () -> new IssueRankingAnalyzerAdapter(this));
        this.addAdapterIfCreated(created, QualityGateAnalyzerAdapter.ID, () -> new QualityGateAnalyzerAdapter(this));
        AnalyzerAdapterUtitity.calculateAndSetAdapterDependencies(this.m_currentlyUsedAnalyzerIdToAdapter.values(), this.m_groups);
    }

    private void addAdapterIfCreated(Set<IConfigurableAnalyzerId> createdAnalyzers, IConfigurableAnalyzerId id, Supplier<AnalyzerAdapter> supplier) {
        assert (createdAnalyzers != null) : "Parameter 'createdAnalyzers' of method 'addAdapter' must not be null";
        assert (id != null) : "Parameter 'id' of method 'addAdapter' must not be null";
        assert (supplier != null) : "Parameter 'supplier' of method 'addAdapter' must not be null";
        if (createdAnalyzers.contains(id)) {
            this.addAnalyzerAdapter(supplier.get());
        }
    }

    public List<IModifiableFile> getAvailableFiles() {
        return this.getSoftwareSystem().getUniqueExistingChild(Files.class).getAnalyzers().getChildren(AnalyzerConfigurationFile.class).stream().filter(AnalyzerConfigurationFile::existsOnDisk).collect(Collectors.toList());
    }

    private AnalyzerConfiguration getAnalyzerConfiguration(String fileName) {
        for (AnalyzerAdapter adapter : this.m_currentlyUsedAnalyzerIdToAdapter.values()) {
            AnalyzerConfiguration config = adapter.getAnalyzer().getConfiguration(AnalyzerConfiguration.class);
            if (config == null || !AnalyzerConfigurationFile.getFileName(config.getAnalyzerId()).equals(fileName)) continue;
            return config;
        }
        return null;
    }

    @Override
    public void importFiles(IWorkerContext workerContext, ImportQualityModel importQualityModel, EnumSet<Modification> modifications, OperationResult result) {
        assert (importQualityModel != null) : "Parameter 'importFiles' of method 'importFiles' must not be null";
        Analyzers analyzers = this.getSoftwareSystem().getUniqueExistingChild(Files.class).getAnalyzers();
        List<ImportQualityModel.ImportQualityModelCandidate> candidates = importQualityModel.getCandidatesByFileType(CoreFileType.ANALYZER_CONFIGURATION);
        block0: for (ImportQualityModel.ImportQualityModelCandidate nextImportQualityModelCandidate : candidates) {
            if (!nextImportQualityModelCandidate.isIncluded()) continue;
            TFile contentFile = nextImportQualityModelCandidate.getModifiableFile().getFile();
            if (importQualityModel.discardCurrentContent() || !nextImportQualityModelCandidate.isAlreadyInModel()) {
                AnalyzerConfiguration nextConfiguration = this.getAnalyzerConfiguration(contentFile.getName());
                if (nextConfiguration != null) {
                    AnalyzerConfigurationFile analyzerConfigurationFile = this.getAnalyzerConfigurationFile(analyzers, contentFile.getName());
                    assert (analyzerConfigurationFile != null) : "'analyzerConfigurationFile' must not be null. Filename: " + contentFile.getName();
                    AnalyzerConfigurationPersistence persistence = new AnalyzerConfigurationPersistence(analyzerConfigurationFile);
                    OperationResult nextResult = persistence.load(nextConfiguration, contentFile);
                    if (nextResult.isSuccess()) {
                        OperationResult saveResult = AnalyzerConfigurationPersistence.save(this.getInstallation().getVersion(), nextConfiguration, analyzerConfigurationFile.getFile(), analyzerConfigurationFile.getFileId());
                        result.addMessagesFrom(saveResult);
                        if (saveResult.isSuccess()) {
                            analyzerConfigurationFile.setExistsOnDisk(true);
                            analyzerConfigurationFile.setNeedsSave(false);
                            analyzerConfigurationFile.resetTimestamp();
                        }
                        this.notifyConfigurationUpdate(workerContext, modifications == null ? AnalyzerConfigurationChangeMode.OPEN : AnalyzerConfigurationChangeMode.MODIFICATION, nextConfiguration, modifications, result);
                    }
                    result.addMessagesFrom(nextResult);
                    continue;
                }
                result.addWarning((OperationResult.IMessageCause)QualityModelMessageCause.ANALYZER_NOT_LICENSED, "'" + FileUtility.getFileNameWithoutExtension((TFile)contentFile) + "'", new Object[0]);
                continue;
            }
            if (importQualityModel.discardCurrentContent()) continue;
            ModifiableFileCandidate candidate = (ModifiableFileCandidate)nextImportQualityModelCandidate.getModifiableFile();
            for (IModifiableFile nextAvailableFile : this.getAvailableFiles()) {
                if (!nextAvailableFile.getIdentifyingPath().equals(candidate.getIdentifyingPath())) continue;
                assert (nextAvailableFile instanceof AnalyzerConfigurationFile) : "Unexpected class in method 'importFiles': " + String.valueOf(nextAvailableFile);
                this.modifyFile(workerContext, contentFile, (AnalyzerConfigurationFile)nextAvailableFile, true, modifications, result);
                continue block0;
            }
        }
    }

    @Override
    public boolean exports(IModifiableFile modifiableFile) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'exports' must not be null";
        return CoreFileType.ANALYZER_CONFIGURATION.equals(modifiableFile.getFileType());
    }

    @Override
    public String getExportBaseDirectory() {
        return "Analyzers";
    }

    @Override
    public void exportFile(IModifiableFile modifiableFile, TFile targetFile, OperationResult result) {
        assert (modifiableFile != null && modifiableFile instanceof AnalyzerConfigurationFile) : "Unexpected class in method 'exportFile': " + String.valueOf(modifiableFile);
        assert (targetFile != null) : "Parameter 'targetFile' of method 'exportFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'exportFile' must not be null";
        AnalyzerConfigurationFile analyzerFile = (AnalyzerConfigurationFile)modifiableFile;
        AnalyzerConfiguration nextConfiguration = this.getConfiguration(analyzerFile.getAnalyzerId());
        if (nextConfiguration != null) {
            result.addMessagesFrom(AnalyzerConfigurationPersistence.save(this.getInstallation().getVersion(), nextConfiguration, targetFile, analyzerFile.getFileId()));
        } else {
            try {
                modifiableFile.getFile().cp_r((File)targetFile);
            }
            catch (IOException e) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_COPY, (Throwable)e, "Failed to export file '" + modifiableFile.getIdentifyingPath() + "'", new Object[0]);
            }
        }
    }

    @Override
    public AnalyzerConfiguration getConfiguration(IAnalyzerId analyzerId) {
        assert (analyzerId != null) : "Parameter 'analyzerId' of method 'getConfiguration' must not be null";
        AnalyzerAdapter analyzerAdapter = this.m_currentlyUsedAnalyzerIdToAdapter.get(analyzerId);
        return analyzerAdapter != null ? analyzerAdapter.getAnalyzer().getConfiguration(AnalyzerConfiguration.class) : null;
    }

    @Override
    public AnalyzerConfiguration getConfigurationForEdit(IAnalyzerId analyzerId) {
        assert (analyzerId != null) : "Parameter 'analyzerId' of method 'getConfigurationForEdit' must not be null";
        AnalyzerConfiguration configuration = this.getConfiguration(analyzerId);
        return configuration != null ? configuration.copy() : null;
    }

    void notifyConfigurationUpdate(IWorkerContext workerContext, AnalyzerConfigurationChangeMode mode, AnalyzerConfiguration configuration, EnumSet<Modification> modifications, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'notifyConfigurationUpdate' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'notifyConfigurationUpdate' must not be null";
        assert (configuration != null) : "Parameter 'configuration' of method 'configurationChanged' must not be null";
        assert (result != null) : "Parameter 'result' of method 'configurationChanged' must not be null";
        this.m_finishModelProcessor.finishAnalyzerConfigurationChanged(workerContext, mode, configuration, modifications, result);
    }

    private Set<AnalyzerGroup> getGroupsAffectedBy(Set<AnalyzerGroup> groups) {
        assert (groups != null) : "Parameter 'groups' of method 'getGroupsAffectedByConfigurationChange' must not be null";
        if (groups.equals(EnumSet.of(AnalyzerGroup.QUALITY_GATE))) {
            return groups;
        }
        THashSet affectedGroups = new THashSet(groups);
        Set<IAnalyzerId> analyzerIds = this.getAnalyzerIds(groups.toArray(new AnalyzerGroup[0]));
        this.collectAffectedGroups(analyzerIds, (Set<AnalyzerGroup>)affectedGroups);
        return affectedGroups;
    }

    private Set<IAnalyzerId> getAnalyzersAffectedBy(Set<IAnalyzerId> analyzers) {
        assert (analyzers != null && analyzers.size() > 0) : "Parameter 'analyzers' of method 'getAnalyzersAffectedBy' must not be empty";
        if (analyzers.size() == 1 && analyzers.contains(CoreAnalyzerId.QUALITY_GATES)) {
            return analyzers;
        }
        THashSet affectedAnalyzers = new THashSet(analyzers);
        THashSet affectedGroups = new THashSet();
        analyzers.forEach(arg_0 -> AnalyzerExtension.lambda$37((Set)affectedGroups, arg_0));
        this.collectAffectedGroups((Set<IAnalyzerId>)affectedAnalyzers, (Set<AnalyzerGroup>)affectedGroups);
        return affectedAnalyzers;
    }

    private void collectAffectedGroups(Set<IAnalyzerId> analyzers, Set<AnalyzerGroup> groups) {
        assert (analyzers != null) : "Parameter 'analyzers' of method 'collectAffectedGroups' must not be null";
        assert (groups != null) : "Parameter 'groups' of method 'collectAffectedGroups' must not be null";
        THashSet dependentAnalyzerGroups = new THashSet();
        analyzers.forEach(arg_0 -> AnalyzerExtension.lambda$38((Set)dependentAnalyzerGroups, arg_0));
        dependentAnalyzerGroups.add(AnalyzerGroup.QUALITY_GATE);
        dependentAnalyzerGroups.add(AnalyzerGroup.ISSUE_RANKING);
        if (!groups.contains((Object)AnalyzerGroup.SYSTEM_DIFF) && !groups.equals(EnumSet.of(AnalyzerGroup.QUALITY_GATE))) {
            dependentAnalyzerGroups.add(AnalyzerGroup.SYSTEM_DIFF);
        }
        if (!(groups.contains((Object)AnalyzerGroup.ISSUE_DENSITY) || groups.equals(EnumSet.of(AnalyzerGroup.QUALITY_GATE)) || groups.equals(EnumSet.of(AnalyzerGroup.QUALITY_GATE, AnalyzerGroup.SYSTEM_DIFF)))) {
            dependentAnalyzerGroups.add(AnalyzerGroup.ISSUE_DENSITY);
        }
        dependentAnalyzerGroups.removeAll(groups);
        if (dependentAnalyzerGroups.isEmpty()) {
            return;
        }
        AnalyzerGroup[] additionalGroups = dependentAnalyzerGroups.toArray(new AnalyzerGroup[0]);
        analyzers.addAll(this.getAnalyzerIds(additionalGroups));
        groups.addAll((Collection<AnalyzerGroup>)dependentAnalyzerGroups);
        this.collectAffectedGroups(analyzers, groups);
    }

    private Set<AnalyzerGroup> getGroupsAffectedByConfigurationChange(AnalyzerConfiguration config) {
        assert (config != null) : "Parameter 'config' of method 'getGroupsAffectedByConfigurationChange' must not be null";
        THashSet affectedByConfigurationChange = new THashSet(((IConfigurableAnalyzerId)config.getAnalyzerId()).getAffectedGroups());
        return this.getGroupsAffectedBy((Set<AnalyzerGroup>)affectedByConfigurationChange);
    }

    public OperationResult applyEditedConfiguration(IWorkerContext workerContext, AnalyzerConfiguration editedConfiguration, boolean force) {
        assert (editedConfiguration != null) : "Parameter 'editedConfiguration' of method 'applyEditedConfiguration' must not be null";
        OperationResult result = new OperationResult("Apply Edited Configuration");
        String fileName = AnalyzerConfigurationFile.getFileName(editedConfiguration.getAnalyzerId());
        AnalyzerConfiguration originalConfiguration = this.getAnalyzerConfiguration(fileName);
        if (force || !originalConfiguration.getValueMap().equals(editedConfiguration.getValueMap())) {
            Set<AnalyzerGroup> allToRestart = this.cancelAndResetAnalyzerGroups(this.getGroupsAffectedByConfigurationChange(originalConfiguration), ResetMode.ALL);
            boolean persistentPropertiesChanged = !originalConfiguration.getValueMapForPersistence().equals(editedConfiguration.getValueMapForPersistence());
            originalConfiguration.apply(editedConfiguration.getValueMap());
            EnumSet<Modification> modifications = EnumSet.noneOf(Modification.class);
            this.notifyConfigurationUpdate(workerContext, AnalyzerConfigurationChangeMode.MODIFICATION, originalConfiguration, modifications, result);
            if (persistentPropertiesChanged) {
                this.configurationChanged(workerContext, editedConfiguration, modifications, result);
            } else {
                this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), modifications, result);
            }
            this.runAnalyzerGroups(allToRestart);
        }
        return result;
    }

    @Override
    public OperationResult applyEditedConfiguration(IWorkerContext workerContext, AnalyzerConfiguration editedConfiguration) {
        return this.applyEditedConfiguration(workerContext, editedConfiguration, false);
    }

    private PrepareRefreshResult.AnalyzerConfigurationModification createAnalyzerConfigurationModification(IAnalyzerId analyzerId, IModifiableFile file, PrepareRefreshResult.AdditionalFileModification modification) {
        assert (analyzerId != null && analyzerId instanceof IConfigurableAnalyzerId) : "Unexpected class in method 'createAnalyzerConfigurationModification': " + String.valueOf(analyzerId);
        assert (file != null) : "Parameter 'file' of method 'createAnalyzerConfigurationModification' must not be null";
        assert (modification != null) : "Parameter 'modification' of method 'createAnalyzerConfigurationModification' must not be null";
        LinkedHashSet<IAnalyzerId> affectedAnalyzerIds = new LinkedHashSet<IAnalyzerId>();
        for (AnalyzerGroup nextGroup : ((IConfigurableAnalyzerId)analyzerId).getAffectedGroups()) {
            affectedAnalyzerIds.addAll(this.getAnalyzerIds(nextGroup));
        }
        return new PrepareRefreshResult.AnalyzerConfigurationModification(analyzerId, file, modification, affectedAnalyzerIds);
    }

    @Override
    public void prepareRefresh(ModifiableFileDeltaDetector deltaDetector, final boolean onSystemOpen, final PrepareRefreshResult prepareRefreshResult) {
        assert (deltaDetector != null) : "Parameter 'deltaDetector' of method 'prepareRefresh' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'prepareRefresh' must not be null";
        deltaDetector.detect(new ModifiableFileDeltaDetector.IProvider(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return AnalyzerExtension.this;
            }

            @Override
            public Class<?>[] getStopClasses() {
                return new Class[]{Analyzer.class};
            }

            @Override
            public boolean exists(IModifiableFile modifiableFile) {
                if (!($assertionsDisabled || modifiableFile != null && modifiableFile instanceof AnalyzerConfigurationFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'exists': " + String.valueOf(modifiableFile)));
                }
                return !onSystemOpen ? modifiableFile.existsOnDisk() : false;
            }

            @Override
            public boolean accept(TFile file) {
                if (!$assertionsDisabled && file == null) {
                    throw new AssertionError((Object)"Parameter 'file' of method 'accept' must not be null");
                }
                return AnalyzerExtension.this.getAnalyzerConfiguration(file.getName()) != null;
            }

            @Override
            public boolean recursive() {
                return false;
            }

            @Override
            public DirectoryPath getDirectoryPath() {
                return AnalyzerExtension.this.getSoftwareSystem().getUniqueExistingChild(Files.class).getAnalyzers();
            }

            @Override
            public List<IFileType> getFileTypes() {
                return Collections.singletonList(CoreFileType.ANALYZER_CONFIGURATION);
            }

            @Override
            public String getImageResource(IFileType fileType) {
                return AnalyzerConfigurationFile.class.getSimpleName();
            }
        });
        if (!onSystemOpen) {
            deltaDetector.getDelta().visit(new ModifiableFileDelta.IVisitor(){

                @Override
                public IModifiableFileDeltaKey getKey() {
                    return AnalyzerExtension.this;
                }

                @Override
                public void visitModified(IModifiableFile modified) {
                    if (!($assertionsDisabled || modified != null && modified instanceof AnalyzerConfigurationFile)) {
                        throw new AssertionError((Object)("Unexpected class in method 'visitModified': " + String.valueOf(modified)));
                    }
                    AnalyzerConfigurationFile configurationFile = (AnalyzerConfigurationFile)modified;
                    prepareRefreshResult.addAnalyzerConfigurationModification(AnalyzerExtension.this.createAnalyzerConfigurationModification(configurationFile.getAnalyzerId(), configurationFile, PrepareRefreshResult.AdditionalFileModification.MODIFIED));
                }

                @Override
                public void visitDeleted(IModifiableFile deleted) {
                    if (!($assertionsDisabled || deleted != null && deleted instanceof AnalyzerConfigurationFile)) {
                        throw new AssertionError((Object)("Unexpected class in method 'visitDeleted': " + String.valueOf(deleted)));
                    }
                    AnalyzerConfigurationFile configurationFile = (AnalyzerConfigurationFile)deleted;
                    prepareRefreshResult.addAnalyzerConfigurationModification(AnalyzerExtension.this.createAnalyzerConfigurationModification(configurationFile.getAnalyzerId(), configurationFile, PrepareRefreshResult.AdditionalFileModification.DELETED));
                }

                @Override
                public void visitAdded(ModifiableFileCandidate added) {
                    if (!$assertionsDisabled && added == null) {
                        throw new AssertionError((Object)"Parameter 'added' of method 'visitAdded' must not be null");
                    }
                    for (IConfigurableAnalyzerId nextId : AnalyzerExtension.this.m_licensedAnalyzerIds) {
                        String nextFileName;
                        if (!nextId.hasConfiguration() || !(nextFileName = AnalyzerConfigurationFile.getFileName(nextId)).equals(added.getFile().getName())) continue;
                        prepareRefreshResult.addAnalyzerConfigurationModification(AnalyzerExtension.this.createAnalyzerConfigurationModification(nextId, added, PrepareRefreshResult.AdditionalFileModification.ADDED));
                        break;
                    }
                }
            }, false);
        }
    }

    @Override
    public void refreshFiles(final IWorkerContext workerContext, ModifiableFileDelta delta, final EnumSet<Modification> modifications, final OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'refreshFiles' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'refreshFiles' must not be null";
        delta.visit(new ModifiableFileDelta.IVisitor(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return AnalyzerExtension.this;
            }

            @Override
            public void visitModified(IModifiableFile modified) {
                if (!($assertionsDisabled || modified != null && modified instanceof AnalyzerConfigurationFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitModified': " + String.valueOf(modified)));
                }
                AnalyzerExtension.this.modifyFile(workerContext, modified.getFile(), (AnalyzerConfigurationFile)modified, false, modifications, result);
            }

            @Override
            public void visitDeleted(IModifiableFile deleted) {
                if (!($assertionsDisabled || deleted != null && deleted instanceof AnalyzerConfigurationFile)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitDeleted': " + String.valueOf(deleted)));
                }
                AnalyzerConfigurationFile configurationFile = (AnalyzerConfigurationFile)deleted;
                configurationFile.setExistsOnDisk(false);
                IAnalyzerId analyzerId = configurationFile.getAnalyzerId();
                AnalyzerConfiguration configuration = AnalyzerExtension.this.getConfiguration(analyzerId);
                if (configuration != null) {
                    configuration.reset();
                    AnalyzerExtension.this.notifyConfigurationUpdate(workerContext, modifications == null ? AnalyzerConfigurationChangeMode.OPEN : AnalyzerConfigurationChangeMode.MODIFICATION, configuration, modifications, result);
                }
            }

            @Override
            public void visitAdded(ModifiableFileCandidate added) {
                if (!$assertionsDisabled && added == null) {
                    throw new AssertionError((Object)"Parameter 'added' of method 'visitAdded' must not be null");
                }
                TFile file = added.getFile();
                for (IConfigurableAnalyzerId nextEntry : AnalyzerExtension.this.m_licensedAnalyzerIds) {
                    String nextFileName = AnalyzerConfigurationFile.getFileName(nextEntry);
                    if (!nextFileName.equals(file.getName())) continue;
                    AnalyzerConfigurationFile nextAnalyzerConfigurationFile = AnalyzerExtension.this.getAnalyzerConfigurationFile(nextEntry);
                    if (!$assertionsDisabled && nextAnalyzerConfigurationFile == null) {
                        throw new AssertionError();
                    }
                    nextAnalyzerConfigurationFile.setFile(file);
                    AnalyzerAdapter adapter = AnalyzerExtension.this.m_currentlyUsedAnalyzerIdToAdapter.get(nextEntry);
                    if (adapter == null) break;
                    AnalyzerConfiguration nextConfiguration = adapter.getAnalyzer().getConfiguration(AnalyzerConfiguration.class);
                    if (!$assertionsDisabled && nextConfiguration == null) {
                        throw new AssertionError((Object)"'nextConfiguration' of method 'loadConfigurationFile' must not be null");
                    }
                    AnalyzerConfigurationPersistence persistence = new AnalyzerConfigurationPersistence(nextAnalyzerConfigurationFile);
                    OperationResult nextResult = persistence.load(nextConfiguration, file);
                    if (nextResult.isSuccess()) {
                        AnalyzerExtension.this.notifyConfigurationUpdate(workerContext, modifications == null ? AnalyzerConfigurationChangeMode.OPEN : AnalyzerConfigurationChangeMode.MODIFICATION, nextConfiguration, modifications, result);
                    }
                    result.addMessagesFrom(nextResult);
                    break;
                }
            }
        }, true);
    }

    private void modifyFile(IWorkerContext workerContext, TFile contentFile, AnalyzerConfigurationFile modified, boolean saveToDisk, EnumSet<Modification> modifications, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'modifyFile' must not be null";
        assert (contentFile != null) : "Parameter 'contentFile' of method 'modifyFile' must not be null";
        assert (modified != null) : "Parameter 'modified' of method 'modifyFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'modifyFile' must not be null";
        IAnalyzerId analyzerId = modified.getAnalyzerId();
        if (this.isAnalyzerLicensed(analyzerId)) {
            AnalyzerConfiguration configuration = this.getConfiguration(analyzerId);
            configuration.reset();
            AnalyzerConfigurationPersistence persistence = new AnalyzerConfigurationPersistence(modified);
            OperationResult loadResult = persistence.load(configuration, contentFile);
            if (loadResult.isSuccess()) {
                modified.reloaded();
                this.notifyConfigurationUpdate(workerContext, modifications == null ? AnalyzerConfigurationChangeMode.OPEN : AnalyzerConfigurationChangeMode.MODIFICATION, configuration, modifications, result);
            }
            result.addMessagesFrom(loadResult);
            if (result.isSuccess() && saveToDisk) {
                result.addMessagesFrom(persistence.save(this.getInstallation().getVersion(), configuration));
                modified.resetTimestamp();
            }
        } else {
            modified.resetTimestamp();
        }
    }

    @Override
    public AnalyzerResult getResultFor(IAnalyzerId id) {
        assert (id != null) : "Parameter 'id' of method 'getResultFor' must not be null";
        AnalyzerAdapter adapter = this.m_currentlyUsedAnalyzerIdToAdapter.get(id);
        return adapter != null ? adapter.getAnalyzer().getResult() : null;
    }

    @Override
    public <T extends IAnalyzerAdapter> T getAnalyzerAadpter(Class<T> analyzerAadpterClass) {
        assert (analyzerAadpterClass != null) : "Parameter 'analyzerAadpterClass' of method 'getAnalyzerAadpter' must not be null";
        for (AnalyzerAdapter next : this.m_currentlyUsedAnalyzerIdToAdapter.values()) {
            if (!analyzerAadpterClass.isAssignableFrom(next.getClass())) continue;
            return (T)next;
        }
        return null;
    }

    @Override
    public List<AnalyzerResult> getResultsFor(AnalyzerGroup group) {
        assert (group != null) : "Parameter 'group' of method 'getResultsFor' must not be null";
        ArrayList<AnalyzerResult> results = new ArrayList<AnalyzerResult>();
        for (Map.Entry<IConfigurableAnalyzerId, AnalyzerAdapter> nextEntry : this.m_currentlyUsedAnalyzerIdToAdapter.entrySet()) {
            if (nextEntry.getKey().getGroup() != group) continue;
            results.add(nextEntry.getValue().getAnalyzer().getResult());
        }
        return results;
    }

    @Override
    public boolean isAnalyzerLicensed(IAnalyzerId analyzerId) {
        assert (analyzerId != null) : "Parameter 'analyzerId' of method 'isAnalyzerLicensed' must not be null";
        return this.m_finishModelProcessor.getLicenseProvider().isFeatureAvailable(analyzerId.getFeature());
    }

    private Set<IConfigurableAnalyzerId> getLicensedAnalyzers(Set<? extends IConfigurableAnalyzerId> analyzerIds) {
        assert (analyzerIds != null) : "Parameter 'analyzerIds' of method 'createAnalyzers' must not be null";
        THashSet licensed = new THashSet(analyzerIds.size());
        for (IConfigurableAnalyzerId iConfigurableAnalyzerId : analyzerIds) {
            if (!this.isAnalyzerLicensed(iConfigurableAnalyzerId)) continue;
            licensed.add(iConfigurableAnalyzerId);
        }
        return licensed;
    }

    private Set<IConfigurableAnalyzerId> createAnalyzers(Analyzers analyzers, Set<? extends IConfigurableAnalyzerId> analyzerIds) {
        assert (analyzers != null) : "Parameter 'analyzers' of method 'createAnalyzers' must not be null";
        assert (analyzerIds != null) : "Parameter 'analyzerIds' of method 'createAnalyzers' must not be null";
        THashSet result = new THashSet();
        for (IConfigurableAnalyzerId nextAnalyzerId : this.getLicensedAnalyzers(analyzerIds)) {
            Analyzer nextAnalyzer = new Analyzer(analyzers, nextAnalyzerId);
            result.add(nextAnalyzerId);
            analyzers.addChild(nextAnalyzer);
            AnalyzerConfiguration nextConfiguration = nextAnalyzerId.getConfigurationCreator().create(nextAnalyzer, nextAnalyzerId);
            if (nextConfiguration == null) continue;
            nextAnalyzer.addChild(nextConfiguration);
        }
        return result;
    }

    private boolean addLanguage(LanguageProvider languageProvider, OperationResult result) {
        assert (languageProvider != null) : "Parameter 'languageProvider' of method 'languageAdded' must not be null";
        Set<IConfigurableAnalyzerId> licensed = this.createAnalyzers(this.getSoftwareSystem().getUniqueExistingChild(Files.class).getAnalyzers(), languageProvider.getAnalyzerIds());
        boolean analyzerDependenciesUpdateNeeded = false;
        for (AnalyzerAdapter analyzerAdapter : languageProvider.getAnalyzerAdapters(this, licensed)) {
            assert (this.isAnalyzerLicensed(analyzerAdapter.getAnalyzerId())) : "'nextAdapter' of method 'languageAdded' must be licensed: " + String.valueOf(analyzerAdapter.getAnalyzer());
            Pair<AnalyzerConfigurationFile, Boolean> added = this.addAnalyzerAdapter(analyzerAdapter);
            AnalyzerConfigurationFile created = (AnalyzerConfigurationFile)added.getFirst();
            if (result != null && created != null && created.getFile().exists()) {
                boolean success = result.isSuccess();
                AnalyzerConfigurationPersistence persistence = new AnalyzerConfigurationPersistence(created);
                OperationResult loadResult = persistence.load(this.getConfiguration(created.getAnalyzerId()), created.getFile());
                result.addMessagesFrom(loadResult);
                created.resetTimestamp();
                if (success) {
                    result.setIsSuccess(success);
                }
            }
            boolean bl = analyzerDependenciesUpdateNeeded = analyzerDependenciesUpdateNeeded || (Boolean)added.getSecond() != false;
        }
        this.m_currentlyUsedAnalyzerIdToAdapter.values().forEach(a -> a.languageAdded(languageProvider));
        return analyzerDependenciesUpdateNeeded;
    }

    void languageAdded(LanguageProvider languageProvider, OperationResult result) {
        assert (languageProvider != null) : "Parameter 'languageProvider' of method 'languageAdded' must not be null";
        if (this.addLanguage(languageProvider, result)) {
            AnalyzerAdapterUtitity.calculateAndSetAdapterDependencies(this.m_currentlyUsedAnalyzerIdToAdapter.values(), this.m_groups);
        }
    }

    void languageRemoved(LanguageProvider languageProvider) {
        assert (languageProvider != null) : "Parameter 'languageProvider' of method 'languageAdded' must not be null";
        boolean analyzerDependencyUpdateNeeded = false;
        for (IConfigurableAnalyzerId iConfigurableAnalyzerId : languageProvider.getAnalyzerIds()) {
            boolean bl = analyzerDependencyUpdateNeeded = this.removeAnalyzerAdapter(iConfigurableAnalyzerId) || analyzerDependencyUpdateNeeded;
        }
        this.m_currentlyUsedAnalyzerIdToAdapter.values().forEach(a -> a.languageRemoved(languageProvider));
        AnalyzerAdapterUtitity.finishLanguageRemoved(this.getInstallation(), languageProvider);
        if (analyzerDependencyUpdateNeeded) {
            AnalyzerAdapterUtitity.calculateAndSetAdapterDependencies(this.m_currentlyUsedAnalyzerIdToAdapter.values(), this.m_groups);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishSoftwareSystemClose(SoftwareSystem softwareSystem, boolean snapshotDeleted, OperationResult result) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'softwareSystemClosed' must not be null";
        assert (result != null) : "Parameter 'result' of method 'finishSoftwareSystemClose' must not be null";
        assert (this.m_executorService != null) : "'m_executorService' of method 'softwareSystemClosed' must not be null";
        AnalyzerExtension analyzerExtension = this;
        synchronized (analyzerExtension) {
            this.m_closed = true;
        }
        this.cancelAndResetAllAnalyzers(ResetMode.ALL, true);
        this.m_executorService.shutdownNow();
        try {
            this.m_executorService.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            this.exceptionCaught("Exception caught during cancel", e);
        }
        this.m_executorService = null;
        AnalyzerAdapterUtitity.finishSoftwareSystemClose(this.getInstallation(), softwareSystem, this, snapshotDeleted, result);
    }

    @Override
    public OperationResult save(AnalyzerConfigurationFile file) {
        Analyzers analyzers;
        assert (file != null) : "Parameter 'file' of method 'save' must not be null";
        assert (file.needsSave()) : "Does not need save: " + String.valueOf(file);
        AnalyzerConfiguration configuration = this.getConfiguration(file.getAnalyzerId());
        OperationResult result = new AnalyzerConfigurationPersistence(file).save(this.getInstallation().getVersion(), configuration);
        if (result.isSuccess()) {
            file.setNeedsSave(false);
            file.setExistsOnDisk(true);
            file.resetTimestamp();
        }
        if (!(analyzers = this.getSoftwareSystem().getUniqueExistingChild(Files.class).getAnalyzers()).correspondingFileExists()) {
            analyzers.checkExistence();
        }
        return result;
    }

    void configurationChanged(AnalyzerConfiguration configuration) {
        assert (configuration != null) : "Parameter 'configuration' of method 'configurationChanged' must not be null";
        AnalyzerConfigurationFile analyzerConfigurationFile = this.getAnalyzerConfigurationFile(configuration.getAnalyzerId());
        assert (analyzerConfigurationFile != null) : "'analyzerConfigurationFile' of method 'configurationChanged' must not be null";
        analyzerConfigurationFile.setNeedsSave(true);
    }

    void configurationChanged(IWorkerContext workerContext, AnalyzerConfiguration configuration, EnumSet<Modification> modifications, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'configurationChanged' must not be null";
        assert (configuration != null) : "Parameter 'configuration' of method 'configurationChanged' must not be null";
        assert (modifications != null) : "Parameter 'modifications' of method 'configurationChanged' must not be null";
        this.configurationChanged(configuration);
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), modifications, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForAnalyzersToComplete(IWorkerContext workerContext) {
        try {
            int controllersToWaitFor = this.m_runningControllers;
            if (workerContext != null && controllersToWaitFor > 0) {
                workerContext.beginSubTask("Waiting for analyzers to complete");
                workerContext.setNumberOfSteps(controllersToWaitFor);
            }
            AnalyzerExtension analyzerExtension = this;
            synchronized (analyzerExtension) {
                int finishedControllers = controllersToWaitFor - this.m_runningControllers;
                while (this.m_runningControllers > 0 || this.m_finishModelProcessorCalls > 0) {
                    if (workerContext != null) {
                        int localFinishedControllers = controllersToWaitFor - this.m_runningControllers;
                        if (workerContext.hasBeenCanceled()) {
                            return;
                        }
                        workerContext.working("Waiting for " + this.m_runningControllers + " analyzers to complete", false);
                        if (localFinishedControllers > finishedControllers) {
                            int diff = localFinishedControllers - finishedControllers;
                            int i = 0;
                            while (i < diff) {
                                workerContext.endStep();
                                ++i;
                            }
                            finishedControllers = localFinishedControllers;
                        }
                    }
                    this.wait(200L);
                }
                if (workerContext != null) {
                    if (finishedControllers < controllersToWaitFor) {
                        int diff = controllersToWaitFor - finishedControllers;
                        int i = 0;
                        while (i < diff) {
                            workerContext.endStep();
                            ++i;
                        }
                    }
                    if (controllersToWaitFor > 0) {
                        workerContext.endSubTask();
                    }
                }
            }
        }
        catch (InterruptedException e) {
            this.exceptionCaught("Exception caught during 'waitForAnalyzersToComplete'", e);
        }
    }

    Set<IAnalyzerId> getAnalyzerIds(AnalyzerGroup ... groups) {
        assert (groups != null) : "Parameter 'groups' of method 'getAnalyzerIds' must not be null";
        THashSet ids = new THashSet();
        AnalyzerGroup[] analyzerGroupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            AnalyzerGroup nextGroup = analyzerGroupArray[n2];
            List nextIds = this.m_groups.get((Object)nextGroup);
            if (nextIds != null) {
                ids.addAll(nextIds.stream().map(a -> a.getAnalyzerId()).collect(Collectors.toSet()));
            }
            ++n2;
        }
        return ids;
    }

    private Pair<AnalyzerConfigurationFile, Boolean> addAnalyzerAdapter(AnalyzerAdapter adapter) {
        assert (adapter != null) : "Parameter 'adapter' of method 'addAnalyzerAdapter' must not be null";
        IConfigurableAnalyzerId analyzerId = adapter.getAnalyzerId();
        boolean licensed = this.isAnalyzerLicensed(analyzerId);
        if (licensed) {
            this.m_currentlyUsedAnalyzerIdToAdapter.put(analyzerId, adapter);
            AnalyzerGroup group = adapter.getGroup();
            assert (group != null) : "Parameter 'group' of method 'addAnalyzerAdapter' must not be null";
            this.m_groups.put((Object)group, (Object)adapter);
            if (analyzerId.hasConfiguration()) {
                Files files = this.getSoftwareSystem().getUniqueExistingChild(Files.class);
                Analyzers analyzers = files.getAnalyzers();
                TFile analyzersFile = analyzers.getFile();
                AnalyzerConfigurationFile createdAnalyzerConfigurationFile = new AnalyzerConfigurationFile(analyzers, analyzerId, new TFile((File)analyzersFile, AnalyzerConfigurationFile.getFileName(analyzerId)), files);
                analyzers.addChild(createdAnalyzerConfigurationFile);
                return new Pair((Object)createdAnalyzerConfigurationFile, (Object)Boolean.TRUE);
            }
        }
        return new Pair(null, (Object)licensed);
    }

    public Set<IAnalyzerId> getAffectedAnalyzersOfPluginAnalyzers() {
        THashSet affected = new THashSet();
        if (this.m_currentlyUsedAnalyzerIdToAdapter.containsKey(CoreAnalyzerId.SCRIPT_RUNNER)) {
            affected.add(CoreAnalyzerId.SCRIPT_RUNNER);
        }
        if (this.m_currentlyUsedAnalyzerIdToAdapter.containsKey(CoreAnalyzerId.ISSUE_DENSITY)) {
            affected.add(CoreAnalyzerId.ISSUE_DENSITY);
        }
        if (this.m_currentlyUsedAnalyzerIdToAdapter.containsKey(CoreAnalyzerId.QUALITY_GATES)) {
            affected.add(CoreAnalyzerId.QUALITY_GATES);
        }
        if (this.m_currentlyUsedAnalyzerIdToAdapter.containsKey(CoreAnalyzerId.SYSTEM_DIFF)) {
            affected.add(CoreAnalyzerId.SYSTEM_DIFF);
        }
        if (this.m_currentlyUsedAnalyzerIdToAdapter.containsKey(CoreAnalyzerId.ISSUE_RANKING)) {
            affected.add(CoreAnalyzerId.ISSUE_RANKING);
        }
        return affected;
    }

    public boolean addPluginAnalyzerAdapter(PluginAnalyzerAdapter pluginAnalyzerAdapter) {
        assert (pluginAnalyzerAdapter != null) : "Parameter 'pluginAnalyzerAdapter' of method 'addPluginAnalyzerAdapter' must not be null";
        LOGGER.debug("Add plugin analyzer adapter '" + String.valueOf(pluginAnalyzerAdapter.getAnalyzerId()) + "'");
        Pair<AnalyzerConfigurationFile, Boolean> licensed = this.addAnalyzerAdapter(pluginAnalyzerAdapter);
        if (((Boolean)licensed.getSecond()).booleanValue()) {
            LOGGER.debug("Calculate and set adapter dependecies");
            AnalyzerAdapterUtitity.calculateAndSetAdapterDependencies(this.m_currentlyUsedAnalyzerIdToAdapter.values(), this.m_groups);
            return true;
        }
        LOGGER.debug("Add plugin analyzer adapter '" + String.valueOf(pluginAnalyzerAdapter.getAnalyzerId()) + "' - done");
        return false;
    }

    public boolean removePluginAnalyzerAdapter(IConfigurableAnalyzerId analyzerId) {
        assert (analyzerId != null) : "Parameter 'analyzerId' of method 'removePluginAnalyzerAdapter' must not be null";
        LOGGER.debug("Remove plugin analyzer adapter '" + String.valueOf(analyzerId) + "'");
        if (this.m_currentlyUsedAnalyzerIdToAdapter.containsKey(analyzerId) && this.removeAnalyzerAdapter(analyzerId)) {
            LOGGER.debug("Calculate and set adapter dependecies");
            AnalyzerAdapterUtitity.calculateAndSetAdapterDependencies(this.m_currentlyUsedAnalyzerIdToAdapter.values(), this.m_groups);
            return true;
        }
        LOGGER.debug("Remove plugin analyzer adapter '" + String.valueOf(analyzerId) + "' - done");
        return false;
    }

    private boolean removeAnalyzerAdapter(final IConfigurableAnalyzerId analyzerId) {
        assert (analyzerId != null) : "Parameter 'analyzerId' of method 'removeAnalyzerAdapter' must not be null";
        if (this.isAnalyzerLicensed(analyzerId)) {
            AnalyzerAdapter adapter = this.m_currentlyUsedAnalyzerIdToAdapter.remove(analyzerId);
            assert (adapter != null) : "'adapter' of method 'removeAnalyzerAdapter' must not be null";
            adapter.aboutToBeRemoved();
            AnalyzerGroup group = adapter.getGroup();
            assert (group != null) : "'group' of method 'removeAnalyzerAdapter' must not be null";
            this.m_groups.remove((Object)group, (Object)adapter);
            Analyzers analyzers = this.getSoftwareSystem().getUniqueExistingChild(Files.class).getAnalyzers();
            Analyzer foundAnalyzer = analyzers.getFirstChild(new NamedElement.IFilter(){

                @Override
                public boolean accept(NamedElement namedElement) {
                    if (!($assertionsDisabled || namedElement != null && namedElement instanceof Analyzer)) {
                        throw new AssertionError((Object)("Unexpected class in method 'accept': " + String.valueOf(namedElement)));
                    }
                    return analyzerId.equals(((Analyzer)namedElement).getId());
                }
            }, Analyzer.class);
            assert (foundAnalyzer != null) : "'foundAnalyzer' of method 'removeAnalyzerAdapter' must not be null";
            foundAnalyzer.remove();
            if (analyzerId.hasConfiguration()) {
                AnalyzerConfigurationFile foundAnalyzerConfigurationFile = analyzers.getFirstChild(new NamedElement.IFilter(){

                    @Override
                    public boolean accept(NamedElement namedElement) {
                        if (!($assertionsDisabled || namedElement != null && namedElement instanceof AnalyzerConfigurationFile)) {
                            throw new AssertionError((Object)("Unexpected class in method 'accept': " + String.valueOf(namedElement)));
                        }
                        return analyzerId.equals(((AnalyzerConfigurationFile)namedElement).getAnalyzerId());
                    }
                }, AnalyzerConfigurationFile.class);
                assert (foundAnalyzerConfigurationFile != null) : "'foundAnalyzerConfigurationFile' of method 'removeAnalyzerAdapter' must not be null";
                foundAnalyzerConfigurationFile.remove();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAnalyzerIfNeeded(AnalyzerAdapter adapter, IAnalyzerResultConsumer consumer, boolean loadResult) {
        AnalyzerState state;
        assert (adapter != null) : "Parameter 'adapter' of method 'runAnalyzerIfNeeded' must not be null";
        AnalyzerExtension analyzerExtension = this;
        synchronized (analyzerExtension) {
            assert (!this.m_closed) : "Software system already closed - runAnalyzerIfNeeded()";
        }
        if (!this.getSoftwareSystem().isClearable()) {
            return;
        }
        AnalyzerResult result = adapter.getAnalyzer().getResult();
        Object object = this;
        synchronized (object) {
            if (this.m_cancelled) {
                return;
            }
        }
        object = result;
        synchronized (object) {
            state = result.getState();
        }
        if (state == AnalyzerState.FINISHED) {
            AnalyzerExtension emitter = this;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Dispatching analyzer finished event for {}", (Object)adapter.getAnalyzerId());
            }
            EventManager.getInstance().dispatch((Object)emitter, (Event)new AnalyzerResultAvailableEvent(this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class), result, consumer != null ? consumer.getOriginator() : null));
            if (consumer != null) {
                consumer.consume(result);
            }
        } else if (this.getSoftwareSystem().isClearable()) {
            adapter.startJobsIfNotRunning(result, consumer, loadResult);
        }
    }

    @Override
    public void runAutomatedAnalyzers(IWorkerContext workerContext) {
        this.runAutomatedAnalyzers(workerContext, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runAutomatedAnalyzers(IWorkerContext workerContext, boolean loadSavedResultIfPresent) {
        AnalyzerExtension analyzerExtension = this;
        synchronized (analyzerExtension) {
            assert (!this.m_closed) : "Software system already closed - runAutomatedAnalyzers()";
        }
        if (!this.getSoftwareSystem().isClearable()) {
            return;
        }
        this.jobControllerStarted(null);
        for (AnalyzerAdapter nextAdapter : this.m_currentlyUsedAnalyzerIdToAdapter.values()) {
            this.runAnalyzerIfNeeded(nextAdapter, null, loadSavedResultIfPresent);
        }
        this.jobControllerFinished(LOGGER.isTraceEnabled() ? new Throwable() : null, null, false, false);
        if (this.m_configurationInfoProvider.getBackgroundTaskExecutionMode() == ISoftwareSystemProvider.BackgroundTaskExecutionMode.WAIT_FOR_COMPLETION) {
            this.waitForAnalyzersToComplete(workerContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AnalyzerResult getAnalyzerResult(IAnalyzerId id, boolean wait) {
        if (!this.getSoftwareSystem().isClearable()) {
            return null;
        }
        AnalyzerResult result = this.getResultFor(id);
        if (result == null) {
            return null;
        }
        AnalyzerState state = null;
        AnalyzerResult analyzerResult = result;
        synchronized (analyzerResult) {
            state = result.getState();
            if (state == AnalyzerState.FINISHED) {
                return result;
            }
            if (!wait) {
                return null;
            }
        }
        AnalyzerAdapter adapter = this.m_currentlyUsedAnalyzerIdToAdapter.get(id);
        assert (adapter != null) : "'adapter' of method 'getAnalyzerResult' must not be null";
        if (!adapter.startJobsIfNotRunning(result, null, false)) {
            return null;
        }
        AnalyzerResult analyzerResult2 = result;
        synchronized (analyzerResult2) {
            state = result.getState();
            try {
                while (state == AnalyzerState.RUNNING || state == AnalyzerState.HAS_NOT_BEEN_RUN) {
                    result.wait();
                    state = result.getState();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (state != AnalyzerState.FINISHED) return null;
        AnalyzerResult analyzerResult3 = result;
        return analyzerResult3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestAnalyzerResults(IAnalyzerResultConsumer consumer) {
        assert (consumer != null) : "Parameter 'consumer' of method 'requestAnalyzerResults' must not be null";
        AnalyzerExtension analyzerExtension = this;
        synchronized (analyzerExtension) {
            if (this.m_closed) {
                return;
            }
        }
        this.jobControllerStarted(null);
        for (IAnalyzerId id : consumer.getAnalyzerIds()) {
            assert (id != null) : "'id' of method 'requestAnalyzerResults' must not be null";
            AnalyzerAdapter adapter = this.m_currentlyUsedAnalyzerIdToAdapter.get(id);
            if (adapter == null) continue;
            this.runAnalyzerIfNeeded(adapter, consumer, false);
        }
        this.jobControllerFinished(LOGGER.isTraceEnabled() ? new Throwable() : null, null, false, false);
        if (this.m_configurationInfoProvider.getBackgroundTaskExecutionMode() == ISoftwareSystemProvider.BackgroundTaskExecutionMode.WAIT_FOR_COMPLETION) {
            this.waitForAnalyzersToComplete(null);
        }
    }

    private void resetAnalyzers(ResetMode resetMode, Collection<AnalyzerGroup> groups, Set<IAnalyzerId> forceReset, boolean onSystemClose) {
        assert (resetMode != null) : "Parameter 'resetMode' of method 'resetAnalyzers' must not be null";
        assert (forceReset != null) : "Parameter 'forceReset' of method 'resetAnalyzers' must not be null";
        ArrayList<Analyzer> reset = new ArrayList<Analyzer>();
        if (resetMode != ResetMode.CURRENTLY_RUNNING) {
            for (AnalyzerAdapter nextAnalyzerAdapter : this.m_currentlyUsedAnalyzerIdToAdapter.values()) {
                if (groups != null && !groups.contains((Object)nextAnalyzerAdapter.getGroup()) || !nextAnalyzerAdapter.reset()) continue;
                reset.add(nextAnalyzerAdapter.getAnalyzer());
            }
        }
        for (IAnalyzerId nextAnalyzerId : forceReset) {
            AnalyzerAdapter nextAnalyzerAdapter = this.m_currentlyUsedAnalyzerIdToAdapter.get(nextAnalyzerId);
            if (nextAnalyzerAdapter == null || !nextAnalyzerAdapter.reset()) continue;
            reset.add(nextAnalyzerAdapter.getAnalyzer());
        }
        THashSet resetAnalyzerIds = new THashSet();
        if (!reset.isEmpty()) {
            reset.forEach(arg_0 -> AnalyzerExtension.lambda$42((Set)resetAnalyzerIds, arg_0));
            LOGGER.debug("Reset analyzers: " + String.valueOf(resetAnalyzerIds));
            this.m_finishModelProcessor.analyzersReset((Set<IAnalyzerId>)resetAnalyzerIds);
            EventManager.getInstance().dispatch((Object)this, (Event)new AnalyzerResultClearedEvent(this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class), reset));
        }
        this.m_finishModelProcessor.finishAnalyzersReset(this.getSoftwareSystem(), (Set<IAnalyzerId>)resetAnalyzerIds, onSystemClose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changedAnalyzerExecutionLevel(AnalyzerExecutionLevel from, AnalyzerExecutionLevel to) {
        assert (from != null) : "Parameter 'from' of method 'changedAnalyzerExecutionLevel' must not be null";
        assert (to != null) : "Parameter 'to' of method 'changedAnalyzerExecutionLevel' must not be null";
        if (this.getSoftwareSystem().isClearable()) {
            boolean areAnalyzersRunning = false;
            AnalyzerExtension analyzerExtension = this;
            synchronized (analyzerExtension) {
                areAnalyzersRunning = !this.m_currentlyRunning.isEmpty();
            }
            if (areAnalyzersRunning) {
                LOGGER.debug("Change analyzer execution level '" + String.valueOf((Object)from) + "' -> '" + String.valueOf((Object)to) + "': analyzers are running => perform cancel/run all");
                this.cancelAndResetAllAnalyzers(ResetMode.ALL);
                this.runAutomatedAnalyzers(null);
            } else if (from.ordinal() > to.ordinal()) {
                LOGGER.debug("Change analyzer execution level '" + String.valueOf((Object)from) + "' -> '" + String.valueOf((Object)to) + "': analyzers are not running => run only new ones");
                ArrayList<AnalyzerAdapter> run = new ArrayList<AnalyzerAdapter>();
                for (Map.Entry<IConfigurableAnalyzerId, AnalyzerAdapter> nextEntry : this.m_currentlyUsedAnalyzerIdToAdapter.entrySet()) {
                    IConfigurableAnalyzerId nextId;
                    int nextExecutionLevelOrdinal;
                    if (!nextEntry.getValue().isEnabled() || (nextExecutionLevelOrdinal = (nextId = nextEntry.getKey()).getExecutionLevel().ordinal()) >= from.ordinal() || nextExecutionLevelOrdinal < to.ordinal()) continue;
                    LOGGER.debug("Run: " + String.valueOf(nextId));
                    run.add(nextEntry.getValue());
                }
                if (!run.isEmpty()) {
                    run.forEach(a -> this.runAnalyzerIfNeeded((AnalyzerAdapter)a, null, false));
                }
            } else assert (from.ordinal() != to.ordinal()) : "Analyzer execution levels are not different";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<IAnalyzerId> cancelAndResetAllAnalyzers(ResetMode resetMode, boolean onSystemClose) {
        assert (resetMode != null) : "Parameter 'resetMode' of method 'cancelAndResetAnalyzers' must not be null";
        Set<IAnalyzerId> cancelledCurrentlyRunning = this.cancelCurrentlyRunningAnalyzers();
        Set<IAnalyzerId> allToReset = !cancelledCurrentlyRunning.isEmpty() ? this.getAnalyzersAffectedBy(cancelledCurrentlyRunning) : cancelledCurrentlyRunning;
        LOGGER.debug("Analyzers cancelled");
        this.resetAnalyzers(resetMode, null, allToReset, onSystemClose);
        AnalyzerExtension analyzerExtension = this;
        synchronized (analyzerExtension) {
            this.m_cancelled = false;
            this.m_lastAppliedAnalyzerExecutionLevel = resetMode == ResetMode.ALL ? null : this.m_lastAppliedAnalyzerExecutionLevel;
        }
        return allToReset;
    }

    @Override
    public Set<IAnalyzerId> cancelAndResetAllAnalyzers(ResetMode resetMode) {
        assert (resetMode != null) : "Parameter 'resetMode' of method 'cancelAndResetAnalyzers' must not be null";
        return this.cancelAndResetAllAnalyzers(resetMode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IAnalyzerId> cancelAndResetAnalyzers(Set<IAnalyzerId> forceResetAnalyzerIds) {
        assert (forceResetAnalyzerIds != null) : "Parameter 'forceResetAnalyzerIds' of method 'cancelAndResetAnalyzers' must not be null";
        LOGGER.debug("AnalyzerExtension.cancelAndResetAnalyzers(resetMode, forceResetAnalyzerIds)");
        THashSet forceReset = new THashSet();
        for (IAnalyzerId nextAnalyzerId : forceResetAnalyzerIds) {
            forceReset.add(nextAnalyzerId);
        }
        forceReset.addAll(this.cancelCurrentlyRunningAnalyzers());
        Object allToReset = !forceReset.isEmpty() ? this.getAnalyzersAffectedBy((Set<IAnalyzerId>)forceReset) : forceReset;
        LOGGER.debug("Analyzers cancelled");
        this.resetAnalyzers(ResetMode.CURRENTLY_RUNNING, null, (Set<IAnalyzerId>)allToReset, false);
        AnalyzerExtension analyzerExtension = this;
        synchronized (analyzerExtension) {
            this.m_cancelled = false;
        }
        return allToReset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<AnalyzerGroup> cancelAndResetAnalyzerGroups(Set<AnalyzerGroup> groups, ResetMode resetMode) {
        assert (groups != null) : "Parameter 'groups' of method 'cancelAndResetAnalyzerGroups' must not be null";
        assert (resetMode != null) : "Parameter 'resetMode' of method 'cancelAndResetAnalyzerGroups' must not be null";
        Set<AnalyzerGroup> groupsToReset = this.getGroupsAffectedBy(groups);
        THashSet allAffectedGroups = new THashSet(groupsToReset);
        Set<IAnalyzerId> forceReset = this.cancelCurrentlyRunningAnalyzers();
        for (IAnalyzerId nextCancelled : forceReset) {
            allAffectedGroups.add(nextCancelled.getGroup());
        }
        LOGGER.debug("Analyzers {} cancelled of groups(s): {}", forceReset, (Object)allAffectedGroups);
        this.resetAnalyzers(resetMode, (Collection<AnalyzerGroup>)allAffectedGroups, forceReset, false);
        AnalyzerExtension analyzerExtension = this;
        synchronized (analyzerExtension) {
            this.m_cancelled = false;
        }
        return allAffectedGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<IAnalyzerId> cancelCurrentlyRunningAnalyzers() {
        THashSet forceReset = new THashSet();
        AnalyzerExtension analyzerExtension = this;
        synchronized (analyzerExtension) {
            this.m_cancelled = true;
            this.m_currentlyRunning.forEach(arg_0 -> AnalyzerExtension.lambda$44((Set)forceReset, arg_0));
            for (IAnalyzerJob job : this.m_currentlyRunning) {
                job.cancel();
                LOGGER.debug("Cancel: " + String.valueOf(job.getResult().getId()));
            }
            while (this.m_runningControllers > 0 || this.m_finishModelProcessorCalls > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    this.exceptionCaught("Exception caught in 'cancelAndResetAnalyzers' [2]", ex);
                }
            }
        }
        return forceReset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IAnalyzerId> runAnalyzers(Set<IAnalyzerId> toRun) {
        assert (toRun != null && !toRun.isEmpty()) : "Parameter 'toRun' of method 'runAnalyzers' must not be empty";
        AnalyzerExtension analyzerExtension = this;
        synchronized (analyzerExtension) {
            if (this.m_closed) {
                return Collections.emptySet();
            }
        }
        if (!this.getSoftwareSystem().isClearable()) {
            return Collections.emptySet();
        }
        LinkedHashSet<IAnalyzerId> jobsStartedFor = new LinkedHashSet<IAnalyzerId>(toRun.size());
        for (IAnalyzerId nextId : toRun) {
            AnalyzerAdapter analyzerAdapter = this.m_currentlyUsedAnalyzerIdToAdapter.get(nextId);
            assert (analyzerAdapter != null) : "'analyzerAdapter' of method 'runAnalyzers' must not be null";
            AnalyzerResult current = analyzerAdapter.getAnalyzer().getResult();
            if (!analyzerAdapter.startJobsIfNotRunning(current, null, false)) continue;
            jobsStartedFor.add(nextId);
        }
        if (this.m_configurationInfoProvider.getBackgroundTaskExecutionMode() == ISoftwareSystemProvider.BackgroundTaskExecutionMode.WAIT_FOR_COMPLETION) {
            this.waitForAnalyzersToComplete(null);
        }
        return jobsStartedFor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<AnalyzerGroup> runAnalyzerGroups(Collection<AnalyzerGroup> groups) {
        assert (groups != null && !groups.isEmpty()) : "Parameter 'groups' of method 'runAnalyzerGroups' must not be empty";
        AnalyzerExtension analyzerExtension = this;
        synchronized (analyzerExtension) {
            if (this.m_closed) {
                return Collections.emptySet();
            }
        }
        if (!this.getSoftwareSystem().isClearable()) {
            return Collections.emptySet();
        }
        LinkedHashSet<AnalyzerGroup> jobsStartedFor = new LinkedHashSet<AnalyzerGroup>(groups.size());
        for (AnalyzerGroup nextGroup : groups) {
            List analyzerAdapters = this.m_groups.get((Object)nextGroup);
            for (AnalyzerAdapter nextAnalyzerAdapter : analyzerAdapters) {
                AnalyzerResult current;
                if (!nextAnalyzerAdapter.startJobsIfNotRunning(current = nextAnalyzerAdapter.getAnalyzer().getResult(), null, false)) continue;
                jobsStartedFor.add(nextGroup);
            }
        }
        if (this.m_configurationInfoProvider.getBackgroundTaskExecutionMode() == ISoftwareSystemProvider.BackgroundTaskExecutionMode.WAIT_FOR_COMPLETION) {
            this.waitForAnalyzersToComplete(null);
        }
        return jobsStartedFor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean submitJob(IAnalyzerJob job, boolean dependentJob) {
        boolean cancelled;
        AnalyzerExtension analyzerExtension = this;
        synchronized (analyzerExtension) {
            cancelled = this.m_cancelled;
            if (!cancelled) {
                this.m_currentlyRunning.add(job);
            }
        }
        if (!cancelled) {
            if (dependentJob) {
                Thread thread = new Thread((Runnable)job, "Dependent Analyzer [" + job.getName() + "]");
                thread.setPriority(1);
                thread.setUncaughtExceptionHandler(this);
                thread.start();
            } else {
                assert (this.m_executorService != null) : "'m_executorService' of method 'submitJob' must not be null";
                this.m_executorService.submit(job);
            }
        }
        return !cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishedJob(IAnalyzerJob job) {
        assert (job != null) : "Parameter 'job' of method 'finishedJob' must not be null";
        AnalyzerExtension analyzerExtension = this;
        synchronized (analyzerExtension) {
            assert (this.m_currentlyRunning.contains(job)) : "Not contained in currently running jobs: " + String.valueOf(job);
            this.m_currentlyRunning.remove(job);
            if (this.m_currentlyRunning.size() == 0) {
                this.notify();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Still running analyzers: {}", (Object)this.m_currentlyRunning.stream().map(j -> j.getName()).collect(Collectors.joining(", ")));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void jobControllerStarted(IAnalyzerId id) {
        boolean notifyStart = false;
        AnalyzerExtension analyzerExtension = this;
        synchronized (analyzerExtension) {
            while (true) {
                if (!this.m_finishingAnalyzerRun) {
                    if (!this.m_analyzersAreRunning && id != null) {
                        notifyStart = true;
                        this.m_analyzersAreRunning = true;
                    }
                    ++this.m_runningControllers;
                    break;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (notifyStart) {
            this.m_lastAppliedAnalyzerExecutionLevel = this.getAnalyzerExecutionLevel();
            EventManager.getInstance().dispatch((Object)this, (Event)new AnalyzersStartedEvent(this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class)));
        }
        if (id != null) {
            LOGGER.debug(String.format("Adapter %s started, m_runningControllers=%d", id.getStandardName(), this.m_runningControllers));
            return;
        }
        LOGGER.debug(String.format("Adapter started, m_runningControllers=%d", this.m_runningControllers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jobControllerFinished(Throwable threadCreationInfo, IAnalyzerId id, boolean metricValueAdded, boolean metricDescriptorAdded) {
        boolean cancelled;
        boolean notify = false;
        boolean allDone = false;
        boolean finishedAnyAnalyzer = false;
        AnalyzerExtension analyzerExtension = this;
        synchronized (analyzerExtension) {
            cancelled = this.m_cancelled;
            if (id != null) {
                if (!this.m_closed) {
                    notify = true;
                    ++this.m_finishModelProcessorCalls;
                }
                ++this.m_finishedAnalyzerCount;
            }
            assert (this.m_runningControllers > 0) : "'m_runningControllers' in method 'jobControllerFinished' must be positive";
            if (--this.m_runningControllers == 0) {
                allDone = true;
                this.m_finishingAnalyzerRun = true;
                if (this.m_finishedAnalyzerCount > 0) {
                    finishedAnyAnalyzer = true;
                    this.m_finishedAnalyzerCount = 0;
                }
            }
        }
        if (finishedAnyAnalyzer) {
            notify = true;
        }
        if (notify) {
            if (threadCreationInfo != null) {
                this.m_finishModelProcessor.addDebugInfo("Software system state: " + String.valueOf((Object)this.getSoftwareSystem().getState()));
                this.m_finishModelProcessor.addDebugInfo("m_closed: " + this.m_closed);
                this.m_finishModelProcessor.addDebugInfo("Thread creation info [Analyzer: " + String.valueOf(id) + "]" + StringUtility.LINE_SEPARATOR + ExceptionUtility.collectAll((Throwable)threadCreationInfo));
            }
            try {
                if (!cancelled) {
                    if (allDone && this.m_analyzersAreRunning) {
                        this.m_finishModelProcessor.finishAnalyzerFinished(this.getSoftwareSystem(), id, metricValueAdded, metricDescriptorAdded, true);
                    } else if (id != null) {
                        this.m_finishModelProcessor.finishAnalyzerFinished(this.getSoftwareSystem(), id, metricValueAdded, metricDescriptorAdded, false);
                    }
                }
            }
            catch (Throwable throwable) {
                AnalyzerExtension analyzerExtension2 = this;
                synchronized (analyzerExtension2) {
                    --this.m_finishModelProcessorCalls;
                    if (this.m_finishModelProcessorCalls == 0) {
                        this.notifyAll();
                    }
                }
                throw throwable;
            }
            AnalyzerExtension analyzerExtension3 = this;
            synchronized (analyzerExtension3) {
                --this.m_finishModelProcessorCalls;
                if (this.m_finishModelProcessorCalls == 0) {
                    this.notifyAll();
                }
            }
        }
        if (allDone) {
            if (this.m_analyzersAreRunning) {
                EventManager.getInstance().dispatch((Object)this, (Event)new AnalyzersFinishedEvent(this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class)));
                this.resetAnalyzerProgress();
                LOGGER.debug("Notified about analyzers finished running");
            }
            analyzerExtension = this;
            synchronized (analyzerExtension) {
                this.m_analyzersAreRunning = false;
                this.m_finishingAnalyzerRun = false;
                this.notifyAll();
            }
            System.gc();
        }
        LOGGER.debug(String.format("Adapter %s finished, m_runningControllers=%d", id, this.m_runningControllers));
    }

    @Override
    public Thread newThread(Runnable runnable) {
        assert (runnable != null) : "Parameter 'runnable' of method 'newThread' must not be null";
        Thread thread = new Thread(runnable, "Analyzer");
        thread.setPriority(1);
        thread.setUncaughtExceptionHandler(this);
        return thread;
    }

    @Override
    public void discardFiles(IWorkerContext workerContext, EnumSet<Modification> modifications, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'discardFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'discardFiles' must not be null";
        for (IConfigurableAnalyzerId nextId : this.m_currentlyUsedAnalyzerIdToAdapter.keySet()) {
            if (!nextId.hasConfiguration()) continue;
            AnalyzerConfiguration configuration = this.getConfiguration(nextId);
            configuration.reset();
            this.notifyConfigurationUpdate(workerContext, modifications == null ? AnalyzerConfigurationChangeMode.OPEN : AnalyzerConfigurationChangeMode.MODIFICATION, configuration, modifications, result);
        }
        for (AnalyzerConfigurationFile next : this.getSoftwareSystem().getUniqueExistingChild(Files.class).getAnalyzers().getChildren(AnalyzerConfigurationFile.class)) {
            TFile nextFile = next.getFile();
            if (!nextFile.exists()) continue;
            try {
                nextFile.rm();
                next.setExistsOnDisk(false);
                next.setNeedsSave(false);
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE, (Throwable)ex);
            }
        }
    }

    @Override
    public AnalyzerConfigurationFile isDeletableAnalyzerConfigurationFile(Element element) {
        assert (element != null) : "Parameter 'element' of method 'isDeletableAnalyzerConfigurationFile' must not be null";
        if (element instanceof AnalyzerConfigurationFile && (((AnalyzerConfigurationFile)element).existsOnDisk() || ((AnalyzerConfigurationFile)element).needsSave())) {
            return (AnalyzerConfigurationFile)element;
        }
        return null;
    }

    @Override
    public OperationResult delete(IWorkerContext workerContext, AnalyzerConfigurationFile toBeDeleted) {
        assert (toBeDeleted != null) : "Parameter 'toBeDeleted' of method 'delete' must not be null";
        assert (this.isDeletableAnalyzerConfigurationFile(toBeDeleted) != null) : "Not deletable: " + String.valueOf(toBeDeleted);
        OperationResult result = new OperationResult("Delete analyzer configuration file '" + toBeDeleted.getIdentifyingPath() + "'");
        if (toBeDeleted.existsOnDisk()) {
            if (!toBeDeleted.getFile().exists()) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, "Analyzer configuration file no longer exists. Refresh of system needed.", new Object[0]);
                return result;
            }
            if (toBeDeleted.getTimestamp() != toBeDeleted.getFile().lastModified()) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, "Analyzer configuration file has been changed on disk. Refresh of system needed.", new Object[0]);
                return result;
            }
            try {
                toBeDeleted.getFile().rm();
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE, (Throwable)ex);
                return result;
            }
        }
        this.cancelAndResetAllAnalyzers(ResetMode.ALL);
        AnalyzerConfiguration configuration = this.getConfiguration(toBeDeleted.getAnalyzerId());
        assert (configuration != null) : "'configuration' of method 'delete' must not be null";
        configuration.reset();
        toBeDeleted.setExistsOnDisk(false);
        toBeDeleted.setNeedsSave(false);
        EnumSet<Modification> modifications = EnumSet.noneOf(Modification.class);
        this.notifyConfigurationUpdate(workerContext, AnalyzerConfigurationChangeMode.MODIFICATION, configuration, modifications, result);
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), modifications, result);
        this.runAutomatedAnalyzers(workerContext);
        return result;
    }

    @Override
    public Set<IAnalyzerId> getCurrentlyAvailableAnalyzerIds() {
        return Collections.unmodifiableSet(this.m_currentlyUsedAnalyzerIdToAdapter.keySet());
    }

    @Override
    public Set<IAnalyzerId> getLicensedAnalyzerIds() {
        return Collections.unmodifiableSet(this.m_licensedAnalyzerIds);
    }

    @Override
    public Set<IAnalyzerId> getUnlicensedAnalyzerIds() {
        return Collections.unmodifiableSet(this.m_notLicensedAnalyzerIds);
    }

    AnalyzerAdapter getAnalyzerAdapter(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'getAnalyzerId' must not be empty";
        String standardName = AnalyzerConfigurationFile.getAnalyzerIdStandardName(identifyingPath);
        for (Map.Entry<IConfigurableAnalyzerId, AnalyzerAdapter> next : this.m_currentlyUsedAnalyzerIdToAdapter.entrySet()) {
            if (!next.getKey().getStandardName().equals(standardName)) continue;
            return next.getValue();
        }
        return null;
    }

    @Override
    public void setQualityModelRoot(TFile qualityModel) {
        assert (qualityModel != null) : "Parameter 'qualityModel' of method 'setQualityModelRoot' must not be null";
        Files files = super.getSoftwareSystem().getUniqueExistingChild(Files.class);
        Analyzers analyzers = files.getAnalyzers();
        analyzers.setPath(new TFile((File)qualityModel, "./Analyzers"));
        for (AnalyzerConfigurationFile next : analyzers.getChildren(AnalyzerConfigurationFile.class)) {
            next.setExistsOnDisk(false);
        }
    }

    @Override
    public List<DuplicateCodeBlockIssue> getParticipatingInDuplicateCodeBlockIssues(SourceFile sourceFile) {
        SourceFileIssueParticipationInfo info;
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'getParticipatingInDuplicateCodeBlockIssues' must not be null";
        AnalyzerResult result = this.getResultFor(CoreAnalyzerId.DUPLICATE_CODE);
        if (result != null && (info = result.getFirstChild(SourceFileIssueParticipationInfo.class)) != null) {
            return info.getIssues(sourceFile);
        }
        return Collections.emptyList();
    }

    @Override
    public List<CycleGroupIssue> getParticipatingInCycleIssues(SourceFile sourceFile) {
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'getParticipatingInCycleIssues' must not be null";
        ArrayList issues = new ArrayList();
        for (AnalyzerAdapter nextAnalyzerAdapter : this.m_currentlyUsedAnalyzerIdToAdapter.values()) {
            AnalyzerResult nextResult;
            SourceFileIssueParticipationInfo nextInfo;
            if (!(nextAnalyzerAdapter instanceof CyclesAnalyzerAdapter) && !(nextAnalyzerAdapter instanceof LogicalToplevelElementCyclesAnalyzerAdapter) || (nextInfo = (nextResult = nextAnalyzerAdapter.getAnalyzer().getResult()).getFirstChild(SourceFileIssueParticipationInfo.class)) == null) continue;
            issues.addAll(nextInfo.getIssues(sourceFile));
        }
        issues.trimToSize();
        return Collections.unmodifiableList(issues);
    }

    @Override
    public TemporalCouplingModel getTemporalCouplingModel(boolean waitForResult) {
        AnalyzerResult result = this.getAnalyzerResult(CoreAnalyzerId.SCM_METRICS, waitForResult);
        if (result == null) {
            return null;
        }
        return result.getFirstChild(TemporalCouplingModel.class);
    }

    private static /* synthetic */ void lambda$37(Set set, IAnalyzerId a) {
        boolean bl = set.add(a.getGroup());
    }

    private static /* synthetic */ void lambda$38(Set set, IAnalyzerId a) {
        boolean bl = set.addAll(a.getAffectedGroups());
    }

    private static /* synthetic */ void lambda$42(Set set, Analyzer a) {
        boolean bl = set.add(a.getId());
    }

    private static /* synthetic */ void lambda$44(Set set, IAnalyzerJob cr) {
        boolean bl = set.add(cr.getResult().getId());
    }
}

