/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.settings;

import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.InstallationBasedCommand;
import com.hello2morrow.sonargraph.core.command.system.settings.ISearchPathProviderManager;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.settings.ISearchPathProvider;
import com.hello2morrow.sonargraph.core.model.system.settings.ISearchPathValidator;
import com.hello2morrow.sonargraph.core.model.system.settings.SearchPathDelta;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;

public abstract class AbstractSearchPathCommand<T extends ICommandInteraction>
extends InstallationBasedCommand<T> {
    private final ISearchPathProviderManager m_providerManager;
    private final SearchPathDelta m_delta;
    private final OperationResult m_result;

    public AbstractSearchPathCommand(ISoftwareSystemProvider provider, T interaction, ISearchPathProviderManager searchPathProvider, SearchPathDelta delta, OperationResult result) {
        super(provider, interaction);
        assert (searchPathProvider != null) : "Parameter 'searchPathProvider' of method 'AbstractSearchPathCommand' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'AbstractSearchPathCommand' must not be null";
        assert (result != null) : "Parameter 'result' of method 'AbstractSearchPathCommand' must not be null";
        this.m_providerManager = searchPathProvider;
        this.m_delta = delta;
        this.m_result = result;
    }

    protected final ISearchPathProvider getProvider() {
        return this.m_providerManager.getProvider();
    }

    protected final ISearchPathValidator getValidator() {
        return this.m_providerManager.getValidator();
    }

    protected final void checkIfPathExists(TFile dir) {
        assert (dir != null) : "Parameter 'dir' of method 'checkIfPathExists' must not be null";
        if (!dir.exists() || !dir.isDirectory()) {
            this.m_result.addError((OperationResult.IMessageCause)IOMessageCause.NOT_A_DIRECTORY, "Given path [" + String.valueOf(dir) + "] is not an existing directory", new Object[0]);
        }
    }

    protected final SearchPathDelta getDelta() {
        return this.m_delta;
    }

    public OperationResult getResult() {
        return this.m_result;
    }

    protected void checkIfPathCanBeAdded(TFile path, OperationResult result) {
        assert (path != null) : "Parameter 'path' of method 'checkIfPathCanBeAdded' must not be null";
        if (this.m_providerManager.getValidator() == null || this.m_delta.getModified() == null) {
            return;
        }
        this.m_providerManager.getValidator().validate(this.m_delta.getModified(), path, result);
    }
}

