/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.script;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IGroovyExtension;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.script.ScriptContent;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.Result;

public final class CreateGroovyScriptCommand
extends SoftwareSystemBasedCommand<ICreateGroovyScriptInteraction> {
    private GroovyScript m_groovyScript;

    public CreateGroovyScriptCommand(ISoftwareSystemProvider provider, ICreateGroovyScriptInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.CREATE_GROOVY_SCRIPT;
    }

    @Override
    public Result isEnabled() {
        Result enabled = super.isEnabled();
        if (enabled.isSuccess() && this.m_groovyScript != null) {
            enabled.addErrorMessage("Groovy script already created");
        }
        return enabled;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        CreateGroovyScriptData data = new CreateGroovyScriptData();
        if (!((ICreateGroovyScriptInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        OperationResultWithOutcome<GroovyScript> result = this.getController().getSoftwareSystem().getExtension(IGroovyExtension.class).createScript(workerContext, data.getName(), data.getBaseDirectory(), data.getScriptContent());
        ((ICreateGroovyScriptInteraction)this.getInteraction()).processCreateGroovyScriptResult((OperationResult)result);
        if (result.isSuccess()) {
            this.m_groovyScript = (GroovyScript)result.getOutcome();
        }
    }

    public GroovyScript getGroovyScript() {
        return this.m_groovyScript;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    public static final class CreateGroovyScriptData
    implements ICommandInteractionData {
        private String m_name;
        private DirectoryPath m_baseDirectory;
        private ScriptContent m_scriptContent;

        public String getName() {
            assert (this.m_name != null && this.m_name.length() > 0) : "'m_name' of method 'getName' must not be empty";
            return this.m_name;
        }

        public void setName(String name) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setName' must not be empty";
            this.m_name = name;
        }

        public DirectoryPath getBaseDirectory() {
            assert (this.m_baseDirectory != null) : "'m_baseDirectory' of method 'getBaseDirectory' must not be null";
            return this.m_baseDirectory;
        }

        public void setBaseDirectory(DirectoryPath baseDirectory) {
            assert (baseDirectory != null) : "Parameter 'baseDirectory' of method 'setBaseDirectory' must not be null";
            this.m_baseDirectory = baseDirectory;
        }

        public void setScriptContent(ScriptContent content) {
            assert (content != null) : "Parameter 'content' of method 'setContent' must not be null";
            this.m_scriptContent = content;
        }

        public ScriptContent getScriptContent() {
            assert (this.m_scriptContent != null) : "Parameter 'm_scriptContent' of method 'getScriptContent' must not be null";
            return this.m_scriptContent;
        }
    }

    public static interface ICreateGroovyScriptInteraction
    extends ICommandInteraction {
        public boolean collect(CreateGroovyScriptData var1);

        public void processCreateGroovyScriptResult(OperationResult var1);
    }
}

