/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.resolution;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.SimpleSoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IIssueExtension;
import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import java.util.List;

public final class EditResolutionCommand
extends SimpleSoftwareSystemBasedCommand {
    private final List<Resolution> m_resolutions;
    private final String m_description;
    private final String m_assignee;
    private final Priority m_priority;
    private final List<String> m_namedElementPatterns;
    private final List<Pair<String, String>> m_dependencyPatterns;

    public EditResolutionCommand(ISoftwareSystemProvider provider, SimpleSoftwareSystemBasedCommand.ISimpleCommandInteraction interaction, List<Resolution> resolutionsToEdit, String description, String assignee, Priority priority, List<String> namedElementPatterns, List<Pair<String, String>> dependencyPatterns) {
        super(provider, interaction);
        assert (resolutionsToEdit != null && !resolutionsToEdit.isEmpty()) : "Parameter 'resolutionsToEdit' of method 'ResolutionCommand' must not be empty";
        this.m_resolutions = resolutionsToEdit;
        this.m_description = description;
        this.m_assignee = assignee;
        this.m_priority = priority;
        this.m_namedElementPatterns = namedElementPatterns;
        this.m_dependencyPatterns = dependencyPatterns;
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.EDIT_RESOLUTION;
    }

    @Override
    public Result isEnabled() {
        Result enabled = super.isEnabled();
        if (enabled.isFailure()) {
            return enabled;
        }
        if (!this.getController().getSoftwareSystem().getCurrentModel().isModifiable()) {
            enabled.addErrorMessage("Virtual model not modifiable");
        }
        return enabled;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        this.getSoftwareSystem().getExtension(IIssueExtension.class).edit(workerContext, this.m_resolutions, this.m_description, this.m_assignee, this.m_priority, this.m_namedElementPatterns, this.m_dependencyPatterns);
    }
}

