/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.diff;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISystemDiffExtension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineType;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;

public final class SetBaselineCommand
extends SoftwareSystemBasedCommand<SetBaselineCommandInteraction> {
    public SetBaselineCommand(ISoftwareSystemProvider provider, SetBaselineCommandInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.SET_BASELINE;
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL;
    }

    @Override
    protected boolean isUndoable() {
        return false;
    }

    @Override
    public boolean providesProgress() {
        return true;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        SetBaselineInteractionData data;
        SetBaselineCommandInteraction interaction = (SetBaselineCommandInteraction)this.getInteraction();
        if (!interaction.collect(data = new SetBaselineInteractionData())) {
            return;
        }
        OperationResult result = this.getController().getSoftwareSystem().getExtension(ISystemDiffExtension.class).setBaseline(workerContext, data.getBaselineType(), data.getBaselineReport());
        interaction.processResult(result);
    }

    public static interface SetBaselineCommandInteraction
    extends ICommandInteraction {
        public boolean collect(SetBaselineInteractionData var1);

        public void processResult(OperationResult var1);
    }

    public static final class SetBaselineInteractionData
    implements ICommandInteractionData {
        private TFile m_baselineReport;
        private BaselineType m_baselineType;

        SetBaselineInteractionData() {
        }

        public void setData(BaselineType baselineType, TFile baselineReport) {
            assert (baselineReport != null) : "Parameter 'baselineReport' of method 'setData' must not be null";
            assert (baselineType != null) : "Parameter 'baselineType' of method 'setData' must not be null";
            this.m_baselineReport = baselineReport;
            this.m_baselineType = baselineType;
        }

        TFile getBaselineReport() {
            assert (this.m_baselineReport != null) : "'m_baselineReport' of method 'getBaselineReport' must not be null";
            return this.m_baselineReport;
        }

        BaselineType getBaselineType() {
            assert (this.m_baselineType != null) : "'m_baselineType' of method 'getBaselineType' must not be null";
            return this.m_baselineType;
        }
    }
}

