/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.base;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISoftwareSystemController;
import com.hello2morrow.sonargraph.core.model.common.SonargraphCategory;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.event.ExceptionEvent;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.core.model.transaction.TransactionType;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public abstract class SonargraphCommand
extends Command {
    private final ISoftwareSystemController m_controller;

    public static final boolean isAvailable(SonargraphCategory category, SoftwareSystemMode inMode) {
        assert (category != null) : "Parameter 'category' of method 'isAvailable' must not be null";
        assert (inMode != null) : "Parameter 'inMode' of method 'isAvailable' must not be null";
        switch (inMode) {
            case SYSTEM: {
                return true;
            }
            case SYSTEM_ATTACHED_TO_SNAPSHOT: 
            case SYSTEM_EXTRACTED_AND_ATTACHED_TO_SNAPSHOT: {
                return category != SonargraphCategory.SYSTEM_WORKSPACE_MODIFICATION && category != SonargraphCategory.SYSTEM_PARSER_MODEL_MODIFICATION && category != SonargraphCategory.SNAPSHOT_CREATION;
            }
            case SYSTEM_LOADED_FROM_SNAPSHOT: {
                return category != SonargraphCategory.SYSTEM_MODIFICATION && category != SonargraphCategory.SYSTEM_WORKSPACE_MODIFICATION && category != SonargraphCategory.SYSTEM_PARSER_MODEL_MODIFICATION && category != SonargraphCategory.SNAPSHOT_CREATION && category != SonargraphCategory.SNAPSHOT_ATTACHMENT;
            }
        }
        assert (false) : "Unhandled mode: " + String.valueOf((Object)inMode);
        return false;
    }

    public static final boolean isAvailable(SonargraphCategory category, SoftwareSystem softwareSystem) {
        assert (category != null) : "Parameter 'category' of method 'isAvailable' must not be null";
        if (CommandRegistry.getInstance().isCategoryAvailable(category)) {
            if (softwareSystem != null) {
                return SonargraphCommand.isAvailable(category, softwareSystem.getMode());
            }
            return true;
        }
        return false;
    }

    public static final boolean isAvailable(ICommandId commandId, SoftwareSystem softwareSystem) {
        assert (commandId != null) : "Parameter 'commandId' of method 'isAvailable' must not be null";
        if (CommandRegistry.getInstance().isCommandLicensed(commandId)) {
            if (softwareSystem != null) {
                return SonargraphCommand.isAvailable(commandId.getCategory(), softwareSystem.getMode());
            }
            return true;
        }
        return false;
    }

    public SonargraphCommand(ISoftwareSystemProvider provider) {
        assert (provider != null && provider instanceof ISoftwareSystemController) : "Unexpected class in method 'SonargraphCommand': " + String.valueOf(provider);
        this.m_controller = (ISoftwareSystemController)provider;
    }

    public INavigationState getNavigationState() {
        return null;
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.BLOCKING;
    }

    protected boolean invalidatesParserModel() {
        return false;
    }

    protected final ISoftwareSystemController getController() {
        return this.m_controller;
    }

    protected abstract boolean isUndoable();

    protected TransactionType getTransactionType() {
        return this.isUndoable() ? TransactionType.UNDOABLE : TransactionType.NONE;
    }

    @Override
    protected final long startTransaction() {
        return this.m_controller.getTransactionProvider().startTransaction(this.getId().getPresentationName(), this.invalidatesParserModel(), this.getNavigationState(), this.getTransactionType());
    }

    @Override
    protected final void cancelTransaction() {
        this.m_controller.getTransactionProvider().cancelTransaction();
    }

    @Override
    protected final OperationResult finishTransaction() {
        return this.m_controller.getTransactionProvider().finishTransaction(this.getId().getPresentationName());
    }

    @Override
    protected final void handle(CommandException exception) {
        assert (exception != null) : "Parameter 'exception' of method 'handle' must not be null";
        EventManager.getInstance().dispatch((Object)this, (Event)new ExceptionEvent(this.m_controller, exception));
    }

    public int hashCode() {
        return this.m_controller.hashCode() + this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SonargraphCommand other = (SonargraphCommand)obj;
        return other.m_controller == this.m_controller && this.getId().equals(other.getId());
    }

    public String toString() {
        return this.getId().toString();
    }
}

