/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitecturalViewOperationExtension;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;

public final class SplitArchitecturalViewBeforeCommand
extends ArchitecturalViewCommand<ISplitArchitecturalViewBeforeInteraction> {
    public SplitArchitecturalViewBeforeCommand(ISoftwareSystemProvider provider, ISplitArchitecturalViewBeforeInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.SPLIT_ARCHITECTURAL_VIEW_BEFORE_OPERATION;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        SplitArchitecturalViewBeforeData data = new SplitArchitecturalViewBeforeData();
        if (((ISplitArchitecturalViewBeforeInteraction)this.getInteraction()).collect(data)) {
            IArchitecturalViewOperationExtension extension = this.getController().getSoftwareSystem().getExtension(IArchitecturalViewOperationExtension.class);
            OperationResultWithOutcome<ArchitecturalViewFile> result = extension.splitBeforeOperation(workerContext, data.getName(), data.getDescription(), data.getOperation(), data.getSplit());
            ((ISplitArchitecturalViewBeforeInteraction)this.getInteraction()).processSplitArchitecturalViewResult(result);
        }
    }

    public static interface ISplitArchitecturalViewBeforeInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(SplitArchitecturalViewBeforeData var1);

        public void processSplitArchitecturalViewResult(OperationResultWithOutcome<ArchitecturalViewFile> var1);
    }

    public static final class SplitArchitecturalViewBeforeData
    implements IArchitecturalViewCommandInteractionData {
        private String m_name;
        private String m_description = "";
        private ArchitecturalViewOperation m_operation;
        private ArchitecturalViewFile m_split;

        SplitArchitecturalViewBeforeData() {
        }

        final String getName() {
            assert (this.m_name != null && this.m_name.length() > 0) : "Parameter 'm_name' of method 'getName' must not be empty";
            return this.m_name;
        }

        public final void setName(String name) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setName' must not be empty";
            this.m_name = name;
        }

        final String getDescription() {
            assert (this.m_description != null) : "'m_description' of method 'getDescription' must not be null";
            return this.m_description;
        }

        public final void setDescription(String description) {
            assert (description != null) : "Parameter 'description' of method 'setDescription' must not be null";
            this.m_description = description;
        }

        public void setOperation(ArchitecturalViewOperation operation) {
            assert (operation != null) : "Parameter 'operation' of method 'setOperation' must not be null";
            this.m_operation = operation;
        }

        ArchitecturalViewOperation getOperation() {
            assert (this.m_operation != null) : "'m_operation' of method 'getOperation' must not be null";
            return this.m_operation;
        }

        public void setSplit(ArchitecturalViewFile split) {
            assert (split != null) : "Parameter 'split' of method 'setSplit' must not be null";
            this.m_split = split;
        }

        final ArchitecturalViewFile getSplit() {
            assert (this.m_split != null) : "'m_split' of method 'getSplit' must not be null";
            return this.m_split;
        }
    }
}

