/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewRepresentationData;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitecturalViewExtension;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewMetrics;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CalculateMetricsCommand
extends ArchitecturalViewCommand<IInteraction> {
    private ExplorationViewMetrics m_metrics;

    public CalculateMetricsCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.CALCULATE_EXPLORATION_VIEW_METRICS;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.NONE;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        Data data = new Data();
        if (((IInteraction)this.getInteraction()).collect(data)) {
            this.m_metrics = this.getSoftwareSystem().getExtension(IArchitecturalViewExtension.class).calculateMetrics(workerContext, data.getElements());
        }
    }

    public ExplorationViewMetrics getMetrics() {
        return this.m_metrics;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    public static final class Data
    extends ArchitecturalViewRepresentationData {
        private List<Element> m_elements;

        Data() {
        }

        public void setData(List<Element> elements) {
            assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'setData' must not be empty";
            this.m_elements = new ArrayList<Element>(elements);
        }

        List<Element> getElements() {
            assert (this.m_elements != null && !this.m_elements.isEmpty()) : "'m_elements' of method 'getElements' must not be empty";
            return Collections.unmodifiableList(this.m_elements);
        }
    }

    public static interface IInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(Data var1);
    }
}

