/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IVirtualModelExtension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SetModelCommand
extends SoftwareSystemBasedCommand<ISetModelInteraction> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetModelCommand.class);

    public SetModelCommand(ISoftwareSystemProvider provider, ISetModelInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.SET_MODEL;
    }

    @Override
    public boolean providesProgress() {
        return true;
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL;
    }

    @Override
    protected boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        SetModelData data = new SetModelData();
        if (((ISetModelInteraction)this.getInteraction()).collect(data)) {
            VirtualModel currentModel = this.getController().getSoftwareSystem().getCurrentModel();
            if (currentModel == data.getModel()) {
                if (LOGGER.isDebugEnabled()) assert (false) : "Virtual Model '" + currentModel.getName() + "' is already active!";
                LOGGER.error("Trying to switch to the already active virtual model {}", (Object)data.getModel().getName());
                return;
            }
            OperationResult result = this.getController().getSoftwareSystem().getExtension(IVirtualModelExtension.class).setVirtualModel(workerContext, data.getModel());
            ((ISetModelInteraction)this.getInteraction()).processSetModelResult(result);
        }
    }

    public static interface ISetModelInteraction
    extends ICommandInteraction {
        public boolean collect(SetModelData var1);

        public void processSetModelResult(OperationResult var1);
    }

    public static final class SetModelData
    implements ICommandInteractionData {
        private VirtualModel m_model;

        public void setModel(VirtualModel model) {
            assert (model != null) : "Parameter 'model' of method 'setModel' must not be null";
            this.m_model = model;
        }

        VirtualModel getModel() {
            assert (this.m_model != null) : "'m_model' of method 'getModel' must not be null";
            return this.m_model;
        }
    }
}

