/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.SaveSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISoftwareSystemController;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;

public final class SaveSoftwareSystemAsCommand
extends SonargraphCommand {
    private final IInteraction m_interaction;

    public static ITextValidator getNameValidator(ISoftwareSystemProvider controller) {
        assert (controller != null) : "Parameter 'controller' of method 'getNameValidator' must not be null";
        return ((ISoftwareSystemController)controller).getSoftwareSystemNameValidator();
    }

    public static IPathValidator getPathValidator(ISoftwareSystemProvider controller) {
        assert (controller != null) : "Parameter 'controller' of method 'getPathValidator' must not be null";
        return ((ISoftwareSystemController)controller).getSoftwareSystemBaseDirectoryValidator();
    }

    public SaveSoftwareSystemAsCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider);
        assert (interaction != null) : "Parameter 'interaction' of method 'SaveSoftwareSystemAsCommand' must not be null";
        this.m_interaction = interaction;
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.SAVE_SOFTWARE_SYSTEM_AS;
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL;
    }

    @Override
    protected boolean isUndoable() {
        return false;
    }

    @Override
    public Result isEnabled() {
        Result enabled = new Result();
        if (!this.getController().hasSoftwareSystem()) {
            enabled.addErrorMessage("No software system opened");
        }
        return enabled;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        SaveAsData data;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        SaveSoftwareSystemCommand saveSoftwareSystemCommand = new SaveSoftwareSystemCommand((ISoftwareSystemProvider)this.getController(), this.m_interaction);
        if (saveSoftwareSystemCommand.isEnabled().isSuccess()) {
            if (!this.m_interaction.confirmSaveOnSaveAs("System contains modified files. These files will be saved immediately.\n\nDo you want to proceed?")) {
                return;
            }
            this.runPrerequisiteCommand(saveSoftwareSystemCommand, workerContext);
            if (saveSoftwareSystemCommand.canceled()) {
                return;
            }
        }
        if (!this.m_interaction.collect(data = new SaveAsData())) {
            return;
        }
        TFile targetSystemDirectory = new TFile((File)data.getDirectory(), data.getName() + ".sonargraph");
        if (targetSystemDirectory.exists() && !this.m_interaction.confirmOverwrite("System directory '" + targetSystemDirectory.getNormalizedAbsolutePath() + "' already exists!\nThe existing directory will not be emptied first, existing files are simply overwritten!\n\nDo you want to proceed?")) {
            return;
        }
        OperationResult result = this.getController().saveSoftwareSystemAs(workerContext, data.getName(), data.getDirectory());
        this.m_interaction.processSavedAsResult(result);
    }

    public static interface IInteraction
    extends SaveSoftwareSystemCommand.ISaveInteraction {
        public static final /* synthetic */ boolean $assertionsDisabled;

        public boolean collect(SaveAsData var1);

        public void processSavedAsResult(OperationResult var1);

        default public boolean confirmSaveOnSaveAs(String message) {
            assert (message != null && message.length() > 0) : "Parameter 'message' of method 'confirmSaveOnSaveAs' must not be empty";
            return true;
        }

        default public boolean confirmOverwrite(String message) {
            assert (message != null && message.length() > 0) : "Parameter 'message' of method 'confirmOverwrite' must not be empty";
            return true;
        }
    }

    public static final class SaveAsData
    implements ICommandInteractionData {
        private String m_name;
        private TFile m_directory;

        public String getName() {
            return this.m_name;
        }

        public void setName(String name) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setName' must not be empty";
            this.m_name = name;
        }

        public TFile getDirectory() {
            return this.m_directory;
        }

        public void setDirectory(TFile directory) {
            assert (directory != null) : "Parameter 'directory' of method 'setDirectory' must not be null";
            assert (directory.isDirectory()) : "Not a directory: " + String.valueOf(directory);
            this.m_directory = directory;
        }
    }
}

