/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IWorkspaceExtension;
import com.hello2morrow.sonargraph.core.model.filter.Filter;
import com.hello2morrow.sonargraph.core.model.filter.PatternType;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public abstract class CreateFilterPatternCommand
extends SoftwareSystemBasedCommand<IInteraction> {
    public CreateFilterPatternCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public final ActivityMode getActivityMode() {
        return ActivityMode.MODAL;
    }

    @Override
    protected final void internalRun(IWorkerContext workerContext) {
        Data data = new Data();
        if (!((IInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        IWorkspaceExtension workspaceExtension = this.getController().getSoftwareSystem().getExtension(IWorkspaceExtension.class);
        OperationResult createPatternResult = workspaceExtension.createPattern(workerContext, data.getType(), data.getPattern(), data.getFilter());
        ((IInteraction)this.getInteraction()).processCreateResult(createPatternResult);
    }

    public static final class Data
    implements ICommandInteractionData {
        private PatternType m_type;
        private String m_pattern;
        private Filter m_filter;

        public void setData(PatternType type, String pattern, Filter filter) {
            assert (type != null) : "Parameter 'type' of method 'setData' must not be null";
            assert (pattern != null && pattern.length() > 0) : "Parameter 'pattern' of method 'setData' must not be empty";
            assert (filter != null) : "Parameter 'filter' of method 'setData' must not be null";
            this.m_type = type;
            this.m_pattern = pattern;
            this.m_filter = filter;
        }

        PatternType getType() {
            assert (this.m_type != null) : "'m_type' of method 'getType' must not be null";
            return this.m_type;
        }

        String getPattern() {
            assert (this.m_pattern != null && this.m_pattern.length() > 0) : "'m_pattern' of method 'getPattern' must not be empty";
            return this.m_pattern;
        }

        Filter getFilter() {
            assert (this.m_filter != null) : "'m_filter' of method 'getFilter' must not be null";
            return this.m_filter;
        }
    }

    public static interface IInteraction
    extends ICommandInteraction {
        public boolean collect(Data var1);

        public void processCreateResult(OperationResult var1);
    }
}

