/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.SaveSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;

public final class CloseSoftwareSystemCommand
extends SoftwareSystemBasedCommand<ICloseInteraction> {
    private boolean m_canceled;

    public CloseSoftwareSystemCommand(ISoftwareSystemProvider provider, ICloseInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.CLOSE_SOFTWARE_SYSTEM;
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        SoftwareSystem softwareSystem;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        if (!((ICloseInteraction)this.getInteraction()).closeSoftwareSystem()) {
            this.m_canceled = true;
            return;
        }
        SaveSoftwareSystemCommand saveSoftwareSystemCommand = new SaveSoftwareSystemCommand((ISoftwareSystemProvider)this.getController(), (SaveSoftwareSystemCommand.ISaveInteraction)this.getInteraction());
        if (saveSoftwareSystemCommand.isEnabled().isSuccess()) {
            this.runPrerequisiteCommand(saveSoftwareSystemCommand, workerContext);
            if (saveSoftwareSystemCommand.canceled()) {
                this.m_canceled = true;
                return;
            }
        }
        if ((softwareSystem = this.getSoftwareSystem()).getMode() == SoftwareSystemMode.SYSTEM_EXTRACTED_AND_ATTACHED_TO_SNAPSHOT) {
            TFile saveToFile;
            CloseExtractedAndAttachedSystemData data = new CloseExtractedAndAttachedSystemData(this.getController().getPathValidatorOnExtractedAndAttachedSoftwareSystemClose(), softwareSystem.getSnapshot(), this.getController().offerSaveToOnExtractedAndAttachedSoftwareSystemClose());
            if (!((ICloseInteraction)this.getInteraction()).collectCloseExtractedAndAttachedSystemData(data)) {
                this.m_canceled = true;
                return;
            }
            TFile tFile = saveToFile = data.saveTo() ? data.saveToFile() : null;
            if (saveToFile != null && saveToFile.exists() && !((ICloseInteraction)this.getInteraction()).confirmUpdateOfExisitingSnapshot("Overwrite content of existing snapshot file '" + saveToFile.getAbsolutePath() + "' ?")) {
                this.m_canceled = true;
                return;
            }
            OperationResult prepareResult = this.getController().prepareExtractedAndAttachedSoftwareSystemClose(workerContext, saveToFile, data.delete());
            if (prepareResult.isFailure()) {
                ((ICloseInteraction)this.getInteraction()).processCloseSoftwareSystemResult(prepareResult);
                this.m_canceled = true;
                return;
            }
        }
        workerContext.working("Close", true);
        OperationResult result = this.getController().closeSoftwareSystem();
        ((ICloseInteraction)this.getInteraction()).processCloseSoftwareSystemResult(result);
    }

    public boolean canceled() {
        return this.m_canceled;
    }

    public static final class CloseExtractedAndAttachedSystemData
    implements ICommandInteractionData {
        private final IPathValidator m_pathValidator;
        private TFile m_saveToFile;
        private boolean m_saveTo;
        private boolean m_delete;

        CloseExtractedAndAttachedSystemData(IPathValidator pathValidator, TFile saveToFile, boolean saveTo) {
            assert (pathValidator != null) : "Parameter 'pathValidator' of method 'CloseExtractedAndAttachedSystenData' must not be null";
            assert (saveToFile != null) : "Parameter 'saveToFile' of method 'CloseExtractedAndAttachedSystenData' must not be null";
            this.m_pathValidator = pathValidator;
            this.m_saveTo = saveTo;
            this.m_saveToFile = saveToFile;
        }

        public IPathValidator getPathValidator() {
            return this.m_pathValidator;
        }

        public boolean saveTo() {
            return this.m_saveTo;
        }

        public void setSaveTo(boolean saveTo) {
            this.m_saveTo = saveTo;
        }

        public TFile saveToFile() {
            return this.m_saveToFile;
        }

        public void setSaveToFile(TFile saveToFile) {
            assert (saveToFile != null) : "Parameter 'saveToFile' of method 'setSaveToFile' must not be null";
            this.m_saveToFile = saveToFile;
        }

        public boolean delete() {
            return this.m_delete;
        }

        public void setDelete(boolean delete) {
            this.m_delete = delete;
        }
    }

    public static interface ICloseInteraction
    extends SaveSoftwareSystemCommand.ISaveInteraction {
        public static final /* synthetic */ boolean $assertionsDisabled;

        public boolean closeSoftwareSystem();

        default public boolean collectCloseExtractedAndAttachedSystemData(CloseExtractedAndAttachedSystemData data) {
            assert (data != null) : "Parameter 'data' of method 'collectCloseExtractedAndAttachedSystenData' must not be null";
            return true;
        }

        default public boolean confirmUpdateOfExisitingSnapshot(String message) {
            assert (message != null && message.length() > 0) : "Parameter 'message' of method 'confirmUpdateOfExisitingSnapshot' must not be empty";
            return true;
        }

        default public void processCloseSoftwareSystemResult(OperationResult result) {
            assert (result != null) : "Parameter 'result' of method 'processCloseSoftwareSystemResult' must not be null";
        }
    }
}

