/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.enterprise;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.enterprise.AbstractDownloadFromServerCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISonargraphEnterpriseExtension;
import com.hello2morrow.sonargraph.core.model.enterprise.ISonargraphEnterpriseProvider;
import com.hello2morrow.sonargraph.core.model.enterprise.SnapshotInfo;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import de.schlichtherle.truezip.file.TFile;

public class DownloadSnapshotFromServerCommand
extends AbstractDownloadFromServerCommand<SnapshotInfo> {
    public DownloadSnapshotFromServerCommand(ISoftwareSystemProvider provider, AbstractDownloadFromServerCommand.IInteraction<SnapshotInfo> interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.DOWNLOAD_SNAPSHOT;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        AbstractDownloadFromServerCommand.CommandInteractionData data = new AbstractDownloadFromServerCommand.CommandInteractionData();
        if (!this.getInteraction().collect(data)) {
            return;
        }
        ISonargraphEnterpriseExtension extension = this.getController().getInstallation().getExtension(ISonargraphEnterpriseExtension.class);
        OperationResultWithOutcome<TFile> result = extension.downloadSnapshot(workerContext, data.getRemoteSystem(), (SnapshotInfo)data.getRemoteInfo(), data.getTargetFile(), data.getInfoProvider());
        this.getInteraction().processResult(result);
    }

    public static String getSnapshotFileName(ISoftwareSystemProvider provider, TFile snapshotDirectory, String fileNameCandidate) {
        assert (provider != null) : "Parameter 'provider' of method 'getSnapshotFileName' must not be null";
        assert (snapshotDirectory != null) : "Parameter 'snapshotDirectory' of method 'getSnapshotFileName' must not be null";
        assert (fileNameCandidate != null && fileNameCandidate.length() > 0) : "Parameter 'fileNameCandidate' of method 'getSnapshotFileName' must not be empty";
        ISonargraphEnterpriseProvider extension = provider.getInstallation().getExtension(ISonargraphEnterpriseProvider.class);
        return extension.getSnapshotFileName(provider, snapshotDirectory, fileNameCandidate);
    }
}

