/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.common;

import com.hello2morrow.sonargraph.core.command.common.ActivationCodeValidator;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ProductPropertiesCause;
import com.hello2morrow.sonargraph.core.command.common.ProductProperty;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicense;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseMessageCause;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseValidator;
import com.hello2morrow.sonargraph.core.controllerinterface.common.ILicenseProvider;
import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.common.SonargraphCategory;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.common.SonargraphProduct;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.HttpConnectionCheck;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.PropertiesParser;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import com.hello2morrow.sonargraph.httpclient.model.ServerInfo;
import com.hello2morrow.sonargraph.license.controller.LicenseProvider;
import com.hello2morrow.sonargraph.license.model.LicenseServerHost;
import com.hello2morrow.sonargraph.license.model.ProductDescriptor;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SonargraphLicenseHandler
implements ILicenseProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonargraphLicenseHandler.class);
    private static final List<String> HOSTS = new ArrayList<String>(ServerInfo.HTTPS_AND_HTTP_HOSTS);
    private static final String SYSTEM_PROPERTY_SONARGRAPH_LICENSE_FILE_PATH = "sonargraph.licenseFilePath";
    private final LicenseProvider m_licenseProvider;
    private final SonargraphProduct m_product;
    private final Map<String, String> m_productProperties;
    private final Version m_productVersion;
    private final ProductDescriptor m_productDescriptor;
    private final SonargraphLicenseValidator m_validator;
    private ProxySettings m_proxySettings;
    private LicenseServerHost m_licenseServerHost;
    private SonargraphLicense m_license;
    private SonargraphLicense m_licenseInValidation;
    private boolean m_renewLicenseTicketAutomatically;
    private final ILicenseLostEventHandler m_lostLicenseEventHandler;

    public static final List<String> getHosts() {
        return Collections.unmodifiableList(HOSTS);
    }

    public static final void setLicenseServerHosts(List<String> hosts) {
        assert (hosts != null && !hosts.isEmpty()) : "Parameter 'hosts' of method 'setLicenseServerHosts' must not be empty";
        HOSTS.clear();
        HOSTS.addAll(hosts);
    }

    public static final boolean canConnectToLicenseServer(String url, ProxySettings proxySettings) {
        return HttpConnectionCheck.canConnect((String)LicenseProvider.getConnectionTestURL((String)url), (String)"OK\n", (ProxySettings)proxySettings);
    }

    protected SonargraphLicenseHandler(SonargraphProduct product, Set<Language> availableLanguages, ILicenseLostEventHandler licenseLosthandler) {
        this(product, availableLanguages, licenseLosthandler, null);
    }

    protected SonargraphLicenseHandler(SonargraphProduct product, Set<Language> availableLanguages, ILicenseLostEventHandler licenseLosthandler, String productPropertiesContent) {
        String content;
        assert (product != null) : "Parameter 'product' of method 'SonargraphLicenseHandler' must not be null";
        assert (availableLanguages != null) : "Parameter 'availableLanguages' of method 'SonargraphLicenseHandler' must not be null";
        this.m_licenseProvider = new LicenseProvider();
        this.m_product = product;
        this.m_lostLicenseEventHandler = licenseLosthandler;
        HashMap<String, Language> nameToAvailableLanguage = new HashMap<String, Language>(availableLanguages.size());
        for (Language nextLanguage : availableLanguages) {
            Language previousLanguage = nameToAvailableLanguage.put(nextLanguage.getStandardName(), nextLanguage);
            assert (previousLanguage == null) : "'previousLanguage' of method 'SonargraphLicenseProvider' must be null";
        }
        OperationResult result = new OperationResult("Read and validate product properties");
        Map productProperties = null;
        Version version = null;
        String string = content = productPropertiesContent == null ? this.getProductPropertiesContent(result) : productPropertiesContent;
        if (result.isSuccess()) {
            String versionAsString;
            assert (content != null && content.length() > 0) : "Parameter 'content' of method 'SonargraphLicenseHandler' must not be empty";
            productProperties = PropertiesParser.parse((String)content);
            this.m_licenseProvider.validate(result, productProperties);
            assert (productProperties != null);
            ProductProperty[] productPropertyArray = ProductProperty.values();
            int n = productPropertyArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProductProperty nextProductProperty = productPropertyArray[n2];
                if (!productProperties.containsKey(nextProductProperty.getStandardName())) {
                    result.addError((OperationResult.IMessageCause)ProductPropertiesCause.MISSING_PROPERTY, nextProductProperty.getStandardName(), new Object[0]);
                }
                ++n2;
            }
            if (result.isSuccess() && (version = Version.create((String)(versionAsString = (String)productProperties.get(ProductProperty.VERSION.getStandardName())))) == null) {
                result.addError((OperationResult.IMessageCause)ProductPropertiesCause.UNRECOGNIZED_VERSION, versionAsString, new Object[0]);
            }
        }
        assert (result.isSuccess()) : result.toString();
        if (result.isSuccess()) {
            this.m_productProperties = productProperties;
            this.m_productVersion = version;
            this.m_productDescriptor = new ProductDescriptor(this.m_productProperties.get(ProductProperty.LICENSOR.getStandardName()), this.m_product.getStandardName(), this.m_productProperties.get(ProductProperty.VERSION.getStandardName()), this.m_productProperties.get(ProductProperty.BUILD_DATE.getStandardName()), this.m_productProperties.get(ProductProperty.COPYRIGHT.getStandardName()), this.m_product == SonargraphProduct.SONARGRAPH_BUILD ? 2 : 1);
            this.m_validator = new SonargraphLicenseValidator(product, version, productProperties, nameToAvailableLanguage, this.m_licenseProvider);
        } else {
            LOGGER.error("Failed to initialize license handler: {}", (Object)result.toString());
            this.m_productProperties = null;
            this.m_productVersion = null;
            this.m_productDescriptor = null;
            this.m_validator = null;
        }
    }

    private String getProductPropertiesContent(OperationResult result) {
        try {
            return FileUtility.getContentFromResourceOnClassPath(this.getClass(), (String)"/Sonargraph.properties");
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)ProductPropertiesCause.FAILED_TO_READ_PROPERTIES, (Throwable)ex);
            return null;
        }
    }

    public final boolean hasBeenProperlyInitialized() {
        return this.m_productProperties != null && this.m_productVersion != null && this.m_productDescriptor != null && this.m_validator != null;
    }

    @Override
    public final SonargraphProduct getProduct() {
        return this.m_product;
    }

    public final ProductDescriptor getProductDescriptor() {
        return this.m_productDescriptor;
    }

    public final String getValue(ProductProperty property) {
        assert (this.hasBeenProperlyInitialized()) : "Not properly initialized";
        assert (property != null) : "Parameter 'property' of method 'getValue' must not be null";
        String value = this.m_productProperties.get(property.getStandardName());
        assert (value != null) : "'value' of method 'getValue' must not be null";
        return value;
    }

    @Override
    public final Version getProductVersion() {
        assert (this.hasBeenProperlyInitialized()) : "Not properly initialized";
        return this.m_productVersion;
    }

    public final void setProxySettings(ProxySettings proxySettings) {
        this.m_proxySettings = proxySettings;
    }

    public final ProxySettings getProxySettings() {
        return this.m_proxySettings != null ? this.m_proxySettings.copy() : null;
    }

    public final void setLicenseServer(LicenseServerHost licenseServer) {
        this.m_licenseServerHost = licenseServer;
    }

    private void tryLicenseTicketRenewalIfNecessaryAndPossible(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'tryLicenseTicketRenewalIfNecessaryAndPossible' must not be null";
        assert (this.m_license != null) : "'m_license' of method 'tryLicenseTicketRenewal' must not be null";
        if (this.m_license.isFloating() || !this.m_license.isValid() && this.m_renewLicenseTicketAutomatically) {
            String activationCode = this.m_license.getValue(SonargraphLicense.Property.ACTIVATION_CODE);
            String ticketId = this.m_license.getValue(SonargraphLicense.Property.TICKET_ID);
            String ticketMagic = this.m_license.getValue(SonargraphLicense.Property.TICKET_MAGIC);
            if (activationCode != null && !activationCode.isEmpty()) {
                assert (this.m_validator != null) : "'m_validator' of method 'tryLicenseTicketRenewalIfNecessaryAndPossible' must not be null";
                this.m_validator.clearUserInfo();
                this.m_license = null;
                OperationResult loadFromActivationCodeResult = this.loadLicenseFromActivationCode(activationCode, ticketId, ticketMagic);
                if (loadFromActivationCodeResult.isSuccess()) {
                    if (this.m_licenseInValidation != null && this.m_licenseInValidation.isValid()) {
                        this.installLicenseInValidation(false);
                    }
                } else {
                    result.addMessagesFrom(loadFromActivationCodeResult);
                }
            }
        }
    }

    public final void releaseLicenseTicket() {
        this.m_licenseProvider.releaseLicenseTicket();
    }

    private String getLicenseFilePath() {
        String licenseFilePath = System.getProperty(SYSTEM_PROPERTY_SONARGRAPH_LICENSE_FILE_PATH);
        if (licenseFilePath != null) {
            LOGGER.info("Loading license file from path specified via system property: {}", (Object)licenseFilePath);
            return licenseFilePath;
        }
        return CoreResourceProviderAdapter.getInstance().getSonargraphUserHomeDir().getAbsolutePath() + "/" + this.m_product.getDirectoryName() + "/" + this.m_product.getStandardName() + ".license";
    }

    private void checkLicense(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'checkLicense' must not be null";
        if (this.m_license != null) {
            if (!this.m_license.isValid()) {
                for (OperationResult next : this.m_license.getAllValidationResults()) {
                    if (!next.isFailure()) continue;
                    result.addMessagesFrom(next);
                }
                result.setIsSuccess(false);
            }
        } else {
            result.setIsSuccess(false);
        }
    }

    private void handleLicenseLost(String serverReply) {
        assert (serverReply != null && serverReply.length() > 0) : "Parameter 'serverReply' of method 'handleLicenseLost' must not be empty";
        if (this.m_lostLicenseEventHandler != null) {
            this.m_lostLicenseEventHandler.handleLicenseLostEvent(serverReply);
        }
    }

    public final boolean refetchLicense() {
        return this.m_licenseProvider.refetchLicense();
    }

    public final OperationResult initializeFromActivationCode(String activationCode) {
        assert (activationCode != null && activationCode.length() > 0) : "Parameter 'activationCode' of method 'initializeFromActivationCode' must not be empty";
        OperationResult result = new OperationResult("Initialize from activation code");
        OperationResult licenseContentResult = new OperationResult("Initialize from activation code");
        Map signedContent = this.m_licenseProvider.getLicenseContentFromActivationCode(HOSTS, this.m_licenseServerHost, this.m_proxySettings, this.m_productDescriptor, activationCode, null, null, this::handleLicenseLost, licenseContentResult);
        if (licenseContentResult.isSuccess()) {
            this.m_license = this.create(signedContent, result);
            if (result.isSuccess()) {
                assert (this.m_license != null) : "'m_license' of method 'initializeFromActivationCode' must not be null";
                this.checkLicense(result);
            }
        } else {
            result.addMessagesFrom(licenseContentResult);
            result.setIsSuccess(false);
        }
        return result;
    }

    private void initializeFromLicenseFile(String licenseFilePath, OperationResult result) {
        assert (licenseFilePath != null && licenseFilePath.length() > 0) : "Parameter 'licenseFilePath' of method 'initializeFromLicenseFile' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'initializeFromLicenseFile' must not be null";
        if (FileUtility.pathExists((String)licenseFilePath)) {
            try {
                String signedContent = FileUtility.getFileContent((TFile)new TFile(licenseFilePath));
                OperationResult initFromSignedContent = this.initializeFromSignedContent(signedContent);
                result.setIsSuccess(initFromSignedContent.isSuccess());
                result.addMessagesFrom(initFromSignedContent);
            }
            catch (IOException ioe) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, "License file '" + licenseFilePath + "' :" + String.valueOf(ioe), new Object[0]);
            }
        } else {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "License file not found: " + licenseFilePath, new Object[0]);
        }
    }

    public final OperationResult initializeFromLicenseFile(String licenseFilePath) {
        assert (licenseFilePath != null && licenseFilePath.length() > 0) : "Parameter 'licenseFilePath' of method 'initializeFromLicenseFile' must not be empty";
        OperationResult result = new OperationResult("Initialize from license file");
        this.initializeFromLicenseFile(licenseFilePath, result);
        return result;
    }

    public OperationResult initialize() {
        OperationResult result = new OperationResult("Initialize from 'default' license file location");
        String licenseFilePath = this.getLicenseFilePath();
        this.initializeFromLicenseFile(licenseFilePath, result);
        return result;
    }

    public OperationResult initializeFromDefaultLicense() {
        OperationResult result = new OperationResult("Initialize default license");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream licenseInput = this.getClass().getClassLoader().getResourceAsStream("default.license");){
                int c;
                assert (licenseInput != null) : "'licenseInput' of method 'initializeFromDefaultLicense' must not be null";
                StringBuilder sb = new StringBuilder(1024);
                while ((c = licenseInput.read()) > 0) {
                    sb.append((char)c);
                }
                OperationResult initFromSignedContent = this.initializeFromSignedContent(sb.toString());
                if (initFromSignedContent.isFailure()) {
                    result.addMessagesFrom(initFromSignedContent);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)e);
        }
        return result;
    }

    protected final OperationResult initializeFromSignedContent(String signedContent) {
        assert (signedContent != null) : "Parameter 'signedContent' of method 'initializeFromSignedContent' must not be null";
        OperationResult result = new OperationResult("Initialize from signed content");
        this.m_license = this.create(PropertiesParser.parse((String)signedContent), result);
        if (result.isSuccess()) {
            assert (this.m_license != null) : "'m_license' of method 'initialize' must not be null";
            this.tryLicenseTicketRenewalIfNecessaryAndPossible(result);
            this.checkLicense(result);
        }
        return result;
    }

    public final OperationResult loadLicenseFromActivationCode(String activationCode, String ticketId, String ticketMagic) {
        LOGGER.debug("Load license from activation code" + (String)(this.m_licenseServerHost == null ? "" : " using license server [" + String.valueOf(this.m_licenseServerHost) + "]"));
        this.m_licenseInValidation = null;
        OperationResult result = new OperationResult("Resolve activation code");
        Map signedContent = this.m_licenseProvider.getLicenseContentFromActivationCode(HOSTS, this.m_licenseServerHost, this.m_proxySettings, this.m_productDescriptor, activationCode, ticketId, ticketMagic, reply -> this.handleLicenseLost((String)reply), result);
        if (result.isSuccess()) {
            this.m_licenseInValidation = this.create(signedContent, result);
        }
        LOGGER.debug("Load license from activation code" + (String)(this.m_licenseServerHost == null ? " with result" : " using license server [" + String.valueOf(this.m_licenseServerHost) + "] with result: " + String.valueOf(result)) + " - done");
        return result;
    }

    public final OperationResult loadLicenseFromFile(TFile licenseFile) {
        assert (licenseFile != null) : "Parameter 'licenseFile' of method 'loadLicenseFromFile' must not be null";
        this.m_licenseInValidation = null;
        OperationResult result = new OperationResult("Read from license file");
        try {
            String content = FileUtility.getFileContent((TFile)licenseFile);
            Map licenseProperties = PropertiesParser.parse((String)content);
            this.m_licenseInValidation = this.create(licenseProperties, result);
        }
        catch (IOException ioe) {
            result.addError((OperationResult.IMessageCause)SonargraphLicenseMessageCause.FAILED_READING_LICENSE_FILE, (Throwable)ioe);
        }
        return result;
    }

    private SonargraphLicense create(Map<String, String> properties, OperationResult contentStructureValidationResult) {
        assert (properties != null) : "Parameter 'signedContent' of method 'create' must not be null";
        assert (contentStructureValidationResult != null) : "Parameter 'contentStructureValidationResult' of method 'create' must not be null";
        String signedContent = this.m_licenseProvider.validate(contentStructureValidationResult, properties);
        if (contentStructureValidationResult.isSuccess()) {
            assert (this.m_validator != null) : "'m_validator' of method 'create' must not be null";
            SonargraphLicense license = new SonargraphLicense(signedContent, properties, contentStructureValidationResult);
            this.m_validator.validate(license);
            return license;
        }
        return null;
    }

    public final OperationResult installLicenseInValidation(boolean forceInstall) {
        OperationResult result;
        block11: {
            assert (this.m_licenseInValidation != null) : "'m_licenseInValidation' of method 'installLicenseInValidation' must not be null";
            assert (this.m_licenseInValidation.isValid()) : "Not a valid license: " + String.valueOf(this.m_licenseInValidation);
            result = new OperationResult("Installing license");
            try {
                try {
                    String licenseFilePath = this.getLicenseFilePath();
                    FileUtility.writeFile((String)licenseFilePath, (Charset)StandardCharsets.UTF_8, (String)this.m_licenseInValidation.getSignedContent(), (boolean)false);
                    if (this.m_license == null || !this.m_license.isValid() || forceInstall) {
                        this.m_license = this.m_licenseInValidation;
                        result.addInfo((OperationResult.IMessageCause)SonargraphLicenseMessageCause.LICENSE_SUCCESSFULLY_INSTALLED);
                        break block11;
                    }
                    if (this.m_product == SonargraphProduct.SONARGRAPH_ECLIPSE) {
                        if (this.m_license.getLicensedFeaturesAndLanguages().equals(this.m_licenseInValidation.getLicensedFeaturesAndLanguages())) {
                            result.addInfo((OperationResult.IMessageCause)SonargraphLicenseMessageCause.LICENSE_SUCCESSFULLY_INSTALLED);
                        } else {
                            result.addInfo((OperationResult.IMessageCause)SonargraphLicenseMessageCause.LICENSE_SUCCESSFULLY_INSTALLED, "Please restart Eclipse for the new license to take effect!");
                        }
                        break block11;
                    }
                    result.addInfo((OperationResult.IMessageCause)SonargraphLicenseMessageCause.LICENSE_SUCCESSFULLY_INSTALLED, this.m_product.getPresentationName() + " will be restarted for the new license to take effect!");
                }
                catch (IOException ex) {
                    result.addError((OperationResult.IMessageCause)SonargraphLicenseMessageCause.FAILED_TO_INSTALL_LICENSE, (Throwable)ex);
                    this.m_licenseInValidation = null;
                }
            }
            finally {
                this.m_licenseInValidation = null;
            }
        }
        return result;
    }

    final Set<? extends ICommandId> getLicensedCommandIds(Set<? extends ICommandId> commandIds) {
        assert (commandIds != null) : "Parameter 'commandIds' of method 'addAvailableCommandIds' must not be null";
        if (!this.hasValidLicense()) {
            return Collections.emptySet();
        }
        HashSet<ICommandId> licensedCommandIds = new HashSet<ICommandId>(commandIds.size());
        EnumSet<SonargraphFeature> features = this.m_license.getFeatures();
        EnumSet<SonargraphCategory> categories = this.m_license.getCategories();
        for (ICommandId iCommandId : commandIds) {
            boolean isLanguageLicensed = false;
            if (iCommandId.getLanguage() == null) {
                LOGGER.debug("Command [" + iCommandId.getStandardName() + "] does not specify a language and is therefore available.");
                isLanguageLicensed = true;
            } else if (this.m_license.isAvailable(iCommandId.getLanguage())) {
                LOGGER.debug("Command [" + iCommandId.getStandardName() + "] is licensed for language [" + String.valueOf(iCommandId.getLanguage()) + "] and is available.");
                isLanguageLicensed = true;
            } else {
                LOGGER.debug("Language [" + String.valueOf(iCommandId.getLanguage()) + "] is not licensed, therefore command [" + iCommandId.getStandardName() + "] won't be available.");
            }
            if (!isLanguageLicensed) continue;
            if (features.contains((Object)iCommandId.getFeature()) && categories.contains((Object)iCommandId.getCategory())) {
                licensedCommandIds.add(iCommandId);
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Command [" + iCommandId.getStandardName() + "] is not licensed and won't be available.");
        }
        return licensedCommandIds;
    }

    public final boolean hasLicense() {
        return this.m_license != null;
    }

    public final SonargraphLicense getLicense() {
        assert (this.hasLicense()) : "No license";
        return this.m_license;
    }

    @Override
    public final String getLicenseType() {
        String license;
        if (this.hasValidLicense() && (license = this.m_license.getValue(SonargraphLicense.Property.LICENSE)) != null) {
            return license;
        }
        return "";
    }

    @Override
    public final void addAdditionalLicenseInfo(OperationResult.IMessageCause info, String message) {
        assert (this.hasLicense()) : "No license available";
        this.m_license.addAdditionalInfo(info, message);
    }

    @Override
    public final void resetAdditionalLicenseInfo() {
        this.m_license.resetAdditionalInfo();
    }

    public final boolean hasValidLicense() {
        return this.m_license != null && this.m_license.isValid();
    }

    public final boolean hasLicenseInValidation() {
        return this.m_licenseInValidation != null;
    }

    public final SonargraphLicense getLicenseInValidation() {
        assert (this.m_licenseInValidation != null) : "Parameter 'm_licenseInValidation' of method 'getLicenseInValidation' must not be null";
        return this.m_licenseInValidation;
    }

    @Override
    public final List<String> getUserInfo() {
        return this.m_validator != null ? this.m_validator.getUserInfo() : Collections.emptyList();
    }

    @Override
    public final boolean isLanguageAvailable(Language language) {
        assert (language != null) : "Parameter 'language' of method 'isLanguageAvailable' must not be null";
        return this.hasValidLicense() ? this.m_license.isAvailable(language) : false;
    }

    @Override
    public final int getLicensedSize(Language language) {
        assert (language != null) : "Parameter 'language' of method 'getLicensedSize' must not be null";
        return this.hasValidLicense() ? this.m_license.getLicensedSize(language) : -1;
    }

    @Override
    public final boolean isFeatureAvailable(SonargraphFeature feature) {
        assert (feature != null) : "Parameter 'feature' of method 'isFeatureAvailable' must not be null";
        return this.hasValidLicense() ? this.m_license.containsFeature(feature) : false;
    }

    public final boolean isCategoryAvailable(SonargraphCategory category) {
        assert (category != null) : "Parameter 'category' of method 'isCategoryAvailable' must not be null";
        return this.hasValidLicense() ? this.m_license.containsCategory(category) : false;
    }

    @Override
    public final EnumSet<SonargraphFeature> getAvailableFeatures() {
        return this.hasValidLicense() ? this.m_license.getFeatures() : EnumSet.noneOf(SonargraphFeature.class);
    }

    @Override
    public final EnumSet<SonargraphFeature> getUnavailableFeatures() {
        EnumSet<SonargraphFeature> unavailableFeatures = EnumSet.allOf(SonargraphFeature.class);
        unavailableFeatures.removeAll(this.getAvailableFeatures());
        return unavailableFeatures;
    }

    public final IPathValidator getFilePathValidator() {
        return new IPathValidator(){

            @Override
            public ValidationResult isValid(TFile currentInput, TFile newInput) {
                ValidationResult result = new ValidationResult(!FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
                if (newInput != null) {
                    if (!newInput.exists()) {
                        result.addError("Invalid path");
                    } else if (!FileUtility.getExtension((TFile)newInput).equals(".license")) {
                        result.addError("Invalid file extension, expected .license");
                    }
                }
                return result;
            }

            @Override
            public IPathValidator.PathType getType() {
                return IPathValidator.PathType.FILE;
            }
        };
    }

    public final ITextValidator getActivationCodeValidator() {
        return new ActivationCodeValidator(this.m_licenseProvider);
    }

    public final void setRenewLicenseTicketAutomatically(boolean renewLicenseTicketAutomatically) {
        this.m_renewLicenseTicketAutomatically = renewLicenseTicketAutomatically;
    }

    public static interface ILicenseLostEventHandler {
        public void handleLicenseLostEvent(String var1);
    }
}

