/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.common;

import com.hello2morrow.sonargraph.core.command.common.AbstractCommand;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandProvider;
import com.hello2morrow.sonargraph.core.command.common.ICommandResultConsumerForwarder;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseHandler;
import com.hello2morrow.sonargraph.core.model.common.SonargraphCategory;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.collections.FixedSizeFiFoQueue;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommandRegistry
implements ThreadFactory,
ICommandResultConsumerForwarder {
    private static final int DEFAULT_EXECUTION_DUMP_SIZE = 200;
    private static final String SONARGRAPH_EXECUTION_DUMP_SIZE_ENV_PARAMETER = "sonargraph.executionDumpSize";
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandRegistry.class);
    private static CommandRegistry s_instance;
    private final Set<ICommandId> m_licensedCommandIds = new HashSet<ICommandId>();
    private final ExecutorService m_executorService;
    private final SonargraphLicenseHandler m_licenseHandler;
    private final FixedSizeFiFoQueue<String> m_executionDump;
    private ICommandResultConsumerForwarder m_forwarder;
    private AbstractCommand m_lastCommandToBeExecuted;
    private AbstractCommand m_currentlyRunningCommand;

    private CommandRegistry(SonargraphLicenseHandler licenseHandler, List<ICommandProvider> commandProviders, int executionDumpSize) {
        assert (commandProviders != null) : "'commandProviders' must not be null";
        assert (licenseHandler != null) : "Parameter 'licenseHandler' of method 'CommandRegistry' must not be null";
        assert (executionDumpSize >= 0) : "Parameter 'executionDumpSize' must be >= 0";
        this.m_forwarder = this;
        this.m_licenseHandler = licenseHandler;
        this.m_executorService = Executors.newFixedThreadPool(1, this);
        this.m_executionDump = new FixedSizeFiFoQueue(executionDumpSize);
        for (ICommandProvider nextCommandProvider : commandProviders) {
            for (ICommandId iCommandId : this.m_licenseHandler.getLicensedCommandIds(nextCommandProvider.getCommandIds())) {
                boolean success = this.m_licensedCommandIds.add(iCommandId);
                assert (success) : "Command id already registered: " + String.valueOf(iCommandId);
            }
        }
    }

    public void setCommandResultConsumerForwarder(ICommandResultConsumerForwarder forwarder) {
        this.m_forwarder = forwarder != null ? forwarder : this;
    }

    public static boolean hasInstance() {
        return s_instance != null;
    }

    public static void createInstance(SonargraphLicenseHandler licenseHandler, List<ICommandProvider> commandProviders) {
        assert (!CommandRegistry.hasInstance()) : "Instance already created";
        int executionDumpSize = 200;
        String envParameter = System.getProperty(SONARGRAPH_EXECUTION_DUMP_SIZE_ENV_PARAMETER);
        if (envParameter != null) {
            try {
                Integer size = Integer.parseInt(envParameter);
                if (size > 0) {
                    executionDumpSize = size;
                } else {
                    LOGGER.error("Environment parameter '{}' must be a positive integer value, but is '{}'. Using default size '{}'", new Object[]{SONARGRAPH_EXECUTION_DUMP_SIZE_ENV_PARAMETER, envParameter, 200});
                }
            }
            catch (NumberFormatException ex) {
                LOGGER.error("Environment parameter '{}' must be a positive integer value, but is '{}'. Using default size '{}'", new Object[]{SONARGRAPH_EXECUTION_DUMP_SIZE_ENV_PARAMETER, envParameter, 200});
            }
        }
        s_instance = new CommandRegistry(licenseHandler, commandProviders, executionDumpSize);
    }

    public static CommandRegistry getInstance() {
        assert (CommandRegistry.hasInstance()) : "Instance not created";
        return s_instance;
    }

    public static void delete() {
        if (s_instance != null) {
            CommandRegistry.s_instance.m_executorService.shutdown();
            s_instance = null;
        }
    }

    public SonargraphLicenseHandler getLicenseHandler() {
        return this.m_licenseHandler;
    }

    private synchronized AbstractCommand getLastCommandToBeExecuted() {
        return this.m_lastCommandToBeExecuted;
    }

    private synchronized AbstractCommand getCurrentlyRunningCommand() {
        return this.m_currentlyRunningCommand;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        assert (runnable != null) : "Parameter 'runnable' of method 'newThread' must not be null";
        Thread thread = new Thread(runnable);
        thread.setName("Command Executor");
        thread.setPriority(5);
        return thread;
    }

    public boolean isFeatureAvailable(SonargraphFeature feature) {
        assert (feature != null) : "Parameter 'feature' of method 'isFeatureAvailable' must not be null";
        return this.m_licenseHandler.isFeatureAvailable(feature);
    }

    public boolean isFeatureAvailable(String featureStandardName) {
        assert (featureStandardName != null && featureStandardName.length() > 0) : "Parameter 'featureStandardName' of method 'isFeatureAvailable' must not be empty";
        try {
            SonargraphFeature feature = SonargraphFeature.fromStandardName(featureStandardName);
            return this.isFeatureAvailable(feature);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Unrecognized feature: " + featureStandardName);
            return false;
        }
    }

    public boolean isCategoryAvailable(SonargraphCategory category) {
        assert (category != null) : "Parameter 'category' of method 'isCategoryAvailable' must not be null";
        return this.m_licenseHandler.isCategoryAvailable(category);
    }

    public boolean isCommandLicensed(ICommandId commandId) {
        assert (commandId != null) : "'commandId' must not be null";
        return this.m_licensedCommandIds.contains(commandId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void runIt(IWorkerContext workerContext, final AbstractCommand command, final CommandResultConsumer consumer, final boolean isPreRequisite, boolean forwardCommandConsumption) {
        block39: {
            if (!CommandRegistry.$assertionsDisabled && workerContext == null) {
                throw new AssertionError((Object)"Parameter 'workerContext' of method 'runIt' must not be null");
            }
            if (!CommandRegistry.$assertionsDisabled && command == null) {
                throw new AssertionError((Object)"Parameter 'command' of method 'runIt' must not be null");
            }
            if (!CommandRegistry.$assertionsDisabled && consumer == null) {
                throw new AssertionError((Object)"Parameter 'consumer' of method 'runIt2' must not be null");
            }
            start = System.currentTimeMillis();
            currentThreadName = Thread.currentThread().getName();
            var10_8 = this;
            synchronized (var10_8) {
                if (command.addExecutionInfo() || CommandRegistry.LOGGER.isDebugEnabled()) {
                    msg = String.format("[%s] Thread[%s] run %scommand '%s'", new Object[]{Iso8601DateFormat.formatDateAndTime((Date)new Date()), currentThreadName, isPreRequisite != false ? "pre-requisite " : "", command});
                    if (command.addExecutionInfo()) {
                        this.m_executionDump.add((Object)msg);
                    }
                    if (CommandRegistry.LOGGER.isDebugEnabled()) {
                        CommandRegistry.LOGGER.debug(msg);
                    }
                }
                lastRunningCommand = this.m_currentlyRunningCommand;
                this.m_currentlyRunningCommand = command;
            }
            commandExecutionException = null;
            transactionFinishedResult = null;
            if (this.isCommandLicensed(command.getId())) {
                isEnabled = command.isEnabled();
                if (isEnabled.isSuccess()) {
                    block38: {
                        block40: {
                            try {
                                try {
                                    if (!isPreRequisite) {
                                        workerContext.start(command.getPresentationName(), command.getActivityMode(), command.providesProgress());
                                    }
                                    txId = command.startTransaction();
                                    if (CommandRegistry.LOGGER.isDebugEnabled()) {
                                        CommandRegistry.LOGGER.debug(String.format("Executing %scommand '%s' with transaction '%d'", new Object[]{isPreRequisite != false ? "pre-requisite " : "", command.getId(), txId}));
                                    }
                                    command.internalRun(workerContext);
                                    transactionFinishedResult = command.finishTransaction();
                                    break block38;
                                }
                                catch (Throwable t) {
                                    CommandRegistry.LOGGER.error(ExceptionUtility.collectAll((Throwable)t));
                                    commandExecutionException = new CommandException("Exception caught running " + (isPreRequisite != false ? "pre-requisite " : "") + "command: " + String.valueOf(command.getId()), t);
                                    try {
                                        command.cancelTransaction();
                                    }
                                    catch (Throwable t1) {
                                        CommandRegistry.LOGGER.error(ExceptionUtility.collectFirstAndLast((Throwable)t1));
                                    }
                                    if (!isPreRequisite) {
                                        workerContext.stop();
                                    }
                                    if (!command.addExecutionInfo() || (additionalExecutionInfo = command.getAdditionalExecutionInfo()).isEmpty()) break block39;
                                    msg = String.format("[%s] Thread[%s] %scommand '%s' ", new Object[]{Iso8601DateFormat.formatDateAndTime((Date)new Date()), currentThreadName, isPreRequisite != false ? "pre-requisite " : "", command});
                                    ** for (next : additionalExecutionInfo)
                                }
                            }
                            catch (Throwable var15_30) {
                                if (!isPreRequisite) {
                                    workerContext.stop();
                                }
                                if (!command.addExecutionInfo() || (additionalExecutionInfo = command.getAdditionalExecutionInfo()).isEmpty()) break block40;
                                msg = String.format("[%s] Thread[%s] %scommand '%s' ", new Object[]{Iso8601DateFormat.formatDateAndTime((Date)new Date()), currentThreadName, isPreRequisite != false ? "pre-requisite " : "", command});
                                ** for (next : additionalExecutionInfo)
                            }
lbl-1000:
                            // 1 sources

                            {
                                this.m_executionDump.add((Object)(msg + next));
                                continue;
lbl55:
                                // 1 sources

                                break block39;
                            }
lbl-1000:
                            // 1 sources

                            {
                                this.m_executionDump.add((Object)(msg + next));
                                continue;
                            }
                        }
                        throw var15_30;
                    }
                    if (!isPreRequisite) {
                        workerContext.stop();
                    }
                    if (command.addExecutionInfo() && !(additionalExecutionInfo = command.getAdditionalExecutionInfo()).isEmpty()) {
                        msg = String.format("[%s] Thread[%s] %scommand '%s' ", new Object[]{Iso8601DateFormat.formatDateAndTime((Date)new Date()), currentThreadName, isPreRequisite != false ? "pre-requisite " : "", command});
                        for (String next : additionalExecutionInfo) {
                            this.m_executionDump.add((Object)(msg + next));
                        }
                    }
                } else if (command.addExecutionInfo()) {
                    msg = String.format("[%s] Thread[%s] %scommand not enabled and not executed '%s': %s", new Object[]{Iso8601DateFormat.formatDateAndTime((Date)new Date()), currentThreadName, isPreRequisite != false ? "pre-requisite " : "", command, isEnabled});
                    this.m_executionDump.add((Object)msg);
                    CommandRegistry.LOGGER.warn(msg);
                }
            } else {
                msg = String.format("[%s] Thread[%s] %scommand not licensed '%s'", new Object[]{Iso8601DateFormat.formatDateAndTime((Date)new Date()), currentThreadName, isPreRequisite != false ? "pre-requisite " : "", command});
                this.m_executionDump.add((Object)msg);
                CommandRegistry.LOGGER.warn(msg);
            }
        }
        msg = String.format("[%s] Thread[%s] %scommand '%s' executed in %s ms", new Object[]{Iso8601DateFormat.formatDateAndTime((Date)new Date()), currentThreadName, isPreRequisite != false ? "pre-requisite " : "", command, System.currentTimeMillis() - start});
        if (command.addExecutionInfo()) {
            this.m_executionDump.add((Object)msg);
        }
        CommandRegistry.LOGGER.debug(msg);
        msg = this;
        synchronized (msg) {
            this.m_currentlyRunningCommand = lastRunningCommand;
            if (command.equals(this.m_lastCommandToBeExecuted)) {
                this.m_lastCommandToBeExecuted = null;
                msg = String.format("[%s] Thread[%s] Removed as last to be executed %scommand '%s'", new Object[]{Iso8601DateFormat.formatDateAndTime((Date)new Date()), currentThreadName, isPreRequisite != false ? "pre-requisite " : "", command});
                if (command.addExecutionInfo()) {
                    this.m_executionDump.add((Object)msg);
                }
                CommandRegistry.LOGGER.debug(msg);
            }
        }
        if (commandExecutionException != null) {
            command.handle(commandExecutionException);
        }
        useCommandExecutionException = commandExecutionException;
        if (forwardCommandConsumption) {
            this.m_forwarder.runCommandResultConsumption(transactionFinishedResult, new Runnable(){

                @Override
                public void run() {
                    String msg = String.format("Thread[%s] Running consume for %scommand '%s'", currentThreadName, isPreRequisite ? "pre-requisite " : "", command);
                    LOGGER.debug(msg);
                    consumer.consume(useCommandExecutionException);
                }

                public String toString() {
                    return command.getId().toString();
                }
            });
        } else {
            message = String.format("Thread[%s] Running consume for %scommand '%s'", new Object[]{currentThreadName, isPreRequisite != false ? "pre-requisite " : "", command});
            CommandRegistry.LOGGER.debug(message);
            consumer.consume(useCommandExecutionException);
        }
    }

    public void runPrerequisiteCommand(IWorkerContext workerContext, AbstractCommand command, CommandResultConsumer consumer) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'runPrerequisiteCommand' must not be null";
        assert (command != null) : "Parameter 'command' of method 'runPrerequisiteCommand' must not be null";
        AbstractCommand currentlyRunning = this.getCurrentlyRunningCommand();
        assert (currentlyRunning != null) : "'currentlyRunning' of method 'runPrerequisiteCommand' must not be null";
        assert (command != currentlyRunning) : "Same instances";
        this.runIt(workerContext, command, consumer, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IWorkerContext workerContext, AbstractCommand command, CommandResultConsumer consumer, boolean canBeQueued, boolean runInDifferentThread, boolean forwardCommandConsumption) {
        Object notBeingExecutedMsg;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'run' must not be null";
        assert (command != null) : "'command' must not be null";
        assert (consumer != null) : "Parameter 'consumer' of method 'run' must not be null";
        AbstractCommand lastCommandToBeExecuted = this.getLastCommandToBeExecuted();
        if (lastCommandToBeExecuted != null) {
            notBeingExecutedMsg = null;
            if (!canBeQueued) {
                notBeingExecutedMsg = String.format("[%s] Thread[%s] Not running command '%s' because it can not be queued - already running command: %s", Iso8601DateFormat.formatDateAndTime((Date)new Date()), Thread.currentThread().getName(), command, lastCommandToBeExecuted);
            } else if (lastCommandToBeExecuted.equals(command)) {
                notBeingExecutedMsg = String.format("[%s] Thread[%s] Not running command '%s' - it is already running", Iso8601DateFormat.formatDateAndTime((Date)new Date()), Thread.currentThread().getName(), command);
            }
            if (notBeingExecutedMsg != null) {
                if (command.addExecutionInfo()) {
                    LOGGER.warn((String)notBeingExecutedMsg);
                    this.m_executionDump.add(notBeingExecutedMsg);
                }
                return;
            }
        }
        notBeingExecutedMsg = this;
        synchronized (notBeingExecutedMsg) {
            LOGGER.debug("About to be scheduled for execution - setting as last to be executed: {}", (Object)command);
            this.m_lastCommandToBeExecuted = command;
        }
        if (runInDifferentThread) {
            msg = String.format("[%s] Thread[%s] Execute in different thread - submitting command: %s", Iso8601DateFormat.formatDateAndTime((Date)new Date()), Thread.currentThread().getName(), command);
            if (command.addExecutionInfo()) {
                this.m_executionDump.add((Object)msg);
            }
            LOGGER.debug(msg);
            this.m_executorService.submit(new QueuedCommand(workerContext, command, consumer));
        } else {
            msg = String.format("[%s] Thread[%s] Execute in same thread: %s", Iso8601DateFormat.formatDateAndTime((Date)new Date()), Thread.currentThread().getName(), command);
            if (command.addExecutionInfo()) {
                this.m_executionDump.add((Object)msg);
            }
            this.runIt(workerContext, command, consumer, false, forwardCommandConsumption);
        }
    }

    public void run(IWorkerContext workerContext, AbstractCommand command, CommandResultConsumer consumer, boolean canBeQueued, boolean runInDifferentThread) {
        this.run(workerContext, command, consumer, canBeQueued, runInDifferentThread, true);
    }

    public String getExecutionContextInfo() {
        StringBuilder context = new StringBuilder("Command execution info (most recently executed command listed first):").append(StringUtility.LINE_SEPARATOR);
        ArrayList commandStack = new ArrayList(this.m_executionDump.getElements());
        Collections.reverse(commandStack);
        context.append(StringUtility.concat(commandStack, (String)StringUtility.LINE_SEPARATOR));
        return context.toString();
    }

    public synchronized boolean isExecutingCommand() {
        boolean isExecuting = this.m_currentlyRunningCommand != null || this.m_lastCommandToBeExecuted != null;
        LOGGER.info("Currently executing commands: " + isExecuting);
        return isExecuting;
    }

    @Override
    public void runCommandResultConsumption(OperationResult result, Runnable runnable) {
        assert (runnable != null) : "Parameter 'runnable' of method 'runCommandResultConsumption' must not be null";
        if (result != null) {
            if (result.isFailure()) {
                LOGGER.error(result.toString());
            } else if (result.containsWarning()) {
                LOGGER.warn(result.toString());
            }
        }
        runnable.run();
    }

    private final class QueuedCommand
    implements Runnable {
        private final IWorkerContext m_workerContext;
        private final AbstractCommand m_command;
        private final CommandResultConsumer m_consumer;

        QueuedCommand(IWorkerContext workerContext, AbstractCommand command, CommandResultConsumer consumer) {
            assert (workerContext != null) : "Parameter 'workerContext' of method 'QueuedCommand' must not be null";
            assert (command != null) : "Parameter 'command' of method 'QueuedCommand' must not be null";
            assert (consumer != null) : "Parameter 'consumer' of method 'QueuedCommand' must not be null";
            this.m_workerContext = workerContext;
            this.m_command = command;
            this.m_consumer = consumer;
        }

        @Override
        public void run() {
            CommandRegistry.this.runIt(this.m_workerContext, this.m_command, this.m_consumer, false, true);
        }
    }
}

