/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.qualitygate;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateResultElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateResultStatus;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class QualityGateExcludeFilterResult
extends AbstractQualityGateResultElement {
    private Map<NamedElement, Set<Element>> m_conditionToExcluded;

    public QualityGateExcludeFilterResult(NamedElement parent, IQualityGateElement element, Set<Element> matches) {
        super(parent, element, matches);
    }

    public void addExcludeInfo(NamedElement element, Set<Element> excluded) {
        assert (element != null) : "Parameter 'element' of method 'addExcludeInfo' must not be null";
        assert (excluded != null && excluded.size() > 0) : "Parameter 'excluded' of method 'addExcludeInfo' must not be empty";
        if (this.m_conditionToExcluded == null) {
            this.m_conditionToExcluded = new LinkedHashMap<NamedElement, Set<Element>>();
        }
        this.m_conditionToExcluded.put(element, excluded);
    }

    @Override
    public String getInformation() {
        int numberOfIssues;
        int numberOfConditions;
        if (this.m_conditionToExcluded == null) {
            numberOfConditions = 0;
            numberOfIssues = 0;
        } else {
            numberOfConditions = this.m_conditionToExcluded.keySet().size();
            HashSet excludedIssues = new HashSet();
            for (Map.Entry<NamedElement, Set<Element>> next : this.m_conditionToExcluded.entrySet()) {
                excludedIssues.addAll(next.getValue());
            }
            numberOfIssues = excludedIssues.size();
        }
        return String.format("Filter matches %d issue(s) of which %d issue(s) match %d condition(s)", this.getMatches().size(), numberOfIssues, numberOfConditions);
    }

    @Override
    public QualityGateResultStatus getResultStatus() {
        return null;
    }
}

