/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.diff.issue;

import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.diff.CompositeElementDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IIssueDiff;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.Severity;

abstract class CompositeIssueDiff<B extends IIssue, C extends Issue>
extends CompositeElementDiff<B, C>
implements IIssueDiff {
    protected CompositeIssueDiff(NamedElement parent, B baseline, C current, IDiffElement.Change change) {
        super(parent, baseline, current, change);
    }

    @Override
    public String getShortName() {
        if (this.getCurrent() != null) {
            return ((Issue)this.getCurrent()).getAffectedElement().getShortName();
        }
        return ((IIssue)this.getBaseline()).getPresentationName() + " [Baseline]";
    }

    @Override
    public String getAffectedElementPresentationName(boolean shortName) {
        if (this.getCurrent() != null) {
            return ((Issue)this.getCurrent()).getAffectedElement().getPresentationName(shortName);
        }
        return ((IIssue)this.getBaseline()).getPresentationName() + " [Baseline]";
    }

    @Override
    public final String getIssueCategoryStandardName() {
        if (this.getCurrent() != null) {
            return ((Issue)this.getCurrent()).getId().getCategory().getStandardName();
        }
        return ((IIssue)this.getBaseline()).getIssueType().getCategory().getName();
    }

    @Override
    public final com.hello2morrow.sonargraph.core.model.common.Severity getSeverity() {
        if (this.getCurrent() != null) {
            return ((Issue)this.getCurrent()).getSeverity();
        }
        Severity baselineSeverity = ((IIssue)this.getBaseline()).getSeverity();
        switch (baselineSeverity) {
            case ERROR: {
                return com.hello2morrow.sonargraph.core.model.common.Severity.ERROR;
            }
            case WARNING: {
                return com.hello2morrow.sonargraph.core.model.common.Severity.WARNING;
            }
            case INFO: {
                return com.hello2morrow.sonargraph.core.model.common.Severity.INFO;
            }
            case NONE: {
                return com.hello2morrow.sonargraph.core.model.common.Severity.NONE;
            }
        }
        assert (false) : "Unsupported baseline severity: " + String.valueOf(baselineSeverity);
        return com.hello2morrow.sonargraph.core.model.common.Severity.NONE;
    }

    @Override
    public final String getIssueCategoryPresentationName() {
        if (this.getCurrent() != null) {
            return ((Issue)this.getCurrent()).getId().getCategory().getPresentationName();
        }
        return ((IIssue)this.getBaseline()).getIssueType().getCategory().getPresentationName();
    }

    @Override
    public final String getProviderPresentationName() {
        if (this.getCurrent() != null) {
            return ((Issue)this.getCurrent()).getProvider().getPresentationName();
        }
        return ((IIssue)this.getBaseline()).getIssueProvider().getPresentationName();
    }
}

