/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.IssueDelta;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import java.util.List;

public abstract class UnmodifiableRootModel
extends VirtualModel {
    private IssueDelta m_delta = new IssueDelta();
    private boolean m_refactoringsModified;

    public UnmodifiableRootModel(NamedElement parent) {
        super(parent);
    }

    @Override
    public final boolean isModifiable() {
        return false;
    }

    @Override
    public final String getBasedOnVirtualModel() {
        return null;
    }

    @Override
    public final synchronized void issuesAdded(List<Issue> issues) {
        assert (issues != null && !issues.isEmpty()) : "Parameter 'issues' of method 'issuesAdded' must not be empty";
        this.m_delta.issuesAdded(issues);
    }

    @Override
    public final synchronized void issuesRemoved(List<Issue> issues) {
        assert (issues != null && !issues.isEmpty()) : "Parameter 'issues' of method 'issuesRemoved' must not be empty";
        this.m_delta.issuesRemoved(issues);
    }

    @Override
    public final synchronized IssueDelta consumeIssueDelta() {
        IssueDelta delta = this.m_delta;
        this.m_delta = new IssueDelta();
        return delta;
    }

    @Override
    public final synchronized boolean haveIssuesBeenModified() {
        return !this.m_delta.isEmpty();
    }

    @Override
    public synchronized void refactoringsModified() {
        this.m_refactoringsModified = true;
    }

    @Override
    public final synchronized boolean haveRefactoringsBeenModified() {
        return this.m_refactoringsModified;
    }

    @Override
    public synchronized boolean consumeRefactoringsModified() {
        boolean modified = this.m_refactoringsModified;
        this.m_refactoringsModified = false;
        return modified;
    }
}

