/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.report;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import java.util.Comparator;

public final class MetricValueComparator
implements Comparator<IMetricValue> {
    public static final int BOTTOM_UP = 1;
    public static final int TOP_DOWN = -1;
    private static final int BEST_AROUND_ZERO = -2;

    @Override
    public int compare(IMetricValue m1, IMetricValue m2) {
        assert (m1 != null) : "Parameter 'm1' of method 'compare' must not be null";
        assert (m2 != null) : "Parameter 'm2' of method 'compare' must not be null";
        IMetricId id1 = m1.getMetricDescriptor().getMetricId();
        IMetricId id2 = m2.getMetricDescriptor().getMetricId();
        assert (id1.equals(id2)) : "Cannot compare metrics of different types. id of m1: " + id1.getStandardName() + ", id of m2: " + id2.getStandardName();
        IMetricId.StandardSorting sorting = id1.getSorting();
        int sortFactor = 0;
        switch (sorting) {
            case LOWER_WORSE: {
                sortFactor = 1;
                break;
            }
            case INDIFFERENT: 
            case HIGHER_WORSE: {
                sortFactor = -1;
                break;
            }
            case OPTIMUM_AT_ZERO: {
                sortFactor = -2;
            }
        }
        Number v1 = m1.getValue();
        Number v2 = m2.getValue();
        int compareValue = sortFactor != -2 ? (id1.isFloat() ? Float.compare(v1.floatValue(), v2.floatValue()) * sortFactor : Integer.compare(v1.intValue(), v2.intValue()) * sortFactor) : (id1.isFloat() ? Double.compare(Math.abs(v1.floatValue()), Math.abs(v2.floatValue())) * -1 : Integer.compare(Math.abs(v1.intValue()), Math.abs(v2.intValue())) * -1);
        return compareValue;
    }
}

