/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.path;

import com.hello2morrow.sonargraph.core.foundation.common.base.IFile;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.path.IBaseDirectory;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotPath;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.Stack;

public abstract class Path
extends NamedElementContainer
implements IFile,
ISnapshotPath {
    private TFile m_file;
    private String m_path;

    protected Path(NamedElement parent) {
        super(parent);
    }

    protected void init(TFile file, IBaseDirectory baseDirectory) {
        assert (file != null) : "'file' must not be null";
        TFile directoryFile = null;
        if (baseDirectory != null) {
            directoryFile = baseDirectory.getDirectoryFile();
        }
        if (file.isAbsolute() || "/\\".indexOf(file.getPath().charAt(0)) >= 0) {
            this.m_file = file.getNormalizedAbsoluteFile();
            this.m_path = FileUtility.calculateRelativePath((TFile)this.m_file, (TFile)directoryFile);
        } else if (directoryFile != null) {
            TFile absoluteFile = new TFile((File)directoryFile, file.getPath());
            this.m_path = FileUtility.calculateRelativePath((TFile)absoluteFile.getNormalizedFile(), (TFile)directoryFile);
            this.m_file = new TFile((File)directoryFile, this.m_path).getNormalizedFile();
        } else {
            this.m_file = file.getNormalizedAbsoluteFile();
            this.m_path = FileUtility.convertPathToUniversalForm((String)this.m_file.getPath());
        }
    }

    protected Path(NamedElement parent, TFile file) {
        super(parent);
        this.init(file, this.getBaseDirectory());
    }

    protected Path(NamedElement parent, TFile file, IBaseDirectory baseDirectory) {
        super(parent);
        assert (baseDirectory != null) : "Parameter 'baseDirectory' of method 'Path' must not be null";
        this.init(file, baseDirectory);
    }

    protected Path(NamedElement parent, String path) {
        super(parent);
        assert (path != null) : "Parameter 'path' of method 'Path' must not be null";
        this.m_path = FileUtility.convertPathToUniversalForm((String)path);
    }

    protected final void resetFile() {
        assert (!this.isArtificial()) : "Is artificial";
        this.m_file = null;
    }

    public final void setPath(String path) {
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'setPath' must not be empty";
        if (!this.isArtificial()) {
            this.getFile();
        }
        this.m_path = path;
    }

    public void setPath(TFile path) {
        assert (this.getFile() != null) : "Has no path: " + String.valueOf(this);
        this.init(path, this.getBaseDirectory());
    }

    @Override
    public final String getPath() {
        return this.m_path;
    }

    public void rebase() {
        assert (!this.isArtificial()) : "'artificial' subclasses must override";
        IBaseDirectory baseDirectory = this.getBaseDirectory();
        this.m_path = FileUtility.calculateRelativePath((TFile)this.getFile(), (TFile)(baseDirectory != null ? baseDirectory.getDirectoryFile() : null));
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(writer.getPersistentPath(this));
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_path = reader.readString();
    }

    public boolean isArtificial() {
        return false;
    }

    public boolean exists() {
        assert (!this.isArtificial()) : "'artificial' subclasses must override";
        return this.getFile().exists();
    }

    @Override
    public TFile getFile() {
        assert (!this.isArtificial()) : "'artificial' subclasses must override";
        if (this.m_file == null) {
            assert (this.m_path != null) : "'m_path' of method 'getFile' must not be null";
            IBaseDirectory baseDirectory = this.getBaseDirectory();
            this.m_file = baseDirectory != null && FileUtility.isRelativePath((String)this.m_path) ? baseDirectory.createFile(this.m_path) : new TFile(this.m_path);
        }
        return this.m_file;
    }

    @Override
    public String getIdentifyingPath() {
        IBaseDirectory baseDirectory = this.getBaseDirectory();
        if (baseDirectory != null && baseDirectory.contributesToIdentifyingPath()) {
            String name = this.getName();
            if (name.startsWith("./")) {
                name = name.substring("./".length());
            }
            return baseDirectory.getNamedElement().getName() + "/" + name;
        }
        return this.getName();
    }

    @Property
    public final String identifyingPath() {
        String identifyingPath = this.getIdentifyingPath();
        return this.getName().equals(identifyingPath) ? null : identifyingPath;
    }

    @Override
    @Property
    public String getAbsolutePath() {
        assert (!this.isArtificial()) : "'artificial' subclasses must override";
        return this.getFile().getNormalizedAbsolutePath();
    }

    public final String calculateRelativePath(IBaseDirectory baseDirectory) {
        assert (baseDirectory != null) : "Parameter 'baseDirectory' of method 'calculateRelativePath' must not be null";
        if (this.isArtificial()) {
            return this.getName();
        }
        return FileUtility.calculateRelativePath((TFile)this.getFile(), (TFile)baseDirectory.getDirectoryFile());
    }

    @Override
    public String getName() {
        return this.m_path;
    }

    @Override
    public String getShortName() {
        String path = this.m_path;
        int pos = path.lastIndexOf(47);
        if (pos != -1) {
            return path.substring(pos + 1);
        }
        return path;
    }

    @Override
    public String getPresentationName(boolean shortName) {
        if (shortName) {
            return this.getShortName();
        }
        return this.getName();
    }

    public IBaseDirectory getBaseDirectory() {
        return this.getParent(IBaseDirectory.class, new Class[0]);
    }

    public final IBaseDirectory getTopmostBaseDirectory() {
        Stack<IBaseDirectory> parentStack = new Stack<IBaseDirectory>();
        IBaseDirectory parent = this.getBaseDirectory();
        while (parent != null) {
            parentStack.push(parent);
            parent = parent instanceof Path ? ((Path)((Object)parent)).getBaseDirectory() : null;
        }
        if (!parentStack.isEmpty()) {
            return (IBaseDirectory)parentStack.pop();
        }
        return null;
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitPath(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append("Path: ");
        builder.append(this.m_path);
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append("Base path: ");
        builder.append(this.getBaseDirectory() == null ? " <no base path> " : this.getBaseDirectory().getDirectoryFile().getAbsolutePath());
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append("Identifying path: ");
        builder.append(this.getIdentifyingPath());
        return builder.toString();
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitPath(IFile var1);
    }
}

