/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class SourceFileIssueParticipationInfo<T extends Issue>
extends NamedElement {
    private final THashMap<SourceFile, ArrayList<T>> m_sourceFileToIssue = new THashMap();

    public SourceFileIssueParticipationInfo(NamedElement parent) {
        super(parent);
    }

    @Override
    public boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    public boolean persist() {
        return false;
    }

    @Override
    public String getImageResourceName() {
        return "Cache";
    }

    @Override
    public String getShortName() {
        return this.getClass().getSimpleName();
    }

    public synchronized void add(T issue, Set<SourceFile> sourceFiles) {
        assert (issue != null) : "Parameter 'issue' of method 'add' must not be null";
        assert (sourceFiles != null && !sourceFiles.isEmpty()) : "Parameter 'sourceFiles' of method 'add' must not be empty";
        sourceFiles.forEach(s -> {
            ArrayList<Issue> issues = (ArrayList<Issue>)this.m_sourceFileToIssue.get(s);
            if (issues == null) {
                issues = new ArrayList<Issue>();
                this.m_sourceFileToIssue.put(s, issues);
            }
            issues.add((Issue)issue);
        });
    }

    public void put(SourceFile sourceFile, Set<T> issues) {
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'put' must not be null";
        assert (issues != null && !issues.isEmpty()) : "Parameter 'issues' of method 'put' must not be empty";
        ArrayList<T> copy = new ArrayList<T>(issues);
        this.m_sourceFileToIssue.put((Object)sourceFile, copy);
    }

    @Override
    public synchronized void finishModification() {
        this.m_sourceFileToIssue.values().forEach(i -> i.trimToSize());
        super.finishModification();
    }

    public synchronized List<T> getIssues(SourceFile sourceFile) {
        assert (sourceFile != null) : "Parameter 'component' of method 'getIssues' must not be null";
        List issues = (List)this.m_sourceFileToIssue.get((Object)sourceFile);
        return issues == null ? Collections.emptyList() : Collections.unmodifiableList(issues);
    }

    public Map<SourceFile, List<T>> getSourceFileToIssues() {
        return Collections.unmodifiableMap(this.m_sourceFileToIssue);
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        int size = this.m_sourceFileToIssue.size();
        builder.append("\n").append("Source file issue participation entries: ").append(size);
        for (Map.Entry nextEntry : this.m_sourceFileToIssue.entrySet()) {
            builder.append("\n").append(((SourceFile)nextEntry.getKey()).getIdentifyingPath()).append(" participates in ").append(((ArrayList)nextEntry.getValue()).size()).append(" issue(s)");
        }
        return builder.toString();
    }
}

