/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.controller.system.diff.DuplicateCodeBlockOccurrenceMatcher;
import com.hello2morrow.sonargraph.core.model.system.diff.duplicate.BaselineOccurrenceDto;
import com.hello2morrow.sonargraph.core.model.system.diff.duplicate.CurrentOccurrenceDto;
import com.hello2morrow.sonargraph.core.model.system.diff.duplicate.DuplicateDto;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.DuplicateCodeBlockOccurrenceDiff;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import java.util.ArrayList;

final class DuplicateCodeBlockDiffMatcher {
    private DuplicateCodeBlockDiffMatcher() {
    }

    public static StrictPair<Double, Integer> match(DuplicateDto<BaselineOccurrenceDto> baseline, DuplicateDto<CurrentOccurrenceDto> current) {
        assert (baseline != null) : "Parameter 'baseline' of method 'match' must not be null";
        assert (current != null) : "Parameter 'current' of method 'match' must not be null";
        double result = 0.0;
        int numberOfMatchedBaselines = 0;
        int numberOfUnmatchedBaselines = 0;
        ArrayList<CurrentOccurrenceDto> unmatchedCurrentOccurrences = new ArrayList<CurrentOccurrenceDto>(current.getOccurrences());
        for (BaselineOccurrenceDto nextBaselineOcc : baseline.getOccurrences()) {
            OccurrenceMatchResult bestMatch = null;
            int i = 0;
            while (i < unmatchedCurrentOccurrences.size()) {
                CurrentOccurrenceDto nextCurrentOcc = (CurrentOccurrenceDto)unmatchedCurrentOccurrences.get(i);
                StrictPair<DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail, Integer> matchInfo = DuplicateCodeBlockOccurrenceMatcher.getChangeDetail(nextCurrentOcc, nextBaselineOcc);
                if (matchInfo != null) {
                    if (matchInfo.getFirst() == DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail.UNMODIFIED) {
                        bestMatch = new OccurrenceMatchResult((DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail)((Object)matchInfo.getFirst()), (Integer)matchInfo.getSecond(), Math.max(nextCurrentOcc.getBlockSize(), nextBaselineOcc.getBlockSize()), i);
                        break;
                    }
                    if (bestMatch == null || (Integer)matchInfo.getSecond() > bestMatch.getOverlap()) {
                        bestMatch = new OccurrenceMatchResult((DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail)((Object)matchInfo.getFirst()), (Integer)matchInfo.getSecond(), Math.max(nextCurrentOcc.getBlockSize(), nextBaselineOcc.getBlockSize()), i);
                    }
                }
                ++i;
            }
            if (bestMatch != null) {
                ++numberOfMatchedBaselines;
                result += bestMatch.getChangeDetail().getScore() * (double)bestMatch.getOverlap() / bestMatch.getBlockSize();
                unmatchedCurrentOccurrences.remove(bestMatch.getIndex());
                continue;
            }
            ++numberOfUnmatchedBaselines;
        }
        if (numberOfMatchedBaselines == 0) {
            return new StrictPair((Object)0.0, (Object)Math.max(baseline.getOccurrences().size(), current.getOccurrences().size()));
        }
        double matchAgainstBaselineScore = result / (double)current.getOccurrences().size();
        double matchAgainstCurrentScore = result / (double)baseline.getOccurrences().size();
        return new StrictPair((Object)Math.max(matchAgainstBaselineScore, matchAgainstCurrentScore), (Object)Math.max(numberOfUnmatchedBaselines, unmatchedCurrentOccurrences.size()));
    }

    public static final class OccurrenceMatchResult {
        private final DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail m_changeDetail;
        private final int m_overlap;
        private final int m_index;
        private final int m_blockSize;

        public OccurrenceMatchResult(DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail changeDetail, int overlap, int blockSize, int index) {
            assert (changeDetail != null) : "Parameter 'changeDetail' of method 'OccurrenceMatchResult' must not be null";
            assert (overlap > 0) : "Parameter overlap must be > 0 but is " + overlap;
            assert (blockSize > 0) : "Parameter blockSize must be > 0 but is " + blockSize;
            assert (index > -1) : "Parameter index must be > -1 but is " + index;
            this.m_changeDetail = changeDetail;
            this.m_overlap = overlap;
            this.m_blockSize = blockSize;
            this.m_index = index;
        }

        public DuplicateCodeBlockOccurrenceDiff.OccurrenceChangeDetail getChangeDetail() {
            return this.m_changeDetail;
        }

        public int getOverlap() {
            return this.m_overlap;
        }

        public int getIndex() {
            return this.m_index;
        }

        public double getBlockSize() {
            return this.m_blockSize;
        }
    }
}

