/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.MetricsExtension;
import com.hello2morrow.sonargraph.core.controller.system.PluginExtension;
import com.hello2morrow.sonargraph.core.controller.system.QualityGateExtension;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.report.ModuleReportFilter;
import com.hello2morrow.sonargraph.core.controller.system.report.QualityGateElementCollector;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IReportExtension;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISoftwareSystemController;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISystemDiffExtension;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IThresholdExtension;
import com.hello2morrow.sonargraph.core.model.analysis.Analyzer;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.Analyzers;
import com.hello2morrow.sonargraph.core.model.analysis.ArchitectureCheckConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.CycleAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.analysis.LastScriptRunnerExecutionStatus;
import com.hello2morrow.sonargraph.core.model.analysis.QualityGateCheckConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.ScriptRunnerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.SystemDiffAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureViolationIssueId;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.element.DependencyIssue;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.plugin.IPluginConfigurationProvider;
import com.hello2morrow.sonargraph.core.model.programming.LogicalSystemNamespace;
import com.hello2morrow.sonargraph.core.model.report.CreateReportResult;
import com.hello2morrow.sonargraph.core.model.report.IBasicReport;
import com.hello2morrow.sonargraph.core.model.report.IReport;
import com.hello2morrow.sonargraph.core.model.report.ModuleReport;
import com.hello2morrow.sonargraph.core.model.report.Report;
import com.hello2morrow.sonargraph.core.model.report.SystemReport;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateResult;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.issue.QualityGateIssueId;
import com.hello2morrow.sonargraph.core.model.system.ranking.IIssueRankingProvider;
import com.hello2morrow.sonargraph.core.model.system.ranking.IssueRank;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.ModuleBasedLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.persistence.report.ExportMetaDataXmlWriter;
import com.hello2morrow.sonargraph.core.persistence.report.ReportHtmlWriter;
import com.hello2morrow.sonargraph.core.persistence.report.ReportXmlWriter;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.foundation.utilities.HashSupport;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.plugin.ISonargraphPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginConfiguration;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReportExtension
extends Extension
implements IReportExtension {
    private static final int ISSUE_RANK_LIMIT = 100;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportExtension.class);
    private static final String DIFF_REPORT_FILE_NAME_PREVIOUS = "system-previous";
    private static final String DIFF_REPORT_FILE_NAME_CURRENT = "system-current";
    private final Installation m_installation;
    private final SoftwareSystem m_softwareSystem;
    private final Set<SonargraphFeature> m_unavailableFeatures;
    private final Set<SonargraphFeature> m_availableFeatures;

    ReportExtension(Installation installation, SoftwareSystem softwareSystem, Set<SonargraphFeature> availableFeatures, Set<SonargraphFeature> unavailableFeatures) {
        assert (installation != null) : "Parameter 'installation' of method 'ReportExtension' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'ReportExtension' must not be null";
        assert (availableFeatures != null && availableFeatures.size() > 0) : "Parameter 'availableFeatures' of method 'ReportExtension' must not be empty";
        assert (unavailableFeatures != null) : "Parameter 'unavailableFeatures' of method 'ReportExtension' must not be null";
        this.m_softwareSystem = softwareSystem;
        this.m_installation = installation;
        this.m_availableFeatures = availableFeatures;
        this.m_unavailableFeatures = unavailableFeatures;
    }

    @Override
    public OperationResultWithOutcome<CreateReportResult> createReport(IWorkerContext workerContext, IReportExtension.CreateReportRequest request) {
        String diffReportFileName;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createReport' must not be null";
        assert (request != null) : "Parameter 'request' of method 'createReport' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Create report for system");
        if (this.m_softwareSystem.getState() != SoftwareSystemState.MODEL_LOADED) {
            LOGGER.warn("Model of software system is currently not loaded! Current state: " + String.valueOf((Object)this.m_softwareSystem.getState()));
        }
        List<IMetricLevel> metricLevels = request.getMetricLevels();
        Set<IReport.Format> formats = request.getReportFormats();
        if (formats.size() == 1) {
            workerContext.setNumberOfSteps(6, new int[]{20, 10, 5, 5, 40, 20});
        } else {
            workerContext.setNumberOfSteps(7, new int[]{20, 10, 5, 5, 20, 20, 20});
        }
        Date timestamp = request.getTimestamp() != null ? request.getTimestamp() : new Date();
        Report report = this.internCreateReportObject(workerContext, metricLevels, request.getReportDescription(), timestamp.getTime());
        if (workerContext.hasBeenCanceled()) {
            return result;
        }
        assert (report != null) : "report object must not be null, if workerContext has not been cancelled";
        IReport mainReport = request.isSplitByModule() ? new SystemReport(report) : report;
        CreateReportResult createReportResult = new CreateReportResult(mainReport);
        TFile targetDirectory = request.getReportDirectory();
        boolean targetDirectoryAlreadyExists = targetDirectory.exists();
        HashSet<IFileType> requestedFileTypes = new HashSet<IFileType>();
        String mainReportFileName = this.createMainReportFileName(request.getReportFileName(), timestamp);
        String string = diffReportFileName = request.getBaselineXmlReportFile() != null && request.isSystemDiffLicensed() ? this.m_softwareSystem.getExtension(ISystemDiffExtension.class).createDiffFileName(request.getReportFileName(), timestamp) : null;
        if (formats.contains((Object)IReport.Format.XML)) {
            requestedFileTypes.add(CoreFileType.REPORT_XML);
            workerContext.beginSubTask("Writing XML report file");
            TFile xmlTargetFile = this.createTargetFile(targetDirectory, mainReportFileName, report, (OperationResult)result, CoreFileType.REPORT_XML, timestamp);
            if (result.isSuccess()) {
                assert (xmlTargetFile != null) : "'xmlTargetFile' of method 'createReport' must not be null";
                createReportResult.addTargetFile(IReport.Format.XML, xmlTargetFile);
                new ReportXmlWriter(this.m_installation.getVersion(), report).storeReportToFile(workerContext, xmlTargetFile, (OperationResult)result);
            }
            workerContext.endSubTask();
        }
        if (formats.contains((Object)IReport.Format.HTML)) {
            requestedFileTypes.add(CoreFileType.REPORT_HTML);
            workerContext.beginSubTask("Writing HTML report files");
            TFile mainHtmlTargetFile = this.createTargetFile(targetDirectory, mainReportFileName, mainReport, (OperationResult)result, CoreFileType.REPORT_HTML, timestamp);
            if (result.isSuccess()) {
                assert (mainHtmlTargetFile != null) : "'mainHtmlTargetFile' of method 'createReport' must not be null";
                createReportResult.addTargetFile(IReport.Format.HTML, mainHtmlTargetFile);
                report.setTargetFile(mainHtmlTargetFile);
                if (request.isSplitByModule()) {
                    SystemReport systemReport = (SystemReport)mainReport;
                    List<Module> modules = mainReport.getModules();
                    workerContext.beginBlockOfWork(modules.size() + 1);
                    for (Module module : modules) {
                        workerContext.working("Writing report for module '" + module.getName() + "'", true);
                        if (result.isSuccess()) {
                            ModuleReport moduleReport = ModuleReportFilter.filterByModule(report, module, 100);
                            moduleReport.performCalculations();
                            this.saveHtmlReport(workerContext, moduleReport, request, null, (OperationResult)result);
                            systemReport.addModuleReport(moduleReport);
                        }
                        workerContext.workItemCompleted();
                    }
                } else {
                    workerContext.beginBlockOfWork(1);
                }
            }
            if (result.isSuccess()) {
                workerContext.working("Writing system report", true);
                this.saveHtmlReport(workerContext, mainReport, request, diffReportFileName, (OperationResult)result);
                workerContext.workItemCompleted();
            }
            workerContext.endSubTask();
        }
        TrueZipFacade.clear((TFile)targetDirectory);
        if (workerContext.hasBeenCanceled()) {
            this.cleanUpTargetDirectory(mainReport, targetDirectory, (OperationResult)result, targetDirectoryAlreadyExists);
            result.setIsSuccess(false);
        } else if (result.isSuccess()) {
            TFile baselineXmlReportFile = request.getBaselineXmlReportFile();
            workerContext.working("Create system diff report", true);
            if (baselineXmlReportFile != null) {
                if (request.isSystemDiffLicensed()) {
                    OperationResultWithOutcome<Map<IFileType, TFile>> diffReportResult = this.m_softwareSystem.getExtension(ISystemDiffExtension.class).createSystemDiffReport(workerContext, report, request.getReportDirectory(), diffReportFileName, requestedFileTypes, baselineXmlReportFile, mainReportFileName);
                    result.addMessagesFrom(diffReportResult);
                    if (result.isSuccess() && diffReportResult.getOutcome() != null) {
                        for (Map.Entry nextDiffFileEntry : ((Map)diffReportResult.getOutcome()).entrySet()) {
                            IFileType fileType = (IFileType)nextDiffFileEntry.getKey();
                            TFile diffReport = (TFile)nextDiffFileEntry.getValue();
                            if (fileType == CoreFileType.REPORT_HTML) {
                                createReportResult.addSystemDiffReport(IReport.Format.HTML, diffReport);
                                continue;
                            }
                            if (fileType != CoreFileType.REPORT_XML) continue;
                            createReportResult.addSystemDiffReport(IReport.Format.XML, diffReport);
                        }
                    }
                }
                result.setIsSuccess(true);
            }
            result.setOutcome((Object)createReportResult);
        }
        return result;
    }

    @Override
    public IReport createReportObjectForBasicSystemInfo(IWorkerContext workerContext) {
        IAnalyzerController analyzerController = this.m_softwareSystem.getExtension(IAnalyzerController.class);
        if (workerContext.hasBeenCanceled()) {
            return null;
        }
        AnalyzerExecutionLevel analyzerExecutionLevel = analyzerController.getAnalyzerExecutionLevel();
        Report report = new Report(this.m_installation.getVersion(), this.m_softwareSystem, new ArrayList<SonargraphFeature>(this.m_availableFeatures), new ArrayList<SonargraphFeature>(this.m_unavailableFeatures), analyzerExecutionLevel, null, System.currentTimeMillis());
        LOGGER.debug("Creating report with active analyzer execution level " + analyzerExecutionLevel.getPresentationName());
        this.addAnalyzerInfo(report);
        this.addPluginInfo(report);
        this.addArchitectureInfo(report);
        this.addQualityGateInfo(report);
        this.addMetrics(workerContext, report, Collections.singletonList(CoreMetricLevel.SYSTEM), analyzerExecutionLevel);
        return report;
    }

    private Report internCreateReportObject(IWorkerContext workerContext, List<IMetricLevel> metricLevels, String reportContextInfo, long timestamp) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internCreateReportObject' must not be null";
        assert (metricLevels != null) : "Parameter 'metricLevels' of method 'internCreateReportObject' must not be null";
        workerContext.beginSubTask("Waiting for analyzers to complete");
        IAnalyzerController analyzerController = this.m_softwareSystem.getExtension(IAnalyzerController.class);
        analyzerController.waitForAnalyzersToComplete(workerContext);
        workerContext.endSubTask();
        if (workerContext.hasBeenCanceled()) {
            return null;
        }
        AnalyzerExecutionLevel analyzerExecutionLevel = analyzerController.getAnalyzerExecutionLevel();
        Report report = new Report(this.m_installation.getVersion(), this.m_softwareSystem, new ArrayList<SonargraphFeature>(this.m_availableFeatures), new ArrayList<SonargraphFeature>(this.m_unavailableFeatures), analyzerExecutionLevel, reportContextInfo, timestamp);
        LOGGER.debug("Creating report with active analyzer execution level " + analyzerExecutionLevel.getPresentationName());
        this.addAnalyzerInfo(report);
        this.addPluginInfo(report);
        this.addArchitectureInfo(report);
        this.addQualityGateInfo(report);
        workerContext.beginSubTask("Adding metrics to report");
        this.addMetrics(workerContext, report, metricLevels, analyzerExecutionLevel);
        workerContext.endSubTask();
        if (workerContext.hasBeenCanceled()) {
            return null;
        }
        workerContext.beginSubTask("Adding issues to report");
        this.addIssues(workerContext, report);
        this.addIssueRankings(workerContext, report);
        workerContext.endSubTask();
        if (workerContext.hasBeenCanceled()) {
            return null;
        }
        workerContext.beginSubTask("Adding resolutions to report");
        this.addResolutions(workerContext, report);
        workerContext.endSubTask();
        if (workerContext.hasBeenCanceled()) {
            return null;
        }
        report.performCalculations();
        return report;
    }

    private void addQualityGateInfo(Report report) {
        assert (report != null) : "Parameter 'report' of method 'addQualityGateInfo' must not be null";
        if (this.m_availableFeatures.contains((Object)SonargraphFeature.ARCHITECTURE)) {
            HashSet<Element> issuesAffectingQualityGateConditions = new HashSet<Element>();
            HashSet<Element> metricValuesAffectingQualityGateConditions = new HashSet<Element>();
            QualityGateExtension qualityGateExtension = this.m_softwareSystem.getExtension(QualityGateExtension.class);
            for (QualityGate next : qualityGateExtension.getAvailableQualityGates()) {
                if (!next.isChecked()) continue;
                if (next.getResultElement() != null) {
                    QualityGateResult qualityGateResult = (QualityGateResult)next.getResultElement();
                    report.addQualityGateResult(next, qualityGateResult);
                    QualityGateElementCollector.collect(qualityGateResult, issuesAffectingQualityGateConditions, metricValuesAffectingQualityGateConditions);
                    continue;
                }
                report.addQualityGateResult(next, null);
            }
            report.setIssuesAffectingQualityGates(issuesAffectingQualityGateConditions);
            report.setMetricValuesAffectingQualityGates(metricValuesAffectingQualityGateConditions);
        }
    }

    private void addPluginInfo(Report report) {
        assert (report != null) : "Parameter 'report' of method 'addPluginInfo' must not be null";
        PluginExtension pluginExtension = this.m_installation.getExtension(PluginExtension.class);
        List<SonargraphPlugin> plugins = pluginExtension.getPlugins();
        IPluginConfigurationProvider pluginConfigurationProvider = this.m_softwareSystem.getExtension(IPluginConfigurationProvider.class);
        for (SonargraphPlugin next : plugins) {
            if (next.getAnalyzerContributor() != null) {
                IConfigurableAnalyzerId pluginAnalyzerId = pluginExtension.getPluginAnalyzerId(this.m_softwareSystem, next);
                if (pluginAnalyzerId != null) {
                    report.addAnalyzerPlugin(next, pluginAnalyzerId);
                } else {
                    LOGGER.debug("Disabled analyzer plugin '" + next.getId() + "'");
                    report.addAnalyzerPlugin(next, null);
                }
            }
            if (next.getModelContributor() != null) {
                report.addModelPlugin(next);
            }
            SonargraphPluginConfiguration nextConfiguration = next.getConfiguration();
            ArrayList<Pair<SonargraphPluginAttribute, String>> configurationsAndValues = new ArrayList<Pair<SonargraphPluginAttribute, String>>();
            for (SonargraphPluginAttribute nextAttribute : nextConfiguration.getAttributes().values()) {
                configurationsAndValues.add((Pair<SonargraphPluginAttribute, String>)new Pair((Object)nextAttribute, (Object)nextConfiguration.getValue((ISonargraphPluginAttribute)nextAttribute).toString()));
            }
            report.addPluginConfiguration(next, pluginConfigurationProvider.getPluginConfigurationFile(next.getId()), configurationsAndValues);
        }
    }

    private void addArchitectureInfo(Report report) {
        assert (report != null) : "Parameter 'report' of method 'addArchitectureInfo' must not be null";
        for (ArchitectureFile next : this.m_softwareSystem.getUniqueExistingChild(Files.class).getArchitecture().getChildren(ArchitectureFile.class)) {
            if (!next.isChecked()) continue;
            String nextContent = next.getContent();
            String nextHash = nextContent.isEmpty() ? HashSupport.MD5.getHexString(next.getName()) : HashSupport.MD5.getHexString(nextContent);
            report.addCheckedArchitecture(next, nextHash);
        }
    }

    private void addAnalyzerInfo(Report report) {
        SystemDiffAnalyzerConfiguration systemDiffAnalyzerConfig;
        String baselinePath;
        AnalyzerConfiguration systemDiffConfiguration;
        Map<String, Object> valueMap;
        AnalyzerConfiguration duplicateCodeConfiguration;
        assert (report != null) : "Parameter 'report' of method 'addAnalyzerInfo' must not be null";
        IAnalyzerController analyzerController = this.m_softwareSystem.getExtension(IAnalyzerController.class);
        HashSet<IAnalyzerId> licensedAnalyzerIds = new HashSet<IAnalyzerId>(analyzerController.getLicensedAnalyzerIds());
        licensedAnalyzerIds.addAll(analyzerController.getCurrentlyAvailableAnalyzerIds());
        licensedAnalyzerIds.stream().forEach(id -> report.addLicensedAnalyzer((IAnalyzerId)id));
        analyzerController.getUnlicensedAnalyzerIds().stream().forEach(id -> report.addUnlicensedAnalyzer((IAnalyzerId)id));
        AnalyzerConfiguration architectureConfiguration = analyzerController.getConfiguration(CoreAnalyzerId.ARCHITECTURE_CHECK);
        if (architectureConfiguration != null) {
            assert (architectureConfiguration instanceof ArchitectureCheckConfiguration) : "Unexpected class in method 'addAnalyzerInfo': " + String.valueOf(architectureConfiguration);
            report.setArchitectureCheckConfigurationEntries(((ArchitectureCheckConfiguration)architectureConfiguration).getIdentifyingPaths());
        }
        if ((duplicateCodeConfiguration = analyzerController.getConfiguration(CoreAnalyzerId.DUPLICATE_CODE)) != null && !(valueMap = duplicateCodeConfiguration.getValueMap()).isEmpty()) {
            ArrayList<String> duplicateCodeConfigurationEntries = new ArrayList<String>(valueMap.size());
            for (Map.Entry<String, Object> nextEntry : valueMap.entrySet()) {
                String nextName = nextEntry.getKey();
                Object nextValue = nextEntry.getValue();
                assert (nextValue != null && nextValue instanceof Integer) : "Unexpected class in method 'addDuplicateCodeConfigurationToXml': " + String.valueOf(nextValue);
                duplicateCodeConfigurationEntries.add(nextName + ":" + String.valueOf(nextValue));
            }
            report.setDuplicateCodeConfigurationEntries(duplicateCodeConfigurationEntries);
        }
        Analyzers analyzers = this.m_softwareSystem.getUniqueExistingChild(Files.class).getAnalyzers();
        if (!report.getUnavailableFeatures().contains((Object)SonargraphFeature.SCRIPTS_AUTOMATED)) {
            AnalyzerConfiguration scriptRunnerConfiguration = analyzerController.getConfiguration(CoreAnalyzerId.SCRIPT_RUNNER);
            assert (scriptRunnerConfiguration != null) : "ScriptRunner configuration must not be null";
            assert (scriptRunnerConfiguration instanceof ScriptRunnerConfiguration) : "Unexpected class in method 'addAnalyzerInfo': " + String.valueOf(scriptRunnerConfiguration);
            report.setScriptRunnerConfiguration((ScriptRunnerConfiguration)scriptRunnerConfiguration);
            Analyzer scriptRunner = analyzers.getUniqueChild(new NamedElement.IFilter(){

                @Override
                public boolean accept(NamedElement analyzer) {
                    if (!(analyzer instanceof Analyzer)) {
                        return false;
                    }
                    return ((Analyzer)analyzer).getId() == CoreAnalyzerId.SCRIPT_RUNNER;
                }
            }, Analyzer.class);
            if (scriptRunner == null) {
                return;
            }
            AnalyzerResult result = scriptRunner.getResult();
            if (result != null) {
                report.addScriptRunnerStatus(result.getUniqueChild(LastScriptRunnerExecutionStatus.class));
            }
        }
        if ((systemDiffConfiguration = analyzerController.getConfiguration(CoreAnalyzerId.SYSTEM_DIFF)) != null && (baselinePath = (systemDiffAnalyzerConfig = (SystemDiffAnalyzerConfiguration)systemDiffConfiguration).getBaselinePath()) != null) {
            report.setBaseline(baselinePath);
        }
        for (Analyzer analyzer : analyzers.getChildren(Analyzer.class)) {
            List<CycleAnalyzerConfiguration> cycleConfigs = analyzer.getChildren(CycleAnalyzerConfiguration.class);
            if (cycleConfigs.size() != 1) continue;
            report.addCycleAnalyzerConfiguration(cycleConfigs.get(0));
        }
        AnalyzerConfiguration qualityGateConfiguration = analyzerController.getConfiguration(CoreAnalyzerId.QUALITY_GATES);
        if (qualityGateConfiguration != null) {
            assert (qualityGateConfiguration instanceof QualityGateCheckConfiguration) : "Unexpected class in method 'addAnalyzerInfo': " + String.valueOf(qualityGateConfiguration);
            report.setQualityGateCheckConfigurationEntries(((QualityGateCheckConfiguration)qualityGateConfiguration).getIdentifyingPaths());
        }
    }

    private void saveHtmlReport(IWorkerContext context, IReport report, IReportExtension.CreateReportRequest request, String diffReportName, OperationResult result) {
        assert (context != null) : "Parameter 'context' of method 'saveReport' must not be null";
        assert (report != null) : "Parameter 'report' of method 'saveHtmlReport' must not be null";
        assert (request != null) : "Parameter 'request' of method 'saveHtmlReport' must not be null";
        assert (result != null) : "Parameter 'result' of method 'saveReport' must not be null";
        ReportHtmlWriter persistence = new ReportHtmlWriter(report);
        int maxMetricValueRowCount = request.getMaxRowCountPerMetricForHtml();
        int metricValueRowCount = maxMetricValueRowCount > 0 ? maxMetricValueRowCount : 25;
        persistence.storeReportToFile(context, report.getTargetFile(), metricValueRowCount, request.getElementCountToSplitHtmlReport(), request.getMaxElementCountForHtmlDetailsPage(), report.getFocus(), diffReportName, result);
    }

    private void cleanUpTargetDirectory(IReport report, TFile targetDirectory, OperationResult result, boolean targetDirectoryAlreadyExists) {
        block12: {
            assert (report != null) : "Parameter 'report' of method 'cleanUpTargetDirectory' must not be null";
            assert (targetDirectory != null) : "Parameter 'targetDirectory' of method 'cleanUpTargetDirectory' must not be null";
            assert (result != null) : "Parameter 'result' of method 'cleanUpTargetDirectory' must not be null";
            try {
                try {
                    if (!targetDirectoryAlreadyExists) {
                        targetDirectory.rm_r();
                    } else {
                        for (IBasicReport moduleReport : report.getModuleReports()) {
                            String fileName = FileUtility.getFileNameWithoutExtension((TFile)moduleReport.getTargetFile());
                            TFile[] tFileArray = FileUtility.listFilesInDir((TFile)targetDirectory, (String)(fileName + ".*"));
                            int n = tFileArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TFile next = tFileArray[n2];
                                next.rm();
                                ++n2;
                            }
                        }
                    }
                }
                catch (IOException ex) {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE_DIRECTORY, (Throwable)ex);
                    report.setTargetFile(null);
                    report.getModuleReports().forEach(r -> r.setTargetFile(null));
                    break block12;
                }
            }
            catch (Throwable throwable) {
                report.setTargetFile(null);
                report.getModuleReports().forEach(r -> r.setTargetFile(null));
                throw throwable;
            }
            report.setTargetFile(null);
            report.getModuleReports().forEach(r -> r.setTargetFile(null));
        }
    }

    private TFile createTargetFile(TFile targetDirectory, String reportFileName, IReport mainReport, OperationResult result, IFileType type, Date timestamp) {
        assert (targetDirectory != null) : "Parameter 'targetDirectory' of method 'createTargetFile' must not be null";
        assert (mainReport != null) : "Parameter 'mainReport' of method 'createTargetFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'createTargetFile' must not be null";
        assert (type != null) : "Parameter 'type' of method 'createTargetFile' must not be null";
        assert (timestamp != null) : "Parameter 'timestamp' of method 'createTargetFile' must not be null";
        boolean targetDirectoryExists = targetDirectory.exists();
        if (!targetDirectoryExists) {
            try {
                targetDirectory.mkdir(true);
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)ex);
                return null;
            }
        }
        TFile targetFile = new TFile((File)targetDirectory, reportFileName + type.getDefaultExtension());
        mainReport.setTargetFile(targetFile);
        return targetFile;
    }

    private String createMainReportFileName(String targetFileName, Date timestamp) {
        Object reportFileName = targetFileName != null && targetFileName.trim().length() > 0 ? targetFileName : this.m_softwareSystem.getName() + "_" + Iso8601DateFormat.formatDateAndTimeForFileName((Date)timestamp);
        return reportFileName;
    }

    @Override
    public List<IMetricLevel> getStandardMetricLevels() {
        ArrayList<CoreMetricLevel> metricLevels = new ArrayList<CoreMetricLevel>(2);
        metricLevels.add(CoreMetricLevel.SYSTEM);
        metricLevels.add(CoreMetricLevel.MODULE);
        return Collections.unmodifiableList(metricLevels);
    }

    private void addMetrics(IWorkerContext context, Report report, List<IMetricLevel> metricLevels, AnalyzerExecutionLevel analyzerExecutionLevel) {
        assert (context != null) : "Parameter 'context' of method 'addMetrics' must not be null";
        assert (report != null) : "Parameter 'report' of method 'createReport' must not be null";
        assert (metricLevels != null) : "Parameter 'metricLevels' of method 'createReport' must not be null";
        assert (analyzerExecutionLevel != null) : "Parameter 'analyzerExecutionLevel' of method 'addMetrics' must not be null";
        IThresholdExtension thresholdExtension = this.m_softwareSystem.getExtension(IThresholdExtension.class);
        thresholdExtension.getThresholds(true).forEach(th -> report.addThreshold((IMetricThreshold)th));
        MetricsExtension metricsExtension = this.m_softwareSystem.getExtension(ISoftwareSystemController.class).getInstallation().getExtension(MetricsExtension.class);
        context.beginBlockOfWork(metricLevels.size());
        for (IMetricLevel level : metricLevels) {
            for (IMetricDescriptor metric : metricsExtension.getAvailableMetricDescriptorsForLevel(level, true)) {
                IMetricDescriptor descriptor = metricsExtension.findMetricByIdAndLevel(metric.getMetricId(), level);
                if (descriptor == null) continue;
                for (IMetricValue iMetricValue : metricsExtension.getMetricValues(this.m_softwareSystem, descriptor, true)) {
                    if (context.hasBeenCanceled()) {
                        return;
                    }
                    NamedElement associatedElement = iMetricValue.getAssociatedElement();
                    assert (associatedElement != null) : "Associated element must not be null";
                    if (level == CoreMetricLevel.SYSTEM) {
                        report.addSystemLevelMetricAndValue(descriptor, iMetricValue);
                        continue;
                    }
                    if (this.isLogicalSystemElement(associatedElement)) {
                        report.addSystemElementMetricAndValue(descriptor, level, iMetricValue, associatedElement);
                        continue;
                    }
                    Module module = this.getModuleOfElement(associatedElement);
                    if (associatedElement == module) assert (level == CoreMetricLevel.MODULE) : "Unexpected level: " + level.getStandardName();
                    if (module != null) {
                        report.addModuleLevelMetricAndValue(module, level, metric, iMetricValue, associatedElement);
                        continue;
                    }
                    report.addSystemElementMetricAndValue(descriptor, level, iMetricValue, associatedElement);
                }
            }
            context.workItemCompleted();
        }
    }

    private boolean isLogicalSystemElement(NamedElement associatedElement) {
        return associatedElement instanceof LogicalSystemNamespace || associatedElement.getParent(LogicalSystemNamespace.class, new Class[0]) != null;
    }

    private Module getModuleOfElement(NamedElement associatedElement) {
        Module module = null;
        if (associatedElement instanceof Module) {
            module = (Module)associatedElement;
        } else {
            ModuleBasedLogicalNamespaceRoot root;
            module = associatedElement.getParent(Module.class, new Class[0]);
            if (module == null && (root = associatedElement.getParent(ModuleBasedLogicalNamespaceRoot.class, new Class[0])) != null) {
                module = root.getPhysicalElement();
            }
        }
        return module;
    }

    private void addIssues(IWorkerContext context, Report report) {
        assert (context != null) : "Parameter 'context' of method 'addIssues' must not be null";
        assert (report != null) : "Parameter 'report' of method 'addIssues' must not be null";
        context.beginBlockOfWork(1);
        report.setIssueCategories(Arrays.asList(IssueCategory.values()));
        VirtualModel currentModel = this.m_softwareSystem.getCurrentModel();
        IssueFilter filter = new IssueFilter(new IStandardEnumeration[0]);
        for (Issue next : currentModel.getIssueList(filter).getIssues()) {
            if (context.hasBeenCanceled()) {
                return;
            }
            if (next instanceof NamedElementIssue) {
                report.addElementIssue((NamedElementIssue)next);
                continue;
            }
            if (next instanceof DependencyIssue) {
                report.addDependencyIssue((DependencyIssue)next);
                continue;
            }
            LOGGER.error("Unsupported issue type '" + next.getClass().getName() + "'");
        }
        context.workItemCompleted();
    }

    private void addIssueRankings(IWorkerContext context, Report report) {
        assert (context != null) : "Parameter 'context' of method 'addIssueRankings' must not be null";
        assert (report != null) : "Parameter 'report' of method 'addIssueRankings' must not be null";
        if (context.hasBeenCanceled()) {
            return;
        }
        IIssueRankingProvider rankingProvider = this.m_softwareSystem.getExtension(IIssueRankingProvider.class);
        List<IssueRank> rankings = rankingProvider.getRankings();
        if (rankings != null) {
            if (rankings.size() > 100) {
                report.setIssueRankings(rankings.subList(0, 100));
            } else {
                report.setIssueRankings(rankings);
            }
        }
    }

    private void addResolutions(IWorkerContext context, Report report) {
        assert (context != null) : "Parameter 'context' of method 'addResolutions' must not be null";
        assert (report != null) : "Parameter 'report' of method 'addResolutions' must not be null";
        context.beginBlockOfWork(1);
        VirtualModel currentModel = this.m_softwareSystem.getCurrentModel();
        for (Resolution next : currentModel.getChildren(Resolution.class)) {
            if (context.hasBeenCanceled()) {
                return;
            }
            report.addResolution(next);
        }
        context.workItemCompleted();
    }

    @Override
    public OperationResultWithOutcome<TFile> exportMetaData(IWorkerContext workerContext, List<IMetricId> metricIds, List<IProviderId> issueProviderIds, List<IIssueId> issueIds, TFile targetFile) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'exportMetaData' must not be null";
        assert (metricIds != null) : "Parameter 'metricIds' of method 'exportMetaData' must not be null";
        assert (issueProviderIds != null && !issueProviderIds.isEmpty()) : "Parameter 'issueProviderIds' of method 'exportMetaData' must not be empty";
        assert (issueIds != null && !issueIds.isEmpty()) : "Parameter 'issueIds' of method 'exportMetaData' must not be empty";
        assert (targetFile != null) : "Parameter 'targetFile' of method 'exportMetaData' must not be null";
        Map<IMetricId, List<IMetricLevel>> metricIdToLevelMap = this.getMetricIdToLevelMap(metricIds);
        ExportMetaDataXmlWriter xmlWriter = new ExportMetaDataXmlWriter(this.m_installation.getVersion(), this.m_softwareSystem.getUniqueExistingChild(Files.class).getSystemDirectory().getFile().getNormalizedAbsolutePath(), this.m_softwareSystem.getId(), metricIdToLevelMap, Arrays.asList(IssueCategory.values()), issueProviderIds, issueIds);
        OperationResultWithOutcome result = new OperationResultWithOutcome("Exporting Metric Meta-Data");
        xmlWriter.writeToFile(targetFile, (OperationResult)result);
        if (result.isSuccess()) {
            result.setOutcome((Object)targetFile);
        }
        return result;
    }

    private Map<IMetricId, List<IMetricLevel>> getMetricIdToLevelMap(List<IMetricId> relevantMetricIds) {
        assert (relevantMetricIds != null) : "Parameter 'relevantMetricIds' of method 'getMetricIdToLevelMap' must not be null";
        TreeMap<IMetricId, ArrayList<IMetricLevel>> metricIdToLevelMap = new TreeMap<IMetricId, ArrayList<IMetricLevel>>(Comparator.comparing(IStandardEnumeration::getStandardName));
        IMetricsProvider metricsProvider = this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class).getInstallation().getExtension(IMetricsProvider.class);
        for (IMetricLevel nextLevel : metricsProvider.getAvailableElementMetricLevels(true, true)) {
            for (IMetricDescriptor nextDescriptor : metricsProvider.getAvailableMetricDescriptorsForLevel(nextLevel, true)) {
                if (!relevantMetricIds.contains(nextDescriptor.getMetricId())) continue;
                ArrayList<IMetricLevel> levels = (ArrayList<IMetricLevel>)metricIdToLevelMap.get(nextDescriptor.getMetricId());
                if (levels == null) {
                    levels = new ArrayList<IMetricLevel>();
                    metricIdToLevelMap.put(nextDescriptor.getMetricId(), levels);
                }
                levels.add(nextLevel);
            }
        }
        return Collections.unmodifiableMap(metricIdToLevelMap);
    }

    @Override
    public Map<IMetricCategory, List<IMetricId>> getAvailableMetricIds(IWorkerContext context) {
        assert (context != null) : "Parameter 'context' of method 'getAvailableMetricIds' must not be null";
        IAnalyzerController analyzerController = this.m_softwareSystem.getExtension(IAnalyzerController.class);
        analyzerController.waitForAnalyzersToComplete(context);
        HashMap<IMetricCategory, TreeSet<IMetricId>> metricIdsMap = new HashMap<IMetricCategory, TreeSet<IMetricId>>();
        for (IMetricId next : this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class).getInstallation().getExtension(IMetricsProvider.class).getAvailableMetricIds()) {
            TreeSet<IMetricId> metricsOfCategory;
            IMetricCategory mainCategory = next.getCategories().get(0);
            if (!metricIdsMap.containsKey(mainCategory)) {
                metricsOfCategory = new TreeSet<IMetricId>(new IMetricId.IdComparator());
                metricIdsMap.put(mainCategory, metricsOfCategory);
            } else {
                metricsOfCategory = (TreeSet<IMetricId>)metricIdsMap.get(mainCategory);
            }
            metricsOfCategory.add(next);
        }
        TreeMap<IMetricCategory, List<IMetricId>> result = new TreeMap<IMetricCategory, List<IMetricId>>(new IMetricCategory.CategoryComparator());
        for (Map.Entry next : metricIdsMap.entrySet()) {
            result.put((IMetricCategory)next.getKey(), new ArrayList((Collection)next.getValue()));
        }
        return result;
    }

    @Override
    public List<IProviderId> getIssueProviderIds(IWorkerContext context) {
        assert (context != null) : "Parameter 'context' of method 'getIssueProviderIds' must not be null";
        IAnalyzerController analyzerController = this.m_softwareSystem.getExtension(IAnalyzerController.class);
        analyzerController.waitForAnalyzersToComplete(context);
        return this.m_installation.getAvailableIssueProviderIds().stream().sorted((p1, p2) -> p1.getStandardName().compareTo(p2.getStandardName())).collect(Collectors.toList());
    }

    @Override
    public List<IIssueId> getIssueIds(IWorkerContext context) {
        assert (context != null) : "Parameter 'context' of method 'getIssueIds' must not be null";
        IAnalyzerController analyzerController = this.m_softwareSystem.getExtension(IAnalyzerController.class);
        analyzerController.waitForAnalyzersToComplete(context);
        List filtered = this.m_installation.getAvailableIssueIds().stream().filter(id -> !id.previewOnly()).sorted((id1, id2) -> id1.getStandardName().compareTo(id2.getStandardName())).collect(Collectors.toCollection(() -> new ArrayList()));
        if (!filtered.contains(ArchitectureViolationIssueId.INSTANCE)) {
            filtered.add(ArchitectureViolationIssueId.INSTANCE);
        }
        if (!filtered.contains(QualityGateIssueId.INSTANCE)) {
            filtered.add(QualityGateIssueId.INSTANCE);
        }
        return filtered;
    }

    public TFile getPreviousDiffReportFile(boolean onlyIfExists) {
        TFile file = new TFile((File)this.m_softwareSystem.getUniqueExistingChild(Files.class).getHiddenDataDirectory(), "system-previous.xml");
        if (onlyIfExists) {
            return file.exists() ? file : null;
        }
        return file;
    }

    public TFile getCurrentDiffReportFile(boolean onlyIfExists) {
        TFile file = new TFile((File)this.m_softwareSystem.getUniqueExistingChild(Files.class).getHiddenDataDirectory(), "system-current.xml");
        if (onlyIfExists) {
            return file.exists() ? file : null;
        }
        return file;
    }

    public static enum MessageCause implements OperationResult.IMessageCause
    {
        WRONG_SYSTEM_STATE,
        FAILED_TO_LOAD_XML_REPORT,
        FAILED_TO_LOAD_BASELINE_SYSTEM_XML_REPORT,
        FAILED_TO_LOAD_CURRENT_SYSTEM_XML_REPORT,
        NO_PREVIOUS_SYSTEM_REPORT_FOUND,
        UNSUPPORTED_VERSION;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

