/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.math.BigDecimal;

public class NumberFormatValidator
implements ITextValidator {
    private final Number m_lowerBorder;
    private final Number m_upperBorder;
    private final boolean m_isDecimal;

    public NumberFormatValidator(Number lowerBorder, Number upperBorder, boolean isDecimal) {
        this.m_lowerBorder = lowerBorder != null ? lowerBorder : new BigDecimal(Integer.MIN_VALUE);
        this.m_upperBorder = upperBorder != null ? upperBorder : new BigDecimal(Integer.MAX_VALUE);
        this.m_isDecimal = isDecimal;
    }

    @Override
    public ValidationResult isValid(String initialInput, String newInput) {
        int numberOfDecimalDigits;
        ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)initialInput, (String)newInput));
        if (newInput == null || newInput.trim().length() == 0) {
            result.addError("Must not be empty");
            newInput = "";
        }
        String trimmedInput = newInput.trim();
        int decimalIndex = trimmedInput.indexOf(NumberUtility.getDecimalSeparator());
        if (!this.m_isDecimal && decimalIndex > -1) {
            result.addError("No decimal number allowed");
            return result;
        }
        Number number = NumberUtility.parse((String)trimmedInput, (!this.m_isDecimal ? 1 : 0) != 0, (boolean)true);
        if (number == null) {
            result.addError("Invalid number format");
            return result;
        }
        int n = numberOfDecimalDigits = decimalIndex < 0 ? 0 : trimmedInput.length() - decimalIndex - 1;
        if (numberOfDecimalDigits > 2) {
            result.addError("Only up to 2 decimal digits supported");
            return result;
        }
        int groupingIndex = trimmedInput.indexOf(NumberUtility.getGroupingSeparator());
        if (groupingIndex == 0) {
            result.addError("Number must not start with grouping character '" + NumberUtility.getGroupingSeparator() + "'");
            return result;
        }
        if (decimalIndex > -1 && groupingIndex > decimalIndex) {
            result.addError("Wrong position of grouping character '" + NumberUtility.getGroupingSeparator() + "'");
            return result;
        }
        boolean endReached = false;
        while (!endReached && groupingIndex > 0) {
            int nextGroupingIndex = trimmedInput.indexOf(NumberUtility.getGroupingSeparator(), groupingIndex + 1);
            if (nextGroupingIndex == -1) {
                nextGroupingIndex = trimmedInput.indexOf(NumberUtility.getDecimalSeparator());
                endReached = true;
            }
            if (nextGroupingIndex == -1) {
                nextGroupingIndex = trimmedInput.length();
                endReached = true;
            }
            if ((nextGroupingIndex - (groupingIndex + 1)) % 3 != 0) {
                result.addError("Wrong position of grouping character '" + NumberUtility.getGroupingSeparator() + "'");
                return result;
            }
            groupingIndex = nextGroupingIndex;
        }
        if (this.m_lowerBorder != null) {
            if (!this.m_isDecimal && number.longValue() < this.m_lowerBorder.longValue()) {
                result.addError("Number must not be lower than '" + NumberUtility.format((Number)this.m_lowerBorder, (boolean)true) + "'");
                return result;
            }
            if (this.m_isDecimal && number.doubleValue() < this.m_lowerBorder.doubleValue()) {
                result.addError("Number must not be lower than '" + NumberUtility.format((Number)this.m_lowerBorder, (boolean)true) + "'");
                return result;
            }
        }
        if (this.m_upperBorder != null) {
            if (!this.m_isDecimal && number.longValue() > this.m_upperBorder.longValue()) {
                result.addError("Number must not be lower than '" + NumberUtility.format((Number)this.m_lowerBorder, (boolean)true) + "'");
                return result;
            }
            if (this.m_isDecimal && number.doubleValue() > this.m_upperBorder.doubleValue()) {
                result.addError("Number must not be greater than '" + NumberUtility.format((Number)this.m_upperBorder, (boolean)true) + "'");
                return result;
            }
        }
        return result;
    }
}

