/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.AnalyzerExtension;
import com.hello2morrow.sonargraph.core.controller.system.analysis.IssueRankingAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementProxy;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.ranking.IIssueRankingProvider;
import com.hello2morrow.sonargraph.core.model.system.ranking.IssueRank;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.List;

public class IssueRankingExtension
extends Extension
implements IIssueRankingProvider {
    private final SoftwareSystem m_softwareSystem;

    public IssueRankingExtension(SoftwareSystem softwareSystem) {
        this.m_softwareSystem = softwareSystem;
    }

    @Override
    public List<IssueRank> getRankings(List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'getRankings' must not be null";
        AnalyzerExtension analyzerExtension = this.m_softwareSystem.getExtension(AnalyzerExtension.class);
        AnalyzerResult result = analyzerExtension.getResultFor(CoreAnalyzerId.ISSUE_RANKING);
        if (result == null) {
            return null;
        }
        THashSet relevantElements = new THashSet();
        IssueFilter filter = IssueRankingAnalyzerAdapter.createIssueFilter();
        for (Element next : elements) {
            NamedElementProxy proxy;
            NamedElement cycleGroup;
            if (next instanceof Issue && filter.accept((Issue)next)) {
                relevantElements.add(next);
                continue;
            }
            if (next instanceof DuplicateCodeBlock || next instanceof CycleGroup) {
                relevantElements.add(next);
                continue;
            }
            if (next instanceof DuplicateCodeBlockOccurrence) {
                relevantElements.add(((DuplicateCodeBlockOccurrence)next).getParent());
                continue;
            }
            if (!(next instanceof NamedElementProxy) || (cycleGroup = (NamedElement)(proxy = (NamedElementProxy)next).getParent(CycleGroup.class, new Class[0])) == null) continue;
            relevantElements.add(cycleGroup);
        }
        ArrayList<IssueRank> rankings = new ArrayList<IssueRank>();
        for (IssueRank next : result.getChildren(IssueRank.class)) {
            if (relevantElements.contains(next.getRankedElement())) {
                rankings.add(next);
            } else if ((next.getRankedElement() instanceof DuplicateCodeBlockIssue || next.getRankedElement() instanceof CycleGroupIssue) && relevantElements.contains(((Issue)next.getRankedElement()).getAffectedElement())) {
                rankings.add(next);
            }
            if (rankings.size() == relevantElements.size()) break;
        }
        return rankings;
    }

    @Override
    public List<IssueRank> getRankings() {
        IAnalyzerController analyzerExtension = this.m_softwareSystem.getExtension(IAnalyzerController.class);
        AnalyzerResult result = analyzerExtension.getResultFor(CoreAnalyzerId.ISSUE_RANKING);
        if (result == null) {
            return null;
        }
        return result.getChildren(IssueRank.class);
    }
}

