/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.remoting;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IRemoteSelectionExtension;
import com.hello2morrow.sonargraph.core.model.remoting.SelectionData;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import java.util.List;

public final class DetermineNamedElementsToSelectCommand
extends SoftwareSystemBasedCommand<IInteraction> {
    public DetermineNamedElementsToSelectCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.DETERMINE_ELEMENTS_TO_SELECT;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        OperationResultWithOutcome<StrictPair<List<SelectionData>, List<String>>> elements = this.getController().getInstallation().getExtension(IRemoteSelectionExtension.class).determineElementsToSelect(workerContext);
        ((IInteraction)this.getInteraction()).handleSelection(elements);
    }

    @Override
    protected boolean isUndoable() {
        return false;
    }

    @Override
    public Result isEnabled() {
        Result result = super.isEnabled();
        if (result.isFailure()) {
            return result;
        }
        if (!this.getController().getInstallation().getExtension(IRemoteSelectionExtension.class).hasRemoteSelection()) {
            result.addErrorMessage("Missing remote selection request");
        }
        return result;
    }

    public static interface IInteraction
    extends ICommandInteraction {
        public void handleSelection(OperationResultWithOutcome<StrictPair<List<SelectionData>, List<String>>> var1);
    }
}

