/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitecturalViewExtension;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewStructureMode;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;

public final class CreateArchitecturalViewCommand
extends ArchitecturalViewCommand<ICreateArchitecturalViewInteraction> {
    public CreateArchitecturalViewCommand(ISoftwareSystemProvider provider, ICreateArchitecturalViewInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.CREATE_ARCHITECTURAL_VIEW;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        CreateArchitecturalViewData createData = new CreateArchitecturalViewData();
        if (((ICreateArchitecturalViewInteraction)this.getInteraction()).collect(createData)) {
            OperationResultWithOutcome<ArchitecturalViewFile> result;
            IArchitecturalViewExtension extension = this.getController().getSoftwareSystem().getExtension(IArchitecturalViewExtension.class);
            ArchitecturalViewFile basedOn = createData.getBasedOn();
            if (basedOn != null) {
                result = extension.create(workerContext, createData.getName(), createData.getDescription(), basedOn);
            } else {
                ExplorationViewStructureMode mode = createData.getMode();
                assert (mode != null) : "'mode' of method 'internalRun' must not be null";
                result = extension.create(workerContext, createData.getName(), createData.getDescription(), mode);
            }
            ((ICreateArchitecturalViewInteraction)this.getInteraction()).processCreateArchitecturalViewResult(result);
        }
    }

    public static final class CreateArchitecturalViewData
    implements IArchitecturalViewCommandInteractionData {
        private String m_name;
        private String m_description;
        private ExplorationViewStructureMode m_mode;
        private ArchitecturalViewFile m_basedOn;

        CreateArchitecturalViewData() {
        }

        public void setData(String name, String description, ExplorationViewStructureMode mode) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setData' must not be empty";
            assert (description != null) : "Parameter 'description' of method 'setData' must not be null";
            assert (mode != null) : "Parameter 'mode' of method 'setData' must not be null";
            this.m_name = name;
            this.m_description = description;
            this.m_mode = mode;
            this.m_basedOn = null;
        }

        public void setData(String name, String description, ArchitecturalViewFile basedOn) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setData' must not be empty";
            assert (description != null) : "Parameter 'description' of method 'setData' must not be null";
            assert (basedOn != null) : "Parameter 'basedOn' of method 'setData' must not be null";
            this.m_name = name;
            this.m_description = description;
            this.m_mode = null;
            this.m_basedOn = basedOn;
        }

        String getName() {
            assert (this.m_name != null) : "'m_name' of method 'getName' must not be null";
            return this.m_name;
        }

        String getDescription() {
            assert (this.m_description != null) : "'m_description' of method 'getDescription' must not be null";
            return this.m_description;
        }

        ExplorationViewStructureMode getMode() {
            return this.m_mode;
        }

        ArchitecturalViewFile getBasedOn() {
            return this.m_basedOn;
        }
    }

    public static interface ICreateArchitecturalViewInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(CreateArchitecturalViewData var1);

        public void processCreateArchitecturalViewResult(OperationResultWithOutcome<ArchitecturalViewFile> var1);
    }
}

