<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <style type="text/css" MEDIA="all">@import url("hello2morrow.css");</style>
        <script src="tablefilter/tablefilter.js"></script>
        <title>Sonargraph Architect Report - Resolution Details for Issue Type <%=issueId.getPresentationName()%></title>
    </head>

    <body>
        <a name="top"></a>
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td width="200" bgcolor="#333333"><img src="spacer.gif" alt="" width="200" height="65" border="0"></td>
                <td width="23" bgcolor="E3E4E5"><img src="spacer.gif" width="23" height="1"></td>
                <td width="100%" bgcolor="E3E4E5">
                    <table border="0" cellspacing="0" cellpadding="0">
                        <tr>
                            <td width="7" bgcolor="e3e4e5"><img src="spacer.gif" width="7" height="1"></td>
                            <td><img src="hello2morrow.gif" alt="hello2morrow" width="227" height="23" border="0"></td>
                            <td width="100%" align="right" bgcolor="e3e4e5"><img src="header.gif" alt="hello2morrow" width="543" height="65" border="0"></td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td colspan="3" bgcolor="#000000"></td>
            </tr>
            <tr>
<!-- start of navigation -->            
                <td bgcolor="#A7A9AC" valign="top">
                    <div class="leftNav">
                    </div>
                </td>
<!-- end of navigation -->
                <!-- start of spacer -->
                <td width="23"><img src="spacer.gif" width="23" height="1"></td><!-- end of spacer -->
                
                <!-- real content -->
                <td width="100%">
                    <table width="100%" border="0">
                        <tr>
                            <td width="1%" height="80" valign="center">
                                <image src="logo.gif" width="350"></image>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <h1><a name="system"></a>Resolution Details for Issues (<%=issueId.getPresentationName()%>) of: <%= report.title %></h1>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <strong>Path: </strong><%= report.systemDirectoryPath %><br/>
                                <strong>System Description: </strong><%= report.softwareSystem.description %><br/>
                                <strong>Sonargraph Version: </strong><%= report.version %><br/>
                                <strong>Report Creation: </strong><%= report.timestampString %><br/>
                                <%
                                if (report.getFocus() == com.hello2morrow.sonargraph.core.model.report.IBasicReport.Focus.MODULE_LEVEL)
                                {
                                	com.hello2morrow.sonargraph.core.model.report.ModuleReport moduleReport = (com.hello2morrow.sonargraph.core.model.report.ModuleReport) report;
                                	String systemReportFileName = moduleReport.getMainReportTargetFile().getName();
                                	String moduleReportFileName = report.getTargetFile().getName();
								%>
									<strong>Link to Main System Report: </strong><a href="./<%=systemReportFileName%>" target="<%=systemReportFileName%>"><%=systemReportFileName%></a><br/>
									<strong>Link to Main Module Report: </strong><a href="./<%=moduleReportFileName%>" target="<%=moduleReportFileName%>"><%=moduleReportFileName%></a><br/>
								<%                                		
                                }
                                else
                                {
                                %>
                                	<strong>Link to Main Report: </strong><a href="./<%=report.getTargetFile().getName()%>" target="<%=report.getTargetFile().getName()%>"><%=report.getTargetFile().getName()%></a><br/>
                                <%
                                }
                                %>
                                <strong>Current Virtual Model: </strong><%= report.currentVirtualModel %> <br/>
                                <%
                                    if (report.getActiveProfile() != null && report.getActiveProfile().length() > 0)
                                    {
                                %>
                                        <strong>Workspace Profile: </strong><%= report.activeProfile %> <br/>
                                <%
                                    }
                                %>
                                <%
                                    if (report.getQualityModelPath() != null && report.getQualityModelPath().length() > 0)
                                    {
                                %>
                                        <strong>Quality Model: </strong><%= report.qualityModelPath %> <br/>
                                <%
                                    }
                                %>
                                <%
                                if(truncated)
                                {
                                %>
                                <strong>NOTE: List of resolutions has been truncated to contain only <%=resolutions.size()%> of <%=totalCount%> entries!</strong>
                                <%
                                }
                                %>
                                <%
                                if (diffReport != null)
                                {
                                %>
                                	<strong>System Diff Report: </strong><a href="<%= diffReport%>#ignore"><%= diffReport%></a> <br/>
                                <%
                                }
                                %> 
                            </td>
                        </tr>
                         <tr>
                            <td><h2><a name="resolutions"></a>Resolutions (<%=resolutions.size()%><% if (truncated) out.print(" of " + totalCount)%>) for Issues of Type "<%=issueId.getPresentationName()%>"</h2>
								<% 
                                if(truncated)
                                {
                                %>
	                            	To ensure usability, the list has been truncated to contain only the first <%=resolutions.size()%> of <%=totalCount%> resolutions.
                                <%
                                }
                                %>  
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <table width="100%" id="resolutions">
                                   	<thead>
	                                    <tr>
	                                        <th>Resolution Type</th>
	                                        <th>Description</th>
	                                        <th>Information</th>
	                                        <th>Date</th>
	                                        <th>Matched</th>
	                                        <th>Priority</th>
	                                        <th>Assignee</th>
	                                    </tr>
                                    </thead>
                                    <% 
                                    i = 0;
                                    for (com.hello2morrow.sonargraph.core.model.resolution.Resolution resolution : resolutions)
                                    {
                                        i++;
                                        out.println("<tr>");
                                        out.println("<td>");
                                        out.println(resolution.getPresentationKind());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(resolution.getDescription());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(resolution.getInformation());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(report.getDate(resolution.getDate()));
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(resolution.getMatchingElementsCount());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(resolution.getPriority().getPresentationName());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(resolution.getAssignee());
                                        out.println("</td>");
                                        out.println("</tr>");
                                    }
                                    %>
                                </table>
                            	<script>
                            		var rowCount = <%=i%>;
                            		var rowCounts = [25, 50];
                            		if (rowCount > 50)
                            		{
                            			rowCounts = [25, 50, rowCount];
                            		}
                            		
                            		var enablePaging = rowCount > 25;
                            		
						    		var filtersConfig = {
										base_path: 'tablefilter/',
						        		extensions:[{
							          		name: 'sort',
							          		types: ['string', 'string', 'string', 'string', 'number', 'string', 'string']								          		
						        		}],
										alternate_rows: true,
										rows_counter: true,
						            	rows_counter_text: 'Resolutions: ',
						            	btn_reset: true,
						            	status_bar: true,
						            	loader: true,
										mark_active_columns: true,
										highlight_keywords: true,
										paging: enablePaging,
								        results_per_page: ['Resolutions/Page: ', rowCounts],
								       	col_widths: ['8px', '25px', '25px', '7px', '7px', '7px', '7px'],
						        		themes: [{ name: 'default' }]
								    };
									var tf = new TableFilter('resolutions', filtersConfig);
									tf.init();
								</script>
                            </td>
                        </tr>
                    </table>
                </td>
                
    <!-- end of real content -->
            </tr>
        </table>
    </body>
</html>