/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.diff;

import com.hello2morrow.sonargraph.core.model.resolution.ResolutionKind;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.SoftwareSystemDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.CycleGroupIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.CyclicElementDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.DuplicateCodeBlockIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.DuplicateCodeBlockOccurrenceDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IssuesDiff;
import com.hello2morrow.sonargraph.core.persistence.diff.AbstractHtmlInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class IssueInfo
extends AbstractHtmlInfo {
    private final IssuesDiff m_issuesDiff;
    private final List<CycleGroupIssueDiff> m_cycleDiffs;
    private final List<DuplicateCodeBlockIssueDiff> m_duplicateDiffs;

    public IssueInfo(SoftwareSystemDiff softwareSystemDiff) {
        super(softwareSystemDiff);
        this.m_issuesDiff = softwareSystemDiff.getUniqueExistingChild(IssuesDiff.class);
        this.m_cycleDiffs = this.removeUnmodifiedChildrenFromList(this.m_issuesDiff.getChildren(CycleGroupIssueDiff.class));
        this.m_cycleDiffs.sort(new Comparator<CycleGroupIssueDiff>(){

            @Override
            public int compare(CycleGroupIssueDiff o1, CycleGroupIssueDiff o2) {
                return Integer.compare(o1.getChange().ordinal(), o2.getChange().ordinal());
            }
        });
        this.m_duplicateDiffs = this.removeUnmodifiedChildrenFromList(this.m_issuesDiff.getChildren(DuplicateCodeBlockIssueDiff.class));
        this.m_duplicateDiffs.sort(new Comparator<DuplicateCodeBlockIssueDiff>(){

            @Override
            public int compare(DuplicateCodeBlockIssueDiff o1, DuplicateCodeBlockIssueDiff o2) {
                return Integer.compare(o1.getChange().ordinal(), o2.getChange().ordinal());
            }
        });
    }

    public boolean hasChanges() {
        return this.m_issuesDiff.getChange() != IDiffElement.Change.UNMODIFIED;
    }

    public List<IIssueDiff> getIssueChanges() {
        List<IIssueDiff> issues = this.removeUnmodifiedChildrenFromList(this.m_issuesDiff.getIssuesWithoutUnchangedResolution());
        Collections.sort(issues, new Comparator<IIssueDiff>(){

            @Override
            public int compare(IIssueDiff o1, IIssueDiff o2) {
                return Integer.compare(o1.getChange().ordinal(), o2.getChange().ordinal());
            }
        });
        return issues;
    }

    public List<CycleGroupIssueDiff> getCycleChanges() {
        return this.m_cycleDiffs;
    }

    public boolean hasCycleChanges() {
        return !this.m_cycleDiffs.isEmpty();
    }

    public List<String> getCyclicElementNames(CycleGroupIssueDiff cycleDiff) {
        assert (cycleDiff != null) : "Parameter 'cycleDiff' of method 'getCyclicElementNames' must not be null";
        ArrayList<String> result = new ArrayList<String>();
        for (CyclicElementDiff next : cycleDiff.getChildren(CyclicElementDiff.class)) {
            if (next.getChange() == IDiffElement.Change.UNMODIFIED) continue;
            StringBuilder builder = new StringBuilder(next.getPresentationName(true));
            builder.append(" [").append(next.getChange().getPresentationName()).append("]");
            result.add(builder.toString());
        }
        return result;
    }

    public String getResolution(IIssueDiff issueDiff) {
        assert (issueDiff != null) : "Parameter 'issueDiff' of method 'getResolution' must not be null";
        ResolutionKind resolutionKind = issueDiff.getCurrentResolutionKind();
        return resolutionKind != null ? resolutionKind.getPresentationName() : "";
    }

    public boolean hasDuplicateChanges() {
        return !this.m_duplicateDiffs.isEmpty();
    }

    public List<DuplicateCodeBlockIssueDiff> getDuplicateChanges() {
        return this.m_duplicateDiffs;
    }

    public List<String> getDuplicateOccurrenceNames(DuplicateCodeBlockIssueDiff duplicateDiff) {
        assert (duplicateDiff != null) : "Parameter 'duplicateDiff' of method 'getDuplicateOccurrenceNames' must not be null";
        ArrayList<String> result = new ArrayList<String>();
        for (DuplicateCodeBlockOccurrenceDiff next : duplicateDiff.getChildren(DuplicateCodeBlockOccurrenceDiff.class)) {
            if (next.getChange() == IDiffElement.Change.UNMODIFIED) continue;
            StringBuilder builder = new StringBuilder(next.getPresentationName(true));
            builder.append(" [").append(next.getChange().getPresentationName()).append("]");
            result.add(builder.toString());
        }
        return result;
    }
}

