/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.workspace;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.model.element.IArchitectureFilterNamePrefixProvider;
import com.hello2morrow.sonargraph.core.model.element.IArchitectureFilterNameProvider;
import com.hello2morrow.sonargraph.core.model.element.ICloneableParent;
import com.hello2morrow.sonargraph.core.model.element.ILanguageScope;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IPhysicalContainer;
import com.hello2morrow.sonargraph.core.model.element.IUnmodifiableElement;
import com.hello2morrow.sonargraph.core.model.element.IWorkspaceFilterNamePrefixProvider;
import com.hello2morrow.sonargraph.core.model.element.IWorkspaceFilterNameProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IRootDirectoryKindProvider;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.UnresolvedWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotDependency;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.core.model.snapshot.SnapshotArgument;
import com.hello2morrow.sonargraph.core.model.workspace.ClosureComputer;
import com.hello2morrow.sonargraph.core.model.workspace.ComponentContainer;
import com.hello2morrow.sonargraph.core.model.workspace.IModule;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class Module
extends ComponentContainer
implements IModule,
IWorkspaceDependencyElement,
IRootDirectoryKindProvider,
ILanguageScope,
IPhysicalContainer,
IWorkspaceFilterNamePrefixProvider,
IWorkspaceFilterNameProvider,
IArchitectureFilterNamePrefixProvider,
IArchitectureFilterNameProvider,
ICloneableParent {
    public static final String IMAGE_RESOURCE_NAME = Module.class.getSimpleName();
    private final List<WorkspaceDependency> m_outgoingWorkspaceDependencies = new ArrayList<WorkspaceDependency>(5);
    private final List<WorkspaceDependency> m_incomingWorkspaceDependencies = new ArrayList<WorkspaceDependency>(5);
    private Set<IWorkspaceDependencyElement> m_closure = null;
    private String m_name;
    private String m_description = "";
    private String m_id;

    public static final UnresolvedWorkspaceDependencyElement addUnresolvedWorkspaceDependencyElement(NamedElement parent, final String name, final String id) {
        assert (parent != null) : "Parameter 'parent' of method 'getOrCreateUnresolvedWorkspaceDependencyElement' must not be null";
        assert (name != null) : "Parameter 'name' of method 'getOrCreateUnresolvedWorkspaceDependencyElement' must not be null";
        assert (id != null) : "Parameter 'id' of method 'getOrCreateUnresolvedWorkspaceDependencyElement' must not be null";
        UnresolvedWorkspaceDependencyElement unresolved = parent.getUniqueChild(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                UnresolvedWorkspaceDependencyElement unresolved = (UnresolvedWorkspaceDependencyElement)namedElement;
                return unresolved.getName().equalsIgnoreCase(name) && unresolved.getId().equalsIgnoreCase(id);
            }
        }, UnresolvedWorkspaceDependencyElement.class);
        if (unresolved == null) {
            unresolved = new UnresolvedWorkspaceDependencyElement(parent, name, id);
            parent.addChild(unresolved);
        }
        return unresolved;
    }

    public Module(NamedElement parent) {
        super(parent);
    }

    public Module(NamedElement parent, String name, String id) {
        this(parent);
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'Module' must not be empty";
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'Module' must not be empty";
        this.m_name = name;
        this.m_id = id;
    }

    public boolean isAutomatic() {
        return false;
    }

    @Override
    public final void dispose() {
        this.m_closure = null;
        this.m_outgoingWorkspaceDependencies.clear();
        this.m_incomingWorkspaceDependencies.clear();
        super.dispose();
    }

    @Override
    public final NamedElement getNamedElement() {
        return this;
    }

    @Override
    public final List<NamedElement> getChildren() {
        return this.getChildren(this.getParent(IModelServiceProvider.class, new Class[0]));
    }

    @Override
    public final String getDomainInfo() {
        return this.getShortName() + " [" + this.getDomain().getPresentationName() + " " + this.getLanguage().getPresentationName() + "]";
    }

    @Property
    public abstract IModuleType getType();

    public IPathValidator.PathType getRootDirectoryPathType() {
        return IPathValidator.PathType.DIRECTORY;
    }

    @Override
    @Property
    public final String getWorkspaceFilterName() {
        return this.getShortName() + "/**";
    }

    @Override
    public final String getWorkspaceFilterNamePrefix() {
        return this.getName() + "/";
    }

    @Override
    public final String getArchitectureFilterNamePrefix() {
        return this.getShortName() + "/";
    }

    @Override
    public final String getArchitectureFilterName() {
        return this.getShortName() + "/**";
    }

    public final List<RootDirectoryPath> getRelevantRootDirectoryPaths() {
        NamedElement.IFilter filter = new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                return !(namedElement instanceof IUnmodifiableElement);
            }
        };
        return this.getChildren(filter, RootDirectoryPath.class);
    }

    public abstract RootDirectoryPath createRootDirectoryPath(IModelServiceProvider var1, NamedElement var2, TFile var3);

    public abstract Class<? extends RootDirectoryPath> getRootDirectoryPathClass();

    public RootDirectoryPath createNonStandardRootDirectoryPath(IModelServiceProvider msp, NamedElement parent, TFile file) {
        assert (msp != null) : "Parameter 'msp' of method 'createNonStandardRootDirectoryPath' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'createNonStandardRootDirectoryPath' must not be null";
        assert (file != null) : "Parameter 'file' of method 'createNonStandardRootDirectoryPath' must not be null";
        assert (false) : "Subclasses need to implement this method if non-standard root directory paths are supported";
        return null;
    }

    public List<? extends RootDirectoryPath> getSourceRootDirectoryPaths() {
        return this.getChildren(RootDirectoryPath.class);
    }

    @Override
    public abstract String getRootDirectoryPathFileTypePresentationKind(boolean var1);

    @Override
    public String getRootDirectoryPathTypePresentationKind() {
        return this.getRootDirectoryPathType().getPresentationName();
    }

    public boolean hasWorkspaceDependencies() {
        return !this.m_incomingWorkspaceDependencies.isEmpty() || !this.m_outgoingWorkspaceDependencies.isEmpty();
    }

    @Override
    public final void addOutgoingWorkspaceDependency(WorkspaceDependency dependency) {
        this.addOutgoingWorkspaceDependencyAt(dependency, -1);
    }

    @Override
    public final void addOutgoingWorkspaceDependencyAt(WorkspaceDependency dependency, int pos) {
        assert (dependency != null) : "Parameter 'dependency' of method 'addWorkspaceDependencyTo' must not be null";
        assert (dependency.getFrom() != null && dependency.getFrom().getUnderlyingObject() == this) : "Startpoint of dependency to add must be 'this'";
        WorkspaceDependency existingDependency = this.getWorkspaceDependencyTo(dependency.getToId());
        if (existingDependency != null ? existingDependency.getTo() == dependency.getTo() && existingDependency.getType().equals(dependency.getType()) && (pos == -1 || this.m_outgoingWorkspaceDependencies.indexOf(existingDependency) == pos) : (existingDependency = this.getWorkspaceDependencyToName(dependency.getToName())) != null && existingDependency.getTo() == dependency.getTo() && existingDependency.getType().equals(dependency.getType()) && (pos == -1 || this.m_outgoingWorkspaceDependencies.indexOf(existingDependency) == pos)) {
            return;
        }
        int previousIndex = -1;
        if (existingDependency != null) {
            previousIndex = this.m_outgoingWorkspaceDependencies.indexOf(existingDependency);
            this.removeOutgoingWorkspaceDependency(existingDependency);
        }
        int newPos = pos;
        if (previousIndex != -1 && previousIndex < pos) {
            newPos = pos - 1;
        }
        if (dependency.getTo().getIncomingWorkspaceDependencies().stream().noneMatch(d -> d.getFrom().getName().equals(this.getName()))) {
            if (newPos < 0 || newPos > this.m_outgoingWorkspaceDependencies.size()) {
                this.m_outgoingWorkspaceDependencies.add(dependency);
            } else {
                this.m_outgoingWorkspaceDependencies.add(newPos, dependency);
            }
            dependency.getTo().addIncomingWorkspaceDependency(dependency);
            this.m_closure = null;
        }
    }

    @Override
    public void unlinkIncoming(WorkspaceDependency dep) {
        assert (dep != null) : "Parameter 'dep' of method 'unlinkIncoming' must not be null";
        this.m_incomingWorkspaceDependencies.remove(dep);
    }

    @Override
    public void unlinkOutgoing(WorkspaceDependency dep) {
        assert (dep != null) : "Parameter 'dep' of method 'unlinkOutgoing' must not be null";
        this.m_outgoingWorkspaceDependencies.remove(dep);
    }

    @Override
    public void removeOutgoingWorkspaceDependency(WorkspaceDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'removeOutgoingWorkspaceDependency' must not be null";
        assert (this.m_outgoingWorkspaceDependencies.contains(dependency)) : "Dependency not found: " + String.valueOf(dependency);
        dependency.remove();
        this.m_closure = null;
    }

    @Override
    public void removeIncomingWorkspaceDependency(WorkspaceDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'removeIncomingWorkspaceDependency' must not be null";
        assert (this.m_incomingWorkspaceDependencies.contains(dependency)) : "Dependency not found: " + String.valueOf(dependency);
        dependency.remove();
        this.m_closure = null;
    }

    @Override
    public final void addIncomingWorkspaceDependency(WorkspaceDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'addIncomingWorkspaceDependency' must not be null";
        assert (!WorkspaceDependency.collectionContainsDependency(this.m_incomingWorkspaceDependencies, dependency.getFrom().getName(), false)) : "Incoming dependency with the same origin already added: " + dependency.toString();
        this.m_incomingWorkspaceDependencies.add(dependency);
        this.m_closure = null;
    }

    @Override
    public final boolean canAccess(IWorkspaceDependencyElement element) {
        assert (element != null) : "Parameter 'element' of method 'canAccess' must not be null";
        if (this.m_closure == null) {
            this.m_closure = ClosureComputer.compute(this);
        }
        return this.m_closure.contains(element);
    }

    @Override
    public final List<IWorkspaceDependencyElement> getReferenced() {
        ArrayList<IWorkspaceDependencyElement> dependsUpon = new ArrayList<IWorkspaceDependencyElement>();
        for (WorkspaceDependency nextDependency : this.m_outgoingWorkspaceDependencies) {
            IWorkspaceDependencyElement nextTo = nextDependency.getTo();
            dependsUpon.add(nextTo);
        }
        return dependsUpon;
    }

    public List<Module> getReferencedToModules(boolean manuallyDefinedOnly) {
        ArrayList<Module> referencedModules = new ArrayList<Module>();
        for (WorkspaceDependency nextDependency : this.m_outgoingWorkspaceDependencies) {
            IWorkspaceDependencyElement nextTo;
            if (manuallyDefinedOnly && nextDependency.isGenerated() || !((nextTo = nextDependency.getTo()) instanceof Module)) continue;
            referencedModules.add((Module)nextTo);
        }
        return referencedModules;
    }

    public List<Module> getReferencedFromModules() {
        ArrayList<Module> referencedFromModules = new ArrayList<Module>();
        for (WorkspaceDependency nextDependency : this.m_incomingWorkspaceDependencies) {
            IWorkspaceDependencyElement nextFrom = nextDependency.getFrom();
            assert (nextFrom instanceof Module) : "Unexpected from workspace dependency element: " + String.valueOf(nextFrom);
            referencedFromModules.add((Module)nextFrom);
        }
        return referencedFromModules;
    }

    public List<WorkspaceDependency> getIncomingDependencies() {
        return Collections.unmodifiableList(this.m_incomingWorkspaceDependencies);
    }

    @Override
    public void remove() {
        this.clearOutgoingWorkspaceDependencies();
        this.clearIncomingWorkspaceDependencies();
        super.remove();
    }

    @Override
    public void clearIncomingWorkspaceDependencies() {
        this.m_closure = null;
        ArrayList<WorkspaceDependency> incoming = new ArrayList<WorkspaceDependency>(this.m_incomingWorkspaceDependencies);
        for (WorkspaceDependency next : incoming) {
            this.removeIncomingWorkspaceDependency(next);
        }
    }

    @Override
    public void clearOutgoingWorkspaceDependencies() {
        this.m_closure = null;
        ArrayList<WorkspaceDependency> outgoing = new ArrayList<WorkspaceDependency>(this.m_outgoingWorkspaceDependencies);
        for (WorkspaceDependency next : outgoing) {
            this.removeOutgoingWorkspaceDependency(next);
        }
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_id);
        writer.writeString(this.m_name);
        writer.writeString(this.m_description);
        for (WorkspaceDependency next : this.m_outgoingWorkspaceDependencies) {
            next.store(writer);
        }
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_id = reader.readString();
        this.m_name = reader.readString();
        this.m_description = reader.readString();
        for (WorkspaceDependency dep : this.m_outgoingWorkspaceDependencies) {
            dep.retrieve(reader);
            dep.getTo().addIncomingWorkspaceDependency(dep);
        }
    }

    @Override
    public void writeDependencyList(ISnapshotWriter writer) throws IOException {
        for (WorkspaceDependency dep : this.m_outgoingWorkspaceDependencies) {
            writer.writeString(dep.getClass().getName());
        }
        writer.writeString(null);
    }

    @Override
    public void readDependencyList(ISnapshotReader reader) throws IOException, ClassNotFoundException {
        WorkspaceDependency dependency;
        SnapshotArgument argument = new SnapshotArgument(IWorkspaceDependencyElement.class, this);
        while ((dependency = reader.read(WorkspaceDependency.class, argument)) != null) {
            assert (dependency.getFrom() == this);
            this.m_outgoingWorkspaceDependencies.add(dependency);
        }
    }

    @Override
    public final int getIndexOfOutgoingDependency(ISnapshotDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'getIndexOf' must not be null";
        int index = this.m_outgoingWorkspaceDependencies.indexOf(dependency);
        assert (index != -1) : "Dependency not found: " + String.valueOf(dependency);
        return index;
    }

    @Override
    public final WorkspaceDependency getOutgoingDependencyAt(int index) {
        return this.m_outgoingWorkspaceDependencies.get(index);
    }

    @Override
    public final WorkspaceDependency getOutgoingWorkspaceDependency(IWorkspaceDependencyElement to) {
        assert (to != null) : "Parameter 'to' of method 'getOutgoingWorkspaceDependency' must not be null";
        for (WorkspaceDependency nextOutgoingDependency : this.m_outgoingWorkspaceDependencies) {
            if (nextOutgoingDependency.getTo() != to) continue;
            return nextOutgoingDependency;
        }
        return null;
    }

    @Override
    public String getImageResourceName() {
        return IMAGE_RESOURCE_NAME;
    }

    @Override
    public final String getName() {
        return this.m_name;
    }

    @Override
    public abstract Language getLanguage();

    public final void setName(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setName' must not be empty";
        this.m_name = name;
    }

    @Override
    public final String getId() {
        return this.m_id;
    }

    @Override
    public final String getShortName() {
        return this.m_name;
    }

    public final void setDescription(String description) {
        assert (description != null) : "'description' must not be null";
        this.m_description = description;
    }

    @Override
    @Property
    public final String getDescription() {
        return this.m_description;
    }

    @Override
    public List<WorkspaceDependency> getOutgoingWorkspaceDependencies() {
        return Collections.unmodifiableList(this.m_outgoingWorkspaceDependencies);
    }

    @Override
    public List<WorkspaceDependency> getIncomingWorkspaceDependencies() {
        return Collections.unmodifiableList(this.m_incomingWorkspaceDependencies);
    }

    public WorkspaceDependency getWorkspaceDependencyTo(String toId) {
        assert (toId != null && toId.length() > 0) : "Parameter 'toId' of method 'getWorkspaceDependencyTo' must not be empty";
        for (WorkspaceDependency dependency : this.m_outgoingWorkspaceDependencies) {
            if (!dependency.getToId().equals(toId)) continue;
            return dependency;
        }
        return null;
    }

    public WorkspaceDependency getWorkspaceDependencyToName(String toName) {
        assert (toName != null && toName.length() > 0) : "Parameter 'toName' of method 'getWorkspaceDependencyTo' must not be empty";
        for (WorkspaceDependency dependency : this.m_outgoingWorkspaceDependencies) {
            if (!dependency.getToName().equals(toName)) continue;
            return dependency;
        }
        return null;
    }

    @Override
    public final NamedElement getUnderlyingObject() {
        return this;
    }

    @Override
    public final Collection<? extends INode.IEdge> getIncomingEdges() {
        return Collections.unmodifiableList(this.m_incomingWorkspaceDependencies);
    }

    protected boolean includeAsOutgoing(IWorkspaceDependencyElement to) {
        return true;
    }

    @Override
    public final Collection<? extends INode.IEdge> getOutgoingEdges() {
        ArrayList<WorkspaceDependency> resolved = new ArrayList<WorkspaceDependency>();
        for (WorkspaceDependency next : this.m_outgoingWorkspaceDependencies) {
            if (!this.includeAsOutgoing(next.getTo())) continue;
            resolved.add(next);
        }
        return resolved;
    }

    public void clearClosure() {
        this.m_closure = null;
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitModule(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        for (WorkspaceDependency next : this.getOutgoingWorkspaceDependencies()) {
            builder.append("\n");
            builder.append("Workspace dependency to: ");
            builder.append(next.getToName());
        }
        return builder.toString();
    }

    @Override
    public boolean ignoreInModelRepresentation() {
        return false;
    }

    public boolean supportsWorkspaceProfiles() {
        return false;
    }

    @Override
    public boolean isModule() {
        return true;
    }

    public static interface IModuleType
    extends IStandardEnumeration {
        public Language getLanguage();
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitModule(Module var1);
    }
}

