/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.treemap;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapLeafElement;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapValueSource;

public final class ScriptMetricValueSource
extends TreeMapValueSource {
    private final String m_provider;
    private final String m_metricId;
    private final TreeMapLeafElement m_leafElement;

    public ScriptMetricValueSource(String provider, String metricId, TreeMapLeafElement leafElement) {
        assert (provider != null && provider.length() > 0) : "Parameter 'provider' of method 'ScriptMetricValueSource' must not be empty";
        assert (metricId != null && metricId.length() > 0) : "Parameter 'metricId' of method 'ScriptMetricValueSource' must not be empty";
        assert (leafElement != null) : "Parameter 'leafElement' of method 'ScriptMetricValueSource' must not be null";
        this.m_provider = provider;
        this.m_metricId = metricId;
        this.m_leafElement = leafElement;
    }

    public ScriptMetricValueSource(IMetricDescriptor metricDescriptor) {
        assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'ScriptMetricValueSource' must not be null";
        assert (metricDescriptor.getLevel() == CoreMetricLevel.COMPONENT || metricDescriptor.getLevel() == CoreMetricLevel.SOURCE_FILE) : "Level not supported: " + String.valueOf(metricDescriptor.getLevel());
        this.m_provider = metricDescriptor.getMetricId().getProvider().getStandardName();
        this.m_metricId = metricDescriptor.getMetricId().getStandardName();
        this.m_leafElement = metricDescriptor.getLevel() == CoreMetricLevel.COMPONENT ? TreeMapLeafElement.PHYSICAL_COMPONENT : TreeMapLeafElement.PHYSICAL_SOURCE_FILE;
    }

    @Override
    ScriptMetricValueSource copy() {
        return this;
    }

    public String getProvider() {
        return this.m_provider;
    }

    public String getMetricId() {
        return this.m_metricId;
    }

    public TreeMapLeafElement getLeafElement() {
        return this.m_leafElement;
    }

    @Override
    public String getImageResourceName() {
        return "Metric";
    }

    @Override
    public String getPresentationName() {
        return this.m_provider + ":" + this.m_metricId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_provider.hashCode();
        result = 31 * result + this.m_metricId.hashCode();
        result = 31 * result + this.m_leafElement.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ScriptMetricValueSource other = (ScriptMetricValueSource)obj;
        return this.m_provider.endsWith(other.m_provider) && this.m_metricId.equals(other.m_metricId) && this.m_leafElement.equals((Object)other.m_leafElement);
    }
}

