/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.ranking;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.author.Author;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import gnu.trove.set.hash.THashSet;
import java.util.Set;

public abstract class Rank<T extends Element>
extends NamedElement {
    private final T m_rankedElement;
    private final float m_score;
    private final float m_importance;
    private final float m_urgency;
    private String m_importanceAlgorithm;
    private String m_urgencyAlgorithm;
    private String m_scoreAlgorithm;

    public Rank(NamedElement parent, T scoredElement, float score, float importance, float urgency) {
        super(parent);
        assert (scoredElement != null) : "Parameter 'scoredElement' of method 'AbstractEisenhowerScore' must not be null";
        this.m_rankedElement = scoredElement;
        this.m_score = score;
        this.m_importance = importance;
        this.m_urgency = urgency;
    }

    public void setImportanceAlgorithm(String importanceAlgorithm) {
        assert (importanceAlgorithm != null) : "Parameter 'importanceAlgorithm' of method 'setImportanceAlgorithm' must not be null";
        this.m_importanceAlgorithm = importanceAlgorithm;
    }

    public void setUrgencyAlgorithm(String urgencyAlgorithm) {
        assert (urgencyAlgorithm != null) : "Parameter 'urgencyAlgorithm' of method 'setUrgencyAlgorithm' must not be null";
        this.m_urgencyAlgorithm = urgencyAlgorithm;
    }

    @Override
    @Property
    public String fullyQualifiedName() {
        return null;
    }

    @Override
    @Property
    public String originalFullyQualifiedName() {
        return null;
    }

    @Override
    public String getShortName() {
        return "Rank for " + ((Element)this.m_rankedElement).getName();
    }

    public T getRankedElement() {
        return this.m_rankedElement;
    }

    public float getScoreValue() {
        return this.m_score;
    }

    @Property
    public String getScore() {
        return this.m_scoreAlgorithm;
    }

    public void setScoreAlgorithm(String scoreAlgorithm) {
        assert (scoreAlgorithm != null) : "Parameter 'scoreAlgorithm' of method 'setScoreAlgorithm' must not be null";
        this.m_scoreAlgorithm = scoreAlgorithm;
    }

    public float getImportanceValue() {
        return this.m_importance;
    }

    @Property
    public String getImportance() {
        return this.m_importanceAlgorithm;
    }

    @Override
    public String getImageResourceName() {
        return "Ranking";
    }

    @Property
    public String getUrgency() {
        return this.m_urgencyAlgorithm;
    }

    public float getUrgencyValue() {
        return this.m_urgency;
    }

    public static final class ScmDataRecord {
        private int m_churn30;
        private int m_changes30;
        private Set<Author> m_authors30 = new THashSet();
        private int m_churn90;
        private int m_changes90;
        private Set<Author> m_authors90 = new THashSet();
        private int m_churn365;
        private int m_changes365;
        private Set<Author> m_authors365 = new THashSet();
        private int m_integrationCount = 0;

        public void setScmValue(IMetricId metricId, int value) {
            assert (metricId != null) : "Parameter 'metricId' of method 'setScmValue' must not be null";
            if (metricId == CoreMetricId.CORE_CHANGES_30) {
                this.m_changes30 = value;
            } else if (metricId == CoreMetricId.CORE_CODE_CHURN_30) {
                this.m_churn30 = value;
            } else if (metricId == CoreMetricId.CORE_CHANGES_90) {
                this.m_changes90 = value;
            } else if (metricId == CoreMetricId.CORE_CODE_CHURN_90) {
                this.m_churn90 = value;
            } else if (metricId == CoreMetricId.CORE_CHANGES_365) {
                this.m_changes365 = value;
            } else if (metricId == CoreMetricId.CORE_CODE_CHURN_365) {
                this.m_churn365 = value;
            } else assert (false) : "Unsupported metric " + String.valueOf(metricId);
        }

        public int getChanges30() {
            return this.m_changes30;
        }

        public int getChurn30() {
            return this.m_churn30;
        }

        public void setAuthors30(Set<Author> authors30) {
            assert (authors30 != null) : "Parameter 'authors30' of method 'setAuthors30' must not be null";
            this.m_authors30 = authors30;
        }

        public Set<Author> getAuthors30() {
            return this.m_authors30;
        }

        public int getChanges90() {
            return this.m_changes90;
        }

        public int getChurn90() {
            return this.m_churn90;
        }

        public void setAuthors90(Set<Author> authors90) {
            assert (authors90 != null) : "Parameter 'authors90' of method 'setAuthors90' must not be null";
            this.m_authors90 = authors90;
        }

        public Set<Author> getAuthors90() {
            return this.m_authors90;
        }

        public int getChanges365() {
            return this.m_changes365;
        }

        public int getChurn365() {
            return this.m_churn365;
        }

        public void setAuthors365(Set<Author> authors365) {
            assert (authors365 != null) : "Parameter 'authors365' of method 'setAuthors365' must not be null";
            this.m_authors365 = authors365;
        }

        public Set<Author> getAuthors365() {
            return this.m_authors365;
        }

        public void integrate(ScmDataRecord scmData) {
            assert (scmData != null) : "Parameter 'scmData' of method 'integrate' must not be null";
            ++this.m_integrationCount;
            this.m_changes30 += scmData.m_changes30;
            this.m_churn30 += scmData.m_churn30;
            this.m_authors30.addAll(scmData.m_authors30);
            this.m_changes90 += scmData.m_changes90;
            this.m_churn90 += scmData.m_churn90;
            this.m_authors90.addAll(scmData.m_authors90);
            this.m_changes365 += scmData.m_changes365;
            this.m_churn365 += scmData.m_churn365;
            this.m_authors365.addAll(scmData.m_authors365);
        }

        public boolean isEmpty() {
            return this.m_integrationCount == 0;
        }
    }
}

