/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.qualitygate;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractIssueDiffAgainstBaselineCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.Operator;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateDiffCheck;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import java.util.List;

public final class ThresholdIssueDiffAgainstBaselineCondition
extends AbstractIssueDiffAgainstBaselineCondition {
    private final String m_metricId;
    private final Operator m_operator;
    private final Float m_diffThresholdRelative;
    private final Float m_diffThreshold;

    public ThresholdIssueDiffAgainstBaselineCondition(NamedElement parent, String issueType, List<String> severities, List<String> resolutions, String metricId, Operator operator, Float diffThreshold, Float diffThresholdRelative, QualityGateDiffCheck check) {
        super(parent, issueType, severities, resolutions, check);
        assert (metricId != null) : "Parameter 'metricId' of method 'ThresholdIssueDiffAgainstBaselineCondition' must not be null";
        assert (operator != null) : "Parameter 'operator' of method 'ThresholdIssueDiffAgainstBaselineCondition' must not be null";
        this.m_metricId = metricId;
        this.m_operator = operator;
        this.m_diffThreshold = diffThreshold;
        this.m_diffThresholdRelative = diffThresholdRelative;
    }

    @Property
    public String getMetricId() {
        return this.m_metricId;
    }

    @Property
    public Operator getOperator() {
        return this.m_operator;
    }

    @Override
    public String getIssueType() {
        return super.getIssueType();
    }

    @Property
    public Float getDiffThreshold() {
        return this.m_diffThreshold;
    }

    @Property
    public Float getDiffThresholdRelative() {
        return this.m_diffThresholdRelative;
    }

    @Override
    public String getDebugInfo() {
        StringBuilder result = new StringBuilder(super.getDebugInfo());
        result.append('|').append(Element.escapeSpecialCharacters(this.m_metricId));
        result.append('|').append(this.m_operator.getSymbol());
        result.append('|');
        if (this.m_diffThreshold != null) {
            result.append(NumberUtility.format((Number)this.m_diffThreshold));
        } else {
            result.append("n/a");
        }
        result.append('|');
        if (this.m_diffThresholdRelative != null) {
            result.append(NumberUtility.format((Number)this.m_diffThresholdRelative));
        } else {
            result.append("n/a");
        }
        return result.toString();
    }

    @Override
    public String getPresentationName(boolean shortName) {
        if (shortName) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName()).append('|');
            builder.append(this.getIssueType()).append('|');
            builder.append(ThresholdIssueDiffAgainstBaselineCondition.getSeverityAsString(this.getSeverityList())).append('|');
            builder.append(ThresholdIssueDiffAgainstBaselineCondition.getResolutionsAsString(this.getResolutionList())).append('|');
            builder.append(this.getMetricId()).append('|');
            builder.append(this.getOperator().getStandardName()).append('|');
            if (this.m_diffThreshold != null) {
                builder.append(NumberUtility.format((Number)this.m_diffThreshold));
            } else {
                builder.append("n/a");
            }
            builder.append('|');
            if (this.m_diffThresholdRelative != null) {
                builder.append(NumberUtility.format((Number)this.m_diffThresholdRelative));
            } else {
                builder.append("n/a");
            }
            builder.append('|');
            builder.append(this.getCheck().getStandardName());
            return builder.toString();
        }
        return ThresholdIssueDiffAgainstBaselineCondition.getPresentationNameLong(this.getSeverityList(), this.getResolutionList(), this.getMetricId(), this.getOperator(), this.getDiffThreshold(), this.getDiffThresholdRelative(), this.getCheck());
    }

    public static String getPresentationNameLong(List<String> severities, List<String> resolutions, String metricId, Operator operator, Float thresholdAbsolute, Float thresholdRelative, QualityGateDiffCheck check) {
        StringBuilder builder = new StringBuilder();
        builder.append("No additional ");
        if (check == QualityGateDiffCheck.STRICT) {
            builder.append("or worsened ");
        }
        builder.append("threshold violations for metric '").append(metricId).append("'");
        builder.append(" with severity '").append(ThresholdIssueDiffAgainstBaselineCondition.getSeverityAsString(severities)).append("'");
        builder.append(" and resolution '").append(ThresholdIssueDiffAgainstBaselineCondition.getResolutionsAsString(resolutions)).append("'");
        if (thresholdAbsolute != null) {
            builder.append(", absolute value diff must be ").append(operator.getPresentationName()).append(" ").append(NumberUtility.format((Number)thresholdAbsolute));
        }
        if (thresholdRelative != null) {
            builder.append(", relative value diff must be ").append(operator.getPresentationName()).append(" ").append(NumberUtility.format((Number)Float.valueOf(thresholdRelative.floatValue() * 100.0f))).append("%");
        }
        return builder.toString();
    }
}

