/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.diff;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineType;
import de.schlichtherle.truezip.file.TFile;

public final class SoftwareSystemDiff
extends NamedElementContainer {
    private final long m_timestampOfDeltaCreation;
    private final TFile m_baselineReport;
    private final long m_baselineTimestamp;
    private final String m_baselineContextInfo;
    private final BaselineType m_type;

    public SoftwareSystemDiff(NamedElement parent, TFile baselineReport, long baselineTimestamp, String baselineContextInfo, BaselineType type) {
        super(parent);
        assert (baselineReport != null) : "Parameter 'baselineReport' of method 'SoftwareSystemDelta' must not be null";
        assert (baselineTimestamp > 0L) : "Parameter 'baselineTimestamp' of method 'SoftwareSystemDelta' must be > 0";
        assert (baselineContextInfo != null) : "Parameter 'baselineContextInfo' of method 'SoftwareSystemDiff' must not be null";
        assert (type != null) : "Parameter 'type' of method 'SoftwareSystemDiff' must not be null";
        this.m_baselineReport = baselineReport;
        this.m_baselineTimestamp = baselineTimestamp;
        this.m_timestampOfDeltaCreation = System.currentTimeMillis();
        this.m_baselineContextInfo = baselineContextInfo;
        this.m_type = type;
    }

    @Override
    public String getShortName() {
        return "SystemDiff";
    }

    public long getTimeStampOfDeltaCreation() {
        return this.m_timestampOfDeltaCreation;
    }

    public TFile getBaselineReport() {
        return this.m_baselineReport;
    }

    @Override
    public boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    public long getBaselineTimestamp() {
        return this.m_baselineTimestamp;
    }

    public String getBaselineContextInfo() {
        return this.m_baselineContextInfo;
    }

    public BaselineType getBaselineType() {
        return this.m_type;
    }
}

