/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.representation;

import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.DependencyType;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.representation.BalancedDependency;
import com.hello2morrow.sonargraph.core.model.representation.PEToLPECacheCreator;
import com.hello2morrow.sonargraph.core.model.representation.Representation;
import com.hello2morrow.sonargraph.core.model.system.Representations;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class BalancedDependencyRepresentation
extends Representation {
    private final Map<ProgrammingElement, LogicalProgrammingElement> m_peToLpeCache;
    private final Set<BalancedDependency> m_incomingExpandedDependencies = new THashSet();
    private final Set<BalancedDependency> m_internalExpandedDependencies = new THashSet();
    private final Set<BalancedDependency> m_outgoingExpandedDependencies = new THashSet();
    private Set<BalancedDependency> m_incomingDependencies;
    private Set<BalancedDependency> m_internalDependencies;
    private Set<BalancedDependency> m_outgoingDependencies;

    public BalancedDependencyRepresentation(SoftwareSystem softwareSystem, NamedElement elementForRepresentation, IDomainRoot.Domain domain, int nameSuffix) {
        super(softwareSystem, softwareSystem.getUniqueExistingChild(Representations.class), Collections.singleton(elementForRepresentation), domain, EndpointType.PARSER_DEPENDENCY, nameSuffix);
        if (domain == IDomainRoot.Domain.LOGICAL_MODULE_SCOPE || domain == IDomainRoot.Domain.LOGICAL_SYSTEM_SCOPE || domain == IDomainRoot.Domain.ARCHITECTURE_LOGICAL) {
            NamedElement rootElement = this.getRootElement();
            PEToLPECacheCreator cacheCreator = new PEToLPECacheCreator();
            rootElement.accept(cacheCreator);
            this.m_peToLpeCache = cacheCreator.getPEToLPECache();
        } else {
            this.m_peToLpeCache = Collections.emptyMap();
        }
    }

    public Collection<BalancedDependency> getIncomingDependencies() {
        assert (this.m_incomingDependencies != null) : "'m_incomingDependencies' of method 'getIncomingDependencies' must not be null";
        return this.m_incomingDependencies;
    }

    public Collection<BalancedDependency> getOutgoingDependencies() {
        assert (this.m_outgoingDependencies != null) : "'m_outgoingDependencies' of method 'getOutgoingDependencies' must not be null";
        return this.m_outgoingDependencies;
    }

    public Collection<BalancedDependency> getInternalDependencies() {
        assert (this.m_internalDependencies != null) : "'m_internalDependencies' of method 'getInternalDependencies' must not be null";
        return this.m_internalDependencies;
    }

    public Set<BalancedDependency> getAllDependencies() {
        THashSet allDependencies = new THashSet();
        for (BalancedDependency parent : this.m_incomingDependencies) {
            this.collectDependencies(parent, (Set<BalancedDependency>)allDependencies);
        }
        for (BalancedDependency parent : this.m_internalDependencies) {
            this.collectDependencies(parent, (Set<BalancedDependency>)allDependencies);
        }
        for (BalancedDependency parent : this.m_outgoingDependencies) {
            this.collectDependencies(parent, (Set<BalancedDependency>)allDependencies);
        }
        return allDependencies;
    }

    private void collectDependencies(BalancedDependency parent, Set<BalancedDependency> collector) {
        assert (parent != null) : "Parameter 'parent' of method 'collectDependencies' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'collectDependencies' must not be null";
        collector.add(parent);
        for (BalancedDependency child : parent.getChildren()) {
            this.collectDependencies(child, collector);
        }
    }

    public void setIncomingDependencies(Set<BalancedDependency> incomingDependencies) {
        this.m_incomingDependencies = incomingDependencies;
    }

    public void setInternalDependencies(Set<BalancedDependency> internalDependencies) {
        this.m_internalDependencies = internalDependencies;
    }

    public void setOutgoingDependencies(Set<BalancedDependency> outgoingDependencies) {
        this.m_outgoingDependencies = outgoingDependencies;
    }

    public Map<NamedElement, NamedElement> getPeToLpeCache() {
        return Collections.unmodifiableMap(this.m_peToLpeCache);
    }

    public void addExpandedDependency(BalancedDependency balancedDependency) {
        assert (balancedDependency != null) : "Parameter 'balancedDependency' of method 'addExpandedDependency' must not be null";
        switch (balancedDependency.getDependencyType()) {
            case INCOMING: {
                this.m_incomingExpandedDependencies.add(balancedDependency);
                break;
            }
            case INTERNAL: {
                this.m_internalExpandedDependencies.add(balancedDependency);
                break;
            }
            case OUTGOING: {
                this.m_outgoingExpandedDependencies.add(balancedDependency);
                break;
            }
            default: {
                assert (false) : "unexpected value for 'dependencyType': " + String.valueOf((Object)balancedDependency.getDependencyType());
                break;
            }
        }
    }

    public Set<Pair<NamedElement, NamedElement>> getExpandedDependenciesAsEndpoints(DependencyType dependencyType) {
        Set<BalancedDependency> expandedDependencies;
        switch (dependencyType) {
            case INCOMING: {
                expandedDependencies = this.m_incomingExpandedDependencies;
                break;
            }
            case INTERNAL: {
                expandedDependencies = this.m_internalExpandedDependencies;
                break;
            }
            case OUTGOING: {
                expandedDependencies = this.m_outgoingExpandedDependencies;
                break;
            }
            default: {
                assert (false) : "unexpected value for 'dependencyType': " + String.valueOf((Object)dependencyType);
                return null;
            }
        }
        return expandedDependencies.stream().map(balancedDependency -> new Pair((Object)balancedDependency.getFromEndPoint(), (Object)balancedDependency.getToEndPoint())).collect(Collectors.toSet());
    }
}

