/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.report;

import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.report.IBasicReport;
import com.hello2morrow.sonargraph.core.model.report.Report;
import com.hello2morrow.sonargraph.core.model.report.ReportComparator;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

public final class ModuleReport
extends Report {
    private final Module m_module;
    private TFile m_mainReportFile;

    public ModuleReport(Report report, Module module, String reportContextInfo) {
        super(report.getVersion(), report.getSoftwareSystem(), report.getAvailableFeatures(), report.getUnavailableFeatures(), report.getAnalyzerExecutionLevel(), reportContextInfo, report.getTimestamp());
        assert (module != null) : "Parameter 'module' of method 'ModuleReport' must not be null";
        this.m_module = module;
    }

    public void setMainReportTargetFile(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'setMainReportTargetFile' must not be null";
        this.m_mainReportFile = file;
    }

    public TFile getMainReportTargetFile() {
        return this.m_mainReportFile;
    }

    @Override
    public List<Module> getModules() {
        return Arrays.asList(this.m_module);
    }

    @Override
    public String getElementName() {
        return this.m_module.getName();
    }

    @Override
    protected List<Issue> calculateUnresolvedIssues() {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        Predicate<Issue> hasNoResolution = i -> i.getResolution() == null;
        this.getThresholdViolationIssues().values().stream().flatMap(ths -> ths.stream()).filter(hasNoResolution).forEach(i -> {
            boolean bl = issues.add((Issue)i);
        });
        this.getDependencyIssues().stream().filter(hasNoResolution).forEach(d -> {
            boolean bl = issues.add((Issue)d);
        });
        this.getCycleIssues().values().stream().flatMap(groups -> groups.stream()).filter(hasNoResolution).forEach(i -> {
            boolean bl = issues.add((Issue)i);
        });
        this.getDuplicateIssues().stream().filter(hasNoResolution).forEach(d -> {
            boolean bl = issues.add((Issue)d);
        });
        this.getNamedElementIssues().stream().filter(hasNoResolution).forEach(n -> {
            boolean bl = issues.add((Issue)n);
        });
        issues.sort(ReportComparator.createIssueComparator());
        return Collections.unmodifiableList(issues);
    }

    @Override
    public IBasicReport.Focus getFocus() {
        return IBasicReport.Focus.MODULE_LEVEL;
    }

    @Override
    public String getTitle() {
        return super.getTitle() + ", Module: " + this.m_module.getName();
    }
}

