/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.refactoring;

import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementMoveRefactoringIssue;
import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.core.model.refactoring.IRefactoringAdapter;
import com.hello2morrow.sonargraph.core.model.refactoring.LanguageSpecificRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringElementType;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringType;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import java.util.Date;

public class MoveRefactoringDefinition
extends LanguageSpecificRefactoringDefinition {
    public static final IIssueId MOVE_REFACTORING_ISSUE_ID = CoreIssueId.MOVE_REFACTORING;
    private String m_targetRootDirectoryFqName;
    private final String m_moveToParentName;

    public static String createDescription(String targetRootDirectoryFqName, String moveToParentName) {
        assert (targetRootDirectoryFqName != null && targetRootDirectoryFqName.length() > 0) : "Parameter 'targetRootDirectoryFqName' of method 'createDescription' must not be empty";
        assert (moveToParentName != null) : "Parameter 'moveToParentName' of method 'createDescription' must not be null";
        if (targetRootDirectoryFqName.startsWith("Workspace")) {
            return "Move to '" + targetRootDirectoryFqName.substring("Workspace".length() + 1) + "/" + moveToParentName + "'";
        }
        return "Move";
    }

    public MoveRefactoringDefinition(NamedElement parent, Date date, String assignee, String description, Priority priority, String definedForLanguage, MoveRenameRefactoringElementType elementType, String targetRootDirectoryFqName, String moveToParentName) {
        super(parent, date, assignee, description, priority, definedForLanguage, elementType);
        assert (targetRootDirectoryFqName != null && targetRootDirectoryFqName.length() > 0) : "Parameter 'targetRootDirectoryFqName' of method 'MoveRefactoringDefinition' must not be empty";
        assert (moveToParentName != null) : "Parameter 'moveToParentName' of method 'MoveRenameRefactoringDefinition' must not be null";
        this.m_targetRootDirectoryFqName = targetRootDirectoryFqName.intern();
        this.m_moveToParentName = moveToParentName.intern();
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.MOVE;
    }

    @Property
    public final String getTargetRootDirectoryFqName() {
        return this.m_targetRootDirectoryFqName;
    }

    public void setTargetRootDirectoryFqName(String newTargetRootFqName) {
        assert (newTargetRootFqName != null && newTargetRootFqName.length() > 0) : "Parameter 'newTargetRootFqName' of method 'adaptTargetRootDirectoryFqName' must not be empty";
        assert (!this.m_targetRootDirectoryFqName.equals(newTargetRootFqName)) : "Must be different, but are the same: " + newTargetRootFqName;
        this.m_targetRootDirectoryFqName = newTargetRootFqName.intern();
    }

    @Property
    public final String getMoveToParentName() {
        return this.m_moveToParentName;
    }

    public String getNewName() {
        return null;
    }

    @Override
    public String getName() {
        return "Move Refactoring";
    }

    @Override
    public String getShortName() {
        return "Move";
    }

    @Override
    public IIssueId getAssociatedIssueId() {
        return MOVE_REFACTORING_ISSUE_ID;
    }

    @Override
    public Issue createAssociatedIssue(Element element, String descriptor) {
        assert (element != null) : "Parameter 'element' of method 'createAssociatedIssue' must not be null";
        assert (descriptor != null && descriptor.length() > 0) : "Parameter 'descriptor' of method 'createAssociatedIssue' must not be empty";
        assert (element != null && element instanceof NamedElement) : "Unexpected class in method 'createAssociatedIssue': " + String.valueOf(element);
        return new NamedElementMoveRefactoringIssue((NamedElement)element, descriptor, MoveRefactoringDefinition.createDescription(this.m_targetRootDirectoryFqName, this.m_moveToParentName));
    }

    @Override
    public String getTargetFqName(String nonMatchingFqName, IRefactoringAdapter refactoringAdapter) {
        assert (nonMatchingFqName != null && nonMatchingFqName.length() > 0) : "Parameter 'nonMatchingFqName' of method 'getTargetFqName' must not be empty";
        assert (refactoringAdapter != null) : "Parameter 'refactoringAdapter' of method 'getTargetFqName' must not be null";
        int pos = nonMatchingFqName.lastIndexOf(58);
        if (pos != -1) {
            String nextName = nonMatchingFqName.substring(pos + 1);
            String moveToParentFqName = refactoringAdapter.getMoveToParentFqName(this.getMoveToParentName(), this.getRefactoringElementType());
            return this.getTargetRootDirectoryFqName() + ":" + (String)(!moveToParentFqName.isEmpty() ? moveToParentFqName + ":" : "") + nextName;
        }
        return null;
    }
}

