/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.EdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyEdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ParserDependencyNodeAdapter
extends NodeAdapter {
    private Map<ParserDependencyNodeAdapter, ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter>> m_out;
    private Map<ParserDependencyNodeAdapter, ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter>> m_in;

    public ParserDependencyNodeAdapter(NamedElement namedElement) {
        super(namedElement);
    }

    @Override
    protected boolean isDerived(EdgeAdapter<? extends NodeAdapter> edge) {
        NamedElement to;
        NamedElement from;
        assert (edge != null) : "Parameter 'edge' of method 'isDerived' must not be null";
        if (edge.getNumberOfDependencies() == 1 && (from = edge.getFrom().getUnderlyingObject()) instanceof ProgrammingElement && (to = edge.getTo().getUnderlyingObject()) instanceof ProgrammingElement) {
            ParserDependency nextInDependency = (ParserDependency)edge.getFirstDependency();
            return nextInDependency.getFrom() == from && nextInDependency.getTo() == to;
        }
        return true;
    }

    public ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter> getOutgoingEdge(ParserDependencyNodeAdapter to) {
        assert (to != null) : "Parameter 'to' of method 'getOutgoingEdge' must not be null";
        return this.m_out != null ? this.m_out.get(to) : null;
    }

    @Override
    public Collection<ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter>> getOutgoingEdges() {
        return this.m_out != null ? Collections.unmodifiableCollection(this.m_out.values()) : Collections.emptySet();
    }

    @Override
    public Collection<ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter>> getIncomingEdges() {
        return this.m_in != null ? Collections.unmodifiableCollection(this.m_in.values()) : Collections.emptySet();
    }

    protected Map<ParserDependencyNodeAdapter, ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter>> getIn() {
        return this.m_in;
    }

    protected Map<ParserDependencyNodeAdapter, ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter>> getOut() {
        return this.m_out;
    }

    @Override
    protected void lastIncomingEdgeRemoved() {
        this.m_in = null;
    }

    @Override
    protected void lastOutgoingEdgeRemoved() {
        this.m_out = null;
    }

    @Override
    protected <K extends NodeAdapter, V extends EdgeAdapter<? extends NodeAdapter>> boolean addToIn(K nodeAdapter, V edge) {
        assert (nodeAdapter != null && nodeAdapter instanceof ParserDependencyNodeAdapter) : "Unexpected class in method 'addToIn': " + String.valueOf(nodeAdapter);
        assert (edge != null && edge instanceof ParserDependencyEdgeAdapter) : "Unexpected class in method 'addToIn': " + String.valueOf(edge);
        if (this.m_in == null) {
            this.m_in = new LinkedHashMap<ParserDependencyNodeAdapter, ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter>>();
        }
        return this.m_in.put((ParserDependencyNodeAdapter)nodeAdapter, (ParserDependencyEdgeAdapter)edge) == null;
    }

    @Override
    protected <K extends NodeAdapter, V extends EdgeAdapter<? extends NodeAdapter>> boolean addToOut(K nodeAdapter, V edge) {
        assert (nodeAdapter != null && nodeAdapter instanceof ParserDependencyNodeAdapter) : "Unexpected class in method 'addToOut': " + String.valueOf(nodeAdapter);
        assert (edge != null && edge instanceof ParserDependencyEdgeAdapter) : "Unexpected class in method 'addToOut': " + String.valueOf(edge);
        if (this.m_out == null) {
            this.m_out = new LinkedHashMap<ParserDependencyNodeAdapter, ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter>>();
        }
        return this.m_out.put((ParserDependencyNodeAdapter)nodeAdapter, (ParserDependencyEdgeAdapter)edge) == null;
    }

    @Override
    public <E extends INode.IEdge> void removeFromOutgoing(E edge) {
        assert (this.m_out != null);
        this.m_out.remove(edge.getTo());
    }

    @Override
    public <E extends INode.IEdge> void removeFromIncoming(E edge) {
        assert (this.m_in != null);
        this.m_in.remove(edge.getFrom());
    }
}

