/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.path;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.CoreDirectoryType;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFilesDirectory;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IDirectoryType;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;

public final class SoftwareSystemDirectory
extends SoftwareSystemFilesDirectory {
    public static final String DIRECTORY_SUFFIX = ".sonargraph";

    public static IPathValidator getValidator() {
        return new IPathValidator(){

            @Override
            public ValidationResult isValid(TFile currentInput, TFile newInput) {
                ValidationResult result = new ValidationResult(!FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
                if (newInput == null || newInput.getPath().isEmpty()) {
                    result.addError("Must not be empty");
                } else {
                    File newInputFile = new File(FileUtility.getIdentifyingPath((TFile)newInput));
                    if (!newInputFile.exists()) {
                        result.addError("Does not exist");
                    } else if (!newInputFile.isDirectory()) {
                        result.addError("Is not a directory");
                    } else if (!newInputFile.getName().endsWith(SoftwareSystemDirectory.DIRECTORY_SUFFIX)) {
                        result.addError("Does not end with '.sonargraph'");
                    } else {
                        File systemFile = new File(newInputFile, "system.sonargraph");
                        if (!systemFile.exists()) {
                            result.addError("No system file in specified directory");
                        }
                    }
                }
                return result;
            }

            @Override
            public IPathValidator.PathType getType() {
                return IPathValidator.PathType.DIRECTORY;
            }
        };
    }

    public static void checkDirectory(TFile directory, OperationResult result) {
        assert (directory != null) : "Parameter 'directory' of method 'checkDirectory' must not be null";
        assert (result != null) : "Parameter 'result' of method 'checkDirectory' must not be null";
        if (!directory.exists()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.DIRECTORY_NOT_FOUND, directory.getAbsolutePath(), new Object[0]);
        } else if (!directory.isDirectory()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.NOT_A_DIRECTORY, directory.getAbsolutePath(), new Object[0]);
        } else if (!directory.getName().endsWith(DIRECTORY_SUFFIX)) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.UNEXPECTED_DIRECTORY_NAME, "Directory does not end with '.sonargraph': " + directory.getAbsolutePath(), new Object[0]);
        } else {
            String name = directory.getName();
            int pos = name.lastIndexOf(DIRECTORY_SUFFIX);
            assert (pos != -1) : "No .sonargraph found in: " + name;
            String systemName = name.substring(0, pos);
            if (systemName == null || systemName.isEmpty()) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.UNEXPECTED_DIRECTORY_NAME, "Directory ends with '.sonargraph' but has no name part: " + directory.getAbsolutePath(), new Object[0]);
            }
        }
    }

    public static String getSoftwareSystemName(TFile directory) {
        assert (directory != null) : "Parameter 'directory' of method 'getSoftwareSystemName' must not be null";
        assert (directory.isDirectory()) : "Not a directory: " + String.valueOf(directory);
        String name = directory.getName();
        int pos = name.lastIndexOf(DIRECTORY_SUFFIX);
        assert (pos != -1) : "No .sonargraph found in: " + name;
        String systemName = name.substring(0, pos);
        assert (systemName != null && systemName.length() > 0) : "'systemName' of method 'getSoftwareSystemName' must not be empty";
        return systemName;
    }

    public SoftwareSystemDirectory(NamedElement parent, String relPath) {
        super(parent, relPath);
    }

    @Override
    public IDirectoryType getDirectoryType() {
        return CoreDirectoryType.SYSTEM;
    }

    @Override
    public String getFullyQualifiedNamePart() {
        return "SystemDirectory";
    }

    @Override
    public String getDescription() {
        return "Contains the system file";
    }

    public void reallocate(String path) {
        this.setPath(path);
        this.reallocate();
    }
}

