/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.graph;

import com.hello2morrow.sonargraph.core.model.context.ContextParserDependency;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.graph.GraphContextParserDependency;
import com.hello2morrow.sonargraph.core.model.graph.GraphRepresentation;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import java.util.List;

public final class GraphContext
implements IContext {
    private final IContext m_defaultContext;
    private final boolean m_violationsOnly;
    private final GraphRepresentation m_graphRepresentation;

    public GraphContext(IContext defaultContext, boolean violationsOnly, GraphRepresentation graphRepresentation) {
        assert (defaultContext != null) : "Parameter 'defaultContext' of method 'GraphContext' must not be null";
        assert (graphRepresentation != null) : "Parameter 'graphRepresentation' of method 'GraphContext' must not be null";
        this.m_defaultContext = defaultContext;
        this.m_violationsOnly = violationsOnly;
        this.m_graphRepresentation = graphRepresentation;
    }

    public String getStandardName() {
        return "Graph Context";
    }

    public String getPresentationName() {
        return "Graph Context";
    }

    @Override
    public boolean isValid() {
        return this.m_graphRepresentation.isValid();
    }

    @Override
    public String getDescription() {
        return "Provides dependencies currently shown in the corresponding graph view";
    }

    @Override
    public ContextParserDependency create(ParserDependency dependency) {
        if (!this.m_violationsOnly || this.m_defaultContext.isViolation(dependency)) {
            return new GraphContextParserDependency(dependency);
        }
        return null;
    }

    @Override
    public boolean isViolation(ParserDependency dependency) {
        return this.m_defaultContext.isViolation(dependency);
    }

    @Override
    public String getViolationInfo(ParserDependency dependency) {
        return this.m_defaultContext.getViolationInfo(dependency);
    }

    @Override
    public List<Issue> collectIssues(ElementWithIssues element, boolean recursively) {
        return this.m_defaultContext.collectIssues(element, recursively);
    }
}

